/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.mobile.IIndexAnalysis;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisCollection;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeInfo;
import com.kingdee.eas.fi.gr.mobile.MobileUtil;
import com.kingdee.eas.fi.gr.mobile.client.AbstractIndexAnalysisListUI;
import com.kingdee.eas.fi.gr.mobile.client.IndexAnalysisEditUI;
import com.kingdee.eas.fi.gr.mobile.client.IndexCalSchemeUI;
import com.kingdee.eas.fi.gr.mobile.client.IndexDispensedUI;
import com.kingdee.eas.fi.gr.mobile.client.IndexExecGuideUI;
import com.kingdee.eas.fi.gr.mobile.client.IndexNewBIUI;
import com.kingdee.eas.fi.gr.mobile.client.IndexSyncUI;
import com.kingdee.eas.fi.gr.mobile.client.IndexTypeEditUI;
import com.kingdee.eas.fi.gr.mobile.client.IndexUnDispensedUI;
import com.kingdee.eas.fi.gr.mobile.client.MaintainOrgUI;
import com.kingdee.eas.fi.gr.mobile.client.OrgTreeMapingEditUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.RegisterWindowKeyListenerHelper;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.MoveTree;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class IndexAnalysisListUI
extends AbstractIndexAnalysisListUI {
    private static final long serialVersionUID = 5127010376818683546L;
    private static final Logger logger = CoreUIObject.getLogger(IndexAnalysisListUI.class);
    private static final int THEME_JCOMPONENT = 0;
    private static final int INDEX_JCOMPONENT = 1;
    private List<String> dispensedId = new ArrayList<String>();
    private Set<String> authorizedOrgTreeIdSet = null;

    public IndexAnalysisListUI() throws Exception {
        this.regTestRemoteApp();
        this.regDebugLoggerKeyListener();
        this.regSQLWindowKeyListener();
        this.regMaintainOrgListener();
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"IndexTree_RootName");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddNew.setEnabled(false);
        this.menuItemAddNew.setEnabled(false);
        this.btnGroupMoveTree.setVisible(false);
        this.menuItemGroupMoveTree.setVisible(false);
        this.btnGroupRemove.setEnabled(false);
        this.menuItemGroupRemove.setEnabled(false);
        this.btnGroupEdit.setEnabled(false);
        this.menuItemGroupEdit.setEnabled(false);
        this.btnSyncIndex.setEnabled(false);
        this.menuSyncIndex.setEnabled(false);
        this.menuItemMoveTree.setEnabled(false);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                if (e.getSelectBlock().getBeginRow() >= 0) {
                    int[] selectRows = KDTableUtil.getSelectedRows((KDTable)IndexAnalysisListUI.this.tblMain);
                    int selectIndex = -1;
                    if (selectRows.length > 0) {
                        selectIndex = selectRows[0];
                    }
                    IndexAnalysisListUI.this.doTableSelectChange(selectIndex);
                }
            }
        });
        this.menuItemMoveTree.setVisible(true);
    }

    private void doTableSelectChange(int selectedRowIndex) {
        ICell iCell = this.tblMain.getRow(selectedRowIndex).getCell("trackRecordCreator.id");
        if (iCell != null && iCell.getValue() != null) {
            this.checkCUPermission(iCell.getValue().toString(), this.getCheckPermissionComponents(1));
        }
    }

    protected void initTree() throws Exception {
        super.initTree();
    }

    public KDTreeNode getSelectedTreeNode() {
        Object comp = this.treeMain.getLastSelectedPathComponent();
        if (comp instanceof KDTreeNode) {
            return (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        }
        return null;
    }

    public void checkTreeNodeSelected(ActionEvent e) {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Leaf_MustSelected"));
            SysUtil.abort();
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        ItemAction action = null;
        if (e != null) {
            action = this.getActionFromActionEvent(e);
        }
        if (action == null) {
            return;
        }
        if (action.equals(this.actionView) && this.isModify) {
            int selectedRow = this.treeMain.getSelectionRows()[0];
            this.initTree();
            this.treeMain.setSelectionRow(selectedRow);
            this.isModify = false;
        } else {
            super.refresh(e);
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.refreshTableData();
        this.checkNodePermission(this.getSelectedTreeNode(), this.getCheckPermissionComponents(0));
        if (this.tblMain.getRowCount() > 0) {
            this.doTableSelectChange(0);
        } else {
            this.checkNodePermission(this.getSelectedTreeNode(), this.getCheckPermissionComponents(1));
        }
    }

    private List<JComponent> getCheckPermissionComponents(int type) {
        ArrayList<JComponent> jComponents = new ArrayList<JComponent>();
        if (type == 1) {
            jComponents.add((JComponent)this.menuItemAddNew);
            jComponents.add((JComponent)this.btnEdit);
            jComponents.add((JComponent)this.menuItemEdit);
            jComponents.add((JComponent)this.btnRemove);
            jComponents.add((JComponent)this.menuItemRemove);
            jComponents.add((JComponent)this.menuItemMoveTree);
        } else if (type == 0) {
            jComponents.add((JComponent)this.btnAddNew);
            jComponents.add((JComponent)this.btnGroupEdit);
            jComponents.add((JComponent)this.menuItemGroupEdit);
            jComponents.add((JComponent)this.btnGroupRemove);
            jComponents.add((JComponent)this.menuItemGroupRemove);
            jComponents.add((JComponent)this.btnCalculate);
            jComponents.add((JComponent)this.menuCalculate);
            jComponents.add((JComponent)this.btnPeriodCalculate);
            jComponents.add((JComponent)this.menuPeriodCalculate);
            jComponents.add((JComponent)this.btnUnPeriodCalculate);
            jComponents.add((JComponent)this.menuUnPeriodCalculate);
            jComponents.add((JComponent)this.orgTreeMaping);
            jComponents.add((JComponent)this.orgTreeMapingMenu);
            jComponents.add((JComponent)this.btnSyncIndex);
            jComponents.add((JComponent)this.menuSyncIndex);
        }
        return jComponents;
    }

    private void refreshTableData() throws BOSException {
        if (this.getSelectedTreeNode() != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (!this.getSelectedTreeNode().isRoot()) {
                IndexTypeInfo selectInfo = (IndexTypeInfo)this.getSelectedTreeNode().getUserObject();
                filter.getFilterItems().add(new FilterItemInfo("indexType.id", (Object)selectInfo.getId().toString()));
                filter.setMaskString("#0");
            } else {
                filter.mergeFilter(this.getAuthorizedOrgTreeFilter("indexType.orgBound.id"), "and");
            }
            view.setFilter(filter);
            view.getSorter().add(new SorterItemInfo("number"));
            this.mainQuery = view;
            try {
                MobileUtil.addGradeManageFilter(this.mainQuery);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            this.mainQuery = null;
        }
        this.tblMain.removeRows();
        int rows = this.tblMain.getRowCount();
        if (rows != 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
        if (this.getSelectedTreeNode() != null) {
            this.initButtons(!this.getSelectedTreeNode().isRoot());
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        String oql = "select id where indexType.jobDefID is not null";
        try {
            int i;
            IndexAnalysisCollection col = IndexAnalysisFactory.getRemoteInstance().getIndexAnalysisCollection(oql);
            HashSet<String> ids = new HashSet<String>();
            for (i = 0; i < col.size(); ++i) {
                ids.add(col.get(i).getId().toString());
            }
            for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                row.getCell("isAutoDispatch").setValue((Object)ids.contains(row.getCell("id").getValue()));
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    private void initButtons(boolean enabled) {
        this.btnAddNew.setEnabled(enabled);
        this.menuItemAddNew.setEnabled(enabled);
        this.btnGroupRemove.setEnabled(enabled);
        this.menuItemGroupRemove.setEnabled(enabled);
        this.btnGroupEdit.setEnabled(enabled);
        this.menuItemGroupEdit.setEnabled(enabled);
        this.orgTreeMaping.setEnabled(enabled);
        this.orgTreeMapingMenu.setEnabled(enabled);
        this.btnCalculate.setEnabled(enabled);
        this.menuCalculate.setEnabled(enabled);
        this.btnUnPeriodCalculate.setEnabled(enabled);
        this.menuUnPeriodCalculate.setEnabled(enabled);
        this.btnPeriodCalculate.setEnabled(enabled);
        this.menuPeriodCalculate.setEnabled(enabled);
        this.btnSyncIndex.setEnabled(enabled);
        this.menuSyncIndex.setEnabled(enabled);
        this.menuItemMoveTree.setEnabled(enabled);
        this.indexDispensed.setEnabled(enabled);
        this.indexUnDispensed.setEnabled(enabled);
        this.menuDispensed.setEnabled(enabled);
        this.menuUnDispensed.setEnabled(enabled);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        KDTreeNode node = this.getSelectedTreeNode();
        String indexTypeID = null;
        if (node != null && node.getUserObject() instanceof IndexTypeInfo) {
            indexTypeID = ((IndexTypeInfo)node.getUserObject()).getId().toString();
        }
        uiContext.put((Object)"indexTypeID", indexTypeID);
        super.prepareUIContext(uiContext, e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkThemeSelected();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkObjectExists();
        super.actionView_actionPerformed(e);
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List ids = this.getSelectedIdValues();
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            try {
                Map appendMessage = IndexAnalysisFactory.getRemoteInstance().appendMessage(ids);
                ids = (List)appendMessage.get("deleteId");
                IndexAnalysisFactory.getRemoteInstance().removeSchemeAndEntry(ids);
                if (appendMessage.get("importId") != null) {
                    if (((List)appendMessage.get("importId")).size() == 0) {
                        MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"88_Delete"), (String)appendMessage.get("message").toString());
                    } else if (MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"84_Confirm"), (String)appendMessage.get("message").toString()) == 0) {
                        ids = (List)appendMessage.get("importId");
                        IndexAnalysisFactory.getRemoteInstance().removeSchemeAndEntry(ids);
                    }
                }
                this.refresh(e);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                SysUtil.abort((Throwable)ex);
            }
            catch (Throwable ex) {
                this.handUIException(ex);
                this.abort();
            }
        }
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public void checkThemeSelected() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode != null && treeNode.getUserObject() instanceof IndexTypeInfo) {
            return;
        }
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"Msg_ThemeMustSelected"));
        SysUtil.abort();
    }

    protected String getSelectedNodeKeyValue() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode != null && treeNode.getUserObject() instanceof IndexTypeInfo) {
            return ((IndexTypeInfo)treeNode.getUserObject()).getId().toString();
        }
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"Msg_ThemeMustSelected"));
        SysUtil.abort();
        return null;
    }

    protected String getEditUIName() {
        return IndexAnalysisEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return IndexAnalysisFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return IndexTypeFactory.getRemoteInstance();
    }

    private FilterInfo getAuthorizedOrgTreeFilter(String filterKey) {
        try {
            if (this.authorizedOrgTreeIdSet == null) {
                this.authorizedOrgTreeIdSet = new HashSet<String>();
                UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
                ObjectStringPK pk = new ObjectStringPK(userInfo.getId().toString());
                OrgTreeCollection treeCol = PermissionFactory.getRemoteInstance().getAllUnionTrees((IObjectPK)pk);
                if (treeCol != null && treeCol.size() > 0) {
                    for (int i = 0; i < treeCol.size(); ++i) {
                        this.authorizedOrgTreeIdSet.add(treeCol.get(i).getId().toString());
                    }
                }
                if (this.authorizedOrgTreeIdSet.size() == 0) {
                    this.authorizedOrgTreeIdSet.add("NULL");
                }
            }
            FilterInfo permFilter = new FilterInfo();
            permFilter.getFilterItems().add(new FilterItemInfo(filterKey, this.authorizedOrgTreeIdSet, CompareType.INCLUDE));
            return permFilter;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    protected FilterInfo getDefaultFilterForTree() {
        try {
            FilterInfo filter = MobileUtil.getGradeSettingFilter();
            filter.mergeFilter(this.getAuthorizedOrgTreeFilter("orgBound.id"), "and");
            return filter;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected String getGroupEditUIName() {
        return IndexTypeEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return null;
    }

    @Override
    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        this.checkThemeSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"indexTypeID", (Object)this.getSelectedNodeKeyValue());
        uiContext.put((Object)"periodType", (Object)RptPeriodTypeEnum.MONTHLY);
        IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IndexExecGuideUI.class.getName(), (Map)uiContext, null);
        iUIWindow.show();
    }

    @Override
    public void actionPeriodCalculate_actionPerformed(ActionEvent e) throws Exception {
        this.checkThemeSelected();
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IndexCalSchemeUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
        this.refresh(e);
    }

    @Override
    public void actionUnPeriodCalculate_actionPerformed(ActionEvent e) throws Exception {
        this.checkThemeSelected();
        IndexTypeInfo itInfo = IndexTypeFactory.getRemoteInstance().getIndexTypeInfo((IObjectPK)new ObjectUuidPK(this.getSelectedNodeKeyValue()));
        String jobDefId = itInfo.getJobDefID();
        if (StringUtils.isEmpty((String)jobDefId)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"Msg_NotSetPeriodCalcuate"));
            return;
        }
        itInfo.setJobDefID(null);
        EnactmentServiceFactory.createRemoteEnactService().removeJobProcessDef(jobDefId);
        IndexTypeFactory.getRemoteInstance().updatePartial((CoreBaseInfo)itInfo, this.getSelector());
        this.refresh(e);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"Msg_UnPeriodCalculateSuccess"));
        this.showMessage();
    }

    @Override
    public void actionSyncIndex_actionPerformed(ActionEvent e) throws Exception {
        this.checkThemeSelected();
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IndexSyncUI.class.getName(), (Map)uiContext, null);
        iUIWindow.show();
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("jobDefID");
        return selector;
    }

    private void regTestRemoteApp() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(123, 11);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIContext uiContext = new UIContext((Object)IndexAnalysisListUI.this);
                try {
                    IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(IndexNewBIUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                    iUIWindow.show();
                }
                catch (UIException e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
        };
        RegisterWindowKeyListenerHelper.registerWindowListener((CoreUI)this, (KeyStroke)keyStroke, (Object)"monitorAction", (AbstractAction)action);
    }

    private void regDebugLoggerKeyListener() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(119, 11);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexAnalysisListUI.this.setDebuglogger();
            }
        };
        RegisterWindowKeyListenerHelper.registerWindowListener((CoreUI)this, (KeyStroke)keyStroke, (Object)"debugLoggerAction", (AbstractAction)action);
    }

    private void regSQLWindowKeyListener() {
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        if (inputMap != null && actionMap != null) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(122, 11);
            inputMap.put(keyStroke, "sql_window");
            actionMap.remove("sql_window");
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IndexAnalysisListUI.this.createSQLWindow();
                }
            };
            actionMap.put("sql_window", action);
        }
    }

    private void regMaintainOrgListener() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(116, 11);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIContext uiContext = new UIContext((Object)IndexAnalysisListUI.this);
                try {
                    IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MaintainOrgUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                    iUIWindow.show();
                    IndexAnalysisListUI.this.refreshList();
                }
                catch (Exception e2) {
                    IndexAnalysisListUI.this.handUIException(e2);
                }
            }
        };
        RegisterWindowKeyListenerHelper.registerWindowListener((CoreUI)this, (KeyStroke)keyStroke, (Object)"maintainOrgAction", (AbstractAction)action);
    }

    private void createSQLWindow() {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fm.common.client.FMIsqlUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (UIException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private void setDebuglogger() {
        try {
            boolean b = ((IIndexAnalysis)this.getBizInterface()).setDebuglogger();
            if (b) {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"38_Debug_Is_Open"));
            } else {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"39_Debug_Is_Close"));
            }
            this.showMessage();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void actionSetOrgTreeMaping_actionPerformed(ActionEvent e) throws Exception {
        IndexTypeInfo indexTypeInfo;
        OrgTreeInfo orgTree;
        UIContext uiContext = new UIContext((Object)this);
        KDTreeNode selectNode = this.getSelectedTreeNode();
        if (selectNode != null && selectNode.getUserObject() != null && selectNode.getUserObject() instanceof IndexTypeInfo && (orgTree = (indexTypeInfo = (IndexTypeInfo)selectNode.getUserObject()).getOrgBound()) != null && orgTree.getId() != null) {
            uiContext.put((Object)"treeInfo", (Object)orgTree);
        }
        IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(OrgTreeMapingEditUI.class.getName(), (Map)uiContext, null);
        iUIWindow.show();
    }

    public void checkNodePermission(KDTreeNode node, List<JComponent> jComponents) {
        IndexTypeInfo selectInfo;
        if (node != null && !node.isRoot() && (selectInfo = (IndexTypeInfo)node.getUserObject()).getTrackRecordCreator() != null) {
            this.checkCUPermission(selectInfo.getTrackRecordCreator().getId().toString(), jComponents);
        }
    }

    public void checkCUPermission(String cuId, List<JComponent> jComponents) {
        if (cuId != null) {
            String curCuId = this.getCurrentCompanyOrgUnitId();
            for (JComponent cuJC : jComponents) {
                cuJC.setEnabled(cuId.equals(curCuId));
            }
        }
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().isRoot()) {
            this.initButtons(false);
        }
    }

    @Override
    public void actionIndexDispensed_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        int winStyle = 95;
        IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IndexDispensedUI.class.getName(), (Map)uiContext, null, OprtState.EDIT, winStyle &= 0xFFFFFFF4);
        iUIWindow.show();
    }

    @Override
    public void actionIndexUnDispensed_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        int winStyle = 95;
        IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IndexUnDispensedUI.class.getName(), (Map)uiContext, null, OprtState.EDIT, winStyle &= 0xFFFFFFF4);
        iUIWindow.show();
    }

    protected boolean canMoveDetailToRoot() {
        return false;
    }

    protected String getSelectDetailTreeName() {
        return "indexType";
    }

    protected void moveTreeNode(MoveTreeEvent e) {
        String curCuId;
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids == null && ids.size() == 0) {
            return;
        }
        if (!(e.getSourceTreeBaseInfo() instanceof IndexTypeInfo) || !(e.getTargetTreeBaseInfo() instanceof IndexTypeInfo)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"66_CannotMoveRoot"));
            return;
        }
        IndexTypeInfo targetIndexTypeInfo = (IndexTypeInfo)e.getTargetTreeBaseInfo();
        if (targetIndexTypeInfo.getCU() != null && !(curCuId = this.getCurrentCompanyOrgUnitId()).equals(targetIndexTypeInfo.getTrackRecordCreator().getId().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"67_CannotCrossCU"));
            return;
        }
        IndexTypeInfo sourceIndexTypeInfo = (IndexTypeInfo)e.getSourceTreeBaseInfo();
        if (sourceIndexTypeInfo.equals(targetIndexTypeInfo)) {
            return;
        }
        String source = ((IndexTypeInfo)e.getSourceTreeBaseInfo()).getId().toString();
        String target = ((IndexTypeInfo)e.getTargetTreeBaseInfo()).getId().toString();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("source", source);
        param.put("target", target);
        param.put("ids", ids);
        try {
            Map map = ((IIndexAnalysis)this.getBizInterface()).moveData(param);
            if (map != null && map.containsKey("errorMsg")) {
                MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"78_CannotMove"), (String)map.get("errorMsg").toString());
            }
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        ((MoveTree)e.getSource()).dispose();
        try {
            int selectedRow = this.treeMain.getSelectionRows()[0];
            this.initTree();
            this.treeMain.setSelectionRow(selectedRow);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private String getCurrentCompanyOrgUnitId() {
        return SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupRemove_actionPerformed(e);
    }

    protected boolean confirmRemove() {
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            KDTreeNode node = this.getSelectedTreeNode();
            String indexTypeId = ((IndexTypeInfo)node.getUserObject()).getId().toString();
            try {
                boolean flag;
                Map deleteMessage = IndexTypeFactory.getRemoteInstance().getMessage(indexTypeId, "delete");
                if (deleteMessage.get("message") == null) {
                    return true;
                }
                String message = deleteMessage.get("message").toString();
                boolean bl = flag = (Integer)deleteMessage.get("flag") == 1;
                if (flag) {
                    if (MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"84_Confirm"), (String)message) == 0) {
                        return true;
                    }
                } else {
                    MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"88_Delete"), (String)message);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                SysUtil.abort((Throwable)e);
            }
        }
        return false;
    }
}

