/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.mobile.IIndexAnalysisScheme;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisInfo;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeEntryCollection;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeEntryInfo;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeInfo;
import com.kingdee.eas.fi.gr.mobile.IndexTypeCollection;
import com.kingdee.eas.fi.gr.mobile.IndexTypeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeInfo;
import com.kingdee.eas.fi.gr.mobile.MobileUtil;
import com.kingdee.eas.fi.gr.mobile.client.AbstractIndexAnalysisSchemeEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class IndexAnalysisSchemeEditUI
extends AbstractIndexAnalysisSchemeEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(IndexAnalysisSchemeEditUI.class);
    private boolean isFireCheckBox = true;
    protected Map<String, Map<String, Object>> selectedCatch = new HashMap<String, Map<String, Object>>();
    private String selectColumn = "selected";
    private String idColumn = "indexID";
    private String indexTypeIdColumn = "indexTypeID";
    protected String resuorcePath = "com.kingdee.eas.fi.gr.mobile.MobileCommonResource";
    private IndexAnalysisSchemeInfo editData = new IndexAnalysisSchemeInfo();
    private Set<String> authorizedOrgTreeIdSet = null;
    private boolean isCtrlPress = false;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.initTableEvent();
        super.onLoad();
        this.oprtState = this.getOprtState();
        this.initTablMainListener();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.freshUI();
    }

    private void initTableEvent() {
        this.tblMain.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    IndexAnalysisSchemeEditUI.this.isCtrlPress = true;
                } else if (e.getKeyCode() == 127) {
                    SysUtil.abort();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (IndexAnalysisSchemeEditUI.this.isCtrlPress) {
                    IndexAnalysisSchemeEditUI.this.isCtrlPress = false;
                }
            }
        });
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 1 && IndexAnalysisSchemeEditUI.this.isCtrlPress) {
                    IRow row = IndexAnalysisSchemeEditUI.this.tblMain.getRow(e.getRowIndex());
                    boolean isSelect = (Boolean)row.getCell("selected").getValue();
                    row.getCell("selected").setValue((Object)(!isSelect ? 1 : 0));
                    ((KDCheckBox)row.getCell("selected").getEditor().getComponent()).setSelected(!isSelect);
                    IndexAnalysisSchemeEditUI.this.selectTreeNode(!isSelect, row);
                    IndexAnalysisSchemeEditUI.this.tblMain.checkParsed();
                }
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock selectBlock = e.getSelectBlock();
                if (selectBlock != null) {
                    ICell cell;
                    int selectIndex = IndexAnalysisSchemeEditUI.this.tblMain.getColumnIndex("selected");
                    Object cellObj = null;
                    if (selectBlock.getBottom() - selectBlock.getTop() > 0) {
                        for (int i = selectBlock.getTop(); i <= selectBlock.getBottom(); ++i) {
                            if (IndexAnalysisSchemeEditUI.this.tblMain.getRow(i).getStyleAttributes().isHided() || !((cellObj = IndexAnalysisSchemeEditUI.this.tblMain.getCell(i, selectIndex).getValue()) instanceof Boolean)) continue;
                            IndexAnalysisSchemeEditUI.this.tblMain.getCell(i, selectIndex).setValue((Object)((Boolean)cellObj == false ? 1 : 0));
                            ((KDCheckBox)IndexAnalysisSchemeEditUI.this.tblMain.getCell(i, selectIndex).getEditor().getComponent()).setSelected((Boolean)cellObj == false);
                            IRow iRow = IndexAnalysisSchemeEditUI.this.tblMain.getRow(i);
                            IndexAnalysisSchemeEditUI.this.selectTreeNode((Boolean)cellObj == false, iRow);
                        }
                    } else if (selectBlock.getBottom() - selectBlock.getTop() == 0 && selectBlock.getBeginCol() == selectBlock.getEndCol() && selectBlock.getBeginCol() == selectIndex && !IndexAnalysisSchemeEditUI.this.tblMain.getRow(selectBlock.getBottom()).getStyleAttributes().isHided() && (cell = IndexAnalysisSchemeEditUI.this.tblMain.getCell(selectBlock.getBottom(), selectBlock.getBeginCol())).getValue() instanceof Boolean) {
                        IRow iRow = IndexAnalysisSchemeEditUI.this.tblMain.getRow(selectBlock.getBottom());
                        cell.setValue((Object)((Boolean)cell.getValue()));
                        ((KDCheckBox)cell.getEditor().getComponent()).setSelected(((Boolean)cell.getValue()).booleanValue());
                        IndexAnalysisSchemeEditUI.this.selectTreeNode((Boolean)cell.getValue(), iRow);
                    }
                }
            }
        });
    }

    protected void selectTreeNode(boolean isSelect, IRow iRow) {
        KDTreeNode curTreeNode = this.getSelectedTreeNode();
        this.catchSelectedIndex(iRow);
        String indexTypeId = String.valueOf(iRow.getCell(this.indexTypeIdColumn).getValue());
        boolean isSelected = false;
        if (isSelect) {
            isSelected = true;
        } else if (this.selectedCatch.get(indexTypeId) != null && !this.selectedCatch.get(indexTypeId).isEmpty()) {
            isSelected = true;
        }
        if (!curTreeNode.isRoot()) {
            if (curTreeNode != null) {
                curTreeNode.setChecked(isSelected);
                this.treeMain.repaint();
            }
        } else if (indexTypeId != null) {
            this.searchAndCheckNode(curTreeNode, indexTypeId, isSelected);
            this.treeMain.repaint();
        }
    }

    private void freshUI() throws Exception {
        this.initIndexSchemeData();
        this.initUI();
        this.initSelectCell();
    }

    private IndexAnalysisSchemeInfo createNewData() {
        IndexAnalysisSchemeInfo schemeInfo = new IndexAnalysisSchemeInfo();
        schemeInfo.setIsDisplayColumnChart(true);
        schemeInfo.setIsDisplayPieChart(true);
        schemeInfo.setColumnChartDispPeriods(3);
        schemeInfo.setLineChartDispPeriods(3);
        schemeInfo.setPieCharCompTops(3);
        schemeInfo.setColumnCharDataType(0);
        schemeInfo.setLineCharDataType(0);
        schemeInfo.setCreateOrgUnit(SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo());
        return schemeInfo;
    }

    private void initIndexSchemeData() throws Exception {
        if (OprtState.ADDNEW.equalsIgnoreCase(this.oprtState)) {
            this.editData = this.createNewData();
            this.editData.copyNewToOld();
            this.editData.setSyncOldValue(false);
            this.selectedCatch.clear();
            return;
        }
        String pk = (String)this.getUIContext().get("ID");
        if (StringUtils.isEmpty((String)pk)) {
            return;
        }
        this.getUIContext().remove("ID");
        StringBuffer oql = new StringBuffer();
        oql.append(" select *,entries.indexType.id,entries.index.id where id = '").append(pk).append("'");
        IndexAnalysisSchemeInfo schemeInfo = this.getBizInterface().getIndexAnalysisSchemeInfo(oql.toString());
        if (schemeInfo != null) {
            this.editData = schemeInfo;
            IndexAnalysisSchemeEntryCollection entryCol = schemeInfo.getEntries();
            if (entryCol != null) {
                int size = entryCol.size();
                for (int i = 0; i < size; ++i) {
                    String indexTypeId = entryCol.get(i).getIndexType().getId().toString();
                    String indexId = entryCol.get(i).getIndex().getId().toString();
                    if (!this.selectedCatch.containsKey(indexTypeId)) {
                        HashMap<String, Object> indexMap = new HashMap<String, Object>();
                        indexMap.put(indexId, null);
                        this.selectedCatch.put(indexTypeId, indexMap);
                        continue;
                    }
                    this.selectedCatch.get(indexTypeId).put(indexId, null);
                }
            }
        }
        this.editData.copyNewToOld();
        this.editData.setSyncOldValue(false);
    }

    private void initUI() {
        this.spnColChartPeriods.setModel((SpinnerModel)this.getSpinnerNumberModel(3, 1, 13, 1));
        this.spnLineChartPeriods.setModel((SpinnerModel)this.getSpinnerNumberModel(3, 1, 13, 1));
        this.spnCompTops.setModel((SpinnerModel)this.getSpinnerNumberModel(3, 1, 5, 1));
        this.btnSave.setEnabled(true);
        this.btnCopy.setEnabled(true);
        if (this.editData != null) {
            this.txtName.setText(this.editData.getName());
            this.txtNumber.setText(this.editData.getNumber());
            this.txtDescription.setText(this.editData.getDescription());
            this.chkIsDisplayColumnChart.setSelected(this.editData.isIsDisplayColumnChart());
            this.chkIsDisplayLineChart.setSelected(this.editData.isIsDisplayLineChart());
            this.chkIsDisplayPieChart.setSelected(this.editData.isIsDisplayPieChart());
            this.spnColChartPeriods.setValue((Object)this.editData.getColumnChartDispPeriods());
            this.spnCompTops.setValue((Object)this.editData.getPieCharCompTops());
            this.spnLineChartPeriods.setValue((Object)this.editData.getLineChartDispPeriods());
            this.btnGrpColumnChart.setValue(this.editData.getColumnCharDataType());
            this.btnGrpLineChart.setValue(this.editData.getLineCharDataType());
        }
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.setButtonDefaultStyl(this.btnSave);
        this.setButtonDefaultStyl(this.btnCopy);
        this.showOprtMessage();
        this.initButtonState();
    }

    private void initButtonState() {
        if (OprtState.ADDNEW.equals(this.oprtState) || OprtState.COPYADDNEW.equals(this.oprtState)) {
            this.btnCopy.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnAddNew.setEnabled(false);
            this.btnSave.setEnabled(true);
            this.unLockUIAndAction();
        } else if (OprtState.EDIT.equals(this.oprtState)) {
            this.btnCopy.setEnabled(true);
            this.btnEdit.setEnabled(false);
            this.btnAddNew.setEnabled(true);
            this.btnSave.setEnabled(true);
            this.unLockUIAndAction();
        } else if (OprtState.VIEW.equals(this.oprtState)) {
            this.btnCopy.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.btnAddNew.setEnabled(true);
            this.btnSave.setEnabled(false);
            this.lockUIComponent();
        }
    }

    private SpinnerNumberModel getSpinnerNumberModel(int initValue, int minimum, int maximum, int stepSize) {
        return new SpinnerNumberModel(initValue, minimum, maximum, stepSize);
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return IndexTypeFactory.getRemoteInstance();
    }

    protected void initTree() throws Exception {
        this.treeMain.getSelectionModel().setSelectionMode(2);
        this.treeMain.setShowCheckBox(true);
        super.initTree();
        this.treeMain.setSyncChecked(true);
        this.treeMain.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                KDTreeNode selectNode = (KDTreeNode)event.getNode();
                if (selectNode != null) {
                    try {
                        IndexAnalysisSchemeEditUI.this.isFireCheckBox = false;
                        IndexAnalysisSchemeEditUI.this.setTblMainSelected(selectNode.isChecked());
                    }
                    finally {
                        IndexAnalysisSchemeEditUI.this.isFireCheckBox = true;
                    }
                }
            }
        });
    }

    private void setTblMainSelected(boolean isSelected) {
        ICell iCell = null;
        IRow iRow = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            iRow = this.tblMain.getRow(i);
            iCell = iRow.getCell(this.selectColumn);
            if (iCell == null) continue;
            iCell.setValue((Object)isSelected);
            ((KDCheckBox)iCell.getEditor().getComponent()).setSelected(isSelected);
            this.catchSelectedIndex(iRow);
        }
    }

    private void searchAndCheckNode(KDTreeNode curNode, String indexTypeId, boolean checked) {
        int childCount = curNode.getChildCount();
        if (childCount > 0) {
            KDTreeNode childNode = null;
            for (int i = 0; i < childCount; ++i) {
                childNode = (KDTreeNode)curNode.getChildAt(i);
                if (childNode == null || childNode.getUserObject() == null || !(childNode.getUserObject() instanceof IndexTypeInfo)) continue;
                if (indexTypeId.equals(((IndexTypeInfo)childNode.getUserObject()).getId().toString())) {
                    childNode.setChecked(checked);
                    return;
                }
                this.searchAndCheckNode(childNode, indexTypeId, checked);
            }
        }
    }

    private void initTablMainListener() {
        this.tblMain.getColumn(this.selectColumn).getStyleAttributes().setLocked(false);
        this.pnlMain.setSize(892, 346);
        this.pnlMain.setDividerLocation(0.3);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                IndexAnalysisSchemeEditUI.this.initSelectCell();
            }
        });
    }

    protected void initSelectCell() {
        ICell iCell = null;
        String indexTypeId = null;
        String id = null;
        Map<String, Object> indexMap = null;
        boolean isSelected = false;
        KDCheckBox curCheckBox = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            iCell = this.tblMain.getRow(i).getCell(this.selectColumn);
            if (iCell != null) {
                indexTypeId = String.valueOf(this.tblMain.getRow(i).getCell(this.indexTypeIdColumn).getValue());
                id = String.valueOf(this.tblMain.getRow(i).getCell(this.idColumn).getValue());
                indexMap = this.selectedCatch.get(indexTypeId);
                isSelected = indexMap != null && indexMap.containsKey(id);
                iCell.setValue((Object)isSelected);
            }
            if (iCell.getEditor() == null) {
                curCheckBox = new KDCheckBox();
                this.initCheckBoxListener(curCheckBox);
                KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JCheckBox)curCheckBox);
                iCell.setEditor((ICellEditor)cellEditor);
            } else {
                curCheckBox = (KDCheckBox)iCell.getEditor().getComponent();
            }
            this.isFireCheckBox = false;
            curCheckBox.setSelected(isSelected);
            this.selectTreeNode(isSelected, this.tblMain.getRow(i));
            this.isFireCheckBox = true;
        }
    }

    private void initCheckBoxListener(KDCheckBox checkBox) {
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent paramItemEvent) {
                if (IndexAnalysisSchemeEditUI.this.isFireCheckBox) {
                    KDTreeNode curTreeNode = IndexAnalysisSchemeEditUI.this.getSelectedTreeNode();
                    IRow iRow = IndexAnalysisSchemeEditUI.this.tblMain.getRow(IndexAnalysisSchemeEditUI.this.tblMain.getSelectManager().getActiveRowIndex());
                    IndexAnalysisSchemeEditUI.this.catchSelectedIndex(iRow);
                    String indexTypeId = String.valueOf(iRow.getCell(IndexAnalysisSchemeEditUI.this.indexTypeIdColumn).getValue());
                    boolean isSelected = false;
                    if (paramItemEvent.getStateChange() == 1) {
                        isSelected = true;
                    } else if (IndexAnalysisSchemeEditUI.this.selectedCatch.get(indexTypeId) != null && !IndexAnalysisSchemeEditUI.this.selectedCatch.get(indexTypeId).isEmpty()) {
                        isSelected = true;
                    }
                    if (!curTreeNode.isRoot()) {
                        if (curTreeNode != null) {
                            curTreeNode.setChecked(isSelected);
                            IndexAnalysisSchemeEditUI.this.treeMain.repaint();
                        }
                    } else if (indexTypeId != null) {
                        IndexAnalysisSchemeEditUI.this.searchAndCheckNode(curTreeNode, indexTypeId, isSelected);
                        IndexAnalysisSchemeEditUI.this.treeMain.repaint();
                    }
                }
            }
        });
    }

    protected void catchSelectedIndex(IRow row) {
        ICell iCell = null;
        String id = null;
        String indexTypeId = null;
        Map<String, Object> indexMap = null;
        if (row != null && (iCell = row.getCell(this.selectColumn)) != null) {
            id = String.valueOf(row.getCell(this.idColumn).getValue());
            indexTypeId = String.valueOf(row.getCell(this.indexTypeIdColumn).getValue());
            indexMap = this.selectedCatch.get(indexTypeId);
            if (((KDCheckBox)iCell.getEditor().getComponent()).isSelected()) {
                if (indexMap == null) {
                    indexMap = new HashMap<String, Object>();
                    this.selectedCatch.put(indexTypeId, indexMap);
                }
                if (!indexMap.containsKey(id)) {
                    indexMap.put(id, null);
                }
            } else if (indexMap != null) {
                indexMap.remove(id);
            }
        }
    }

    public KDTreeNode getSelectedTreeNode() {
        Object comp = this.treeMain.getLastSelectedPathComponent();
        if (comp instanceof KDTreeNode) {
            KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
            return treeNode;
        }
        return null;
    }

    public void checkTreeNodeSelected(ActionEvent e) {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Leaf_MustSelected"));
            SysUtil.abort();
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.refreshTableData();
    }

    protected void refreshTableData() throws BOSException {
        if (this.getSelectedTreeNode() != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (!this.getSelectedTreeNode().isRoot()) {
                IndexTypeInfo selectInfo = (IndexTypeInfo)this.getSelectedTreeNode().getUserObject();
                filter.getFilterItems().add(new FilterItemInfo("indexType.id", (Object)selectInfo.getId().toString()));
                filter.setMaskString("#0");
            } else {
                filter.mergeFilter(this.getAuthorizedOrgTreeFilter("indexType.orgBound.id"), "and");
            }
            view.setFilter(filter);
            view.getSorter().add(new SorterItemInfo("number"));
            this.mainQuery = view;
            try {
                MobileUtil.addGradeManageFilter(this.mainQuery);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            this.mainQuery = null;
        }
        this.tblMain.removeRows();
        int rows = this.tblMain.getRowCount();
        if (rows != 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    protected String getKeyFieldName() {
        return "indexID";
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"IndexTree_RootName");
    }

    protected SelectorItemCollection getSelectorForTree() {
        return null;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IIndexAnalysisScheme getBizInterface() throws Exception {
        return IndexAnalysisSchemeFactory.getRemoteInstance();
    }

    public boolean checkSelectedCatchEmpty() {
        if (!this.selectedCatch.isEmpty()) {
            for (Map<String, Object> curMap : this.selectedCatch.values()) {
                if (curMap == null || curMap.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return null;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected FilterInfo getDefaultFilterForTree() {
        try {
            FilterInfo filter = MobileUtil.getGradeSettingFilter();
            filter.mergeFilter(this.getAuthorizedOrgTreeFilter("orgBound.id"), "and");
            return filter;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private FilterInfo getAuthorizedOrgTreeFilter(String filterKey) {
        try {
            if (this.authorizedOrgTreeIdSet == null) {
                this.authorizedOrgTreeIdSet = new HashSet<String>();
                UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
                ObjectStringPK pk = new ObjectStringPK(userInfo.getId().toString());
                OrgTreeCollection treeCol = PermissionFactory.getRemoteInstance().getAllUnionTrees((IObjectPK)pk);
                if (treeCol != null && treeCol.size() > 0) {
                    for (int i = 0; i < treeCol.size(); ++i) {
                        this.authorizedOrgTreeIdSet.add(treeCol.get(i).getId().toString());
                    }
                }
                if (this.authorizedOrgTreeIdSet.size() == 0) {
                    this.authorizedOrgTreeIdSet.add("NULL");
                }
            }
            FilterInfo permFilter = new FilterInfo();
            permFilter.getFilterItems().add(new FilterItemInfo(filterKey, this.authorizedOrgTreeIdSet, CompareType.INCLUDE));
            return permFilter;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    protected void initPopmenu() {
    }

    protected void initGroupButton() {
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verifyData();
        this.catchUIData2SchemeInfo();
        IObjectPK pk = this.getBizInterface().save((CoreBaseInfo)this.editData);
        this.editData.setId(BOSUuid.read((String)pk.toString()));
        this.editData.copyNewToOld();
        this.editData.setSyncOldValue(false);
        this.oprtState = "SAVE_OK";
        this.showOprtMessage();
        this.oprtState = OprtState.EDIT;
    }

    public void verifyData() throws Exception {
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)(this.kDLabelContainer1.getBoundLabelText() + EASResource.getString((String)this.resuorcePath, (String)"NotBlank").substring(1)));
            this.txtNumber.setFocusable(true);
            SysUtil.abort();
            return;
        }
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)(this.kDLabelContainer2.getBoundLabelText() + EASResource.getString((String)this.resuorcePath, (String)"NotBlank").substring(1)));
            this.txtName.setFocusable(true);
            SysUtil.abort();
            return;
        }
        if (this.checkSelectedCatchEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resuorcePath, (String)"SelectIndex"));
            SysUtil.abort();
            return;
        }
        if (!(this.chkIsDisplayColumnChart.isSelected() || this.chkIsDisplayLineChart.isSelected() || this.chkIsDisplayPieChart.isSelected())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resuorcePath, (String)"PleaseSelectDisplayType"));
            SysUtil.abort();
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> indexTypeIDSet = new HashSet<String>();
        for (Map.Entry<String, Map<String, Object>> entry : this.selectedCatch.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            indexTypeIDSet.add(entry.getKey());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", indexTypeIDSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IndexTypeCollection indexTypeCol = IndexTypeFactory.getRemoteInstance().getIndexTypeCollection(view);
        HashSet<String> combineKey = new HashSet<String>();
        StringBuffer key = new StringBuffer();
        boolean isSameElements = true;
        int size = indexTypeCol.size();
        for (int i = 0; i < size; ++i) {
            key.setLength(0);
            IndexTypeInfo info = indexTypeCol.get(i);
            key.append(this.surgeKey(info.getOrgBound().getId().toString())).append(this.surgeKey(info.getCurrency().getId().toString())).append(this.surgeKey("" + info.getDimension().getValue()));
            if (!combineKey.contains(key.toString()) && combineKey.size() > 0) {
                isSameElements = false;
                break;
            }
            combineKey.add(key.toString());
        }
        if (!isSameElements) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resuorcePath, (String)"DisplayInfoIsNotSame"));
            SysUtil.abort();
            return;
        }
    }

    private String surgeKey(String key) {
        return "[" + key + "]";
    }

    private void catchUIData2SchemeInfo() {
        if (this.editData == null) {
            this.editData = new IndexAnalysisSchemeInfo();
        }
        this.editData.setName(this.txtName.getText());
        this.editData.setNumber(this.txtNumber.getText());
        this.editData.setDescription(this.txtDescription.getText());
        this.editData.setIsDisplayColumnChart(this.chkIsDisplayColumnChart.isSelected());
        this.editData.setIsDisplayLineChart(this.chkIsDisplayLineChart.isSelected());
        this.editData.setIsDisplayPieChart(this.chkIsDisplayPieChart.isSelected());
        this.editData.setColumnChartDispPeriods(this.spnColChartPeriods.getIntegerVlaue());
        this.editData.setLineChartDispPeriods(this.spnLineChartPeriods.getIntegerVlaue());
        this.editData.setPieCharCompTops(this.spnCompTops.getIntegerVlaue());
        this.editData.setColumnCharDataType(this.btnGrpColumnChart.getValue());
        this.editData.setLineCharDataType(this.btnGrpLineChart.getValue());
        IndexAnalysisSchemeEntryCollection oldEntries = (IndexAnalysisSchemeEntryCollection)((Object)this.editData.getEntries().clone());
        IndexAnalysisSchemeEntryCollection newEntries = new IndexAnalysisSchemeEntryCollection();
        HashSet<String> indexAnalysisIDSet = new HashSet<String>();
        for (Map.Entry<String, Map<String, Object>> entry : this.selectedCatch.entrySet()) {
            Map<String, Object> indexMap = entry.getValue();
            if (indexMap == null || indexMap.size() <= 0) continue;
            IndexTypeInfo typeInfo = new IndexTypeInfo();
            typeInfo.setId(BOSUuid.read((String)entry.getKey()));
            for (Object obj : indexMap.keySet().toArray()) {
                IndexAnalysisSchemeEntryInfo item = new IndexAnalysisSchemeEntryInfo();
                IndexAnalysisInfo indexInfo = new IndexAnalysisInfo();
                indexInfo.setId(BOSUuid.read((String)((String)obj)));
                item.setIndex(indexInfo);
                item.setIndexType(typeInfo);
                item.setScheme(this.editData);
                item.setId(BOSUuid.create((BOSObjectType)item.getBOSType()));
                newEntries.add(item);
                indexAnalysisIDSet.add((String)obj);
            }
        }
        if (OprtState.COPYADDNEW.equals(this.oprtState)) {
            this.editData.put("entries", (Object)newEntries);
            return;
        }
        if (oldEntries.size() != newEntries.size()) {
            this.editData.put("entries", (Object)newEntries);
            return;
        }
        int size = oldEntries.size();
        for (int i = 0; i < size; ++i) {
            if (indexAnalysisIDSet.contains(oldEntries.get(i).getIndex().getId().toString())) continue;
            this.editData.put("entries", (Object)newEntries);
            return;
        }
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setId(null);
        this.editData.setNumber(null);
        this.txtNumber.setText(null);
        this.editData.setName(null);
        this.txtName.setText(null);
        this.editData.copyNewToOld();
        this.editData.setSyncOldValue(false);
        this.oprtState = OprtState.COPYADDNEW;
        this.showOprtMessage();
        this.initButtonState();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.oprtState = OprtState.ADDNEW;
        this.freshUI();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.oprtState = OprtState.EDIT;
        this.initButtonState();
    }

    protected void showOprtMessage() {
        String msg = null;
        String res = null;
        Object[] objs = null;
        String oprtMsgKey = "Msg_View_New";
        if (OprtState.EDIT.equalsIgnoreCase(this.oprtState)) {
            oprtMsgKey = "Msg_Edit_New";
        } else if (OprtState.VIEW.equalsIgnoreCase(this.oprtState)) {
            oprtMsgKey = "Msg_View_New";
        } else if (OprtState.ADDNEW.equalsIgnoreCase(this.oprtState)) {
            oprtMsgKey = "Msg_AddNew_New";
        } else if (OprtState.COPYADDNEW.equalsIgnoreCase(this.oprtState)) {
            oprtMsgKey = "Msg_CopyNew_New";
        } else if ("SAVE_OK".equals(this.oprtState)) {
            oprtMsgKey = "Msg_Save_OK_New";
        }
        res = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + oprtMsgKey));
        objs = new Object[]{this.getClassAlise()};
        msg = MessageFormat.format(res, objs);
        this.setMessageText(msg);
        if ("SAVE_OK".equals(this.oprtState)) {
            res = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit_New");
            res = MessageFormat.format(res, objs);
            this.setNextMessageText(res);
            this.setIsShowTextOnly(false);
            this.setShowMessagePolicy(0);
            this.showMessage();
            return;
        }
        this.setIsShowTextOnly(true);
        this.showMessage();
    }

    protected String getClassAlise() {
        String className = FrameWorkUtils.getClassAlias((CoreBaseInfo)this.editData);
        return className;
    }

    public boolean isModify() {
        if (OprtState.VIEW.equals(this.oprtState)) {
            return false;
        }
        this.catchUIData2SchemeInfo();
        return this.editData.isValueChange();
    }

    public boolean destroyWindow() {
        this.checkModified();
        try {
            ((ListUI)this.getUIContext().get("Owner")).refreshList();
        }
        catch (Exception e) {
            logger.error((Object)"refreshList error:", (Throwable)e);
        }
        return super.destroyWindow();
    }

    public void checkModified() {
        if (this.isModify()) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                this.btnSave.getAction().actionPerformed(event);
                if (this.actionSave.isInvokeFailed()) {
                    SysUtil.abort();
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }
}

