/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.dynbusiness.adv.chain.StringUtil;
import com.kingdee.eas.fi.gr.mobile.IndexTypeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeInfo;
import com.kingdee.eas.fi.gr.mobile.client.AbstractIndexCalSchemeUI;
import com.kingdee.eas.fi.gr.mobile.client.scheme.DispatchPeriodSourceImpl;
import com.kingdee.eas.fi.gr.mobile.client.scheme.IDispatchPeriodSource;
import com.kingdee.eas.fi.gr.mobile.client.scheme.SchemeUIUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class IndexCalSchemeUI
extends AbstractIndexCalSchemeUI {
    private static final long serialVersionUID = 1090936588743767502L;
    private static final Logger logger = CoreUIObject.getLogger(IndexCalSchemeUI.class);
    private IndexTypeInfo bizObjectInfo;
    private IDispatchPeriodSource source;

    public void onLoad() throws Exception {
        String indexTypeID = "";
        String jobDefID = "";
        if (this.getUIContext().containsKey("indexTypeID") && (indexTypeID = this.getUIContext().get("indexTypeID").toString()) != null) {
            this.bizObjectInfo = IndexTypeFactory.getRemoteInstance().getIndexTypeInfo((IObjectPK)new ObjectUuidPK(indexTypeID), this.getSelector());
            jobDefID = this.bizObjectInfo.getJobDefID();
            if (StringUtils.isEmpty((String)jobDefID)) {
                this.bizObjectInfo.setJobDefID(null);
            }
            this.source = new DispatchPeriodSourceImpl(this.bizObjectInfo);
            if (jobDefID != null) {
                this.txtProcessID.setText(jobDefID);
                this.txtProcessDesc.setText(SchemeUIUtils.getTextByDispatchPeriodId(jobDefID));
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        ((CoreBaseInfo)this.source.getJobParam()).setId(this.bizObjectInfo.getId());
        SchemeUIUtils.saveJobProcessDef(this.source);
        this.bizObjectInfo.setJobDefID(this.source.getJobProcess());
        if (StringUtil.isEmpty((String)this.bizObjectInfo.getJobDefID())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"Msg_TimeSolutionIsNotBeSetted"));
            return;
        }
        IndexTypeFactory.getRemoteInstance().updatePartial((CoreBaseInfo)this.bizObjectInfo, this.getSelector());
        this.destroyWindow();
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("jobDefID");
        return selector;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    public void actionPeriodCal_actionPerformed(ActionEvent e) throws Exception {
        boolean choose = SchemeUIUtils.show((Object)this, this.source, logger);
        if (choose) {
            this.txtProcessID.setText(this.source.getJobProcess());
            this.txtProcessDesc.setText(this.source.getText());
        }
    }
}

