/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.mobile.IndexDispensedFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeInfo;
import com.kingdee.eas.fi.gr.mobile.MobileUtil;
import com.kingdee.eas.fi.gr.mobile.client.AbstractIndexDispensedUI;
import com.kingdee.eas.fi.gr.mobile.client.SelectUserByUserGroupUI;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class IndexDispensedUI
extends AbstractIndexDispensedUI {
    private static final long serialVersionUID = 7912210734766555263L;
    private static final Logger logger = CoreUIObject.getLogger(IndexDispensedUI.class);
    private String selectColumn = "selected";
    private String idColumn = "id";
    private String indexTypeIdColumn = "indexTypeId";
    private boolean isFireCheckBox = true;
    protected boolean isUserNull = true;
    protected boolean isDispensed = true;
    protected Map<String, Map<String, Object>> selectedCatch = new HashMap<String, Map<String, Object>>();
    protected String resuorcePath = "com.kingdee.eas.fi.gr.mobile.MobileCommonResource";
    protected MetaDataPK pk = new MetaDataPK("com.kingdee.eas.base.permission.app.UserListQuery");
    private Set<String> authorizedOrgTreeIdSet = null;
    private boolean isCtrlPress = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTablMainListener();
        this.initSelectCell();
        this.btnCancel1.setEnabled(true);
        this.btnOk.setEnabled(true);
        this.add.setEnabled(true);
        this.remove.setEnabled(true);
        this.userKDTable.getStyleAttributes().setLocked(true);
        this.userKDTable.getSelectManager().setSelectMode(10);
        this.initTableEvent();
    }

    private void initTableEvent() {
        this.tblMain.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    IndexDispensedUI.this.isCtrlPress = true;
                } else if (e.getKeyCode() == 127) {
                    SysUtil.abort();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (IndexDispensedUI.this.isCtrlPress) {
                    IndexDispensedUI.this.isCtrlPress = false;
                }
            }
        });
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 1 && IndexDispensedUI.this.isCtrlPress) {
                    IRow row = IndexDispensedUI.this.tblMain.getRow(e.getRowIndex());
                    boolean isSelect = (Boolean)row.getCell("selected").getValue();
                    row.getCell("selected").setValue((Object)(!isSelect ? 1 : 0));
                    ((KDCheckBox)row.getCell("selected").getEditor().getComponent()).setSelected(!isSelect);
                    IndexDispensedUI.this.selectTreeNode(!isSelect, row);
                    IndexDispensedUI.this.tblMain.checkParsed();
                }
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock selectBlock = e.getSelectBlock();
                if (selectBlock != null) {
                    ICell cell;
                    int selectIndex = IndexDispensedUI.this.tblMain.getColumnIndex("selected");
                    Object cellObj = null;
                    if (selectBlock.getBottom() - selectBlock.getTop() > 0) {
                        for (int i = selectBlock.getTop(); i <= selectBlock.getBottom(); ++i) {
                            if (IndexDispensedUI.this.tblMain.getRow(i).getStyleAttributes().isHided() || !((cellObj = IndexDispensedUI.this.tblMain.getCell(i, selectIndex).getValue()) instanceof Boolean)) continue;
                            IndexDispensedUI.this.tblMain.getCell(i, selectIndex).setValue((Object)((Boolean)cellObj == false ? 1 : 0));
                            ((KDCheckBox)IndexDispensedUI.this.tblMain.getCell(i, selectIndex).getEditor().getComponent()).setSelected((Boolean)cellObj == false);
                            IRow iRow = IndexDispensedUI.this.tblMain.getRow(i);
                            IndexDispensedUI.this.selectTreeNode((Boolean)cellObj == false, iRow);
                        }
                    } else if (selectBlock.getBottom() - selectBlock.getTop() == 0 && selectBlock.getBeginCol() == selectBlock.getEndCol() && selectBlock.getBeginCol() == selectIndex && !IndexDispensedUI.this.tblMain.getRow(selectBlock.getBottom()).getStyleAttributes().isHided() && (cellObj = (cell = IndexDispensedUI.this.tblMain.getCell(selectBlock.getBottom(), selectBlock.getBeginCol())).getValue()) instanceof Boolean) {
                        IRow iRow = IndexDispensedUI.this.tblMain.getRow(selectBlock.getBottom());
                        cell.setValue((Object)((Boolean)cellObj));
                        ((KDCheckBox)cell.getEditor().getComponent()).setSelected(((Boolean)cellObj).booleanValue());
                        IndexDispensedUI.this.selectTreeNode((Boolean)cellObj, iRow);
                    }
                }
            }
        });
    }

    protected void selectTreeNode(boolean isSelect, IRow iRow) {
        KDTreeNode curTreeNode = this.getSelectedTreeNode();
        this.catchSelectedIndex(iRow);
        String indexTypeId = String.valueOf(iRow.getCell(this.indexTypeIdColumn).getValue());
        boolean isSelected = false;
        if (isSelect) {
            isSelected = true;
        } else if (this.selectedCatch.get(indexTypeId) != null && !this.selectedCatch.get(indexTypeId).isEmpty()) {
            isSelected = true;
        }
        if (!curTreeNode.isRoot()) {
            if (curTreeNode != null) {
                curTreeNode.setChecked(isSelected);
                this.treeMain.repaint();
            }
        } else if (indexTypeId != null) {
            this.searchAndCheckNode(curTreeNode, indexTypeId, isSelected);
            this.treeMain.repaint();
        }
    }

    private void initTablMainListener() {
        this.tblMain.getColumn(this.selectColumn).getStyleAttributes().setLocked(false);
        this.pnlMain.setDividerLocation(0.3);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                IndexDispensedUI.this.initSelectCell();
            }
        });
    }

    protected void initSelectCell() {
        ICell iCell = null;
        String indexTypeId = null;
        String id = null;
        Map<String, Object> indexMap = null;
        boolean isSelected = false;
        KDCheckBox curCheckBox = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            iCell = this.tblMain.getRow(i).getCell(this.selectColumn);
            if (iCell != null) {
                indexTypeId = String.valueOf(this.tblMain.getRow(i).getCell(this.indexTypeIdColumn).getValue());
                id = String.valueOf(this.tblMain.getRow(i).getCell(this.idColumn).getValue());
                indexMap = this.selectedCatch.get(indexTypeId);
                isSelected = indexMap != null && indexMap.containsKey(id);
                iCell.setValue((Object)isSelected);
            }
            if (iCell.getEditor() == null) {
                curCheckBox = new KDCheckBox();
                this.initCheckBoxListener(curCheckBox);
                KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JCheckBox)curCheckBox);
                iCell.setEditor((ICellEditor)cellEditor);
            } else {
                curCheckBox = (KDCheckBox)iCell.getEditor().getComponent();
            }
            this.isFireCheckBox = false;
            curCheckBox.setSelected(isSelected);
            this.isFireCheckBox = true;
        }
    }

    private void initCheckBoxListener(KDCheckBox checkBox) {
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent paramItemEvent) {
                if (IndexDispensedUI.this.isFireCheckBox) {
                    KDTreeNode curTreeNode = IndexDispensedUI.this.getSelectedTreeNode();
                    IRow iRow = IndexDispensedUI.this.tblMain.getRow(IndexDispensedUI.this.tblMain.getSelectManager().getActiveRowIndex());
                    IndexDispensedUI.this.catchSelectedIndex(iRow);
                    String indexTypeId = String.valueOf(iRow.getCell(IndexDispensedUI.this.indexTypeIdColumn).getValue());
                    boolean isSelected = false;
                    if (paramItemEvent.getStateChange() == 1) {
                        isSelected = true;
                    } else if (IndexDispensedUI.this.selectedCatch.get(indexTypeId) != null && !IndexDispensedUI.this.selectedCatch.get(indexTypeId).isEmpty()) {
                        isSelected = true;
                    }
                    if (!curTreeNode.isRoot()) {
                        if (curTreeNode != null) {
                            curTreeNode.setChecked(isSelected);
                            IndexDispensedUI.this.treeMain.repaint();
                        }
                    } else if (indexTypeId != null) {
                        IndexDispensedUI.this.searchAndCheckNode(curTreeNode, indexTypeId, isSelected);
                        IndexDispensedUI.this.treeMain.repaint();
                    }
                }
            }
        });
    }

    protected void initTree() throws Exception {
        if (!this.isUserNull || this.isDispensed) {
            this.treeMain.getSelectionModel().setSelectionMode(2);
            this.treeMain.setShowCheckBox(true);
            super.initTree();
            this.treeMain.setSyncChecked(true);
            this.treeMain.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

                public void nodeStateChange(TreeNodeStateChangeEvent event) {
                    KDTreeNode selectNode = (KDTreeNode)event.getNode();
                    if (selectNode != null) {
                        try {
                            IndexDispensedUI.this.isFireCheckBox = false;
                            IndexDispensedUI.this.setTblMainSelected(selectNode.isChecked());
                        }
                        finally {
                            IndexDispensedUI.this.isFireCheckBox = true;
                        }
                    }
                }
            });
        }
    }

    private void setTblMainSelected(boolean isSelected) {
        ICell iCell = null;
        IRow iRow = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            iRow = this.tblMain.getRow(i);
            iCell = iRow.getCell(this.selectColumn);
            if (iCell == null) continue;
            iCell.setValue((Object)isSelected);
            ((KDCheckBox)iCell.getEditor().getComponent()).setSelected(isSelected);
            this.catchSelectedIndex(iRow);
        }
    }

    private void searchAndCheckNode(KDTreeNode curNode, String indexTypeId, boolean checked) {
        int childCount = curNode.getChildCount();
        if (childCount > 0) {
            KDTreeNode childNode = null;
            for (int i = 0; i < childCount; ++i) {
                childNode = (KDTreeNode)curNode.getChildAt(i);
                if (childNode == null || childNode.getUserObject() == null || !(childNode.getUserObject() instanceof IndexTypeInfo)) continue;
                if (indexTypeId.equals(((IndexTypeInfo)childNode.getUserObject()).getId().toString())) {
                    childNode.setChecked(checked);
                    return;
                }
                this.searchAndCheckNode(childNode, indexTypeId, checked);
            }
        }
    }

    public KDTreeNode getSelectedTreeNode() {
        Object comp = this.treeMain.getLastSelectedPathComponent();
        if (comp instanceof KDTreeNode) {
            KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
            return treeNode;
        }
        return null;
    }

    public void checkTreeNodeSelected(ActionEvent e) {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Leaf_MustSelected"));
            SysUtil.abort();
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.refreshTableData();
    }

    protected void refreshTableData() throws BOSException {
        if (this.getSelectedTreeNode() != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (!this.getSelectedTreeNode().isRoot()) {
                IndexTypeInfo selectInfo = (IndexTypeInfo)this.getSelectedTreeNode().getUserObject();
                filter.getFilterItems().add(new FilterItemInfo("indexType.id", (Object)selectInfo.getId().toString()));
                filter.setMaskString("#0");
            } else {
                filter.mergeFilter(this.getAuthorizedOrgTreeFilter("indexType.orgBound.id"), "and");
            }
            view.setFilter(filter);
            view.getSorter().add(new SorterItemInfo("number"));
            this.mainQuery = view;
            try {
                MobileUtil.addGradeManageFilter(this.mainQuery);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            this.mainQuery = null;
        }
        this.tblMain.removeRows();
        int rows = this.tblMain.getRowCount();
        if (rows != 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return IndexTypeFactory.getRemoteInstance();
    }

    protected void catchSelectedIndex(IRow row) {
        ICell iCell = null;
        String id = null;
        String indexTypeId = null;
        Map<String, Object> indexMap = null;
        if (row != null && (iCell = row.getCell(this.selectColumn)) != null) {
            id = String.valueOf(row.getCell(this.idColumn).getValue());
            indexTypeId = String.valueOf(row.getCell(this.indexTypeIdColumn).getValue());
            indexMap = this.selectedCatch.get(indexTypeId);
            if (((KDCheckBox)iCell.getEditor().getComponent()).isSelected()) {
                if (indexMap == null) {
                    indexMap = new HashMap<String, Object>();
                    this.selectedCatch.put(indexTypeId, indexMap);
                }
                if (!indexMap.containsKey(id)) {
                    indexMap.put(id, null);
                }
            } else if (indexMap != null) {
                indexMap.remove(id);
            }
        }
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"IndexTree_RootName");
    }

    @Override
    public void actionAddUser_actionPerformed(ActionEvent e) throws Exception {
        this.addUserByGroup();
    }

    private void addUser() throws Exception {
        Object selectObject;
        KDCommonPromptDialog dlg = this.getAddUserDialog();
        dlg.show();
        if (!dlg.isCanceled() && (selectObject = dlg.getData()) != null && selectObject instanceof Object[] && ((Object[])selectObject).length > 0) {
            this.addUserToTable((Object[])selectObject);
        }
    }

    private void addUserByGroup() throws Exception {
        HashMap uiContext = new HashMap();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelectUserByUserGroupUI.class.getName(), uiContext, null, OprtState.EDIT);
        uiWindow.show();
        if (uiWindow.getUIObject() instanceof SelectUserByUserGroupUI) {
            SelectUserByUserGroupUI ui = (SelectUserByUserGroupUI)uiWindow.getUIObject();
            if (ui.isCanceled()) {
                return;
            }
            Object data = ui.getData();
            if (data != null && data instanceof Object[] && ((Object[])data).length > 0) {
                this.addUserToTable((Object[])data);
            }
        }
    }

    @Override
    public void actionRemoveUser_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.userKDTable);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            this.userKDTable.removeRow(i);
        }
    }

    @Override
    public void actionDispensed_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> selectedUserIds = new ArrayList<String>();
        for (int i = 0; i < this.userKDTable.getRowCount(); ++i) {
            selectedUserIds.add(String.valueOf(this.userKDTable.getCell(i, "id").getValue()));
        }
        if (selectedUserIds.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resuorcePath, (String)"SelectUser"));
            return;
        }
        if (this.checkSelectedCatchEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resuorcePath, (String)"SelectIndex"));
            return;
        }
        boolean result = IndexDispensedFactory.getRemoteInstance().dispensedIndex(selectedUserIds, this.selectedCatch);
        if (result) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resuorcePath, (String)"DispensedSuccess"));
            super.destroyWindow();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resuorcePath, (String)"DispensedFaild"));
        }
    }

    public boolean checkSelectedCatchEmpty() {
        if (!this.selectedCatch.isEmpty()) {
            for (Map<String, Object> curMap : this.selectedCatch.values()) {
                if (curMap == null || curMap.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    protected void addUserToTable(Object[] objects) throws Exception {
        Arrays.sort((Object[])objects, (Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object paramT1, Object paramT2) {
                if (paramT1 != null && paramT2 != null) {
                    return ((UserInfo)paramT1).getNumber().compareTo(((UserInfo)paramT2).getNumber());
                }
                return 0;
            }
        });
        HashMap selectedMap = new HashMap();
        for (int i = 0; i < this.userKDTable.getRowCount(); ++i) {
            selectedMap.put(String.valueOf(this.userKDTable.getCell(i, "id").getValue()), null);
        }
        UserInfo curUserInfo = null;
        IRow iRow = null;
        for (Object curObj : objects) {
            curUserInfo = (UserInfo)curObj;
            if (selectedMap.containsKey(curUserInfo.getId().toString())) continue;
            iRow = this.userKDTable.addRow();
            iRow.getCell("id").setValue((Object)curUserInfo.getId().toString());
            iRow.getCell("account").setValue((Object)curUserInfo.getNumber());
            iRow.getCell("name").setValue((Object)curUserInfo.getName());
            iRow.getCell("type").setValue((Object)curUserInfo.getType());
            iRow.getCell("cu").setValue((Object)curUserInfo.getCU().getName());
            if (curUserInfo.getGroup() != null) {
                iRow.getCell("group").setValue((Object)curUserInfo.getGroup().getName());
            }
            iRow.getCell("isAdmin").setValue((Object)curUserInfo.isBizAdmin());
        }
        selectedMap.clear();
    }

    protected KDCommonPromptDialog getAddUserDialog() throws Exception {
        FilterInfo userFilterInfo = this.getUserFilterInfo();
        SelectorItemCollection sel = this.getUserSelector();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)((Object)this));
        KDCommonPromptDialog dlg = new KDCommonPromptDialog((Dialog)ownerWindow, null);
        dlg.setEnabledMultiSelection(true);
        dlg.setQueryInfo(this.pk);
        dlg.setSelectorCollection(sel);
        if (userFilterInfo != null) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(userFilterInfo);
            dlg.setEntityViewInfo(entityViewInfo);
        }
        return dlg;
    }

    protected FilterInfo getUserFilterInfo() throws Exception {
        FilterInfo userFilterInfo = new FilterInfo();
        userFilterInfo.getFilterItems().add(new FilterItemInfo("defOrgUnit.id", (Object)("select forgid from t_pm_orgrange where  fuserId ='" + SysContext.getSysContext().getCurrentUserInfo().getId().toString() + "' and ftype = " + 30), CompareType.INNER));
        try {
            userFilterInfo.mergeFilter(Administrator.getNotAdminUserFilter(), "AND");
        }
        catch (BOSException ex) {
            logger.error((Object)"IndexDispensedUI:getUserFilterInfo", (Throwable)ex);
            ExceptionHandler.handle((Throwable)ex);
        }
        return userFilterInfo;
    }

    private SelectorItemCollection getUserSelector() {
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("*"));
        sel.add(new SelectorItemInfo("CU.name"));
        sel.add(new SelectorItemInfo("CU.id"));
        sel.add(new SelectorItemInfo("defOrgUnit.id"));
        sel.add(new SelectorItemInfo("defOrgUnit.name"));
        sel.add(new SelectorItemInfo("group.name"));
        sel.add(new SelectorItemInfo("group.id"));
        return sel;
    }

    @Override
    public void actionCloseWin_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return null;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected FilterInfo getDefaultFilterForTree() {
        try {
            FilterInfo filter = MobileUtil.getGradeSettingFilter();
            filter.mergeFilter(this.getAuthorizedOrgTreeFilter("orgBound.id"), "and");
            return filter;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private FilterInfo getAuthorizedOrgTreeFilter(String filterKey) {
        try {
            if (this.authorizedOrgTreeIdSet == null) {
                this.authorizedOrgTreeIdSet = new HashSet<String>();
                UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
                ObjectStringPK pk = new ObjectStringPK(userInfo.getId().toString());
                OrgTreeCollection treeCol = PermissionFactory.getRemoteInstance().getAllUnionTrees((IObjectPK)pk);
                if (treeCol != null && treeCol.size() > 0) {
                    for (int i = 0; i < treeCol.size(); ++i) {
                        this.authorizedOrgTreeIdSet.add(treeCol.get(i).getId().toString());
                    }
                }
                if (this.authorizedOrgTreeIdSet.size() == 0) {
                    this.authorizedOrgTreeIdSet.add("NULL");
                }
            }
            FilterInfo permFilter = new FilterInfo();
            permFilter.getFilterItems().add(new FilterItemInfo(filterKey, this.authorizedOrgTreeIdSet, CompareType.INCLUDE));
            return permFilter;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    protected void initPopmenu() {
    }

    protected void initGroupButton() {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    private String getCurrentCompanyOrgUnitId() {
        return SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
    }
}

