/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptTmpGuideUIUtil;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisFacadeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeCollection;
import com.kingdee.eas.fi.gr.mobile.IndexTypeDimension;
import com.kingdee.eas.fi.gr.mobile.IndexTypeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeInfo;
import com.kingdee.eas.fi.gr.mobile.client.AbstractIndexExecGuideUI;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogHelper;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogNew;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class IndexExecGuideUI
extends AbstractIndexExecGuideUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(IndexExecGuideUI.class);
    private boolean isCalculated = false;
    private IndexTypeInfo itInfo = null;

    protected void initListener() {
        super.initListener();
        this.cbIs13Period.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IndexExecGuideUI.this.cbIs13Period.isSelected()) {
                    IndexExecGuideUI.this.txtSuffix.setText("*");
                } else {
                    IndexExecGuideUI.this.txtSuffix.setText("");
                }
            }
        });
    }

    public void onLoad() {
        MnsRptTmpGuideUIUtil.initGuideImage(this.pnlImage);
        final String indexTypeId = (String)this.getUIContext().get("indexTypeID");
        this.itInfo = this.getIndexTypeInfo(indexTypeId);
        if (IndexTypeDimension.year.equals((Object)this.itInfo.getDimension())) {
            this.contPeriod.setVisible(false);
        }
        final int year = Calendar.getInstance().get(1);
        int month = Calendar.getInstance().get(2) + 1;
        int mp = 12;
        int p = 1;
        int defaultYear = 1;
        int defaultPeriod = 1;
        if (IndexTypeDimension.year.equals((Object)this.itInfo.getDimension())) {
            mp = 12;
            p = 12;
            defaultYear = year - 1;
            defaultPeriod = p;
        } else if (IndexTypeDimension.month.equals((Object)this.itInfo.getDimension())) {
            mp = 12;
            p = month;
            defaultYear = year;
            defaultPeriod = p - 1;
            if (defaultPeriod == 0) {
                --defaultYear;
                defaultPeriod = 12;
            }
        } else if (IndexTypeDimension.quater.equals((Object)this.itInfo.getDimension())) {
            mp = 4;
            p = month == 1 || month == 2 || month == 3 ? 1 : (month == 4 || month == 5 || month == 6 ? 2 : (month == 7 || month == 8 || month == 9 ? 3 : 4));
            defaultYear = year;
            defaultPeriod = p - 1;
            if (defaultPeriod == 0) {
                --defaultYear;
                defaultPeriod = 4;
            }
        }
        final int maxPeriod = mp;
        final int period = p;
        CslRptUIUtil.setSpineRange(this.txtYear, 1900, year, true, false);
        if (year == defaultYear) {
            CslRptUIUtil.setSpineRange(this.txtPeriod, 1, period, true, false);
        } else {
            CslRptUIUtil.setSpineRange(this.txtPeriod, 1, maxPeriod, true, false);
        }
        this.txtYear.setValue((Object)defaultYear);
        if (IndexTypeDimension.year.equals((Object)this.itInfo.getDimension())) {
            if (period != 12) {
                CslRptUIUtil.setSpineRange(this.txtYear, 1900, year - 1, true, false);
                this.txtYear.setValue((Object)(year - 1));
            }
            CslRptUIUtil.setSpineRange(this.txtPeriod, maxPeriod, maxPeriod, true, false);
            this.cbIs13Period.setVisible(true);
            this.txtYear.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    IndexExecGuideUI.this.refreshIs13Period(Integer.parseInt(IndexExecGuideUI.this.txtYear.getValue().toString()), Integer.parseInt(IndexExecGuideUI.this.txtPeriod.getValue().toString()), indexTypeId);
                }
            });
            this.refreshIs13Period(Integer.parseInt(this.txtYear.getValue().toString()), Integer.parseInt(this.txtPeriod.getValue().toString()), indexTypeId);
        } else if (IndexTypeDimension.month.equals((Object)this.itInfo.getDimension()) || IndexTypeDimension.quater.equals((Object)this.itInfo.getDimension())) {
            this.txtPeriod.setValue((Object)defaultPeriod);
            this.txtYear.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int v;
                    int n = v = e.getSource() == null ? 0 : Integer.parseInt(IndexExecGuideUI.this.txtYear.getValue().toString());
                    if (v < year) {
                        CslRptUIUtil.setSpineRange(IndexExecGuideUI.this.txtPeriod, 1, maxPeriod, false, false);
                    } else if (v == year) {
                        int p;
                        CslRptUIUtil.setSpineRange(IndexExecGuideUI.this.txtPeriod, 1, period, false, false);
                        int n2 = p = IndexExecGuideUI.this.txtPeriod.getValue() == null ? 1 : Integer.parseInt(IndexExecGuideUI.this.txtPeriod.getValue().toString());
                        if (p > period) {
                            IndexExecGuideUI.this.txtPeriod.setValue((Object)period);
                        }
                    }
                    if (IndexTypeDimension.month.equals((Object)IndexExecGuideUI.this.itInfo.getDimension()) && Integer.parseInt(IndexExecGuideUI.this.txtPeriod.getValue().toString()) == 12 || IndexTypeDimension.quater.equals((Object)IndexExecGuideUI.this.itInfo.getDimension()) && Integer.parseInt(IndexExecGuideUI.this.txtPeriod.getValue().toString()) == 4) {
                        IndexExecGuideUI.this.refreshIs13Period(Integer.parseInt(IndexExecGuideUI.this.txtYear.getValue().toString()), Integer.parseInt(IndexExecGuideUI.this.txtPeriod.getValue().toString()), indexTypeId);
                    }
                }
            });
            this.txtPeriod.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (IndexTypeDimension.month.equals((Object)IndexExecGuideUI.this.itInfo.getDimension()) && Integer.parseInt(IndexExecGuideUI.this.txtPeriod.getValue().toString()) == 12 || IndexTypeDimension.quater.equals((Object)IndexExecGuideUI.this.itInfo.getDimension()) && Integer.parseInt(IndexExecGuideUI.this.txtPeriod.getValue().toString()) == 4) {
                        IndexExecGuideUI.this.cbIs13Period.setVisible(true);
                        IndexExecGuideUI.this.lblSuffix.setVisible(true);
                        IndexExecGuideUI.this.refreshIs13Period(Integer.parseInt(IndexExecGuideUI.this.txtYear.getValue().toString()), Integer.parseInt(IndexExecGuideUI.this.txtPeriod.getValue().toString()), indexTypeId);
                    } else {
                        IndexExecGuideUI.this.cbIs13Period.setSelected(false);
                        IndexExecGuideUI.this.cbIs13Period.setVisible(false);
                        IndexExecGuideUI.this.lblSuffix.setVisible(false);
                    }
                }
            });
            if (IndexTypeDimension.month.equals((Object)this.itInfo.getDimension()) && defaultPeriod == 12 || IndexTypeDimension.quater.equals((Object)this.itInfo.getDimension()) && defaultPeriod == 4) {
                this.cbIs13Period.setVisible(true);
                this.lblSuffix.setVisible(true);
                this.refreshIs13Period(defaultYear, defaultPeriod, indexTypeId);
            } else {
                this.cbIs13Period.setSelected(false);
                this.cbIs13Period.setVisible(false);
                this.lblSuffix.setVisible(false);
            }
        }
        this.txtIndexName.setText(this.itInfo.getName());
        this.txtOrgBound.setText(this.itInfo.getOrgBound().getName());
        this.txtCurrency.setText(this.itInfo.getCurrency().getName());
        this.txtDimension.setText(this.itInfo.getDimension().getAlias());
        this.txtUnit.setText(this.itInfo.getUnit());
        this.txtFactor.setText(this.itInfo.getFactor() + "");
    }

    private void refreshIs13Period(int year, int period, String indexTypeId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("indexTypeId", indexTypeId);
        param.put("year", year);
        param.put("period", period);
        Map map = null;
        try {
            map = IndexTypeFactory.getRemoteInstance().getIndexCalcGuideInfo(param);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (map != null) {
            this.cbIs13Period.setSelected(((Boolean)map.get("is13Period")).booleanValue());
            String suffix = map.get("suffix") != null ? map.get("suffix").toString() : "*";
            this.txtSuffix.setText(suffix);
        } else {
            this.cbIs13Period.setSelected(false);
            this.txtSuffix.setText("*");
        }
    }

    private IndexTypeInfo getIndexTypeInfo(String id) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("unit"));
        view.getSelector().add(new SelectorItemInfo("factor"));
        view.getSelector().add(new SelectorItemInfo("dimension"));
        view.getSelector().add(new SelectorItemInfo("currency.name"));
        view.getSelector().add(new SelectorItemInfo("orgBound.name"));
        IndexTypeInfo info = null;
        IndexTypeCollection iit = null;
        try {
            iit = IndexTypeFactory.getRemoteInstance().getIndexTypeCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (iit != null) {
            info = iit.get(0);
        }
        return info;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        if (this.isCalculated) {
            this.destroyWindow();
        }
        final String indexTypeID = (String)this.getUIContext().get("indexTypeID");
        final String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        final int year = Integer.valueOf(this.txtYear.getValue().toString());
        final int period = Integer.valueOf(this.txtPeriod.getValue().toString());
        final int periodType = ((RptPeriodTypeEnum)this.getUIContext().get("periodType")).getValue();
        final boolean is13Period = this.cbIs13Period.isSelected();
        ProgressDialogNew progressDialog = ProgressDialogHelper.createProgressDialogNew((CoreUI)this, (boolean)true);
        try {
            this.loadMonitorMsg(progressDialog, true);
            progressDialog.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"IndexType_Calculating"), -1);
                        monitor.setTaskName(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"IndexType_Calculating"));
                        monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"IndexType_Cal_PrepareData"));
                        IndexAnalysisFacadeFactory.getRemoteInstance().runImmediate(userId, indexTypeID, year, period, periodType, is13Period);
                        IndexExecGuideUI.this.udpateIndexCalcGuide();
                        monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)"IndexType_Cal_Finish"));
                    }
                    catch (EASBizException e) {
                        IndexExecGuideUI.this.handleException((Exception)((Object)e));
                    }
                    catch (BOSException e) {
                        IndexExecGuideUI.this.handleException((Exception)((Object)e));
                    }
                    finally {
                        monitor.done();
                    }
                }
            }, progressDialog);
        }
        catch (Exception ex) {
            logger.error((Object)"Report Calculate Progress Error", (Throwable)ex);
        }
        this.isCalculated = true;
        this.destroyWindow();
    }

    private void loadMonitorMsg(ProgressDialogNew dialogNew, boolean canBackRun) {
        if (canBackRun && dialogNew != null) {
            dialogNew.setWindowMsgTitle(DesignerResource.getString((String)"calculate2"));
            dialogNew.setMsg(DesignerResource.getString((String)"calculateComplete"));
            String uiTitle = null;
            String str = this.getUITitle();
            if (str != null) {
                uiTitle = str.substring(str.indexOf("-") + 1, str.length());
            }
            dialogNew.setUiTitle(uiTitle);
        }
    }

    private void udpateIndexCalcGuide() {
        if (this.itInfo != null && (IndexTypeDimension.month.equals((Object)this.itInfo.getDimension()) && Integer.parseInt(this.txtPeriod.getValue().toString()) == 12 || IndexTypeDimension.quater.equals((Object)this.itInfo.getDimension()) && Integer.parseInt(this.txtPeriod.getValue().toString()) == 4 || IndexTypeDimension.year.equals((Object)this.itInfo.getDimension()))) {
            try {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("indexTypeId", (String)this.getUIContext().get("indexTypeID"));
                param.put("year", Integer.valueOf(this.txtYear.getValue().toString()));
                param.put("period", Integer.valueOf(this.txtPeriod.getValue().toString()));
                param.put("is13Period", this.cbIs13Period.isSelected());
                if (this.cbIs13Period.isSelected()) {
                    String suffix = this.txtSuffix.getText();
                    if (suffix.length() > 13) {
                        suffix = suffix.substring(0, 13);
                    }
                    param.put("suffix", suffix);
                } else {
                    param.put("suffix", "");
                }
                IndexTypeFactory.getRemoteInstance().updateIndexCalcGuideInfo(param);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

