/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.mobile.IIndexAnalysisFacade;
import com.kingdee.eas.fi.gr.mobile.IIndexType;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisFacadeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisInfo;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeEntryCollection;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeInfo;
import com.kingdee.eas.fi.gr.mobile.IndexDataElementEnum;
import com.kingdee.eas.fi.gr.mobile.IndexQueryCondition;
import com.kingdee.eas.fi.gr.mobile.IndexTypeCollection;
import com.kingdee.eas.fi.gr.mobile.IndexTypeDimension;
import com.kingdee.eas.fi.gr.mobile.IndexTypeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeInfo;
import com.kingdee.eas.fi.gr.mobile.MobileUtil;
import com.kingdee.eas.fi.gr.mobile.client.AbstractIndexNewBIUI;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.KDTableMoveAction;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class IndexNewBIUI
extends AbstractIndexNewBIUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(IndexNewBIUI.class);
    private IIndexAnalysisFacade iInterface = null;
    private IIndexType iIndexType = null;
    private String defaultNumberFmt = null;
    private boolean isSupport13Period = false;
    private KDTableMoveAction rowMoveAction1 = null;
    private KDTableMoveAction rowMoveAction3 = null;

    public IndexNewBIUI() throws Exception {
        boolean[] values = CSLParamUtil.batchGetParam(null, new String[]{"GR_CSL_Support13Period"});
        this.isSupport13Period = values[0];
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.defaultNumberFmt = CslRptUIUtil.getNumberFtm(2);
        this.iInterface = IndexAnalysisFacadeFactory.getRemoteInstance();
        this.iIndexType = IndexTypeFactory.getRemoteInstance();
        this.initPanelIndex();
        this.initPanelBoss();
        this.initPanelCalcTime();
        this.initPanelSortIndexType();
    }

    public void initPanelIndex() {
        this.tblIndexType.checkParsed();
        this.tblIndexType.getSelectManager().setSelectMode(2);
        this.tblIndexType.getColumn("amount").getStyleAttributes().setNumberFormat(this.defaultNumberFmt);
        this.tblUserDefine.checkParsed();
        this.tblUserDefine.getSelectManager().setSelectMode(2);
        this.rowMoveAction1 = new KDTableMoveAction(this.tblUserDefine);
        this.tblIndexes.checkParsed();
        this.tblIndexes.getSelectManager().setSelectMode(2);
        this.tblDetail.checkParsed();
        this.tblDetail.getSelectManager().setSelectMode(2);
        this.tblHisAmount.checkParsed();
        this.tblHisAmount.getSelectManager().setSelectMode(2);
    }

    public void initPanelBoss() {
        this.tblBossMain.checkParsed();
        this.tblBossMain.getSelectManager().setSelectMode(2);
        this.tblBossChart.checkParsed();
        this.tblBossChart.getSelectManager().setSelectMode(2);
        this.tblPie.checkParsed();
        this.tblPie.getSelectManager().setSelectMode(2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap param = new HashMap();
                    Map map = IndexNewBIUI.this.iInterface.getBossQuery(param);
                    HashSet ids = new HashSet();
                    if (map != null) {
                        List schemeList = (List)map.get("schemeList");
                        for (int i = 0; i < schemeList.size(); ++i) {
                            ids.add(((Map)schemeList.get(i)).get("schemeId"));
                        }
                    }
                    IndexNewBIUI.this.pmptScheme.setQueryInfo("com.kingdee.eas.fi.gr.mobile.IndexSchmeQuery");
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                    view.setFilter(filter);
                    IndexNewBIUI.this.pmptScheme.setEntityViewInfo(view);
                }
                catch (Exception e) {
                    IndexNewBIUI.this.handUIException(e);
                }
            }
        });
    }

    private void initPanelCalcTime() {
        this.tblUpdateCalcTime.checkParsed();
        KDDatePicker dp = new KDDatePicker();
        KDTDefaultCellEditor dcEditor = new KDTDefaultCellEditor(dp);
        this.tblUpdateCalcTime.getColumn("lastCalcTime").setEditor((ICellEditor)dcEditor);
        this.dpDate3.setValue(null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    EntityViewInfo view = new EntityViewInfo();
                    view.getSelector().add(new SelectorItemInfo("id"));
                    view.getSelector().add(new SelectorItemInfo("number"));
                    view.getSelector().add(new SelectorItemInfo("name"));
                    view.getSelector().add(new SelectorItemInfo("lastCalcTime"));
                    MobileUtil.addGradeManageFilter(view);
                    IndexTypeCollection col = IndexNewBIUI.this.iIndexType.getIndexTypeCollection(view);
                    for (int i = 0; i < col.size(); ++i) {
                        IRow row = IndexNewBIUI.this.tblUpdateCalcTime.addRow();
                        IndexTypeInfo info = col.get(i);
                        row.getCell("id").setValue((Object)info.getId().toString());
                        row.getCell("select").setValue((Object)false);
                        row.getCell("number").setValue((Object)info.getNumber());
                        row.getCell("name").setValue((Object)info.getName());
                        row.getCell("lastCalcTime").setValue((Object)info.getLastCalcTime());
                    }
                }
                catch (Exception e) {
                    IndexNewBIUI.this.handUIException(e);
                }
            }
        });
    }

    private void initPanelSortIndexType() {
        this.tblSortIndexType.checkParsed();
        this.rowMoveAction3 = new KDTableMoveAction(this.tblSortIndexType);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap param = new HashMap();
                    Map map = IndexNewBIUI.this.iInterface.getBossQuery(param);
                    HashSet ids = new HashSet();
                    if (map != null) {
                        List schemeList = (List)map.get("schemeList");
                        for (int i = 0; i < schemeList.size(); ++i) {
                            ids.add(((Map)schemeList.get(i)).get("schemeId"));
                        }
                    }
                    IndexNewBIUI.this.pmptScheme3.setQueryInfo("com.kingdee.eas.fi.gr.mobile.IndexSchmeQuery");
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                    view.setFilter(filter);
                    IndexNewBIUI.this.pmptScheme3.setEntityViewInfo(view);
                }
                catch (Exception e) {
                    IndexNewBIUI.this.handUIException(e);
                }
            }
        });
    }

    @Override
    protected void btnQueryBarAndLin_actionPerformed(ActionEvent e) throws Exception {
        this.initTblBossChart();
    }

    @Override
    protected void btnQueryPie_actionPerformed(ActionEvent e) throws Exception {
        this.initTblPie();
    }

    @Override
    protected void btnQueryIndex_actionPerformed(ActionEvent e) throws Exception {
        this.initTblIndexes();
        this.initPanelDetail();
    }

    @Override
    protected void btnBossMain_actionPerformed(ActionEvent e) throws Exception {
        if (this.pmptScheme.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"867_selectScheme"));
            SysUtil.abort();
        }
        if (this.pmptOrgUnit2.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"868_selectOrg"));
            SysUtil.abort();
        }
        this.tblBossMain.removeRows();
        HashMap<String, Object> param = new HashMap<String, Object>();
        IndexAnalysisSchemeInfo schemeInfo = (IndexAnalysisSchemeInfo)this.pmptScheme.getValue();
        IndexTypeInfo indexTypeInfo = schemeInfo.getEntries().get(0).getIndexType();
        indexTypeInfo = this.iIndexType.getIndexTypeInfo((IObjectPK)new ObjectUuidPK(indexTypeInfo.getId().toString()));
        String orgTreeId = this.getTreeByIndexTypeYearPeriod(indexTypeInfo.getId().toString(), this.spinYear.getIntegerVlaue(), this.spinPeriod.getIntegerVlaue());
        OrgUnitInfo ou = (OrgUnitInfo)this.pmptOrgUnit2.getValue();
        OrgStructureCollection col = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection("select id, longNumber where tree.id='" + orgTreeId + "' and unit.id='" + ou.getId().toString() + "'");
        if (col != null && col.size() > 0) {
            param.put("orgId", col.get(0).getId().toString());
            param.put("longNumber", col.get(0).getLongNumber());
        }
        param.put("schemeId", schemeInfo.getId().toString());
        param.put("year", this.spinYear.getIntegerVlaue());
        param.put("period", this.spinPeriod.getIntegerVlaue());
        param.put("treeId", orgTreeId);
        Map map = this.iInterface.getBossMain(param);
        if (map != null && map.get("table") != null) {
            List list = (List)map.get("table");
            for (int i = 0; i < list.size(); ++i) {
                int j;
                Map itMap = (Map)list.get(i);
                List headList1 = (List)itMap.get("head1");
                List headList2 = (List)itMap.get("head2");
                List bodyList = (List)itMap.get("body");
                List columns = (List)itMap.get("columns");
                List indexIds = (List)itMap.get("indexIds");
                Map corner = (Map)itMap.get("corner");
                String corner1 = (String)corner.get("corner1");
                String corner2 = (String)corner.get("corner2");
                if (headList1.size() > this.tblBossMain.getColumnCount() - 2) {
                    int diff = headList1.size() - this.tblBossMain.getColumnCount() + 2;
                    this.tblBossMain.addColumns(diff);
                }
                IRow row = this.tblBossMain.addRow();
                row.getCell("indexId").setValue((Object)"");
                row.getCell("indexName").setValue((Object)(corner1 + "\n" + corner2));
                row.getStyleAttributes().setBackground(Color.decode("#FFFF9C"));
                for (j = 0; j < headList1.size(); ++j) {
                    row.getCell(j + 2).setValue((Object)(headList1.get(j).toString() + headList2.get(j).toString()));
                }
                for (j = 0; j < bodyList.size(); ++j) {
                    row = this.tblBossMain.addRow();
                    row.getCell("indexId").setValue(indexIds.get(j));
                    row.getCell("indexName").setValue(columns.get(j));
                    List bodyRow = (List)bodyList.get(j);
                    for (int k = 0; k < bodyRow.size(); ++k) {
                        row.getCell(k + 2).setValue(bodyRow.get(k));
                    }
                }
            }
        }
    }

    private void initTblPie() throws Exception {
        int r;
        if (this.tblBossMain.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"869_selectTarget"));
            SysUtil.abort();
        }
        if ((r = this.tblBossMain.getSelectManager().get().getBeginRow()) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"869_selectTarget"));
            SysUtil.abort();
        }
        if (this.tblBossMain.getRow(r).getCell("indexId").getValue() == null || StringUtils.isEmpty((String)this.tblBossMain.getRow(r).getCell("indexId").getValue().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"870_selectTargetRow"));
            SysUtil.abort();
        }
        if (this.cmbPieDEType.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"871_selectType"));
            SysUtil.abort();
        }
        this.tblPie.removeRows();
        String indexId = this.tblBossMain.getRow(r).getCell("indexId").getValue().toString();
        HashMap<String, Object> param = new HashMap<String, Object>();
        IndexAnalysisSchemeInfo scheme = (IndexAnalysisSchemeInfo)this.pmptScheme.getValue();
        IndexTypeInfo indexTypeInfo = scheme.getEntries().get(0).getIndexType();
        indexTypeInfo = this.iIndexType.getIndexTypeInfo((IObjectPK)new ObjectUuidPK(indexTypeInfo.getId().toString()));
        param.put("schemeId", scheme.getId().toString());
        param.put("idxId", indexId);
        param.put("treeId", indexTypeInfo.getOrgBound().getId().toString());
        OrgUnitInfo ou = (OrgUnitInfo)this.pmptOrgUnit2.getValue();
        OrgStructureCollection col = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection("select id, longNumber where tree.id='" + indexTypeInfo.getOrgBound().getId().toString() + "' and unit.id='" + ou.getId().toString() + "'");
        if (col != null && col.size() > 0) {
            param.put("orgId", col.get(0).getId().toString());
            param.put("longNumber", col.get(0).getLongNumber());
        }
        param.put("chartType", 3);
        param.put("year", this.spinYear.getIntegerVlaue());
        param.put("period", this.spinPeriod.getIntegerVlaue());
        Map map = this.iInterface.getBossChart(param);
        if (map != null && map.get("deList") != null) {
            List deList = (List)map.get("deList");
            int index = this.cmbPieDEType.getSelectedIndex();
            Map map1 = (Map)deList.get(index);
            String caption = map1.get("caption").toString();
            String subCaption = map1.get("subCaption").toString();
            this.txtPieTitle.setText(caption);
            this.txtPieUnit.setText(subCaption);
            String[] category = (String[])map1.get("category");
            String[] seriesname = (String[])map1.get("seriesname");
            List table = (List)map1.get("table");
            List headList = (List)table.get(0);
            List bodyList = (List)table.get(1);
            for (int i = 0; i < bodyList.size(); ++i) {
                List dataRow = (List)bodyList.get(i);
                IRow row = this.tblPie.addRow();
                row.getCell(0).setValue(dataRow.get(0));
                row.getCell(1).setValue(dataRow.get(1));
                row.getCell(2).setValue(dataRow.get(2));
            }
        }
    }

    @Override
    protected void btnUpdateCalcTime_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblUpdateCalcTime.getRowCount();
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblUpdateCalcTime.getRow(i);
            if (!((Boolean)row.getCell("select").getValue()).booleanValue()) continue;
            Date d = (Date)row.getCell("lastCalcTime").getValue();
            if (d != null) {
                IndexTypeInfo info = new IndexTypeInfo();
                info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
                info.setLastCalcTime(new Timestamp(d.getTime()));
                colls.add((CoreBaseInfo)info);
                continue;
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"872_writeDate"));
            SysUtil.abort();
        }
        Result r = this.iIndexType.update(colls);
        if (r.size() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"873_updateSuccess"));
        }
    }

    @Override
    public void btnSortIndexType_actionPerformed(ActionEvent e) throws Exception {
        if (this.pmptScheme3.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"867_selectScheme"));
            SysUtil.abort();
        }
        int count = this.tblSortIndexType.getRowCount();
        ArrayList<Object> ids = new ArrayList<Object>();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblSortIndexType.getRow(i);
            if (!((Boolean)row.getCell("select").getValue()).booleanValue()) continue;
            ids.add(row.getCell("id").getValue());
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("schemeId", ((IndexAnalysisSchemeInfo)this.pmptScheme3.getValue()).getId().toString());
        param.put("indexType", ids);
        this.iInterface.sortIndexType(param);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"874_schemeOrderSuccess"));
    }

    @Override
    protected void btnQuery_actionPerformed(ActionEvent e) throws Exception {
        super.btnQuery_actionPerformed(e);
        this.tblIndexType.removeRows();
        Map result = this.iInterface.getIdxTypeCollection();
        if (result.get("key_list") != null) {
            List l = (List)result.get("key_list");
            for (int i = 0; i < l.size(); ++i) {
                IRow row = this.tblIndexType.addRow();
                Map m = (Map)l.get(i);
                row.getCell("indexTypeName").setValue(m.get("name"));
                row.getCell("yearAndPeriod").setValue(m.get("unit"));
                row.getCell("amount").setValue(m.get("amount"));
                row.getCell("indexName").setValue(m.get("indexName"));
                row.getCell("id").setValue(m.get("id"));
                row.getCell("indexId").setValue(m.get("indexId"));
            }
        }
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        super.btnClear_actionPerformed(e);
        this.tblIndexType.removeRows();
    }

    @Override
    protected void btnUserDefine_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblUserDefine.getRowCount();
        String ids = "";
        for (int i = 0; i < size; ++i) {
            ids = ids + this.tblUserDefine.getRow(i).getCell("id") + ",";
        }
        if (ids.length() > 0) {
            ids = ids.substring(0, ids.length() - 1);
            this.iInterface.updateIdxTypeCollection(ids);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"875_customThemeSuccess"));
        }
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        this.rowMoveAction1.moveSelectedRowToPreRow();
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        this.rowMoveAction1.moveSelectedRowToNextRow();
    }

    @Override
    protected void btnUp3_actionPerformed(ActionEvent e) throws Exception {
        this.rowMoveAction3.moveSelectedRowToPreRow();
    }

    @Override
    protected void btnDown3_actionPerformed(ActionEvent e) throws Exception {
        this.rowMoveAction3.moveSelectedRowToNextRow();
    }

    @Override
    protected void btnBossQuery_actionPerformed(ActionEvent e) throws Exception {
        super.btnBossQuery_actionPerformed(e);
    }

    @Override
    protected void btnMain_actionPerformed(ActionEvent e) throws Exception {
        super.btnMain_actionPerformed(e);
    }

    @Override
    protected void btnDetail_actionPerformed(ActionEvent e) throws Exception {
        super.btnDetail_actionPerformed(e);
    }

    @Override
    protected void btnSort_actionPerformed(ActionEvent e) throws Exception {
        super.btnSort_actionPerformed(e);
    }

    protected void initListener() {
        super.initListener();
        this.pmptUser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    IndexNewBIUI.this.initTblUserDefine();
                }
                catch (Exception e1) {
                    logger.error((Object)e);
                }
            }
        });
        this.tblIndexType.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    IndexNewBIUI.this.initPanelIndexes();
                }
                catch (Exception ee) {
                    IndexNewBIUI.this.handleException(ee);
                }
            }
        });
        this.tblIndexes.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    IndexNewBIUI.this.initTblDetail();
                }
                catch (Exception ee) {
                    IndexNewBIUI.this.handleException(ee);
                }
            }
        });
        this.spYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    IndexNewBIUI.this.initOrgUnit((OrgUnitInfo)IndexNewBIUI.this.pmptOrgUnit.getValue());
                }
                catch (Exception e1) {
                    IndexNewBIUI.this.handUIException(e1);
                }
            }
        });
        this.spPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    IndexNewBIUI.this.initOrgUnit((OrgUnitInfo)IndexNewBIUI.this.pmptOrgUnit.getValue());
                }
                catch (Exception e1) {
                    IndexNewBIUI.this.handUIException(e1);
                }
            }
        });
        this.pmptScheme.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    IndexNewBIUI.this.initTblBossMain();
                }
                catch (Exception e1) {
                    logger.error((Object)e);
                }
            }
        });
        this.tblBossMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    IndexNewBIUI.this.initPanelBarAndLin();
                    IndexNewBIUI.this.initPanelPie();
                }
                catch (Exception ee) {
                    IndexNewBIUI.this.handleException(ee);
                }
            }
        });
        this.pmptScheme3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    IndexNewBIUI.this.initTblSortIndexType();
                }
                catch (Exception e1) {
                    logger.error((Object)e);
                }
            }
        });
    }

    private void initTblBossMain() throws Exception {
        OrgUnitInfo value = (OrgUnitInfo)this.pmptOrgUnit2.getValue();
        IndexAnalysisSchemeInfo scheme = (IndexAnalysisSchemeInfo)this.pmptScheme.getValue();
        IndexTypeInfo indexTypeInfo = scheme.getEntries().get(0).getIndexType();
        indexTypeInfo = this.iIndexType.getIndexTypeInfo((IObjectPK)new ObjectUuidPK(indexTypeInfo.getId().toString()));
        if (scheme != null && indexTypeInfo != null) {
            if (this.spinYear.getIntegerVlaue() <= 0 || this.spinPeriod.getIntegerVlaue() <= 0) {
                Timestamp ts = indexTypeInfo.getLastCalcTime();
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(ts.getTime());
                int year = c.get(1);
                int month = c.get(2) + 1;
                int period = -1;
                IndexTypeDimension dimension = indexTypeInfo.getDimension();
                period = dimension == IndexTypeDimension.quater ? month / 3 : (dimension == IndexTypeDimension.year ? 12 : month);
                this.spinYear.setValue((Object)year);
                this.spinPeriod.setValue((Object)period);
            }
            String orgTreeId = indexTypeInfo.getId().toString();
            orgTreeId = this.getTreeByIndexTypeYearPeriod(orgTreeId, this.spinYear.getIntegerVlaue(), this.spinPeriod.getIntegerVlaue());
            UnionF7Helper.UnionF7 f7 = UnionF7Helper.getUnionF7((IUIObject)this, (int)3);
            f7.setTreeID(orgTreeId);
            OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
            orgTreeInfo.setId(BOSUuid.read((String)orgTreeId));
            String unitsSql = UnionF7Helper.getUnionSQLByUserPKAndTreePK((IObjectPK)CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), (IObjectPK)CslRptUtil.getPK((IObjectValue)orgTreeInfo));
            f7.filterUnitSql(unitsSql);
            this.pmptOrgUnit2.setSelector((KDPromptSelector)f7);
            this.pmptOrgUnit2.setEnabled(true);
            this.pmptOrgUnit2.setData(value == null ? null : this.getOrgUnitByTreeAndUnit(orgTreeId, value.getNumber()));
        } else {
            this.pmptOrgUnit2.setData(null);
            this.pmptOrgUnit2.setSelector(null);
            this.pmptOrgUnit2.setEnabled(false);
        }
    }

    private void initPanelBarAndLin() throws Exception {
        this.tblBossChart.removeRows();
        this.txtChartTitle.setText("");
        this.txtChartUnit.setText("");
        IndexAnalysisSchemeInfo scheme = (IndexAnalysisSchemeInfo)this.pmptScheme.getValue();
        IndexTypeInfo indexTypeInfo = scheme.getEntries().get(0).getIndexType();
        indexTypeInfo = this.iIndexType.getIndexTypeInfo((IObjectPK)new ObjectUuidPK(indexTypeInfo.getId().toString()));
        this.cmbDEType2.removeAllItems();
        if (indexTypeInfo.isIsProduce()) {
            this.cmbDEType2.addItem((Object)IndexDataElementEnum.Produce);
        }
        if (indexTypeInfo.isIsCumulative()) {
            this.cmbDEType2.addItem((Object)IndexDataElementEnum.Cumulation);
        }
        if (indexTypeInfo.isIsBalance()) {
            this.cmbDEType2.addItem((Object)IndexDataElementEnum.Balance);
        }
    }

    private void initPanelPie() throws Exception {
        this.tblPie.removeRows();
        this.txtPieTitle.setText("");
        this.txtPieUnit.setText("");
        IndexAnalysisSchemeInfo scheme = (IndexAnalysisSchemeInfo)this.pmptScheme.getValue();
        IndexTypeInfo indexTypeInfo = scheme.getEntries().get(0).getIndexType();
        indexTypeInfo = this.iIndexType.getIndexTypeInfo((IObjectPK)new ObjectUuidPK(indexTypeInfo.getId().toString()));
        this.cmbPieDEType.removeAllItems();
        if (indexTypeInfo.isIsProduce()) {
            this.cmbPieDEType.addItem((Object)IndexDataElementEnum.Produce);
        }
        if (indexTypeInfo.isIsCumulative()) {
            this.cmbPieDEType.addItem((Object)IndexDataElementEnum.Cumulation);
        }
        if (indexTypeInfo.isIsBalance()) {
            this.cmbPieDEType.addItem((Object)IndexDataElementEnum.Balance);
        }
    }

    private void initTblBossChart() throws Exception {
        int r;
        if (this.tblBossMain.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"869_selectTarget"));
            SysUtil.abort();
        }
        if ((r = this.tblBossMain.getSelectManager().get().getBeginRow()) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"869_selectTarget"));
            SysUtil.abort();
        }
        if (this.tblBossMain.getRow(r).getCell("indexId").getValue() == null || StringUtils.isEmpty((String)this.tblBossMain.getRow(r).getCell("indexId").getValue().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"870_selectTargetRow"));
            SysUtil.abort();
        }
        if (this.cmbDEType2.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"871_selectType"));
            SysUtil.abort();
        }
        this.tblBossChart.removeRows();
        String indexId = this.tblBossMain.getRow(r).getCell("indexId").getValue().toString();
        HashMap<String, Object> param = new HashMap<String, Object>();
        IndexAnalysisSchemeInfo scheme = (IndexAnalysisSchemeInfo)this.pmptScheme.getValue();
        String col3Name = "";
        String col4Name = "";
        if (scheme.getColumnCharDataType() == 0) {
            col3Name = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"876_yearOnYearNumber");
            col4Name = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"877_yearOnYearRate");
        } else {
            col3Name = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"878_budgetNumber");
            col4Name = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"879_budgetDone");
        }
        this.tblBossChart.getHeadRow(0).getCell(2).setValue((Object)col3Name);
        this.tblBossChart.getHeadRow(0).getCell(3).setValue((Object)col4Name);
        IndexTypeInfo indexTypeInfo = scheme.getEntries().get(0).getIndexType();
        indexTypeInfo = this.iIndexType.getIndexTypeInfo((IObjectPK)new ObjectUuidPK(indexTypeInfo.getId().toString()));
        param.put("schemeId", scheme.getId().toString());
        param.put("idxId", indexId);
        param.put("treeId", indexTypeInfo.getOrgBound().getId().toString());
        OrgUnitInfo ou = (OrgUnitInfo)this.pmptOrgUnit2.getValue();
        OrgStructureCollection col = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection("select id, longNumber where tree.id='" + indexTypeInfo.getOrgBound().getId().toString() + "' and unit.id='" + ou.getId().toString() + "'");
        if (col != null && col.size() > 0) {
            param.put("orgId", col.get(0).getId().toString());
            param.put("longNumber", col.get(0).getLongNumber());
        }
        param.put("chartType", 1);
        param.put("year", this.spinYear.getIntegerVlaue());
        param.put("period", this.spinPeriod.getIntegerVlaue());
        Map map = this.iInterface.getBossChart(param);
        if (map != null && map.get("deList") != null) {
            List deList = (List)map.get("deList");
            int index = this.cmbDEType2.getSelectedIndex();
            Map map1 = (Map)deList.get(index);
            String caption = map1.get("caption").toString();
            String subCaption = map1.get("subCaption").toString();
            this.txtChartTitle.setText(caption);
            this.txtChartUnit.setText(subCaption);
            String[] category = (String[])map1.get("category");
            String[] seriesname = (String[])map1.get("seriesname");
            List table = (List)map1.get("table");
            List headList = (List)table.get(0);
            List bodyList = (List)table.get(1);
            for (int i = 0; i < bodyList.size(); ++i) {
                List dataRow = (List)bodyList.get(i);
                IRow row = this.tblBossChart.addRow();
                row.getCell(0).setValue(dataRow.get(0));
                row.getCell(1).setValue(dataRow.get(1));
                row.getCell(2).setValue(dataRow.get(2));
                row.getCell(3).setValue(dataRow.get(3));
            }
        }
    }

    private void initOrgUnit(OrgUnitInfo value) throws Exception {
        this.checkCondition();
        int row = this.tblIndexType.getSelectManager().get().getBeginRow();
        if (row < 0) {
            this.pmptOrgUnit.setData(null);
            this.pmptOrgUnit.setSelector(null);
            this.pmptOrgUnit.setEnabled(false);
        } else {
            String indexTypeId = this.tblIndexType.getRow(row).getCell("id").getValue().toString();
            String orgTreeId = this.getTreeByIndexTypeYearPeriod(indexTypeId, this.spYear.getIntegerVlaue(), this.spPeriod.getIntegerVlaue());
            if (!StringUtils.isEmpty((String)orgTreeId)) {
                UnionF7Helper.UnionF7 f7 = UnionF7Helper.getUnionF7((IUIObject)this, (int)3);
                f7.setTreeID(orgTreeId);
                OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
                orgTreeInfo.setId(BOSUuid.read((String)orgTreeId));
                String unitsSql = UnionF7Helper.getUnionSQLByUserPKAndTreePK((IObjectPK)CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), (IObjectPK)CslRptUtil.getPK((IObjectValue)orgTreeInfo));
                f7.filterUnitSql(unitsSql);
                this.pmptOrgUnit.setSelector((KDPromptSelector)f7);
                this.pmptOrgUnit.setEnabled(true);
                this.pmptOrgUnit.setData(value == null ? null : this.getOrgUnitByTreeAndUnit(orgTreeId, value.getNumber()));
            } else {
                this.pmptOrgUnit.setData(null);
                this.pmptOrgUnit.setSelector(null);
                this.pmptOrgUnit.setEnabled(false);
            }
        }
    }

    private FullOrgUnitInfo getOrgUnitByTreeAndUnit(String treeId, String unitNumber) {
        if (!StringUtils.isEmpty((String)treeId) && !StringUtils.isEmpty((String)unitNumber)) {
            try {
                String permFilterSql = UnionF7Helper.getUnionSQLByUserPKAndTreePK((IObjectPK)CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), (IObjectPK)new ObjectStringPK(treeId));
                FullOrgUnitCollection coll = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection("select id,name,number,longnumber where number='" + unitNumber + "' and id in (" + permFilterSql + ")");
                return coll.get(0);
            }
            catch (BOSException e) {
                logger.error((Object)("getOrgUnitByTreeAndUnit:" + treeId + ":" + unitNumber), (Throwable)e);
            }
        }
        return null;
    }

    private void initTblUserDefine() throws Exception {
        this.tblUserDefine.removeRows();
        UserInfo userInfo = (UserInfo)this.pmptUser.getData();
        if (userInfo != null) {
            Map map = this.iInterface.getIdxTypeDefine();
            if (map == null || map.get("key_list") == null) {
                return;
            }
            List l = (List)map.get("key_list");
            for (int i = 0; i < l.size(); ++i) {
                Map m = (Map)l.get(i);
                IRow row = this.tblUserDefine.addRow();
                row.getCell("select").setValue((Object)false);
                row.getCell("indexTypeName").setValue(m.get("name"));
                row.getCell("isUserDefined").setValue((Object)"1".equals(m.get("isAdded")));
                row.getCell("id").setValue(m.get("id"));
            }
        }
    }

    private void initTblIndexes() throws Exception {
        this.tblIndexes.removeRows();
        this.checkCondition();
        int row = this.tblIndexType.getSelectManager().get().getBeginRow();
        if (row >= 0) {
            String indexTypeId = this.tblIndexType.getRow(row).getCell("id").getValue().toString();
            IndexTypeInfo indexTypeInfo = this.iIndexType.getIndexTypeInfo((IObjectPK)new ObjectUuidPK(indexTypeId));
            IndexQueryCondition cond = new IndexQueryCondition();
            cond.setIdxTypeID(indexTypeId);
            cond.setFirstMainQuery(false);
            cond.setYear(this.spYear.getIntegerVlaue());
            cond.setDimension(indexTypeInfo.getDimension().getValue());
            cond.setPeriod(this.spPeriod.getIntegerVlaue());
            cond.setOrgTreeID(indexTypeInfo.getOrgBound().getId().toString());
            cond.setDataElement(((IndexDataElementEnum)((Object)this.cmbDEType.getSelectedItem())).getValue());
            if (this.pmptOrgUnit.getValue() != null) {
                String treeId = indexTypeInfo.getOrgBound().getId().toString();
                String unitId = ((OrgUnitInfo)this.pmptOrgUnit.getValue()).getId().toString();
                OrgStructureInfo info = OrgStructureFactory.getRemoteInstance().getOrgStructureInfo("select id,longnumber where unit.id='" + unitId + "' and tree.id='" + treeId + "'");
                cond.setLongNumber(info == null ? null : info.getLongNumber());
                cond.setOrgID(info.getId().toString());
            }
            cond.setIdxID(((IndexAnalysisInfo)this.pmptIndex.getValue()).getId().toString());
            cond.setPeriodType(3);
            cond.setUserId("");
            cond.setSortColumnNo("");
            cond.setSortType(1);
            cond.setSearchTxt("");
            if (this.cbMainQueryType.isSelected()) {
                cond.setMainQueryType(2);
            }
            Map map = this.iInterface.getIdxAnaMainData(cond);
            this.fillTblIndexes(map);
        }
    }

    private void checkCondition() {
        if (this.tblIndexType.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"880_selectTheme"));
            SysUtil.abort();
        }
        if (this.tblIndexType.getSelectManager().get() == null || this.tblIndexType.getSelectManager().get().getBeginRow() < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"880_selectTheme"));
            SysUtil.abort();
        }
        if (this.pmptIndex.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"869_selectTarget"));
            SysUtil.abort();
        }
    }

    private void fillTblIndexes(Map map) {
        if (map != null) {
            List result;
            int i;
            List columnnos = (List)map.get("key_columnnos");
            List columnnames = (List)map.get("key_columnnames");
            if (columnnames != null) {
                IRow headRow = this.tblIndexes.getHeadRow(0);
                for (i = 0; i < columnnames.size(); ++i) {
                    headRow.getCell(i + 4).setValue(columnnames.get(i));
                }
            }
            if ((result = (List)map.get("key_list")) != null) {
                for (i = 0; i < result.size(); ++i) {
                    IRow bodyRow = this.tblIndexes.addRow();
                    Map rec = (Map)result.get(i);
                    bodyRow.getCell(1).setValue(rec.get("orgID"));
                    bodyRow.getCell(2).setValue(rec.get("orgName"));
                    bodyRow.getCell(3).setValue(rec.get("longNumber"));
                    for (int j = 0; j < columnnos.size(); ++j) {
                        bodyRow.getCell(j + 4).setValue((Object)((String)rec.get(columnnos.get(j))).toString());
                    }
                    bodyRow.setUserObject((Object)rec);
                }
            }
        }
    }

    private void initPanelIndexes() throws Exception {
        this.tblIndexes.removeRows();
        int row = this.tblIndexType.getSelectManager().get().getBeginRow();
        if (row >= 0) {
            String indexTypeId = this.tblIndexType.getRow(row).getCell("id").getValue().toString();
            IndexTypeInfo indexTypeInfo = this.iIndexType.getIndexTypeInfo((IObjectPK)new ObjectUuidPK(indexTypeId));
            Timestamp ts = indexTypeInfo.getLastCalcTime();
            int year = -1;
            int month = -1;
            Calendar c = Calendar.getInstance();
            if (ts != null) {
                c.setTimeInMillis(ts.getTime());
            } else {
                c.setTime(new Date());
            }
            year = c.get(1);
            month = c.get(2) + 1;
            this.spYear.setValue((Object)year, false);
            this.spPeriod.setValue((Object)month, false);
            this.cmbDEType.removeAllItems();
            if (indexTypeInfo.isIsProduce()) {
                this.cmbDEType.addItem((Object)IndexDataElementEnum.Produce);
            }
            if (indexTypeInfo.isIsCumulative()) {
                this.cmbDEType.addItem((Object)IndexDataElementEnum.Cumulation);
            }
            if (indexTypeInfo.isIsBalance()) {
                this.cmbDEType.addItem((Object)IndexDataElementEnum.Balance);
            }
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            String treeId = indexTypeInfo.getOrgBound().getId().toString();
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setTreeID(treeId);
            f7.setCtrlUnitPK(indexTypeInfo.getOrgBound().getCU());
            f7.setMultiSelect(false);
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            this.pmptOrgUnit.setSelector((KDPromptSelector)f7);
            this.pmptOrgUnit.setEditable(true);
            this.pmptOrgUnit.setValue(null);
            this.pmptIndex.setQueryInfo("com.kingdee.eas.fi.gr.mobile.IndexAnalysisQuery");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("indexType.id", (Object)indexTypeId));
            this.pmptIndex.setEntityViewInfo(view);
            this.pmptIndex.setValue(null);
        }
    }

    private void initTblDetail() throws Exception {
        this.initPanelDetail();
        int r = this.tblIndexes.getSelectManager().get().getBeginRow();
        if (r >= 0 && this.pmptIndex.getValue() != null) {
            IndexQueryCondition cond = new IndexQueryCondition();
            IndexAnalysisInfo indexInfo = (IndexAnalysisInfo)this.pmptIndex.getValue();
            cond.setIdxTypeID(indexInfo.getIndexType().getId().toString());
            cond.setYear(this.spYear.getIntegerVlaue());
            cond.setPeriod(this.spPeriod.getIntegerVlaue());
            cond.setUserId("");
            cond.setOrgID(this.tblIndexes.getRow(r).getCell("orgId").getValue().toString());
            cond.setIdxID(((IndexAnalysisInfo)this.pmptIndex.getValue()).getId().toString());
            cond.setDataElement(((IndexDataElementEnum)((Object)this.cmbDEType.getSelectedItem())).getValue());
            Map map = this.iInterface.getIdxAnaDetailData(cond);
            if (map != null && map.size() > 0) {
                List detailList = (List)map.get("key_detailList");
                List chartList = (List)map.get("key_chartList");
                Map tab3 = (Map)map.get("key_tab3");
                Map condMap = (Map)map.get("key_other");
                this.txtUpdateDate.setText((String)condMap.get("updateTime"));
                this.txtUnit.setText((String)condMap.get("unit"));
                this.txtTitle.setText((String)condMap.get("chartTitle"));
                this.txtDescription.setText((String)tab3.get("description"));
                for (int i = 0; i < detailList.size(); ++i) {
                    IRow row = this.tblDetail.addRow();
                    Map rec = (Map)detailList.get(i);
                    row.getCell(0).setValue(rec.get("dataTypeName"));
                    row.getCell(1).setValue(rec.get("amount"));
                }
                List list3 = (List)map.get("key_chartList");
                for (int i = 0; i < list3.size(); ++i) {
                    IRow row = this.tblHisAmount.addRow();
                    Map rec = (Map)list3.get(i);
                    row.getCell("year").setValue(rec.get("relPeriod"));
                    row.getCell("period").setValue(rec.get("period"));
                    row.getCell("amount").setValue(rec.get("amount"));
                }
            }
        }
    }

    private void initTblSortIndexType() throws Exception {
        this.tblSortIndexType.removeRows();
        IndexAnalysisSchemeInfo info = (IndexAnalysisSchemeInfo)this.pmptScheme3.getValue();
        IndexAnalysisSchemeEntryCollection col = info.getEntries();
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < col.size(); ++i) {
            ids.add(col.get(i).getIndexType().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        IndexTypeCollection c = this.iIndexType.getIndexTypeCollection(view);
        for (int i = 0; i < c.size(); ++i) {
            IRow row = this.tblSortIndexType.addRow();
            row.getCell("id").setValue((Object)c.get(i).getId().toString());
            row.getCell("select").setValue((Object)false);
            row.getCell("number").setValue((Object)c.get(i).getNumber());
            row.getCell("name").setValue((Object)c.get(i).getName());
        }
    }

    private void initPanelDetail() throws Exception {
        this.tblDetail.removeRows();
        this.tblHisAmount.removeRows();
        this.txtUpdateDate.setText(null);
        this.txtUnit.setText(null);
        this.txtTitle.setText(null);
        this.txtDescription.setText(null);
    }

    private String getTreeByIndexTypeYearPeriod(String indexTypeId, int year, int period) throws Exception {
        Date rptDate = (Date)RPTDate13Util.getRptYearAndPeriodAndDate(year, period, 3, 0, 0, this.isSupport13Period).get(2);
        IndexTypeInfo itInfo = IndexTypeFactory.getRemoteInstance().getIndexTypeInfo((IObjectPK)new ObjectUuidPK(indexTypeId));
        String oldTreeId = itInfo.getOrgBound().getId().toString();
        String oql = "select id,startDate,endDate,name,number where number in (select fnumber from t_org_tree where fid='" + oldTreeId + "') and startDate!= null order by number,startDate asc )";
        OrgTreeCollection col = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection(oql);
        if (col != null && col.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String curDate = sdf.format(rptDate);
            for (int i = 0; i < col.size(); ++i) {
                OrgTreeInfo tree = col.get(i);
                if (sdf.format(tree.getStartDate()).compareTo(curDate) > 0 || tree.getEndDate() != null && sdf.format(tree.getEndDate()).compareTo(curDate) < 0) continue;
                return tree.getId().toString();
            }
        }
        return null;
    }
}

