/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTPrintManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.icon.Icon;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.UnionVersion2F7;
import com.kingdee.eas.fi.gr.mobile.OrgTreeMapingCollection;
import com.kingdee.eas.fi.gr.mobile.OrgTreeMapingFactory;
import com.kingdee.eas.fi.gr.mobile.OrgTreeMapingInfo;
import com.kingdee.eas.fi.gr.mobile.client.AbstractOrgTreeMapingEditUI;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.treetable.TreeIcon;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OrgTreeMapingEditUI
extends AbstractOrgTreeMapingEditUI {
    private static final long serialVersionUID = 6852849103636407820L;
    private static final Logger logger = CoreUIObject.getLogger(OrgTreeMapingEditUI.class);
    private boolean isListenerTrigger = true;
    private TreeRenderer treeRender = null;
    private IFullOrgUnit ifo = FullOrgUnitFactory.getRemoteInstance();

    public void onLoad() throws Exception {
        OrgTreeInfo treeInfo;
        super.onLoad();
        this.mainTable.checkParsed();
        this.initTargetOrgTreeF7();
        this.initTableListener();
        this.btnPrint.setEnabled(true);
        this.btnPrintPre.setEnabled(true);
        Map uiContext = this.getUIContext();
        if (uiContext.containsKey("treeInfo") && (treeInfo = (OrgTreeInfo)uiContext.get("treeInfo")) != null && treeInfo.getId() != null) {
            treeInfo = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo("where id ='" + treeInfo.getId().toString() + "'");
            this.targetOrgTreeF7.setData((Object)treeInfo);
        }
    }

    private void initTableListener() throws Exception {
        OrgTreeMapingEditUI _uiObject = this;
        HashMap permissionTreeMap = new HashMap();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectStringPK pk = new ObjectStringPK(userInfo.getId().toString());
        OrgTreeCollection treeCol = PermissionFactory.getRemoteInstance().getAllUnionTrees((IObjectPK)pk);
        if (treeCol != null && treeCol.size() > 0) {
            for (int i = 0; i < treeCol.size(); ++i) {
                permissionTreeMap.put(treeCol.get(i).getId().toString(), null);
            }
        }
        String filter = CslRptUtil.handleBudgetFilter(null, null, null, null);
        String oql = "select * where type = 8 and (isHide = 0 or isHide is null)";
        if (!StringUtils.isEmpty((String)filter)) {
            oql = oql + " and " + filter;
        }
        oql = oql + " order by number,startDate asc";
        OrgTreeCollection coll = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection(oql);
        for (int i = 0; i < coll.size(); ++i) {
            if (permissionTreeMap.containsKey(coll.get(i).getId().toString())) continue;
            coll.removeObject(i);
            --i;
        }
        permissionTreeMap.clear();
        this.mainTable.addKDTActiveCellListener(new KDTActiveCellListener((IUIObject)_uiObject, coll){
            final /* synthetic */ IUIObject val$_uiObject;
            final /* synthetic */ OrgTreeCollection val$coll;
            {
                this.val$_uiObject = iUIObject;
                this.val$coll = orgTreeCollection;
            }

            public void activeCellChanged(KDTActiveCellEvent e) {
                if (e.getRowIndex() < 0 || e.getColumnIndex() < 0) {
                    return;
                }
                if (OrgTreeMapingEditUI.this.mainTable.getColumn(e.getColumnIndex()).getKey().equals("srcOrgTreeNumber") && OrgTreeMapingEditUI.this.mainTable.getCell(e.getRowIndex(), e.getColumnIndex()).getEditor() == null) {
                    UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7(this.val$_uiObject, 3){

                        protected OrgTreeCollection fillTreeComboOnUnion() throws EASBizException, BOSException {
                            return val$coll;
                        }

                        public Object getData() {
                            OrgTreeInfo treeInfo = this.getComboTreeSelectedItem();
                            OrgStructureInfo structureInfo = new OrgStructureInfo();
                            OrgUnitInfo unitInfo = (OrgUnitInfo)super.getData();
                            FullOrgUnitInfo fullOrgUnit = null;
                            try {
                                fullOrgUnit = OrgTreeMapingEditUI.this.ifo.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(unitInfo.getId().toString()));
                            }
                            catch (EASBizException e) {
                                OrgTreeMapingEditUI.this.handUIException(e);
                            }
                            catch (BOSException e) {
                                OrgTreeMapingEditUI.this.handUIException(e);
                            }
                            structureInfo.setUnit(fullOrgUnit);
                            structureInfo.setTree(treeInfo);
                            return structureInfo;
                        }
                    };
                    f7.setMultiSelect(false);
                    KDBizPromptBox promptBox = new KDBizPromptBox();
                    promptBox.setSelector((KDPromptSelector)f7);
                    KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)promptBox);
                    OrgTreeMapingEditUI.this.mainTable.getCell(e.getRowIndex(), e.getColumnIndex()).setEditor((ICellEditor)cellEditor);
                }
            }
        });
        this.mainTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    if (e.getClickCount() == 1 && OrgTreeMapingEditUI.this.mainTable.getColumn(e.getColIndex()).getKey().equals("targetOrgUnitNumber") && OrgTreeMapingEditUI.this.mainTable.getCell(e.getRowIndex(), e.getColIndex()) != null) {
                        Object curObj = OrgTreeMapingEditUI.this.mainTable.getCell(e.getRowIndex(), e.getColIndex()).getValue();
                        if (OrgTreeMapingEditUI.this.treeRender != null && curObj != null && curObj instanceof OrgStructureInfo && OrgTreeMapingEditUI.this.treeRender.isInRect(((OrgStructureInfo)curObj).getId().toString(), e.getX(), e.getY())) {
                            OrgTreeMapingEditUI.this.expandNode(e.getRowIndex());
                        }
                    }
                }
                catch (Exception exc) {
                    OrgTreeMapingEditUI.this.handUIException(exc);
                }
            }
        });
        this.mainTable.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                if (evt.getRowIndex() < 0 || evt.getColIndex() < 0) {
                    return;
                }
                if (OrgTreeMapingEditUI.this.mainTable.getColumn(evt.getColIndex()).getKey().equals("srcOrgTreeNumber") && OrgTreeMapingEditUI.this.mainTable.getRowCount() > evt.getRowIndex()) {
                    ICell curCell = OrgTreeMapingEditUI.this.mainTable.getCell(evt.getRowIndex(), evt.getColIndex());
                    if (curCell != null) {
                        Object cellObj = curCell.getValue();
                        if (cellObj != null && cellObj instanceof OrgStructureInfo) {
                            OrgStructureInfo orgStructure = (OrgStructureInfo)cellObj;
                            OrgTreeMapingEditUI.this.setMainTableChangeValue(evt.getRowIndex(), orgStructure);
                        } else {
                            OrgTreeMapingEditUI.this.setMainTableChangeValue(evt.getRowIndex(), null);
                        }
                    } else {
                        OrgTreeMapingEditUI.this.setMainTableChangeValue(evt.getRowIndex(), null);
                    }
                }
            }
        });
    }

    private void expandNode(int rowIndex) {
        Object treeNode = this.mainTable.getCell(rowIndex, "targetOrgUnitNumber").getValue();
        if (treeNode != null && treeNode instanceof OrgStructureInfo) {
            OrgStructureInfo parentNode;
            Boolean isExpand = (Boolean)(parentNode = (OrgStructureInfo)treeNode).get("isExpand");
            parentNode.put("isExpand", (Object)(isExpand == false ? 1 : 0));
            this.hideChildRow(parentNode, rowIndex, isExpand);
        }
    }

    private void hideChildRow(OrgStructureInfo parentNode, int parentRowIndex, boolean hided) {
        if (parentNode != null) {
            String parentId = parentNode.getId().toString();
            Object curNode = null;
            while (parentRowIndex < this.mainTable.getRowCount() - 1) {
                OrgStructureInfo childNode;
                if ((curNode = this.mainTable.getCell(++parentRowIndex, "targetOrgUnitNumber").getValue()) == null || !(curNode instanceof OrgStructureInfo) || !(childNode = (OrgStructureInfo)curNode).getParent().getId().toString().equals(parentId)) continue;
                this.mainTable.getRow(parentRowIndex).getStyleAttributes().setHided(hided);
                if (childNode.isIsLeaf()) continue;
                if (hided) {
                    this.hideChildRow(childNode, parentRowIndex, hided);
                    continue;
                }
                if (!((Boolean)childNode.get("isExpand")).booleanValue()) continue;
                this.hideChildRow(childNode, parentRowIndex, false);
            }
        }
    }

    public void setMainTableChangeValue(int rowIndex, OrgStructureInfo orgStructure) {
        if (this.isListenerTrigger) {
            try {
                this.isListenerTrigger = false;
                if (orgStructure != null) {
                    this.mainTable.getCell(rowIndex, "srcOrgTreeNumber").setValue((Object)orgStructure.getTree().getNumber());
                    this.mainTable.getCell(rowIndex, "srcOrgUnitName").setValue((Object)orgStructure.getUnit().getName());
                    this.mainTable.getCell(rowIndex, "srcOrgUnitNumber").setValue((Object)orgStructure.getUnit().getNumber());
                    this.mainTable.getCell(rowIndex, "srcOrgTreeName").setValue((Object)orgStructure.getTree().getName());
                } else {
                    this.mainTable.getCell(rowIndex, "srcOrgTreeNumber").setValue(null);
                    this.mainTable.getCell(rowIndex, "srcOrgUnitName").setValue(null);
                    this.mainTable.getCell(rowIndex, "srcOrgUnitNumber").setValue(null);
                    this.mainTable.getCell(rowIndex, "srcOrgTreeName").setValue(null);
                }
            }
            finally {
                this.isListenerTrigger = true;
            }
        }
    }

    private void initTargetOrgTreeF7() throws Exception {
        UnionVersion2F7 f7 = new UnionVersion2F7();
        f7.setTitile(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.jqorgt"));
        this.targetOrgTreeF7.setSelector((KDPromptSelector)f7);
        this.targetOrgTreeF7.setEditable(false);
        this.targetOrgTreeF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                OrgTreeMapingEditUI.this.initMainTable();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMainTable() {
        block8: {
            this.treeRender = new TreeRenderer();
            this.mainTable.getColumn("targetOrgUnitNumber").setRenderer((IBasicRender)this.treeRender);
            this.mainTable.checkParsed();
            this.mainTable.removeRows(false);
            OrgTreeInfo treeInfo = (OrgTreeInfo)this.targetOrgTreeF7.getData();
            if (treeInfo != null) {
                try {
                    OrgStructureCollection targetOrgStructures = this.getTargetOrgUnit(treeInfo.getId().toString());
                    Map<String, OrgTreeMapingInfo> srcOrgTreeMapings = this.getSrcOrgTreeMapings(targetOrgStructures);
                    if (targetOrgStructures == null) break block8;
                    boolean isTmpTag = this.isListenerTrigger;
                    IRow row = null;
                    OrgStructureInfo info = null;
                    OrgTreeMapingInfo orgTreeMapingInfo = null;
                    for (int i = 0; i < targetOrgStructures.size(); ++i) {
                        info = targetOrgStructures.get(i);
                        row = this.mainTable.addRow();
                        info.put("isExpand", (Object)Boolean.TRUE);
                        row.getCell("targetOrgUnitNumber").setValue((Object)info);
                        row.getCell("targetOrgUnitName").setValue((Object)info.getUnit().getName());
                        orgTreeMapingInfo = srcOrgTreeMapings.get(info.getTree().getNumber() + info.getUnit().getNumber());
                        if (orgTreeMapingInfo == null) continue;
                        try {
                            if (this.isListenerTrigger) {
                                this.isListenerTrigger = false;
                            }
                            row.getCell("srcOrgTreeNumber").setValue((Object)orgTreeMapingInfo.getSrcOrgTreeNumber());
                        }
                        finally {
                            this.isListenerTrigger = isTmpTag;
                        }
                        row.getCell("srcOrgUnitNumber").setValue((Object)orgTreeMapingInfo.getSrcOrgUnitNumber());
                        row.getCell("srcOrgUnitName").setValue((Object)orgTreeMapingInfo.getSrcOrgUnitName());
                        row.getCell("srcOrgTreeName").setValue((Object)orgTreeMapingInfo.getSrcOrgTreeName());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    SysUtil.abort((Throwable)e);
                }
            }
        }
        Color curColor = new Color(0xF6F6BF);
        this.mainTable.getColumn("srcOrgTreeNumber").getStyleAttributes().setBackground(curColor);
        this.mainTable.getColumn("srcOrgUnitNumber").getStyleAttributes().setBackground(curColor);
        this.mainTable.getColumn("srcOrgUnitName").getStyleAttributes().setBackground(curColor);
        this.mainTable.getColumn("srcOrgTreeName").getStyleAttributes().setBackground(curColor);
        this.mainTable.repaint();
    }

    private Map<String, OrgTreeMapingInfo> getSrcOrgTreeMapings(OrgStructureCollection targetOrgStructures) throws Exception {
        HashMap<String, OrgTreeMapingInfo> map = new HashMap<String, OrgTreeMapingInfo>();
        if (targetOrgStructures != null && targetOrgStructures.size() > 0) {
            StringBuffer ksql = new StringBuffer();
            ksql.append("select targetOrgTreeNumber,targetOrgUnitNumber,srcOrgTreeName,srcOrgTreeNumber,srcOrgUnitNumber,srcOrgUnitName where");
            OrgStructureInfo info = null;
            for (int i = 0; i < targetOrgStructures.size(); ++i) {
                info = targetOrgStructures.get(i);
                if (i > 0) {
                    ksql.append(" or ");
                }
                ksql.append(" (targetOrgTreeNumber='").append(info.getTree().getNumber()).append("'");
                ksql.append(" and targetOrgUnitNumber='").append(info.getUnit().getNumber()).append("')");
            }
            OrgTreeMapingCollection orgTreeMapingColl = OrgTreeMapingFactory.getRemoteInstance().getOrgTreeMapingCollection(ksql.toString());
            OrgTreeMapingInfo orgTreeMapingInfo = null;
            for (int i = 0; i < orgTreeMapingColl.size(); ++i) {
                orgTreeMapingInfo = orgTreeMapingColl.get(i);
                map.put(orgTreeMapingInfo.getTargetOrgTreeNumber() + orgTreeMapingInfo.getTargetOrgUnitNumber(), orgTreeMapingInfo);
            }
        }
        return map;
    }

    private OrgStructureCollection getTargetOrgUnit(String targetOrgTreeId) throws Exception {
        OrgTreeInfo treeInfo = (OrgTreeInfo)this.targetOrgTreeF7.getData();
        if (treeInfo != null) {
            OrgStructureCollection orgStructureColl = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection("select id,level,isLeaf,unit.name,unit.number,unit.id,tree.number,unit.isunion,parent.id where tree.id='" + targetOrgTreeId + "'  order by longnumber asc");
            OrgStructureInfo curOrgStrInfo = null;
            HashMap parentMap = new HashMap();
            for (int i = orgStructureColl.size() - 1; i >= 0; --i) {
                curOrgStrInfo = orgStructureColl.get(i);
                if (curOrgStrInfo.getParent() != null && curOrgStrInfo.getParent().getId() != null) {
                    parentMap.put(curOrgStrInfo.getParent().getId().toString(), null);
                }
                if (parentMap.containsKey(curOrgStrInfo.getId().toString())) {
                    curOrgStrInfo.setIsLeaf(false);
                    continue;
                }
                curOrgStrInfo.setIsLeaf(true);
            }
            parentMap.clear();
            return orgStructureColl;
        }
        return null;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.targetOrgTreeF7.getData() != null) {
            CoreBaseCollection colls = new CoreBaseCollection();
            IRow curRow = null;
            OrgStructureInfo targetOrgStructureInfo = null;
            for (int row = 0; row < this.mainTable.getRowCount(); ++row) {
                curRow = this.mainTable.getRow(row);
                if (curRow == null || curRow.getCell("srcOrgTreeNumber").getValue() == null || StringUtils.isEmpty((String)curRow.getCell("srcOrgTreeNumber").getValue().toString().trim())) continue;
                OrgTreeMapingInfo info = new OrgTreeMapingInfo();
                info.setTargetOrgTreeNumber(((OrgTreeInfo)this.targetOrgTreeF7.getData()).getNumber());
                if (curRow.getCell("targetOrgUnitName").getValue() != null) {
                    info.setTargetOrgUnitName(curRow.getCell("targetOrgUnitName").getValue().toString().trim());
                }
                targetOrgStructureInfo = (OrgStructureInfo)curRow.getCell("targetOrgUnitNumber").getValue();
                info.setTargetOrgUnitNumber(targetOrgStructureInfo.getUnit().getNumber());
                if (curRow.getCell("srcOrgTreeName").getValue() != null) {
                    info.setSrcOrgTreeName(curRow.getCell("srcOrgTreeName").getValue().toString().trim());
                }
                info.setSrcOrgTreeNumber(curRow.getCell("srcOrgTreeNumber").getValue().toString().trim());
                if (curRow.getCell("srcOrgUnitName").getValue() != null) {
                    info.setSrcOrgUnitName(curRow.getCell("srcOrgUnitName").getValue().toString().trim());
                }
                info.setSrcOrgUnitNumber(curRow.getCell("srcOrgUnitNumber").getValue().toString().trim());
                colls.add((CoreBaseInfo)info);
            }
            if (colls.size() > 0) {
                OrgTreeMapingFactory.getRemoteInstance().addnewBatchData(colls);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"98_CompanyMapingEditUI"));
            }
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.targetOrgTreeF7.getData() != null) {
            OrgTreeInfo treeInfo = (OrgTreeInfo)this.targetOrgTreeF7.getData();
            if (MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource.DeleteTreeMaping"), treeInfo.getName() + "(" + treeInfo.getNumber() + ")")) == 0) {
                OrgTreeMapingFactory.getRemoteInstance().delete("where targetOrgTreeNumber='" + treeInfo.getNumber() + "'");
                this.targetOrgTreeF7.setData(null);
                this.mainTable.removeRows(false);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"97_CompanyMapingEditUI"));
            }
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        KDTPrintManager prm = this.mainTable.getPrintManager();
        prm.print();
    }

    @Override
    public void actionPrintPre_actionPerformed(ActionEvent e) throws Exception {
        KDTPrintManager prm = this.mainTable.getPrintManager();
        prm.printPreview();
    }

    public class TreeRenderer
    implements IBasicRender {
        private Icon cbIcon;
        private SimpleTextRender simpleRender;
        private Map<String, Rectangle> iconRect = new HashMap<String, Rectangle>();

        public TreeRenderer() {
            this.cbIcon = new TreeIcon();
            this.simpleRender = new SimpleTextRender();
        }

        public void draw(Graphics graphics, Shape clip, Object value, Style cellStyle) {
            if (value == null || !(value instanceof OrgStructureInfo)) {
                return;
            }
            OrgStructureInfo orgStructureInfo = (OrgStructureInfo)value;
            int ident = orgStructureInfo.getLevel() * 8;
            Rectangle rect = clip.getBounds();
            int x = rect.x + ident;
            int y = rect.y + (rect.height - this.cbIcon.getHeight()) / 2;
            int v = orgStructureInfo.isIsLeaf() ? 0 : (orgStructureInfo.get("isExpand") == Boolean.TRUE ? 2 : (orgStructureInfo.get("isExpand") == Boolean.FALSE ? 1 : 2));
            Color color = cellStyle.getFontColor();
            graphics.setColor(color);
            int xx = x + this.cbIcon.getWidth() + 8;
            Rectangle newRec = new Rectangle(xx, rect.y, clip.getBounds().width - this.cbIcon.getWidth() - 8, (int)clip.getBounds().getHeight());
            this.simpleRender.draw(graphics, (Shape)newRec, orgStructureInfo.getUnit().getNumber(), cellStyle);
            if (!orgStructureInfo.isIsLeaf()) {
                this.cbIcon.paint((Object)new Integer(v), graphics, x, y);
                this.iconRect.put(orgStructureInfo.getId().toString(), new Rectangle(x, y, this.cbIcon.getWidth(), this.cbIcon.getHeight()));
            }
        }

        public boolean isInRect(String id, int x, int y) {
            Rectangle rectangle = this.iconRect.get(id);
            return rectangle != null && rectangle.x < x && (double)rectangle.x + rectangle.getWidth() > (double)x;
        }
    }
}

