/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.mobile.ReportUserGroupCollection;
import com.kingdee.eas.fi.gr.mobile.ReportUserGroupEntryCollection;
import com.kingdee.eas.fi.gr.mobile.ReportUserGroupEntryFactory;
import com.kingdee.eas.fi.gr.mobile.ReportUserGroupFactory;
import com.kingdee.eas.fi.gr.mobile.ReportUserGroupInfo;
import com.kingdee.eas.fi.gr.mobile.client.AbstractSelectUserByUserGroupUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SelectUserByUserGroupUI
extends AbstractSelectUserByUserGroupUI {
    private static final Logger logger = CoreUIObject.getLogger(SelectUserByUserGroupUI.class);
    private Map<String, List<ItemInfo>> unselectedItems = new HashMap<String, List<ItemInfo>>();
    private List<ItemInfo> selectedItems = new ArrayList<ItemInfo>();
    protected MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.base.permission.app.UserListQuery");
    private boolean canceled = true;
    private static final int MOVE_TO_DEST = 0;
    private static final int MOVE_TO_SOURCE = 1;

    public void onLoad() throws Exception {
        this.tblSource.checkParsed();
        this.tblTarget.checkParsed();
        this.tblSource.setEditable(false);
        this.tblTarget.setEditable(false);
        this.tblSource.getSelectManager().setSelectMode(10);
        this.tblTarget.getSelectManager().setSelectMode(10);
        super.onLoad();
        this.init();
    }

    public Object getData() {
        UserInfo[] a = new UserInfo[this.selectedItems.size()];
        for (int i = 0; i < this.selectedItems.size(); ++i) {
            a[i] = this.selectedItems.get((int)i).userInfo;
        }
        return a;
    }

    private void init() throws Exception {
        String oql = "select id,number,name order by number";
        ReportUserGroupCollection col = ReportUserGroupFactory.getRemoteInstance().getReportUserGroupCollection(oql);
        this.combUserGroup.addItem((Object)"");
        for (int i = 0; i < col.size(); ++i) {
            this.combUserGroup.addItem((Object)col.get(i));
        }
    }

    private void initUserByUserGroup() {
        KDTable table = this.tblSource;
        table.removeRows(false);
        Object c = this.combUserGroup.getSelectedItem();
        String itemNumber = "";
        if (c != null && !"".equals(c) && c instanceof ReportUserGroupInfo) {
            itemNumber = ((ReportUserGroupInfo)c).getNumber();
        }
        List<ItemInfo> list = this.unselectedItems.get(itemNumber);
        String txt = this.txtQuery.getText();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).isMatched(txt)) continue;
                this.createNewRow(table, list.get(i));
            }
        } else if (StringUtils.isEmpty((String)itemNumber)) {
            this.queryAuthorizedUserAndFill();
        } else {
            list = new ArrayList<ItemInfo>();
            this.unselectedItems.put(itemNumber, list);
            String oql = "select id,user.id,user.number,user.name,user.type,user.CU.name,user.group.name,user.bizAdmin where group.number='" + itemNumber + "'";
            try {
                ReportUserGroupEntryCollection col = ReportUserGroupEntryFactory.getRemoteInstance().getReportUserGroupEntryCollection(oql);
                for (int i = 0; i < col.size(); ++i) {
                    UserInfo user = col.get(i).getUser();
                    ItemInfo itemInfo = new ItemInfo(user, col.get(i).getGroup().getNumber());
                    if (itemInfo.isMatched(txt)) {
                        this.createNewRow(table, itemInfo);
                    }
                    list.add(itemInfo);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private void queryAuthorizedUserAndFill() {
        try {
            UserCollection userCol = UserFactory.getRemoteInstance().getUserCollection(this.getQueryUserView());
            List<ItemInfo> list = this.unselectedItems.get("");
            if (list == null) {
                list = new ArrayList<ItemInfo>();
                this.unselectedItems.put("", list);
            }
            this.tblSource.removeRows(false);
            for (int i = 0; i < userCol.size(); ++i) {
                ItemInfo itemInfo = new ItemInfo(userCol.get(i), "");
                list.add(itemInfo);
                this.createNewRow(this.tblSource, itemInfo);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private EntityViewInfo getQueryUserView() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getUserSelector());
        view.setFilter(this.getUserFilterInfo());
        if (!StringUtils.isEmpty((String)this.txtQuery.getText())) {
            int i;
            String searchTxt = "%" + this.txtQuery.getText().trim() + "%";
            StringBuffer maskString = new StringBuffer();
            int size = view.getFilter().getFilterItems().size();
            for (i = 0; i < size; ++i) {
                if (i > 0) {
                    maskString.append(" and ");
                }
                maskString.append("#").append(i);
            }
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)searchTxt, CompareType.LIKE));
            view.getFilter().getFilterItems().add(new FilterItemInfo("name", (Object)searchTxt, CompareType.LIKE));
            maskString.append(" and (#").append(i++).append(" or #").append(i).append(")");
            view.getFilter().setMaskString(maskString.toString());
        }
        return view;
    }

    private SelectorItemCollection getUserSelector() {
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("*"));
        sel.add(new SelectorItemInfo("CU.name"));
        sel.add(new SelectorItemInfo("CU.id"));
        sel.add(new SelectorItemInfo("defOrgUnit.id"));
        sel.add(new SelectorItemInfo("defOrgUnit.name"));
        sel.add(new SelectorItemInfo("group.name"));
        sel.add(new SelectorItemInfo("group.id"));
        return sel;
    }

    protected FilterInfo getUserFilterInfo() throws Exception {
        FilterInfo userFilterInfo = new FilterInfo();
        userFilterInfo.getFilterItems().add(new FilterItemInfo("defOrgUnit.id", (Object)("select forgid from t_pm_orgrange where  fuserId ='" + SysContext.getSysContext().getCurrentUserInfo().getId().toString() + "' and ftype = 30"), CompareType.INNER));
        try {
            userFilterInfo.mergeFilter(Administrator.getNotAdminUserFilter(), "AND");
        }
        catch (BOSException ex) {
            logger.error((Object)"", (Throwable)ex);
            ExceptionHandler.handle((Throwable)ex);
        }
        return userFilterInfo;
    }

    private void createNewRow(KDTable table, ItemInfo itemInfo) {
        IRow row = table.addRow();
        row.getCell(0).setValue((Object)itemInfo.id);
        row.getCell(1).setValue((Object)itemInfo.number);
        row.getCell(2).setValue((Object)itemInfo.name);
        row.getCell(3).setValue((Object)itemInfo.userInfo);
        row.getCell(4).setValue((Object)itemInfo.userGroupNumber);
    }

    @Override
    protected void combUserGroup_itemStateChanged(ItemEvent e) throws Exception {
        this.initUserByUserGroup();
    }

    @Override
    protected void btnRight_actionPerformed(ActionEvent e) throws Exception {
        this.moveItem(0, false);
    }

    @Override
    protected void btnLeft_actionPerformed(ActionEvent e) throws Exception {
        this.moveItem(1, false);
    }

    @Override
    protected void btnAllRight_actionPerformed(ActionEvent e) throws Exception {
        this.moveItem(0, true);
    }

    @Override
    protected void btnAllLeft_actionPerformed(ActionEvent e) throws Exception {
        this.moveItem(1, true);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.setCanceled(false);
        this.destroyWindow();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCanceled(true);
        this.destroyWindow();
    }

    @Override
    protected void tblSource_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.moveItem(0, false);
        }
    }

    @Override
    protected void tblTarget_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.moveItem(1, false);
        }
    }

    @Override
    protected void btnQuery_actionPerformed(ActionEvent e) throws Exception {
        this.filterData();
    }

    @Override
    protected void txtQuery_keyReleased(KeyEvent e) throws Exception {
        this.filterData();
    }

    private void filterData() {
        List<ItemInfo> list;
        String txt = this.txtQuery.getText();
        String itemNumber = "";
        Object o = this.combUserGroup.getSelectedItem();
        if (o != null && o instanceof ReportUserGroupInfo) {
            itemNumber = ((ReportUserGroupInfo)o).getNumber();
        }
        if ((list = this.unselectedItems.get(itemNumber)) != null) {
            this.tblSource.removeRows(false);
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).isMatched(txt)) continue;
                this.createNewRow(this.tblSource, list.get(i));
            }
        }
    }

    private void moveItem(int iMoveDirection, boolean isMoveAll) {
        int i;
        ItemInfo itemInfo;
        KDTable toKdTable;
        KDTable sourceKdTable;
        boolean is2Right;
        String itemNumber = "";
        Object o = this.combUserGroup.getSelectedItem();
        if (o != null && o instanceof ReportUserGroupInfo) {
            itemNumber = ((ReportUserGroupInfo)o).getNumber();
        }
        int iMoveSize = -1;
        boolean bl = is2Right = iMoveDirection == 0;
        if (is2Right) {
            sourceKdTable = this.tblSource;
            toKdTable = this.tblTarget;
        } else {
            sourceKdTable = this.tblTarget;
            toKdTable = this.tblSource;
        }
        if (sourceKdTable.getRowCount() <= 0) {
            return;
        }
        IRow row = null;
        Object userInfo = null;
        if (isMoveAll) {
            int j;
            int count = sourceKdTable.getRowCount();
            if (is2Right) {
                for (j = 0; j < count; ++j) {
                    row = sourceKdTable.getRow(j);
                    ItemInfo itemInfo2 = new ItemInfo((UserInfo)row.getCell(3).getValue(), itemNumber);
                    if (!this.selectedItems.contains(itemInfo2)) {
                        this.selectedItems.add(itemInfo2);
                    }
                    if (this.unselectedItems.get(itemNumber) == null) continue;
                    this.unselectedItems.get(itemNumber).remove(itemInfo2);
                }
            } else {
                for (j = 0; j < count; ++j) {
                    row = sourceKdTable.getRow(j);
                    String number = row.getCell(4).getValue().toString();
                    itemInfo = new ItemInfo((UserInfo)row.getCell(3).getValue(), number);
                    if (this.unselectedItems.get(number) == null) continue;
                    this.unselectedItems.get(number).add(itemInfo);
                }
                this.selectedItems.clear();
            }
            sourceKdTable.removeRows(false);
        } else {
            int i2;
            iMoveSize = sourceKdTable.getSelectManager().size();
            if (iMoveSize <= 0) {
                return;
            }
            ArrayList<Integer> movingList = new ArrayList<Integer>(iMoveSize);
            for (i2 = 0; i2 < iMoveSize; ++i2) {
                int j;
                KDTSelectBlock sb = sourceKdTable.getSelectManager().get(i2);
                if (is2Right) {
                    for (j = sb.getTop(); j <= sb.getBottom(); ++j) {
                        row = sourceKdTable.getRow(j);
                        itemInfo = new ItemInfo((UserInfo)row.getCell(3).getValue(), itemNumber);
                        if (!this.selectedItems.contains(itemInfo)) {
                            this.selectedItems.add(itemInfo);
                        }
                        if (this.unselectedItems.get(itemNumber) != null) {
                            this.unselectedItems.get(itemNumber).remove(itemInfo);
                        }
                        movingList.add(new Integer(j));
                    }
                    continue;
                }
                for (j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    row = sourceKdTable.getRow(j);
                    String number = row.getCell(4).getValue().toString();
                    ItemInfo itemInfo3 = new ItemInfo((UserInfo)row.getCell(3).getValue(), number);
                    if (this.unselectedItems.get(number) != null) {
                        this.unselectedItems.get(number).add(itemInfo3);
                        this.selectedItems.remove(itemInfo3);
                    }
                    movingList.add(new Integer(j));
                }
            }
            Collections.sort(movingList);
            for (i2 = movingList.size() - 1; i2 >= 0; --i2) {
                Integer rowIndex = (Integer)movingList.get(i2);
                sourceKdTable.removeRow(rowIndex.intValue());
            }
        }
        if (is2Right) {
            toKdTable.removeRows(false);
            for (i = 0; i < this.selectedItems.size(); ++i) {
                this.createNewRow(toKdTable, this.selectedItems.get(i));
            }
        } else {
            toKdTable.removeRows(false);
            for (i = 0; i < this.unselectedItems.get(itemNumber).size(); ++i) {
                String txt = this.txtQuery.getText();
                if (!this.unselectedItems.get(itemNumber).get(i).isMatched(txt)) continue;
                this.createNewRow(toKdTable, this.unselectedItems.get(itemNumber).get(i));
            }
        }
    }

    class ItemInfo {
        BOSUuid id;
        String number;
        String name;
        UserInfo userInfo;
        String userGroupNumber;

        public ItemInfo(String id, String number, String name, String userGroupNumber) {
            this.id = BOSUuid.read((String)id);
            this.number = number;
            this.name = name;
            UserInfo userInfo = new UserInfo();
            userInfo.setId(this.id);
            userInfo.setNumber(number);
            userInfo.setName(name);
            this.userInfo = userInfo;
            this.userGroupNumber = userGroupNumber;
        }

        public ItemInfo(UserInfo userInfo, String userGroupNumber) {
            this.id = userInfo.getId();
            this.number = userInfo.getNumber();
            this.name = userInfo.getName();
            this.userInfo = userInfo;
            this.userGroupNumber = userGroupNumber;
        }

        public int hashCode() {
            return this.id.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return this.hashCode() == ((ItemInfo)obj).hashCode();
        }

        public boolean isMatched(String searchTxt) {
            return StringUtils.isEmpty((String)searchTxt) || this.number.indexOf(searchTxt) != -1 || this.name.indexOf(searchTxt) != -1;
        }
    }
}

