/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.fi.gr.mobile.client.AbstractTemplateTypeF7UI;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class TemplateTypeF7UI
extends AbstractTemplateTypeF7UI {
    private static final Logger logger = CoreUIObject.getLogger(TemplateTypeF7UI.class);
    private boolean isCanceled = true;
    private static final BOSUuid ROOT_ID = BOSUuid.read((String)"111111111111111111111111111=");
    private static final String rootDisplayName = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Group_Root");

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCtrls();
        this.setUITitle(this.getUIContext().get("Title").toString());
        this.buildTree();
    }

    private void initCtrls() {
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TemplateTypeF7UI.this.onClickForBtnOK();
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)((Object)TemplateTypeF7UI.this), (Throwable)exc);
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateTypeF7UI.this.onClickForBtnCancel();
            }
        });
        this.kDTree1.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)TemplateTypeF7UI.this.kDTree1.getLastSelectedPathComponent();
                    if (treeNode == null) {
                        return;
                    }
                    TreeNodeObject userObject = (TreeNodeObject)treeNode.getUserObject();
                    if (userObject != null && userObject.isLeaf()) {
                        try {
                            TemplateTypeF7UI.this.onClickForBtnOK();
                        }
                        catch (Exception exc) {
                            ExceptionHandler.handle((Component)((Object)TemplateTypeF7UI.this), (Throwable)exc);
                        }
                    }
                }
            }
        });
    }

    protected void onClickForBtnOK() throws Exception {
        this.checkSelectedNode();
        this.isCanceled = false;
        this.disposeUIWindow();
    }

    protected void checkSelectedNode() throws Exception {
        if (this.kDTree1.getLastSelectedPathComponent() == null) {
            throw new OUException(OUException.PLS_SEL_ONE_ORG);
        }
    }

    protected void onClickForBtnCancel() {
        this.isCanceled = true;
        this.disposeUIWindow();
    }

    public boolean destroyWindow() {
        this.isCanceled = true;
        return super.destroyWindow();
    }

    protected void buildTree() throws Exception {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode(null);
        IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.fi.gr.mobile.app.TemplateTypeF7Query"));
        IRowSet rowSet = queryExecutor.executeQuery();
        root = this.buildTreeNode(this.getRootNode(), this.indexByParent(rowSet, ROOT_ID.toString()));
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root);
        this.kDTree1.setModel((TreeModel)treeModel);
        this.kDTree1.setRootVisible(false);
        this.kDTree1.setShowCheckBox(false);
        this.kDTree1.setShowsRootHandles(true);
        this.kDTree1.repaint();
    }

    public Map<String, List<TreeNodeObject>> indexByParent(IRowSet rowSet, String parentNode) throws SQLException {
        ArrayList<TreeNodeObject> nodeList = new ArrayList<TreeNodeObject>();
        while (rowSet.next()) {
            nodeList.add(new TreeNodeObject(rowSet.getString("id"), rowSet.getString("number"), rowSet.getString("name"), rowSet.getBoolean("isLeaf"), rowSet.getString("parent.id")));
        }
        HashMap<String, List<TreeNodeObject>> result = new HashMap<String, List<TreeNodeObject>>();
        ArrayList<TreeNodeObject> firstLevelList = new ArrayList<TreeNodeObject>();
        String firstLevel = parentNode;
        result.put(firstLevel, firstLevelList);
        for (int i = 0; i < nodeList.size(); ++i) {
            TreeNodeObject node = (TreeNodeObject)nodeList.get(i);
            if (node.getParentId() == null) {
                firstLevelList.add(node);
                continue;
            }
            String parentId = node.getParentId();
            ArrayList<TreeNodeObject> childList = (ArrayList<TreeNodeObject>)result.get(parentId);
            if (childList == null) {
                childList = new ArrayList<TreeNodeObject>();
                childList.add(node);
                result.put(parentId, childList);
                continue;
            }
            childList.add(node);
        }
        return result;
    }

    public KDTreeNode buildTreeNode(TreeNodeObject rootNode, Map<String, List<TreeNodeObject>> map) {
        KDTreeNode node = new KDTreeNode((Object)rootNode);
        node.setText(rootNode.getName());
        node.setUserObject((Object)rootNode);
        List<TreeNodeObject> childList = map.get(rootNode.getId());
        if (childList != null) {
            for (int i = 0; i < childList.size(); ++i) {
                TreeNodeObject childType = childList.get(i);
                node.add((MutableTreeNode)this.buildTreeNode(childType, map));
            }
        }
        return node;
    }

    private TreeNodeObject getRootNode() {
        return new TreeNodeObject(ROOT_ID.toString(), rootDisplayName);
    }

    public Object getData() {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.kDTree1.getLastSelectedPathComponent();
        if (treeNode == null) {
            return null;
        }
        TreeNodeObject nodeObject = (TreeNodeObject)treeNode.getUserObject();
        TemplateTypeInfo templateTypeInfo = new TemplateTypeInfo();
        templateTypeInfo.setId(BOSUuid.read((String)nodeObject.getId()));
        templateTypeInfo.setNumber(nodeObject.getNumber());
        templateTypeInfo.setName(nodeObject.getName());
        return templateTypeInfo;
    }

    protected void initKeyStroke() {
    }

    private static class TreeNodeObject {
        private String id;
        private String number;
        private String name;
        private boolean isleaf;
        private String parentId;

        public TreeNodeObject(String id, String number, String name, boolean isleaf, String parentId) {
            this.id = id;
            this.number = number;
            this.name = name;
            this.isleaf = isleaf;
            this.parentId = parentId;
        }

        public TreeNodeObject(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public boolean isLeaf() {
            return this.isleaf;
        }

        public String getParentId() {
            return this.parentId;
        }

        public String toString() {
            return this.name;
        }
    }
}

