/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.client.scheme;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.mobile.client.scheme.IDispatchPeriodSource;
import com.kingdee.eas.fi.gr.weaverpt.FormatJobProcessSettingAction;
import com.kingdee.eas.fi.rpt.RptCalcSchemeFactory;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SchemeUIUtils {
    private static final Logger log = Logger.getLogger(SchemeUIUtils.class);

    public static boolean show(Object owner, IDispatchPeriodSource source, Logger logger) throws EASBizException, BOSException {
        String tempSchedule;
        if (!source.needShow()) {
            return false;
        }
        ScheduleDef previousScheduleInfo = source.getUserObject();
        String previousSchedule = null;
        if (previousScheduleInfo == null && source.getJobProcess() != null) {
            previousScheduleInfo = SchemeUIUtils.parseJobProcess(source.getJobProcess());
            source.setUserObject(previousScheduleInfo);
        }
        if (previousScheduleInfo != null) {
            previousSchedule = KpdlParser.scheduleToString((ScheduleDef)previousScheduleInfo);
        }
        if ((tempSchedule = ProcessSchedulePlan.open((Object)owner, (String)previousSchedule, (boolean)false)) == null) {
            return false;
        }
        try {
            ScheduleDef scheduleDef = KpdlParser.parseSchedule((String)tempSchedule);
            logger.error((Object)("[WEAVE]tempSchedule:" + tempSchedule));
            ScheduleDef oldSetting = source.getUserObject();
            if (scheduleDef == null || scheduleDef.getDefine() == null || oldSetting != null && scheduleDef.getType() == oldSetting.getType() && scheduleDef.getDefine().equals(oldSetting.getDefine())) {
                return false;
            }
            String newSetting = new FormatJobProcessSettingAction().action(scheduleDef);
            source.setText(newSetting);
            source.setUserObject(scheduleDef);
            return true;
        }
        catch (WfKpdlParseException e1) {
            logger.error((Object)"", (Throwable)e1);
            return false;
        }
    }

    private static ScheduleDef parseJobProcess(String jobProcess) throws EASBizException, BOSException {
        Map map = RptCalcSchemeFactory.getRemoteInstance().getProcessDef(jobProcess);
        ScheduleDef schdef = null;
        if (map == null || map.isEmpty()) {
            return null;
        }
        schdef = new ScheduleDef(null);
        String define = (String)map.get("rpt_cacl_scheme_define");
        String[] defines = define.split(":");
        schdef.setType(ScheduleType.getEnum((String)defines[0]));
        schdef.setDefine(defines[1]);
        schdef.setBeginTime((Date)map.get("rpt_cacl_scheme_begintime"));
        schdef.setUseCalendar(RptUtil.isTrue(map.get("rpt_cacl_scheme_is_use_calendar ")));
        schdef.setOrgUnitId((String)map.get("rpt_cacl_scheme_org"));
        schdef.setInstructionType(1);
        return schdef;
    }

    public static String getTextByDispatchPeriodId(String jobDefID) throws Exception {
        if (!StringUtils.isEmpty((String)jobDefID)) {
            Map map = RptCalcSchemeFactory.getRemoteInstance().getProcessDef(jobDefID);
            ScheduleDef schdef = null;
            if (map != null && !map.isEmpty()) {
                schdef = new ScheduleDef(null);
                String define = (String)map.get("rpt_cacl_scheme_define");
                String[] defines = define.split(":");
                schdef.setType(ScheduleType.getEnum((String)defines[0]));
                schdef.setDefine(defines[1]);
                schdef.setBeginTime((Date)map.get("rpt_cacl_scheme_begintime"));
                schdef.setUseCalendar(RptUtil.isTrue(map.get("rpt_cacl_scheme_is_use_calendar ")));
                schdef.setOrgUnitId((String)map.get("rpt_cacl_scheme_org"));
                schdef.setInstructionType(1);
                return new FormatJobProcessSettingAction().action(schdef);
            }
        }
        return null;
    }

    public static String saveJobProcessDef(IDispatchPeriodSource source) {
        try {
            ScheduleDef schedule = source.getUserObject();
            if (schedule == null) {
                return null;
            }
            String jobProcessDef = source.getJobProcess();
            if (jobProcessDef != null) {
                source.getWorkflowClient().updateProcessSchedule(jobProcessDef, KpdlParser.scheduleToString((ScheduleDef)schedule));
                return jobProcessDef;
            }
            HashMap<String, String> jobContext = new HashMap<String, String>();
            jobContext.put("bizId", ((CoreBaseInfo)source.getJobParam()).getId().toString());
            jobContext.put("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            FunctionObjectInfo function = SchemeUIUtils.buildFunctionObjectInfo(source);
            OperationInfo operation = SchemeUIUtils.buildOperationInfo(source, function);
            jobProcessDef = source.getWorkflowClient().createJobProcessDef(source.getJobTitle(), function, operation, jobContext, KpdlParser.scheduleToString((ScheduleDef)schedule), SysContext.getSysContext().getLocale());
            source.setJobProcess(jobProcessDef);
            return jobProcessDef;
        }
        catch (WfException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return null;
    }

    private static OperationInfo buildOperationInfo(IDispatchPeriodSource source, FunctionObjectInfo function) {
        OperationInfo operation = function.getOperation().get(source.operationIndex());
        return operation;
    }

    private static FunctionObjectInfo buildFunctionObjectInfo(IDispatchPeriodSource source) {
        MetaDataPK functionPK = MetaDataPK.create((String)source.function());
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK);
        return function;
    }
}

