/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.pa.IPaTemplate;
import com.kingdee.eas.fi.gr.pa.PaReportFactory;
import com.kingdee.eas.fi.gr.pa.PaRptTmpTypeEnum;
import com.kingdee.eas.fi.gr.pa.PaTemplateFactory;
import com.kingdee.eas.fi.gr.pa.PaTemplateInfo;
import com.kingdee.eas.fi.gr.pa.PaTemplateTypeInfo;
import com.kingdee.eas.fi.gr.pa.PaTmpException;
import com.kingdee.eas.fi.gr.pa.client.AbstractPaTemplateEditUI;
import com.kingdee.eas.fi.gr.pa.client.PaGroupTreecomponent;
import com.kingdee.eas.fi.gr.pa.client.PaTemplateListUI;
import com.kingdee.eas.fi.gr.pa.client.PaTemplateProcessUI;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.SwingUtilities;

public class PaTemplateEditUI
extends AbstractPaTemplateEditUI {
    private static final long serialVersionUID = -7746469667723419562L;
    private PaTemplateInfo curTemplateInfo;
    private static final String resPath = "com.kingdee.eas.fi.gr.pa.PaTmpUIResource";

    public void onLoad() throws Exception {
        String templateID = (String)this.getUIContext().get("ID");
        if (!StringUtils.isEmpty((String)templateID)) {
            this.setPaTemplateInfo(this.getTemplateInfo(templateID));
        }
        super.onLoad();
        this.initUI(templateID);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setName(this.txtName.getText().trim());
        this.editData.setNumber(this.txtNumber.getText().trim());
        this.editData.setTemplateType(PaRptTmpTypeEnum.PORTFOLIOANALYSISREPORT);
        PaTemplateTypeInfo type = new PaTemplateTypeInfo();
        BOSUuid id = BOSUuid.read((String)this.getUIContext().get("displayTypeId").toString());
        if (!id.equals((Object)PaGroupTreecomponent.getRootId())) {
            type.setId(id);
            this.editData.setDisplayTemplateType(type);
        }
    }

    public void setPaTemplateInfo(PaTemplateInfo newTemplateInfo) {
        this.curTemplateInfo = newTemplateInfo;
    }

    protected PaTemplateInfo getTemplateInfo(String templateID) throws Exception {
        IPaTemplate template = (IPaTemplate)this.getBizInterface();
        return (PaTemplateInfo)template.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)templateID)), this.getSelectors());
    }

    protected PaTemplateInfo getTemplateInfo() {
        return this.curTemplateInfo;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        return sic;
    }

    private void initUI(String templateid) throws EASBizException, BOSException {
        this.menuItemAddNew.setVisible(false);
        this.btnCanclButton.setEnabled(true);
        if (!"ADDNEW".equals(this.getOprtState()) && this.isExistReport(templateid)) {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
        } else {
            this.txtNumber.requestFocus();
        }
        this.setUITitle();
    }

    private boolean isExistReport(String templateid) throws BOSException, EASBizException {
        return PaReportFactory.getRemoteInstance().exists("select fid where paTemplate = '" + templateid + "'");
    }

    private void setUITitle() {
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
        } else {
            this.setUITitle(this.getUITitle() + " " + EASResource.getString((String)resPath, (String)"Edit"));
        }
    }

    protected IObjectValue createNewData() {
        PaTemplateInfo template = new PaTemplateInfo();
        template.setNumber(this.txtNumber.getText().trim());
        template.setName(this.txtName.getText().trim());
        template.setTemplateType(PaRptTmpTypeEnum.PORTFOLIOANALYSISREPORT);
        PaTemplateTypeInfo type = new PaTemplateTypeInfo();
        BOSUuid id = BOSUuid.read((String)this.getUIContext().get("displayTypeId").toString());
        if (!id.equals((Object)PaGroupTreecomponent.getRootId())) {
            type.setId(id);
            template.setDisplayTemplateType(type);
        }
        return template;
    }

    protected void verifyInput() throws Exception {
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            this.txtNumber.requestFocus(true);
            throw new CheckFormulaException(CheckFormulaException.NUMBER_BLANK);
        }
        if ("ADDNEW".equals(this.getOprtState()) || this.isModify() && this.curTemplateInfo != null && !this.curTemplateInfo.getNumber().equals(this.editData.getNumber())) {
            this.checktempCodeDump((PaTemplateInfo)this.getEditDataObject());
        }
        if (this.txtName.getText() == null || this.txtName.getText().trim().length() == 0) {
            this.txtName.requestFocus(true);
            throw new CheckFormulaException(CheckFormulaException.NAME_BLANK);
        }
    }

    public boolean isModify() {
        this.storeFields();
        boolean r = false;
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (!StringUtils.isEmpty((String)this.editData.getNumber())) {
                return true;
            }
            if (!StringUtils.isEmpty((String)this.editData.getName())) {
                return true;
            }
        } else {
            if (!this.curTemplateInfo.getNumber().equals(this.editData.getNumber())) {
                return true;
            }
            if (!this.curTemplateInfo.getName().equals(this.editData.getName())) {
                return true;
            }
        }
        return r;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PaTemplateFactory.getRemoteInstance();
    }

    public boolean getIsCacl() {
        return false;
    }

    public boolean checkBeforeWindowClosing() {
        if ("".equals(this.txtNumber.getText()) && "".equals(this.txtName.getText())) {
            this.setOprtState("VIEW");
        }
        return super.checkBeforeWindowClosing();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        PaTemplateInfo vo = (PaTemplateInfo)this.getEditDataObject();
        if ("EDIT".equals(this.getOprtState())) {
            if (this.isModify() && !this.isExistReport(vo.getId().toString())) {
                this.verifyInput();
                this.getBizInterface().update((IObjectPK)new ObjectUuidPK(vo.getId().toString()), (CoreBaseInfo)vo);
                this.disposeUIWindow();
                MsgBox.showInfo((String)EASResource.getString((String)resPath, (String)"updateSuccess"));
                this.refreshParentList();
            } else {
                this.destroyWindow();
            }
        } else {
            this.verifyInput();
            this.getUIWindow().hide();
            UIContext context = new UIContext(this.getUIContext().get("Owner"));
            context.put((Object)"InitDataObject", (Object)vo);
            final IUIWindow window2 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(PaTemplateProcessUI.class.getName(), (Map)context, null, OprtState.ADDNEW);
            this.disposeUIWindow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    window2.show();
                }
            });
        }
    }

    private void refreshParentList() {
        Map ctx = this.getUIContext();
        Object owner = ctx.get("Owner");
        if (owner instanceof PaTemplateListUI) {
            ((PaTemplateListUI)((Object)owner)).selfRefresh();
        }
    }

    public VirtualSheetParamInfo save() throws Exception {
        IObjectPK pk = null;
        pk = ((ITemplate)this.getBizInterface()).submit((CoreBaseInfo)this.curTemplateInfo);
        this.setOprtState(OprtState.EDIT);
        this.setPaTemplateInfo((PaTemplateInfo)this.getBizInterface().getValue(pk, this.getSelectors()));
        return this.curTemplateInfo;
    }

    private void checktempCodeDump(PaTemplateInfo templateInfo) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)templateInfo.getNumber());
        FilterItemInfo filterItem3 = new FilterItemInfo("templateType", (Object)new Integer(templateInfo.getTemplateType().getValue()));
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItem3);
        boolean isExist = this.getBizInterface().exists(filter);
        if (isExist) {
            throw new PaTmpException(PaTmpException.CODEUP);
        }
    }
}

