/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.client;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.fi.gr.pa.PaTemplateFactory;
import com.kingdee.eas.fi.gr.pa.PaTemplateInfo;
import com.kingdee.eas.fi.gr.pa.client.PaTemplateToolClass;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.ICoreBase;

public class PaTemplateProcessBookProvider
extends IBookProvider {
    public static final String INCLUDE_POSTED = "IncludePosted";
    public static final String INCLUDE_SUB = "IncludeSub";
    public static final String INCLUDE_SUB_ACCOUNT = "IncludeSubAccount";
    public static final String INCLUDE_LEAF = "IncludeLeaf";
    public static final String INCLUDE_LEAF_ACCOUNT = "IncludeLeafAccount";
    public static final String CURRENCY = "Currency";
    public static final String END_PERIOD = "EndPeriod";
    public static final String START_PERIOD = "StartPeriod";
    public static final String END_DATE = "EndDate";
    public static final String START_DATE = "StartDate";
    public static final String END_YEAR = "EndYear";
    public static final String START_YEAR = "StartYear";
    public static final String SHEET_TYPE = "SheetClass";
    public static final String AUTOCALCULATESTATE = "autoCalculateState";
    public static final String INCLUDE_DETAILACCOUNT_ASSTITEM = "IncludeAllAssistItems";

    public PaTemplateProcessBookProvider() {
    }

    public PaTemplateProcessBookProvider(PaTemplateInfo entityInfo) {
        this.setEditValue((IObjectValue)entityInfo);
    }

    public IObjectValue createNewReport() throws Exception {
        return null;
    }

    public String getBizFactoryName() {
        return PaTemplateFactory.class.getName();
    }

    public ICoreBase getBizInterface() throws Exception {
        return PaTemplateFactory.getRemoteInstance();
    }

    public Book loadBook() throws Exception {
        Book book = null;
        if (this.getPaTemplateInfo().getData() != null) {
            book = this.getPaTemplateInfo().getBook();
        }
        if (book == null) {
            return null;
        }
        BookProperties properties = BookProperties.loadFromBook((Book)book);
        ReportVariables variables = properties.getVariables();
        RptSheetParamCollection sheetParam = this.getPaTemplateInfo().getSheetParam();
        for (int i = 0; sheetParam != null && i < sheetParam.size(); ++i) {
            RptSheetParamInfo p = sheetParam.get(i);
            ReportVariables sheetV = PaTemplateProcessBookProvider.sheetParams2Variables(p);
            variables.addAll(sheetV, false);
        }
        properties.restoreToBook(book);
        return book;
    }

    public void restoreBook(Book book) throws Exception {
        ReportVariables variables = ReportVariables.loadFromBook((Book)book);
        this.getPaTemplateInfo().getSheetParam().clear();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            String name = sheet.getSheetName();
            RptSheetParamInfo info = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, null);
            info.setSheetID(sheet.getID());
            info.setRelaType(ReportTypeEnum.PATEMPLATE);
            this.getPaTemplateInfo().getSheetParam().add(info);
        }
        PaTemplateProcessBookProvider.preparePaTemplateInfoSave((IObjectValue)this.getPaTemplateInfo(), book);
        this.getPaTemplateInfo().setBook(book);
    }

    public PaTemplateInfo getPaTemplateInfo() {
        return (PaTemplateInfo)this.getEditValue();
    }

    public static ReportVariables sheetParams2Variables(RptSheetParamInfo p) {
        String sheetName = p.getSheetName();
        ReportVariables variables = null;
        variables = PaTemplateToolClass.initTemplateSheetReservedVariables(sheetName);
        VariableEntry variableEntry = null;
        variableEntry = variables.get(START_YEAR, sheetName);
        variableEntry.setValue(String.valueOf(p.getStartYear()));
        variableEntry.setType(3);
        variableEntry = variables.get(END_YEAR, sheetName);
        variableEntry.setValue(String.valueOf(p.getEndYear()));
        variableEntry.setType(3);
        variableEntry = variables.get(START_PERIOD, sheetName);
        variableEntry.setValue(String.valueOf(p.getStartPeriod()));
        variableEntry.setType(3);
        variableEntry = variables.get(END_PERIOD, sheetName);
        variableEntry.setValue(String.valueOf(p.getEndPeriod()));
        variableEntry.setType(3);
        variableEntry = variables.get(CURRENCY, sheetName);
        variableEntry.setValue(p.getCurrency() == null ? "" : String.valueOf(p.getCurrency().getNumber()));
        variableEntry.setQuery("com.kingdee.eas.basedata.assistant.app.CurrencyAllQuery");
        variableEntry = variables.get(INCLUDE_POSTED, sheetName);
        variableEntry.setValue(String.valueOf(p.isIsIncludingUnposted()));
        variableEntry.setType(1);
        return variables;
    }

    public static void preparePaTemplateInfoSave(IObjectValue model, Book book) {
        VirtualSheetParamInfo virtualSheetParamInfo = (VirtualSheetParamInfo)model;
        ReportVariables variables = ReportVariables.loadFromBook((Book)book);
        virtualSheetParamInfo.getSheetParam().clear();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            String name = sheet.getSheetName();
            RptSheetParamInfo pinfo = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, null);
            pinfo.setSheetID(sheet.getID());
            if (virtualSheetParamInfo instanceof PaTemplateInfo) {
                pinfo.setRelaType(ReportTypeEnum.PATEMPLATE);
            }
            virtualSheetParamInfo.getSheetParam().add(pinfo);
        }
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("templatetype"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        return sic;
    }
}

