/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.client.report;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.pa.PaReportFactory;
import com.kingdee.eas.fi.gr.pa.PaReportInfo;
import com.kingdee.eas.fi.gr.pa.PaRptClientUtil;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.ICoreBase;

public class PaReportProvider
extends IBookProvider {
    public IObjectValue createNewReport() throws Exception {
        PaReportInfo paReportInfo = this.getPaReportInfo();
        if (paReportInfo == null) {
            paReportInfo = new PaReportInfo();
        }
        paReportInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        paReportInfo.setSourceType(RptSrcTypeEnum.PAREPORT);
        if (paReportInfo.getId() == null) {
            paReportInfo.setId(BOSUuid.create((BOSObjectType)paReportInfo.getBOSType()));
        }
        return paReportInfo;
    }

    public PaReportInfo getPaReportInfo() {
        return (PaReportInfo)this.getEditValue();
    }

    public String getBizFactoryName() {
        return PaReportFactory.class.getName();
    }

    public ICoreBase getBizInterface() throws Exception {
        return PaReportFactory.getRemoteInstance();
    }

    public Book loadBook() throws Exception {
        Book book = null;
        if (this.getPaReportInfo().getData() != null) {
            book = this.getPaReportInfo().getBook();
        }
        if (book == null) {
            return null;
        }
        PaRptClientUtil.prepareReportInfo4Display((IObjectValue)this.getPaReportInfo(), book);
        return book;
    }

    public IObjectValue queryEditData(IObjectPK pk) throws Exception {
        return super.queryEditData(pk);
    }

    public void restoreBook(Book book) throws Exception {
        PaRptClientUtil.prepareReportInfo4Save((IObjectValue)this.getPaReportInfo(), book);
        this.getPaReportInfo().setBook(book);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isOpenAutoCalc"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("reportDate"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.isGrouping"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("savePoint"));
        sic.add(new SelectorItemInfo("sheetParam"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add("paTemplate");
        sic.add("paTemplate.id");
        sic.add("paTemplate.number");
        sic.add("paTemplate.name");
        return sic;
    }
}

