/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.client.rptguide;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.fi.gr.pa.PaRptClientUtil;
import com.kingdee.eas.fi.gr.pa.client.rptguide.AbstractPreViewTabUI;
import com.kingdee.eas.fi.gr.pa.client.rptguide.PaRptFillHelper;
import com.kingdee.eas.fi.gr.pa.rptguide.CompanyTabInfo;
import com.kingdee.eas.fi.gr.pa.rptguide.ItemTabInfo;
import com.kingdee.eas.fi.gr.pa.rptguide.PaRptFillinfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;

public class PreViewTabUI
extends AbstractPreViewTabUI {
    private static final long serialVersionUID = -991282589834424895L;
    private static final int SIZE = 5;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo itemInfo = new FilterItemInfo("view", (Object)"1");
        filterInfo.getFilterItems().add(itemInfo);
        filterInfo.setMaskString("#0");
        return filterInfo;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.clear();
        KDTabbedPane tabbedPane = (KDTabbedPane)this.getParent();
        if (tabbedPane == null) {
            return;
        }
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        v.setFilter(filterInfo);
        for (int i = 0; i < tabbedPane.getComponentCount(); ++i) {
            if (!(tabbedPane.getComponent(i) instanceof CustomerQueryPanel)) continue;
            CustomerQueryPanel queryPanel = (CustomerQueryPanel)tabbedPane.getComponent(i);
            filterInfo.getFilterItems().addObjectCollection((IObjectCollection)queryPanel.getFilterInfo().getFilterItems());
        }
        this.loadTable(PaRptFillHelper.makePaRptFillinfo(v));
    }

    public void clear() {
        super.clear();
        this.initTable();
    }

    private void initTable() {
        this.viewTable.removeColumns();
        this.viewTable.setRowCount(-1);
        this.viewTable.setHeadDisplayMode(1);
        this.viewTable.setCellDisplayMode(1);
        this.viewTable.addColumns(5);
        this.viewTable.addRows(5);
    }

    public void loadTable(PaRptFillinfo paRptFillinfo) {
        this.initTable();
        int companySize = paRptFillinfo.getCompanyTabColl().size();
        int itemSize = paRptFillinfo.getItemTabColl().size();
        if (companySize == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)PaRptClientUtil.getResString("15_CompanyNull"));
            SysUtil.abort();
        }
        if (itemSize == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)PaRptClientUtil.getResString("23_ItemNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)paRptFillinfo.getPoint())) {
            MsgBox.showInfo((Component)((Object)this), (String)PaRptClientUtil.getResString("16_pointNull"));
            SysUtil.abort();
        }
        Book book = Book.Manager.getNewBook(null);
        book.setCalculate(false);
        Point point = null;
        Range range = book.getSheet(0).getRange(paRptFillinfo.getPoint(), true);
        if (range == null || range.getBlock(0).getCol() < 0 || range.getBlock(0).getRow() < 0) {
            MsgBox.showError((String)PaRptClientUtil.getResString("22_pointError"));
            SysUtil.abort();
        } else {
            point = new Point(range.getBlock(0).getCol(), range.getBlock(0).getRow());
        }
        if (paRptFillinfo.getFillType() == 0) {
            if (point.y + companySize >= 5) {
                this.viewTable.addRows(point.y + companySize - 5 + 5);
            }
            if (point.x + itemSize >= 5) {
                this.viewTable.addColumns(point.x + itemSize - 5 + 5);
            }
        } else {
            if (point.y + itemSize >= 5) {
                this.viewTable.addRows(point.y + itemSize - 5 + 5);
            }
            if (point.x + companySize >= 5) {
                this.viewTable.addColumns(point.x + companySize - 5 + 5);
            }
        }
        int colIndex = point.x;
        int rowIndex = point.y;
        ICell cell = null;
        for (int i = 0; i < companySize; ++i) {
            CompanyTabInfo companyTabInfo = paRptFillinfo.getCompanyTabColl().get(i);
            cell = paRptFillinfo.getFillType() == 0 ? this.viewTable.getCell(++rowIndex, colIndex) : this.viewTable.getCell(rowIndex, ++colIndex);
            cell.setValue((Object)companyTabInfo.getShowString());
        }
        colIndex = point.x;
        rowIndex = point.y;
        for (int i = 0; i < itemSize; ++i) {
            ItemTabInfo info = paRptFillinfo.getItemTabColl().get(i);
            cell = paRptFillinfo.getFillType() == 0 ? this.viewTable.getCell(rowIndex, ++colIndex) : this.viewTable.getCell(++rowIndex, colIndex);
            String displayName = info.getRPTItemInfo().getName() + "/" + info.getDataElementInfo().getName() + "/" + info.getValueType().getAlias();
            cell.setValue((Object)displayName);
        }
    }
}

