/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgRangeFilterUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgF7Facade;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OrgTreeF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CslRptOrgTreeF7
extends OrgTreeF7 {
    public boolean isCanceled = true;
    protected boolean isMultiSelect = false;
    private boolean isSelectChild = true;
    private boolean triggerExpand = true;
    public List<FullOrgUnitInfo> result = new ArrayList<FullOrgUnitInfo>();
    Map<String, Object> selectLongNumbers = null;
    Map<String, Object> expandNodeLongNumber = new HashMap<String, Object>();
    Map threads = new ConcurrentHashMap();

    public void onLoad() throws Exception {
        this.setUITitle(OrgType.ControlUnit.getAlias());
        this.kDLabelContainer1.setVisible(false);
        this.cboType.setVisible(false);
        this.toolBar.setVisible(false);
        this.cboList.setVisible(false);
        Map map = this.getUIContext();
        this.selectLongNumbers = (Map)map.get("selectIds");
        this.initExpandNode(this.selectLongNumbers);
        this.isMultiSelect = (Boolean)map.get("IsMultiSelect");
        if (this.isMultiSelect) {
            this.treeOrg.getSelectionModel().setSelectionMode(2);
            this.treeOrg.setShowCheckBox(true);
        } else {
            this.treeOrg.getSelectionModel().setSelectionMode(1);
            this.treeOrg.setShowCheckBox(false);
        }
        this.addTreeListener();
        try {
            this.isSelectChild = false;
            this.setTreeData();
        }
        finally {
            this.isSelectChild = true;
        }
    }

    protected void treeOrg_mouseClicked(MouseEvent e) throws Exception {
    }

    private void initExpandNode(Map<String, Object> selectLongNumbers) throws Exception {
        if (selectLongNumbers != null) {
            for (String longNumber : selectLongNumbers.keySet()) {
                while (longNumber.indexOf("!") > 0) {
                    if (this.expandNodeLongNumber.containsKey(longNumber = longNumber.substring(0, longNumber.lastIndexOf("!")))) continue;
                    this.expandNodeLongNumber.put(longNumber, null);
                }
            }
        }
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = false;
        KDTreeNode rootNode = (KDTreeNode)this.treeOrg.getModel().getRoot();
        this.result.clear();
        this.getChildrenNodes(rootNode, this.result);
        if (!this.result.isEmpty()) {
            this.getUIWindow().close();
        }
    }

    void getChildrenNodes(KDTreeNode parent, List<FullOrgUnitInfo> nodeList) {
        Enumeration enum1 = parent.children();
        if (enum1.hasMoreElements()) {
            while (enum1.hasMoreElements()) {
                KDTreeNode node = (KDTreeNode)enum1.nextElement();
                if (node.isChecked()) {
                    nodeList.add((FullOrgUnitInfo)node.getUserObject());
                }
                this.getChildrenNodes(node, nodeList);
            }
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    void setTreeData() throws Exception {
        this.initTree(null, this.getrootCU(), 0);
    }

    private void addTreeListener() {
        this.treeOrg.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                if (CslRptOrgTreeF7.this.triggerExpand) {
                    DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                    CslRptOrgTreeF7.this.expandTree(tmp);
                }
            }
        });
        this.treeOrg.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                if (CslRptOrgTreeF7.this.isSelectChild) {
                    try {
                        CslRptOrgTreeF7.this.triggerExpand = false;
                        KDTreeNode selectNode = (KDTreeNode)event.getNode();
                        if (selectNode != null) {
                            selectNode.setChecked(selectNode.isChecked());
                            CslRptOrgTreeF7.this.getChildrens((DefaultKingdeeTreeNode)selectNode, selectNode.isChecked());
                            CslRptOrgTreeF7.this.treeOrg.repaint();
                        }
                    }
                    finally {
                        CslRptOrgTreeF7.this.triggerExpand = true;
                    }
                }
            }
        });
    }

    private void expandTree(DefaultKingdeeTreeNode curNode) {
        if (curNode == null) {
            return;
        }
        try {
            this.loadNode(curNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadNode(DefaultKingdeeTreeNode tmp) throws BOSException, EASBizException {
        FullOrgUnitInfo unitInfo;
        if (tmp != null && tmp.getUserObject() != null && (unitInfo = (FullOrgUnitInfo)tmp.getUserObject()).get("alreadyLoad") == null) {
            OrgAssistInfo assistInfo = this.buildNewOrgF7AssistInfo();
            INewOrgF7Facade facade = NewOrgF7FacadeFactory.getRemoteInstance();
            List orgCol = facade.getDirectChildren(assistInfo, (CoreBaseInfo)unitInfo);
            this.insertNodeIntoRoot(tmp, orgCol);
            unitInfo.put("alreadyLoad", (Object)true);
        }
    }

    void getChildrens(DefaultKingdeeTreeNode parent, boolean isChecked) {
        this.expandTree(parent);
        Enumeration enum1 = parent.children();
        if (enum1.hasMoreElements()) {
            while (enum1.hasMoreElements()) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enum1.nextElement();
                node.setChecked(isChecked);
                this.getChildrens(node, isChecked);
            }
        }
    }

    private FullOrgUnitInfo getrootCU() throws Exception {
        BOSUuid rootID = BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4");
        ObjectUuidPK pk = new ObjectUuidPK(rootID);
        FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)pk);
        return unitInfo;
    }

    private void initTree(KDTreeNode selectedNode, FullOrgUnitInfo unitInfo, int operate) throws Exception {
        INewOrgF7Facade facade = NewOrgF7FacadeFactory.getRemoteInstance();
        KDTreeNode root = selectedNode != null ? (KDTreeNode)this.treeOrg.getModel().getRoot() : new KDTreeNode((Object)unitInfo);
        this.treeOrg.setModel((TreeModel)new DefaultTreeModel((TreeNode)root){

            @Override
            public boolean isLeaf(Object node) {
                FullOrgUnitInfo info = (FullOrgUnitInfo)((KDTreeNode)node).getUserObject();
                return info == null || info.isIsLeaf();
            }
        });
        OrgAssistInfo assistInfo = this.getOrgAssistInfo(selectedNode, unitInfo, operate);
        if (assistInfo == null) {
            return;
        }
        List orgCol = facade.getDirectChildren(assistInfo, (CoreBaseInfo)unitInfo);
        if (selectedNode == null) {
            this.insertNodeIntoRoot((DefaultKingdeeTreeNode)root, orgCol);
        } else {
            this.insertNodeIntoRoot((DefaultKingdeeTreeNode)selectedNode, orgCol);
            if (orgCol != null && orgCol.size() > 0) {
                ((FullOrgUnitInfo)selectedNode.getUserObject()).setIsLeaf(false);
            }
            ((FullOrgUnitInfo)selectedNode.getUserObject()).put("alreadyLoad", (Object)true);
        }
        ((FullOrgUnitInfo)root.getUserObject()).put("alreadyLoad", (Object)true);
        if (root.getUserObject() == null) {
            this.treeOrg.setRootVisible(false);
        } else {
            this.treeOrg.setRootVisible(true);
        }
        this.treeOrg.setShowsRootHandles(true);
        this.treeOrg.setSelectionNode((DefaultKingdeeTreeNode)root);
        this.treeOrg.updateUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNodeIntoRoot(DefaultKingdeeTreeNode root, List orgCol) {
        for (int i = 0; i < orgCol.size(); ++i) {
            FullOrgUnitInfo info = (FullOrgUnitInfo)orgCol.get(i);
            KDTreeNode treeNode = new KDTreeNode((Object)info);
            treeNode.setCustomIcon(EASResource.getIcon((String)"imgTree_company"));
            treeNode.setCheckBoxEnabled(true);
            if (this.selectLongNumbers.containsKey(info.getLongNumber())) {
                treeNode.setChecked(true);
                this.selectLongNumbers.remove(info.getLongNumber());
            }
            root.add((MutableTreeNode)treeNode);
            if (!this.expandNodeLongNumber.containsKey(info.getLongNumber())) continue;
            Object[] pathtoRoot = treeNode.getPath();
            final TreePath path = new TreePath(pathtoRoot);
            final String id = ((FullOrgUnitInfo)treeNode.getUserObject()).getId().toString();
            try {
                if (treeNode.getParent() != null && ((KDTreeNode)treeNode.getParent()).getUserObject() != null) {
                    final String parentId = ((FullOrgUnitInfo)((KDTreeNode)treeNode.getParent()).getUserObject()).getId().toString();
                    if (parentId != null && this.threads.containsKey(parentId)) {
                        Thread curThread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                while (CslRptOrgTreeF7.this.threads.containsKey(parentId)) {
                                    try {
                                        Thread.sleep(10L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                CslRptOrgTreeF7.this.threads.put(id, this);
                                CslRptOrgTreeF7.this.treeOrg.expandPath(path);
                            }
                        });
                        curThread.start();
                    } else {
                        this.threads.put(id, this);
                        this.treeOrg.expandPath(path);
                    }
                } else {
                    this.threads.put(id, this);
                    this.treeOrg.expandPath(path);
                }
            }
            finally {
                this.threads.remove(id);
            }
            this.expandNodeLongNumber.remove(info.getLongNumber());
        }
    }

    private OrgAssistInfo getOrgAssistInfo(KDTreeNode selectedNode, FullOrgUnitInfo unitInfo, int operate) throws EASBizException, BOSException {
        OrgAssistInfo assistInfo = null;
        assistInfo = this.buildNewOrgF7AssistInfo();
        if (selectedNode != null) {
            selectedNode.removeAllChildren();
        }
        return assistInfo;
    }

    private OrgAssistInfo buildNewOrgF7AssistInfo() {
        OrgAssistInfo assistInfo = new OrgAssistInfo();
        StringBuffer extraFilters = new StringBuffer();
        extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FIsCU = 1 ");
        assistInfo.setExtraFilters(extraFilters.toString());
        assistInfo.setInnerJoinStyle(false);
        ArrayList<String> decorators = new ArrayList<String>();
        decorators.add(null);
        decorators.add("com.kingdee.eas.basedata.org.app.helper.NormalFilter4F7Decorator");
        decorators.add("com.kingdee.eas.basedata.org.app.helper.OrgRangeFilter4F7Decorator");
        assistInfo.setConstructParam(decorators);
        assistInfo.setNeedAddSealUpFilter(true);
        assistInfo.setNeedAddAssistantFilter(true);
        assistInfo.setInnerJoinStyle(false);
        if (AdminOrgRangeFilterUtil.isFilterByUserAdminOrgRange(null)) {
            assistInfo.setNeedAddOrgRange(true);
            assistInfo.setOrgRangeType(2);
        }
        return assistInfo;
    }
}

