/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.client.itask;

import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.rptintegration.DataCenterInfo;
import com.kingdee.eas.fi.gr.rptintegration.client.itask.TaskManager;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.DataCenterUtil;
import com.kingdee.eas.fi.gr.rptintegration.util.ResultInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeHandle;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.util.synchronize.push.TriggerBatchDownLoadPush;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceClient;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SynBatchTask
extends TaskManager {
    WebServiceClient webServiceClient;
    WebServiceInfo xbangServiceInfo;
    List<WebServiceInfo> webServiceList;
    List<String> ids = null;
    String bosType = null;

    public SynBatchTask(List<String> ids, String bosType, Component cc) throws Exception {
        DataCenterInfo datacenterInfo = DataCenterUtil.getCurrentDatacenter(null);
        if (datacenterInfo == null) {
            MsgBox.showWarning((Component)cc, (String)CoreUtils.getResourceStr(null, "NotCurrentDataCenter"));
            SysUtil.abort();
        }
        this.webServiceList = DataCenterUtil.getWebserviceList(null, "parent.id='" + datacenterInfo.getId().toString() + "'");
        if (this.webServiceList == null || this.webServiceList.size() <= 0) {
            MsgBox.showWarning((Component)cc, (String)CoreUtils.getResourceStr(null, "notSubDataCenter"));
            SysUtil.abort();
        }
        this.ids = ids;
        this.bosType = bosType;
    }

    @Override
    public ResultInfo executeTask(int step) throws Exception {
        if (step == this.getTaskStepCount() - 1) {
            return null;
        }
        if (this.webServiceClient == null) {
            this.webServiceClient = WebServiceClient.getInstance();
        }
        int mod = step % 2;
        int count = step / 2;
        if (mod == 0) {
            this.xbangServiceInfo = this.webServiceList.get(count);
            boolean islogin = this.webServiceClient.login(this.xbangServiceInfo);
            if (!islogin) {
                throw new NullPointerException(CoreUtils.getResourceStr(null, "DataCenter") + "[" + this.xbangServiceInfo.getDataCenterName() + "]" + CoreUtils.getResourceStr(null, "ConnectFail"));
            }
            return null;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        if (this.bosType.equals(new OrgUnitInfo().getBOSType().toString())) {
            params.add(new Object[]{SynchronizeType.getFullOrgUnitInfo, "id"});
            params.add(new Object[]{SynchronizeType.oUPartUnionGroup, "unit.id"});
        } else if (this.bosType.equals(new RPTItemInfo().getBOSType().toString())) {
            params.add(new Object[]{SynchronizeType.getRptItems, "id"});
            params.add(new Object[]{SynchronizeType.itemRelationShip, "item.id"});
            params.add(new Object[]{SynchronizeType.itemRelationShipEntry, "targetItem.id"});
        } else {
            if (this.bosType.equals(new OrgTreeInfo().getBOSType().toString())) {
                params.add(new Object[]{SynchronizeType.getOrgTreeTask, "id"});
                OrgTreeCollection orgTreeCol = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection("select number where id in(" + CslRptUtil.list2String(this.ids, ",", true) + ")");
                ArrayList<String> numbers = new ArrayList<String>();
                for (int i = 0; i < orgTreeCol.size(); ++i) {
                    numbers.add(orgTreeCol.get(i).getNumber());
                }
                if (numbers.isEmpty()) {
                    return this.result;
                }
                SynchronizeHandle triggerDownLoadObj = SynchronizeType.getSynType2HandleObject().get(SynchronizeType.triggerBatchDownLoadPush);
                this.result = ((TriggerBatchDownLoadPush)triggerDownLoadObj).triggerDownLoadHandleForBatch(null, params, numbers, this.bosType, this.webServiceClient, this.xbangServiceInfo);
                return this.result;
            }
            if (this.bosType.equals(new DataElementInfo().getBOSType().toString())) {
                params.add(new Object[]{SynchronizeType.getDataElementTask, "id"});
            }
        }
        if (this.ids.isEmpty()) {
            return this.result;
        }
        SynchronizeHandle triggerDownLoadObj = SynchronizeType.getSynType2HandleObject().get(SynchronizeType.triggerBatchDownLoadPush);
        this.result = ((TriggerBatchDownLoadPush)triggerDownLoadObj).triggerDownLoadHandleForBatch(null, params, this.ids, this.bosType, this.webServiceClient, this.xbangServiceInfo);
        return this.result;
    }

    @Override
    public String getSubTaskTitle(int step) {
        if (step == this.getTaskStepCount() - 1) {
            return CoreUtils.getResourceStr(null, "taskEnd");
        }
        int mod = step % 2;
        int count = step / 2;
        if (mod == 0) {
            return CoreUtils.getResourceStr(null, "ConnectDataCenter") + "[" + this.webServiceList.get(count).getDataCenterName() + "]...";
        }
        return EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"971_SynBatchTask");
    }

    @Override
    public String getTaskName() {
        return CoreUtils.getResourceStr(null, "CommitRptInfo");
    }

    @Override
    public int getTaskStepCount() {
        return 1 * this.webServiceList.size() + this.webServiceList.size() + 1;
    }

    @Override
    public String getTaskContextString() {
        return null;
    }

    @Override
    public String getTaskNumber() {
        return this.bosType;
    }
}

