/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.util.synchronize.download;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.rptintegration.IRptIntegrationFacade;
import com.kingdee.eas.fi.gr.rptintegration.ISynLog;
import com.kingdee.eas.fi.gr.rptintegration.RptIntegrationFacadeFactory;
import com.kingdee.eas.fi.gr.rptintegration.SynLogCollection;
import com.kingdee.eas.fi.gr.rptintegration.SynLogFactory;
import com.kingdee.eas.fi.gr.rptintegration.util.CoreUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.MappedDataConf;
import com.kingdee.eas.fi.gr.rptintegration.util.ResultInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeHandle;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceClient;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.TypeConversionUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class SynOperateByDownLoadUtils
extends CoreUtils
implements SynchronizeHandle {
    private static Logger logger = Logger.getLogger(SynOperateByDownLoadUtils.class);
    public static int batchSize = 300;
    public boolean isOnlySynAddNew = false;
    public boolean isOnlySynAddNewAndDelete = false;
    public String isPush = "isPush";
    public boolean isCover = false;
    private String tmpSelectStr = null;

    public String getObjectCollectionJsonstring(Context ctx, String selectStr, String whereStr, String orderStr, Map<String, String> subDataMap, String field, String subDataCenterId) throws Exception {
        IObjectCollection collection = this.getObjectCollection(ctx, selectStr, whereStr, orderStr);
        this.handleCollMap(ctx, collection, subDataMap, new String[]{field});
        this.handleCollMap(ctx, collection, subDataCenterId, this.getBOSObjectType().toString(), true);
        JSONArray jsonArray = new JSONArray();
        CoreBaseInfo info = null;
        for (int i = 0; i < collection.size(); ++i) {
            info = (CoreBaseInfo)collection.getObject(i);
            if (StringUtils.isEmpty((String)selectStr)) {
                jsonArray.put((Object)SynOperateByDownLoadUtils.objectToJsonObj((IObjectValue)info));
                continue;
            }
            jsonArray.put((Object)SynOperateByDownLoadUtils.objectToJson((IObjectValue)info, null, selectStr.split(",")));
        }
        collection.clear();
        return jsonArray.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectCollection getObjectCollection(Context ctx, String selects, String whereStr, String orderStr) throws Exception {
        if (StringUtils.isEmpty((String)selects) && StringUtils.isEmpty((String)whereStr) && StringUtils.isEmpty((String)orderStr)) {
            return this.getBizInterface(ctx).getCollection();
        }
        StringBuffer oql = new StringBuffer();
        if (!StringUtils.isEmpty((String)selects)) {
            oql.append(" select ").append(selects);
        }
        if (!StringUtils.isEmpty((String)whereStr)) {
            oql.append(" where ").append(whereStr);
        }
        if (!StringUtils.isEmpty((String)orderStr)) {
            oql.append(" order by ").append(orderStr);
        }
        ICacheConfig iCacheConfig = null;
        boolean isCatch = true;
        try {
            iCacheConfig = CacheConfigManager.getConfig();
            if (iCacheConfig != null) {
                boolean bl = isCatch = iCacheConfig.needServerCache() && iCacheConfig.needCache(this.getBOSObjectType());
                if (isCatch) {
                    iCacheConfig.setServerCache(false);
                }
            }
            if (StringUtils.isEmpty((String)oql.toString())) {
                CoreBaseCollection coreBaseCollection = this.getBizInterface(ctx).getCollection();
                return coreBaseCollection;
            }
            CoreBaseCollection coreBaseCollection = this.getBizInterface(ctx).getCollection(oql.toString());
            return coreBaseCollection;
        }
        finally {
            if (iCacheConfig != null && isCatch) {
                iCacheConfig.setServerCache(true);
            }
        }
    }

    private Map<String, CoreBaseInfo> getSubInfoMap(Context ctx, String selects, String whereStr, String orderStr, boolean isIncludeValue) throws Exception {
        IObjectCollection rptClassColl = this.getObjectCollection(ctx, selects, whereStr, orderStr);
        HashMap<String, CoreBaseInfo> SubInfoMap = new HashMap<String, CoreBaseInfo>();
        for (int i = 0; i < rptClassColl.size(); ++i) {
            if (isIncludeValue) {
                SubInfoMap.put(rptClassColl.getObject(i).get("id").toString(), (CoreBaseInfo)rptClassColl.getObject(i));
                continue;
            }
            SubInfoMap.put(rptClassColl.getObject(i).get("id").toString(), null);
        }
        rptClassColl.clear();
        return SubInfoMap;
    }

    @Override
    public ResultInfo sourceDataCenterHandle(Context ctx, String[] args, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        return this.sourceDataCenterHandleByDownLoad(ctx, args, webServiceClient, xbangServiceInfo);
    }

    public ResultInfo sourceDataCenterHandleByDownLoad(Context ctx, String[] args, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        List[] synDatas = null;
        ResultInfo resultInfo = new ResultInfo();
        ICacheConfig iCacheConfig = null;
        boolean isCatch = true;
        try {
            if (ctx != null && (iCacheConfig = CacheConfigManager.getConfig()) != null) {
                boolean bl = isCatch = iCacheConfig.needServerCache() && iCacheConfig.needCache(this.getBOSObjectType());
                if (isCatch) {
                    iCacheConfig.setServerCache(false);
                }
            }
            boolean isBatchSyn = args.length > 1;
            synDatas = this.getSynDatas(ctx, args, webServiceClient, xbangServiceInfo);
            String msg = this.checkAndDeleteDup(ctx, synDatas[0], false);
            String msg2 = this.checkAndDeleteDup(ctx, synDatas[2], true);
            if (msg != null && msg2 != null) {
                msg = msg + "," + msg2;
            } else if (msg2 != null) {
                msg = msg2;
            }
            if (!StringUtils.isEmpty((String)msg)) {
                resultInfo.setMsgInfo(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.rptintegration.RptIntegrationUIMsg", (String)"SubDataCenterExist"), msg));
            }
            if (!this.saveSynUpate(ctx, synDatas[0], synDatas[1], synDatas[2], synDatas[3], isBatchSyn) || !this.synRelateObject(ctx, synDatas[0], synDatas[1], synDatas[2], synDatas[3], webServiceClient, xbangServiceInfo, isBatchSyn)) {
                resultInfo.setStatus(1);
            }
            if (synDatas != null) {
                for (List curSynDatas : synDatas) {
                    if (curSynDatas == null) continue;
                    curSynDatas.clear();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"sourceDataCenterHandleByPush error", (Throwable)ex);
            throw ex;
        }
        finally {
            if (synDatas != null) {
                for (List curList : synDatas) {
                    if (curList == null) continue;
                    curList.clear();
                }
            }
            if (iCacheConfig != null && isCatch) {
                iCacheConfig.setServerCache(true);
            }
        }
        return resultInfo;
    }

    public boolean synRelateObject(Context ctx, List addObjectList, List deletePkList, List updateObjectList, List synLogList, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo, boolean isBatchSyn) throws Exception {
        return true;
    }

    public boolean saveSynUpate(Context ctx, List addObjectList, List deletePkList, List updateObjectList, List synLogList, boolean isBatchSyn) throws Exception {
        IRptIntegrationFacade IFacade = ctx == null ? RptIntegrationFacadeFactory.getRemoteInstance() : RptIntegrationFacadeFactory.getLocalInstance(ctx);
        IFacade.saveSynUpdate(this.getBOSObjectType(), addObjectList, deletePkList, updateObjectList, synLogList, this.getExtProperties());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List[] getSynDatas(Context ctx, String[] args, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        List<CoreBaseInfo> parentList = null;
        Map<String, CoreBaseInfo> subMap = null;
        ArrayList<String> synLogList = new ArrayList<String>();
        List<String>[] diffListArr = null;
        try {
            BOSObjectType bosType = this.getBOSObjectType();
            String parentMethod = this.getMethod();
            boolean isBatchSyn = args.length > 1;
            parentList = this.getTargetList(parentMethod, args, "id", this.getWhereStr(), this.getOrderStr(), webServiceClient, xbangServiceInfo);
            String whereStr = this.getWhereStr();
            if (isBatchSyn) {
                StringBuffer curIds = new StringBuffer();
                for (int i = 0; i < parentList.size(); ++i) {
                    curIds.append("'").append(parentList.get(i).getId()).append("',");
                }
                if (curIds.length() > 0) {
                    curIds.deleteCharAt(curIds.lastIndexOf(","));
                }
                whereStr = StringUtils.isEmpty((String)whereStr) ? " id in(" + curIds + ")" : "(" + whereStr + ") and id in(" + curIds + ")";
            }
            subMap = this.getSubInfoMap(ctx, "id", whereStr, this.getOrderStr(), false);
            for (CoreBaseInfo curInfo : parentList) {
                synLogList.add(curInfo.getId().toString());
            }
            diffListArr = this.getDiffIds(ctx, subMap, parentList, bosType.toString(), isBatchSyn);
            List<CoreBaseInfo> addList = null;
            if (diffListArr[0].size() > 0) {
                if (isBatchSyn) {
                    args[1] = "id";
                    args[2] = CslRptUtil.list2String(diffListArr[0], ",", true);
                    args[4] = "s";
                    addList = this.getTargetList(parentMethod, args, this.getSelectStr(ctx), null, this.getOrderStr(), webServiceClient, xbangServiceInfo);
                } else {
                    addList = this.getTargetList(parentMethod, args, this.getSelectStr(ctx), "id in(" + CslRptUtil.list2String(diffListArr[0], ",", true) + ")", this.getOrderStr(), webServiceClient, xbangServiceInfo);
                }
                diffListArr[0].clear();
            }
            ArrayList<CoreBaseInfo> updateList = new ArrayList<CoreBaseInfo>();
            if (!this.isOnlySynAddNew && !this.isOnlySynAddNewAndDelete) {
                if (diffListArr[2].size() > 0) {
                    int count = 0;
                    StringBuffer inStr = new StringBuffer();
                    for (String curId : diffListArr[2]) {
                        inStr.append("'").append(curId).append("',");
                        if (++count < batchSize) continue;
                        this.getUpadeInfoList(ctx, args, parentMethod, updateList, inStr.deleteCharAt(inStr.lastIndexOf(",")).toString(), webServiceClient, xbangServiceInfo);
                        inStr.setLength(0);
                        count = 0;
                    }
                    if (inStr.length() > 0) {
                        this.getUpadeInfoList(ctx, args, parentMethod, updateList, inStr.deleteCharAt(inStr.lastIndexOf(",")).toString(), webServiceClient, xbangServiceInfo);
                    }
                    diffListArr[2].clear();
                }
            } else {
                if (this.isOnlySynAddNew) {
                    diffListArr[1].clear();
                }
                updateList.clear();
                synLogList.clear();
            }
            List[] listArray = new List[]{addList, diffListArr[1], updateList, synLogList};
            return listArray;
        }
        finally {
            if (parentList != null) {
                parentList.clear();
            }
            if (subMap != null) {
                subMap.clear();
            }
            if (diffListArr != null) {
                diffListArr[0].clear();
                diffListArr[2].clear();
            }
        }
    }

    public void getUpadeInfoList(Context ctx, String[] args, String parentMethod, List<CoreBaseInfo> updateList, String inStr, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        if (!StringUtils.isEmpty((String)inStr)) {
            String[] curArgs = null;
            if (args.length <= 1) {
                curArgs = new String[5];
                curArgs[0] = args[0];
            } else {
                curArgs = args;
            }
            curArgs[1] = "id";
            curArgs[2] = inStr;
            curArgs[4] = "s";
            List<CoreBaseInfo> parentList = this.getTargetList(parentMethod, curArgs, this.getSelectStr(ctx), null, this.getOrderStr(), webServiceClient, xbangServiceInfo);
            Map<String, CoreBaseInfo> subInfoMap = this.getSubInfoMap(ctx, this.getSelectStr(ctx), "id in(" + inStr + ")", this.getOrderStr(), true);
            CoreBaseInfo subInfo = null;
            for (CoreBaseInfo parentInfo : parentList) {
                subInfo = subInfoMap.get(parentInfo.getId().toString());
                if (this.equals(ctx, subInfo, parentInfo)) continue;
                updateList.add(parentInfo);
            }
            parentList.clear();
            subInfoMap.clear();
        }
    }

    public List<CoreBaseInfo> getTargetList(String parentMethod, String[] args, String selectStr, String whereStr, String order, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        ArrayList<CoreBaseInfo> resultList = new ArrayList<CoreBaseInfo>();
        String targetData = this.getTargetDataStr(parentMethod, args, selectStr, whereStr, order, webServiceClient, xbangServiceInfo);
        if (!StringUtils.isEmpty((String)targetData)) {
            CoreBaseInfo info = null;
            JSONArray jsonArray = new JSONArray(targetData);
            for (int i = 0; i < jsonArray.length(); ++i) {
                info = SynOperateByDownLoadUtils.jsonObjectToObject(null, jsonArray.getJSONObject(i), this.getBOSObjectType());
                resultList.add(info);
            }
        }
        return resultList;
    }

    public List<CoreBaseInfo> getTargetList(String parentMethod, String selectStr, String whereStr, String order, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        return this.getTargetList(parentMethod, null, selectStr, whereStr, order, webServiceClient, xbangServiceInfo);
    }

    public List<CoreBaseInfo> getTargetList(Context ctx, String parentMethod, String selectStr, String whereStr, String order, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo, boolean isParentCenter) throws Exception {
        List<CoreBaseInfo> infos = this.getTargetList(parentMethod, null, selectStr, whereStr, order, webServiceClient, xbangServiceInfo);
        for (CoreBaseInfo info : infos) {
            Map<String, String[]> curMapped = MappedDataConf.getMappedData(ctx, this.getCoreBaseInfo().getBOSType().toString());
            if (curMapped == null || curMapped.isEmpty() || StringUtils.isEmpty((String)xbangServiceInfo.getDataCenterId())) continue;
            for (String mapBosType : curMapped.keySet()) {
                this.handleInfoMap(ctx, info, this.getDataMap(ctx, xbangServiceInfo.getDataCenterId(), mapBosType, false), curMapped.get(mapBosType));
            }
        }
        return infos;
    }

    public String getTargetDataStr(String parentMethod, String[] args, String selectStr, String whereStr, String order, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        ArrayList<String> params = new ArrayList<String>();
        params.add(selectStr);
        params.add(whereStr);
        params.add(order);
        if (args != null && args.length > 0) {
            for (String arg : args) {
                params.add(arg);
            }
        }
        xbangServiceInfo.setOperationName("invoke");
        xbangServiceInfo.setArgs(new Object[]{parentMethod, params.toArray(new String[0])});
        String targetDataStr = (String)webServiceClient.callMethod(xbangServiceInfo);
        return targetDataStr;
    }

    public String getTargetDataStr(String parentMethod, String selectStr, String whereStr, String order, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        return this.getTargetDataStr(parentMethod, null, selectStr, whereStr, order, webServiceClient, xbangServiceInfo);
    }

    public List<String>[] getDiffIds(Context ctx, Map<String, CoreBaseInfo> subInfoMap, List<CoreBaseInfo> parentInfoList, String bosType, boolean isBatchSyn) throws Exception {
        ArrayList<String> adds = new ArrayList<String>();
        ArrayList<String> deletes = new ArrayList<String>();
        ArrayList<String> updates = new ArrayList<String>();
        if (parentInfoList != null && parentInfoList.size() > 0) {
            HashMap parentMap = new HashMap();
            CoreBaseInfo parentInfo = null;
            for (int i = 0; i < parentInfoList.size(); ++i) {
                parentInfo = parentInfoList.get(i);
                if (!subInfoMap.containsKey(parentInfo.getId().toString())) {
                    adds.add(parentInfo.getId().toString());
                } else {
                    updates.add(parentInfo.getId().toString());
                }
                parentMap.put(parentInfo.getId().toString(), null);
            }
            if (!isBatchSyn) {
                ISynLog iSynLog = ctx == null ? SynLogFactory.getRemoteInstance() : SynLogFactory.getLocalInstance(ctx);
                String curBosType = this.getExtProperties() != null ? bosType + this.getExtProperties() : bosType;
                SynLogCollection synLogs = iSynLog.getSynLogCollection("select synEntityId where synType='" + curBosType + "'");
                if (synLogs != null) {
                    for (int i = 0; i < synLogs.size(); ++i) {
                        if (parentMap.containsKey(synLogs.get(i).getSynEntityId().toString())) continue;
                        deletes.add(synLogs.get(i).getSynEntityId().toString());
                    }
                }
                synLogs.clear();
            }
            parentMap.clear();
        }
        subInfoMap.clear();
        parentInfoList.clear();
        return new List[]{adds, deletes, updates};
    }

    public boolean equals(Context ctx, CoreBaseInfo parentInfo, CoreBaseInfo subInfo) throws Exception {
        Object cols = null;
        for (String curCol : this.getEquesCols(ctx).split(",")) {
            if (curCol.toLowerCase(Locale.ENGLISH).equals("id") || curCol.toLowerCase(Locale.ENGLISH).equals("creator.id") || curCol.toLowerCase(Locale.ENGLISH).equals("lastupdateuser.id") || this.equals(parentInfo, subInfo, curCol)) continue;
            return false;
        }
        return true;
    }

    private boolean equals(CoreBaseInfo parentInfo, CoreBaseInfo subInfo, String col) {
        int index = col.indexOf(".");
        if (index > 0) {
            String parent = col.substring(0, col.indexOf("."));
            String subCol = col.substring(col.indexOf(".") + 1);
            return this.equals((CoreBaseInfo)parentInfo.get(parent), (CoreBaseInfo)subInfo.get(parent), subCol);
        }
        return SynOperateByDownLoadUtils.isEquals(this.getInfoValue(parentInfo, col), this.getInfoValue(subInfo, col));
    }

    private Object getInfoValue(CoreBaseInfo info, String key) {
        if (info == null) {
            return null;
        }
        if (key.toLowerCase(Locale.ENGLISH).equals("name") || key.toLowerCase(Locale.ENGLISH).equals("description")) {
            return TypeConversionUtils.objToString((Object)info.get(key));
        }
        if (key.toLowerCase(Locale.ENGLISH).equals("number") || key.toLowerCase(Locale.ENGLISH).equals("Longnumber")) {
            return TypeConversionUtils.objToString((Object)info.get(key));
        }
        if (key.toLowerCase(Locale.ENGLISH).equals("id")) {
            return info.getId() == null ? null : info.getId().toString();
        }
        return info.get(key);
    }

    public abstract ICoreBase getBizInterface(Context var1) throws Exception;

    public abstract CoreBaseInfo getCoreBaseInfo() throws Exception;

    public abstract String getMethod();

    public BOSObjectType getBOSObjectType() throws Exception {
        return this.getCoreBaseInfo().getBOSType();
    }

    public String getSelectStr(Context ctx) {
        try {
            if (StringUtils.isEmpty((String)this.tmpSelectStr)) {
                this.tmpSelectStr = this.getInfoPropertiesStr(ctx, this.getBOSObjectType());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"getSelectStr error", (Throwable)ex);
        }
        return this.tmpSelectStr;
    }

    public String getEquesCols(Context ctx) {
        return this.getSelectStr(ctx);
    }

    public String getWhereStr() {
        return null;
    }

    public String getOrderStr() {
        return null;
    }

    @Override
    public String targetDataCenterHandle(Context ctx, String[] args) throws Exception {
        return this.targetDataCenterHandleByDownLoad(ctx, args);
    }

    public String targetDataCenterHandleByDownLoad(Context ctx, String[] args) throws Exception {
        try {
            if (args == null) {
                return this.getObjectCollectionJsonstring(ctx, null, null, null, null, null, null);
            }
            String selectStr = args.length >= 1 ? args[0] : null;
            String whereStr = args.length >= 2 ? args[1] : null;
            String orderStr = args.length >= 3 ? args[2] : null;
            String subDataCenterId = args.length >= 4 ? args[3] : null;
            String field = args.length >= 5 ? args[4] : null;
            String ids = args.length >= 6 ? args[5] : null;
            String mapBosType = args.length >= 7 ? args[6] : null;
            String opt = args.length >= 8 ? args[7] : null;
            boolean isParentIds = true;
            if (opt != null && "s".equals(opt)) {
                isParentIds = false;
            }
            Map<String, String> dataMap = null;
            if (!StringUtils.isEmpty((String)subDataCenterId)) {
                dataMap = this.getDataMap(ctx, subDataCenterId, mapBosType);
            }
            whereStr = this.getWhereStr(ids, dataMap, whereStr, field, isParentIds);
            String result = this.getObjectCollectionJsonstring(ctx, selectStr, whereStr, orderStr, dataMap, field, subDataCenterId);
            if (dataMap != null) {
                dataMap.clear();
            }
            return result;
        }
        catch (Exception ex) {
            logger.error((Object)"sourceDataCenterHandleByPush error", (Throwable)ex);
            throw ex;
        }
    }

    private String getWhereStr(String ids, Map<String, String> dataMap, String whereStr, String field, boolean isParentIds) {
        StringBuffer where = new StringBuffer();
        if (whereStr != null) {
            where.append("(").append(whereStr).append(")");
        }
        if (!isParentIds && ids != null) {
            if (where.length() > 0) {
                where.append(" and ");
            }
            where.append(field).append(" in (");
            List<String> idList = this.inString2List(ids);
            String curId = null;
            for (String id : idList) {
                curId = dataMap.get(id);
                if (StringUtils.isEmpty((String)curId)) {
                    curId = id;
                }
                where.append("'").append(curId).append("',");
            }
            where.deleteCharAt(where.lastIndexOf(","));
            where.append(")");
        } else if (ids != null) {
            if (where.length() > 0) {
                where.append(" and ");
            }
            where.append(field).append(" in (").append(ids).append(")");
        }
        if (where.length() <= 0) {
            return null;
        }
        return where.toString();
    }

    private List<String> inString2List(String inStr) {
        String[] strs;
        ArrayList<String> list = new ArrayList<String>();
        for (String str : strs = inStr.split(",")) {
            if (StringUtils.isEmpty((String)str)) continue;
            str = str.trim();
            list.add(str.substring(1, str.length() - 1));
        }
        return list;
    }

    public String checkAndDeleteDup(Context ctx, List<CoreBaseInfo> infoList, boolean isUpdate) throws Exception {
        if (!StringUtils.isEmpty((String)this.getCheckDupCol()) && infoList != null && infoList.size() > 0) {
            StringBuffer inStr = new StringBuffer();
            StringBuffer noInStr = new StringBuffer();
            HashMap<Object, CoreBaseInfo> InfoMap = new HashMap<Object, CoreBaseInfo>();
            for (CoreBaseInfo info : infoList) {
                InfoMap.put(info.get(this.getCheckDupCol()), info);
                inStr.append("'").append(info.get(this.getCheckDupCol())).append("',");
                if (!isUpdate) continue;
                noInStr.append("'").append(info.getId().toString()).append("',");
            }
            if (inStr.lastIndexOf(",") > 0) {
                inStr.deleteCharAt(inStr.lastIndexOf(","));
            }
            if (noInStr.lastIndexOf(",") > 0) {
                noInStr.deleteCharAt(noInStr.lastIndexOf(","));
            }
            if (inStr.length() > 0) {
                CoreBaseCollection colls;
                StringBuffer oql = new StringBuffer();
                oql.append("select id,").append(this.getCheckDupCol()).append(" where ").append(this.getCheckDupCol());
                oql.append(" in (").append(inStr).append(")");
                if (isUpdate && noInStr.length() > 0) {
                    oql.append(" and id not in(").append(noInStr).append(")");
                }
                if (this.getCheckDupWhere() != null) {
                    oql.append(" and ").append(this.getCheckDupWhere());
                }
                if ((colls = this.getBizInterface(ctx).getCollection(oql.toString())) != null && colls.size() > 0) {
                    StringBuffer msg = new StringBuffer();
                    CoreBaseInfo curInfo = null;
                    for (int i = 0; i < colls.size(); ++i) {
                        curInfo = (CoreBaseInfo)InfoMap.get(colls.get(i).get(this.getCheckDupCol()));
                        msg.append(curInfo.get(this.getCheckDupCol())).append(",");
                        infoList.remove(curInfo);
                    }
                    InfoMap.clear();
                    if (msg.lastIndexOf(",") > 0) {
                        msg.deleteCharAt(msg.lastIndexOf(","));
                    }
                    return msg.toString();
                }
            }
            InfoMap.clear();
        }
        return null;
    }

    public String getExtProperties() {
        return null;
    }

    public String getCheckDupCol() {
        return null;
    }

    public String getCheckDupWhere() {
        return null;
    }
}

