/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.weaverpt.IRptAutoWeaveSchmBase;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmBaseFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.client.AbstractRptAutoWeaveSchmExcuteImmediatelyUI;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexException;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.ShowUIMessageAction;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class RptAutoWeaveSchmExcuteImmediatelyUI
extends AbstractRptAutoWeaveSchmExcuteImmediatelyUI {
    private static final Logger logger = CoreUIObject.getLogger(RptAutoWeaveSchmExcuteImmediatelyUI.class);
    private boolean isSupport13Period = false;
    private Integer[] countMonth = new Integer[12];
    private Integer[] countWeek = new Integer[53];
    private Integer[] countQuarterly = new Integer[4];
    private Integer[] countSemiyYear = new Integer[2];
    private int periodType = 0;
    private Object convertSolution;
    private RptAutoWeaveSchmRptInfo schmRptInfo = null;
    private boolean isReceiveSchm = false;
    private KDCheckBox chkIsReceive = null;
    KDCheckBox chkIsSendBack = null;

    public RptAutoWeaveSchmExcuteImmediatelyUI() throws Exception {
        int i;
        this.isSupport13Period = CslRptUtil.isSupport13Period(null);
        int monthCount = 12;
        if (this.isSupport13Period) {
            this.countMonth = new Integer[13];
            monthCount = 13;
        }
        for (i = 0; i < monthCount; ++i) {
            this.countMonth[i] = i + 1;
        }
        for (i = 0; i < 53; ++i) {
            this.countWeek[i] = i + 1;
        }
        for (i = 0; i < 4; ++i) {
            this.countQuarterly[i] = i + 1;
        }
        for (i = 0; i < 2; ++i) {
            this.countSemiyYear[i] = i + 1;
        }
    }

    public void onLoad() throws Exception {
        this.initSchmRptInfo();
        this.hideComponent();
        this.onLoadForCurrency();
        this.initOperate();
        this.onLoadYearPeriodComponent();
        super.onLoad();
        this.registerListener();
    }

    public void initSchmRptInfo() throws Exception {
        String schmId = (String)this.getUIContext().get("SchmId");
        String oql = "select convertSolution.id,templateEtries.template.periodtype,isAddNew,isCopyPre,isCalc,isAduit,isCommit,isReceive,isSendBack,dispatchPeriod,currency.id where id = '" + schmId + "'";
        this.schmRptInfo = RptAutoWeaveSchmRptFactory.getRemoteInstance().getRptAutoWeaveSchmRptInfo(oql);
    }

    private void hideComponent() {
        if (this.getUIContext().get("isFromReportSystem") != null) {
            boolean isFromReportSystem = Boolean.valueOf((String)this.getUIContext().get("isFromReportSystem"));
            if (isFromReportSystem) {
                this.chkIsConvert.setVisible(false);
                this.chkIsCommit.setBounds(180, 64, 91, 19);
            } else {
                this.chkIsConvert.setVisible(true);
                this.chkIsCommit.setBounds(180, 96, 80, 19);
            }
        }
    }

    private void onLoadOperationComponent(RptAutoWeaveSchmRptInfo schmRptInfo) {
        this.chkIsAddNew.setSelected(schmRptInfo.isIsAddNew());
        this.chkIsAduit.setSelected(schmRptInfo.isIsAduit());
        this.chkIsCalc.setSelected(schmRptInfo.isIsCalc());
        this.chkIsCommit.setSelected(schmRptInfo.isIsCommit());
        this.chkIsCopyPre.setSelected(schmRptInfo.isIsCopyPre());
        if (this.chkIsConvert.isVisible()) {
            this.chkIsConvert.setSelected(this.convertSolution != null);
        }
        if (this.isReceiveSchm) {
            this.chkIsReceive.setSelected(schmRptInfo.isIsReceive());
            this.chkIsSendBack.setSelected(schmRptInfo.isIsSendBack());
        }
    }

    private void onLoadYearPeriodComponent() throws EASBizException, BOSException {
        Calendar calenda = Calendar.getInstance();
        int year = calenda.get(1);
        this.txtYear.setValue((Object)year);
        this.txtYear.setModel((SpinnerModel)this.getSpinnerNumberModel(year, 1900, 2199, 1));
        int period = calenda.get(2);
        this.periodType = this.schmRptInfo.getTemplateEtries().get(0).getTemplate().getPeriodType().getValue();
        this.convertSolution = this.schmRptInfo.getConvertSolution();
        switch (this.periodType) {
            case 1: {
                this.contYear.setVisible(false);
                this.contPeriod.setVisible(false);
                this.contMonth.setVisible(false);
                this.contDate.setVisible(true);
                calenda.add(5, -1);
                this.dpkDate.setValue((Object)calenda.getTime());
                break;
            }
            case 2: {
                this.contDate.setVisible(true);
                this.contYear.setEnabled(false);
                this.contPeriod.setVisible(false);
                this.contMonth.setEnabled(false);
                this.setCompenentPositionForWeekly();
                Date date = (Date)this.dpkDate.getValue();
                int[] yearPeriod = RPTDateUtil.getPeriod(date, RptPeriodTypeEnum.WEEKLY);
                int weaveYear = yearPeriod[0];
                int weavePeriod = yearPeriod[1];
                this.txtYear.setValue((Object)weaveYear);
                this.spinPeriod.setModel((SpinnerModel)this.getSpinnerNumberModel(weavePeriod, 1, 53, 1));
                break;
            }
            case 3: {
                this.contPeriod.setVisible(false);
                calenda.add(2, -1);
                period = calenda.get(2) + 1;
                int max = 12;
                if (this.isSupport13Period) {
                    max = 13;
                }
                this.spinPeriod.setModel((SpinnerModel)this.getSpinnerNumberModel(period, 1, max, 1));
                year = calenda.get(1);
                this.txtYear.setValue((Object)year);
                break;
            }
            case 4: {
                this.contPeriod.setVisible(false);
                int quarterly = 0;
                if (++period >= 1 && period <= 3) {
                    quarterly = 1;
                } else if (period >= 4 && period <= 6) {
                    quarterly = 2;
                } else if (period >= 7 && period <= 9) {
                    quarterly = 3;
                } else if (period >= 10 && period <= 12) {
                    quarterly = 4;
                }
                if (--quarterly == 0) {
                    quarterly = 4;
                    --year;
                }
                this.txtYear.setValue((Object)year);
                this.spinPeriod.setModel((SpinnerModel)this.getSpinnerNumberModel(quarterly, 1, 4, 1));
                break;
            }
            case 5: {
                this.contPeriod.setVisible(false);
                int semiYearly = 0;
                semiYearly = ++period >= 1 && period <= 6 ? 1 : 2;
                if (--semiYearly == 0) {
                    semiYearly = 2;
                    --year;
                }
                this.txtYear.setValue((Object)year);
                this.spinPeriod.setModel((SpinnerModel)this.getSpinnerNumberModel(semiYearly, 1, 2, 1));
                break;
            }
            case 6: {
                this.contPeriod.setVisible(false);
                this.contMonth.setVisible(false);
                break;
            }
        }
        this.onLoadOperationComponent(this.schmRptInfo);
    }

    private void setCompenentPositionForWeekly() {
        int winHeight = this.getHeight() + 39;
        this.setBounds(this.getX(), this.getY(), this.getWidth(), winHeight);
        this.contDate.setBounds(10, this.contDate.getY(), 356, this.contDate.getHeight());
        int contYearY = this.contYear.getY() + this.contYear.getHeight() + 20;
        this.contYear.setBounds(this.contYear.getX(), contYearY, this.contYear.getWidth(), this.contYear.getHeight());
        this.contMonth.setBounds(this.contMonth.getX(), contYearY, this.contMonth.getWidth(), this.contMonth.getHeight());
        int currencyY = contYearY + this.contYear.getHeight() + 20;
        this.contCurrency.setBounds(this.contCurrency.getX(), currencyY, this.contCurrency.getWidth(), this.contCurrency.getHeight());
        int kDPanel1Y = currencyY + this.contCurrency.getHeight() + 20;
        this.kDPanel1.setBounds(this.kDPanel1.getX(), kDPanel1Y, this.kDPanel1.getWidth(), this.kDPanel1.getHeight());
        int kDSeparator2Y = kDPanel1Y + this.kDPanel1.getHeight() + 5;
        this.kDSeparator2.setBounds(this.kDSeparator2.getX(), kDSeparator2Y, this.kDSeparator2.getWidth(), this.kDSeparator2.getHeight());
        int btnConfirmY = kDSeparator2Y + this.kDSeparator2.getHeight() + 5;
        this.btnConfirm.setBounds(this.btnConfirm.getX(), btnConfirmY, this.btnConfirm.getWidth(), this.btnConfirm.getHeight());
        this.btnCancel.setBounds(this.btnCancel.getX(), btnConfirmY, this.btnCancel.getWidth(), this.btnCancel.getHeight());
    }

    private SpinnerNumberModel getSpinnerNumberModel(int initValue, int minimum, int maximum, int stepSize) {
        return new SpinnerNumberModel(initValue, minimum, maximum, stepSize);
    }

    private void onLoadForCurrency() {
        if (this.schmRptInfo.getCurrency() != null) {
            CslClientHelper.initCurrencyToCombox((JComboBox)this.combCurrency, this.schmRptInfo.getCurrency().getId().toString(), false);
        } else {
            CslClientHelper.initCurrencyToCombox((JComboBox)this.combCurrency, true, false);
        }
        this.combCurrency.doLayout();
    }

    private void registerListener() {
        this.chkIsAddNew.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RptAutoWeaveSchmExcuteImmediatelyUI.this.setMutualSelect(e);
            }
        });
        this.chkIsCopyPre.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RptAutoWeaveSchmExcuteImmediatelyUI.this.setMutualSelect(e);
            }
        });
        this.dpkDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (RptAutoWeaveSchmExcuteImmediatelyUI.this.periodType == 2) {
                    RptAutoWeaveSchmExcuteImmediatelyUI.this.refreshDate();
                }
            }
        });
    }

    private void refreshDate() {
        Date date = (Date)this.dpkDate.getValue();
        int[] yearPeriod = RPTDateUtil.getPeriod(date, RptPeriodTypeEnum.WEEKLY);
        int weaveYear = yearPeriod[0];
        int weavePeriod = yearPeriod[1];
        this.txtYear.setValue((Object)weaveYear);
        this.spinPeriod.setValue((Object)weavePeriod);
    }

    private void setMutualSelect(ChangeEvent e) {
        if ("chkIsCopyPre".equals(((KDCheckBox)e.getSource()).getName())) {
            if (this.chkIsCopyPre.isSelected()) {
                this.chkIsAddNew.setSelected(false);
            }
        } else if (this.chkIsAddNew.isSelected()) {
            this.chkIsCopyPre.setSelected(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void btnConform_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        String schmId = (String)this.getUIContext().get("SchmId");
        ShowUIMessageAction showMessageHandler = (ShowUIMessageAction)this.getUIContext().get("showMessageHandler");
        Uuid mutexUuidForStartExecute = null;
        try {
            BOSUuid bosUuid = BOSUuid.read((String)schmId);
            mutexUuidForStartExecute = MutexUtil.setMutex("SchmStartExecute", bosUuid, "ActionEdit");
        }
        catch (MutexException ex) {
            logger.warn((Object)"", (Throwable)((Object)ex));
            showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"EXECUTE_WARNING_CANNOT_DUP_EXECUTE"), true, true);
            return;
        }
        try {
            super.btnConform_actionPerformed(e);
            showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"SHOW_MSG_EXECUTING"), false, true);
            IRptAutoWeaveSchmBase schmDao = RptAutoWeaveSchmBaseFactory.getRemoteInstance();
            HashMap<String, Comparable<Boolean>> params = new HashMap<String, Comparable<Boolean>>();
            try {
                if (schmId == null) {
                    params.put("OMIT_DEPEND_SCHM", Boolean.TRUE);
                } else {
                    int year = Integer.valueOf(this.txtYear.getValue().toString());
                    int period = 0;
                    switch (this.periodType) {
                        case 1: {
                            Date date = (Date)this.dpkDate.getValue();
                            Calendar calenda = Calendar.getInstance();
                            calenda.setTime(date);
                            year = calenda.get(1);
                            period = calenda.get(6);
                            break;
                        }
                        case 6: {
                            period = 0;
                            break;
                        }
                        default: {
                            period = Integer.valueOf(this.spinPeriod.getValue().toString());
                        }
                    }
                    CurrencyInfo currency = (CurrencyInfo)this.combCurrency.getSelectedItem();
                    params.put("isFromCustom", Boolean.valueOf(true));
                    params.put("year", Integer.valueOf(year));
                    params.put("period", Integer.valueOf(period));
                    params.put("currency", (Comparable<Boolean>)currency);
                    if (!this.isReceiveSchm) {
                        boolean isAddNew = this.chkIsAddNew.isSelected();
                        boolean isAudit = this.chkIsAduit.isSelected();
                        boolean isCalc = this.chkIsCalc.isSelected();
                        boolean isCommit = this.chkIsCommit.isSelected();
                        boolean isCopyPre = this.chkIsCopyPre.isSelected();
                        boolean isConvert = this.chkIsConvert.isSelected();
                        params.put("isAddNew", Boolean.valueOf(isAddNew));
                        params.put("isAudit", Boolean.valueOf(isAudit));
                        params.put("isCalc", Boolean.valueOf(isCalc));
                        params.put("isCommit", Boolean.valueOf(isCommit));
                        params.put("isCopyPre", Boolean.valueOf(isCopyPre));
                        params.put("isConvert", Boolean.valueOf(isConvert));
                    } else {
                        boolean isReceive = this.chkIsReceive.isSelected();
                        boolean isSendBack = this.chkIsSendBack.isSelected();
                        params.put("isReceive", Boolean.valueOf(isReceive));
                        params.put("isSendBack", Boolean.valueOf(isSendBack));
                    }
                }
                schmDao.schemeImmediatelyRun(schmId, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), params);
                this.disposeUIWindow();
            }
            catch (RptWeaveException ex) {
                logger.warn((Object)"", (Throwable)((Object)ex));
                showMessageHandler.showMessage(ex.getMessage(), true, true);
            }
        }
        finally {
            MutexUtil.releaseMutex(mutexUuidForStartExecute);
        }
    }

    private void initOperate() throws Exception {
        if (this.getUIContext().containsKey("isReceiveSchm")) {
            this.isReceiveSchm = (Boolean)this.getUIContext().get("isReceiveSchm");
        }
        if (this.isReceiveSchm) {
            ArrayList<KDCheckBox> operateCheckBoxs = new ArrayList<KDCheckBox>();
            operateCheckBoxs.add(this.chkIsAddNew);
            operateCheckBoxs.add(this.chkIsCalc);
            operateCheckBoxs.add(this.chkIsCommit);
            operateCheckBoxs.add(this.chkIsAduit);
            operateCheckBoxs.add(this.chkIsCopyPre);
            operateCheckBoxs.add(this.chkIsConvert);
            for (JComponent jComponent : operateCheckBoxs) {
                jComponent.setVisible(false);
            }
            this.chkIsReceive = new KDCheckBox();
            this.chkIsReceive.setText(CslRptUtil.getString("checkReceive"));
            this.chkIsReceive.setBounds(new Rectangle(20, 32, 80, 19));
            this.kDPanel1.add((Component)this.chkIsReceive, null);
            this.chkIsSendBack = new KDCheckBox();
            this.chkIsSendBack.setText(CslRptUtil.getString("909_sendBack"));
            this.chkIsSendBack.setBounds(new Rectangle(180, 32, 80, 19));
            this.kDPanel1.add((Component)this.chkIsSendBack, null);
            this.chkIsSendBack.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RptAutoWeaveSchmExcuteImmediatelyUI.this.checkedChange(RptAutoWeaveSchmExcuteImmediatelyUI.this.chkIsSendBack, RptAutoWeaveSchmExcuteImmediatelyUI.this.chkIsReceive);
                }
            });
            this.chkIsReceive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RptAutoWeaveSchmExcuteImmediatelyUI.this.checkedChange(RptAutoWeaveSchmExcuteImmediatelyUI.this.chkIsReceive, RptAutoWeaveSchmExcuteImmediatelyUI.this.chkIsSendBack);
                }
            });
            Rectangle curBound = this.kDPanel1.getBounds();
            curBound.height -= 60;
            this.kDPanel1.setBounds(curBound);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.kDSeparator2);
            arrayList.add(this.btnConfirm);
            arrayList.add(this.btnCancel);
            for (JComponent jComponent : arrayList) {
                curBound = jComponent.getBounds();
                curBound.y -= 60;
                jComponent.setBounds(curBound);
            }
            curBound = this.getBounds();
            curBound.height -= 60;
            this.setBounds(curBound);
            this.chkIsAddNew.setSelected(false);
            this.chkIsAduit.setSelected(false);
            this.chkIsCalc.setSelected(false);
            this.chkIsCommit.setSelected(false);
            this.chkIsCopyPre.setSelected(false);
            this.chkIsConvert.setSelected(false);
        }
    }

    public void checkedChange(KDCheckBox changeChk, KDCheckBox needChangeChk) {
        try {
            if (changeChk.isSelected()) {
                needChangeChk.setSelected(false);
            }
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    private void verify() {
        boolean isSelected = true;
        if (!this.isReceiveSchm) {
            boolean isAddNew = this.chkIsAddNew.isSelected();
            boolean isAudit = this.chkIsAduit.isSelected();
            boolean isCalc = this.chkIsCalc.isSelected();
            boolean isCommit = this.chkIsCommit.isSelected();
            boolean isCopyPre = this.chkIsCopyPre.isSelected();
            boolean isConvert = this.chkIsConvert.isSelected();
            if (!(isAddNew || isAudit || isCalc || isCommit || isCopyPre || isConvert)) {
                isSelected = false;
            }
        } else {
            boolean isReceive = this.chkIsReceive.isSelected();
            boolean isSendBack = this.chkIsSendBack.isSelected();
            if (!isSendBack && !isReceive) {
                isSelected = false;
            }
        }
        if (!isSelected) {
            StringBuffer errorMsg = new StringBuffer();
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.MUST_CHOOSE_AUTO_WEAVE_OPERATE"));
            errorMsg.append("\n");
            MsgBox.showWarning((Component)((Object)this), (String)errorMsg.toString());
            SysUtil.abort();
        }
    }
}

