/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.client.uiaction;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.eas.fi.gr.cslrpt.RptReciveQueryStatusEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveLogSuccEnum;
import com.kingdee.eas.fi.rpt.ColorSchemeFactory;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class TableColorUIAction {
    private static final Logger log = Logger.getLogger(TableColorUIAction.class);
    private Map<String, Color> defaultColors;
    private KDTable table;
    private String statusColumnName;

    public TableColorUIAction(KDTable table, Map<String, KDTextField> colorCtrls, String statusColumnName) {
        this.table = table;
        this.statusColumnName = statusColumnName;
        String uiClassName = "com.kingdee.eas.fi.gr.cslrpt.client.ReceiveListUI";
        try {
            this.defaultColors = new HashMap<String, Color>();
            Map receiveDefaultColors = ColorSchemeFactory.getRemoteInstance().getColorSchemesMap(uiClassName);
            this.defaultColors.put(RptWeaveLogSuccEnum.SUCCESS.getName(), (Color)receiveDefaultColors.get(RptReciveQueryStatusEnum.CONFIRMED.getName()));
            this.defaultColors.put(RptWeaveLogSuccEnum.FAILED.getName(), (Color)receiveDefaultColors.get(RptReciveQueryStatusEnum.COMMITTED.getName()));
            this.defaultColors.put(RptWeaveLogSuccEnum.EXCEUTING.getName(), (Color)receiveDefaultColors.get(RptReciveQueryStatusEnum.WEAVING.getName()));
            this.defaultColors.put(RptWeaveLogSuccEnum.NOSTART.getName(), (Color)receiveDefaultColors.get(RptReciveQueryStatusEnum.UNWEAVE.getName()));
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
        }
        Iterator<String> it = colorCtrls.keySet().iterator();
        RptWeaveLogSuccEnum colorType = null;
        KDTextField colorCtrl = null;
        while (it.hasNext()) {
            try {
                colorType = RptWeaveLogSuccEnum.getEnum(it.next());
                colorCtrl = colorCtrls.get(colorType.getName());
                colorCtrl.setCustomBackgroundColor(this.defaultColors.get(colorType.getName()));
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    public void color(Map<String, Color> newColors, int firstIndex, int lastIndex) {
        if (newColors != null && !newColors.isEmpty()) {
            this.defaultColors = newColors;
        }
        IRow row = null;
        for (int i = firstIndex; i <= lastIndex; ++i) {
            row = this.table.getRow(i);
            ICell cell = row.getCell(this.statusColumnName);
            int reportStatus = -99;
            Object value = cell.getValue();
            Color color = null;
            if (value instanceof RptWeaveLogSuccEnum) {
                reportStatus = ((RptWeaveLogSuccEnum)((Object)value)).getValue();
            } else if (value instanceof Number) {
                reportStatus = ((Number)value).intValue();
            } else if (value instanceof BizEnumValueDTO) {
                reportStatus = Integer.parseInt((String)((BizEnumValueDTO)value).getValue());
            }
            color = reportStatus == 2 ? this.defaultColors.get(RptWeaveLogSuccEnum.EXCEUTING.getName()) : (reportStatus == 0 ? this.defaultColors.get(RptWeaveLogSuccEnum.FAILED.getName()) : (reportStatus == 1 ? this.defaultColors.get(RptWeaveLogSuccEnum.SUCCESS.getName()) : this.defaultColors.get(RptWeaveLogSuccEnum.NOSTART.getName())));
            row.getStyleAttributes().setBackground(color);
        }
    }
}

