/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyListener;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSRow;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslReportDataProvider;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.DynaItemListener;
import com.kingdee.eas.rptclient.gr.rptclient.util.DynamicTemplateUtility;
import com.kingdee.eas.rptclient.gr.rptclient.util.TableAfterAction;
import com.kingdee.eas.rptclient.gr.rptclient.util.TableBeforeAction;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.rptclient.newrpt.client.designer.MenuManager;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportDesigner;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.designer.check.ReportCheckHelper;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.rptclient.newrpt.util.ResourceHelper;
import com.kingdee.eas.rptclient.newrpt.util.SpreadHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class CslReportDesigner
extends ReportDesigner {
    public static final String MenuName_Save = "File/saveFile";
    public static final String MenuName_Audit = "Tool/audit";
    public static final String MenuName_UnAudit = "Tool/unaudit";
    private ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.RPTDesignerResource");
    private String id;
    private CoreUIObject uiObj;
    private boolean isAudited = false;

    public CslReportDesigner(String id, CoreUIObject uiObj) throws BOSException {
        this.id = id;
        this.uiObj = uiObj;
        String sql = "select FAuditedStatus from t_eas_report where fid = ?";
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id});
        try {
            if (rowSet.next()) {
                int status = rowSet.getInt("FAuditedStatus");
                this.isAudited = 2 == status;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void initApplication() throws Exception {
        RptCheckExpTank expTank;
        KDSpread spread;
        BookProperties properties;
        super.initApplication();
        CslReportDataProvider provider = (CslReportDataProvider)this.getDataProvider();
        String title = "ADDNEW".equals(this.getOperState()) ? this.resHelper.getString("addnew") : ("EDIT".equals(this.getOperState()) ? this.resHelper.getString("edit") : this.resHelper.getString("view"));
        title = title + this.resHelper.getString("report");
        title = title + "--" + provider.getReportVO().getName();
        this.setTitle(title);
        if (this.getOperState().equals("ADDNEW") && (properties = BookProperties.loadFromSpread((spread = this.getSpread()).getBook())) != null && properties.getOperationSchema() != null && (expTank = properties.getOperationSchema().getExpTank()) != null && expTank.getExpressions() != null) {
            Iterator it = expTank.getExpressions().iterator();
            while (it.hasNext()) {
                RptCheckExpression exp = (RptCheckExpression)it.next();
                exp.setStatus(3);
                exp.setEditable(false);
                exp.setDeleteable(false);
            }
        }
        this.initListener();
        ActionFileSave actionFileSave = new ActionFileSave();
        actionFileSave.putValue("Name", this.resHelper.getString("actionFileSave"));
        this.setAction(MenuName_Save, actionFileSave, "control S");
        JToolBar toolBar = this.getToolBar("common");
        KDWorkButton saveButton = new KDWorkButton();
        actionFileSave.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_save"));
        saveButton.setAction((Action)actionFileSave);
        saveButton.setText("");
        saveButton.setToolTipText(this.resHelper.getString("actionFileSave"));
        toolBar.add((Component)saveButton, 1);
        KDMenu menuTool = (KDMenu)this.getMenuManager().findMenuUsingPath("tool");
        ActionAudit actionAudit = new ActionAudit();
        actionAudit.putValue("Name", this.resHelper.getString("actionAudit") + "(A)");
        KDMenuItem menuItemAudit = new KDMenuItem((Action)actionAudit);
        menuItemAudit.setName("audit");
        menuItemAudit.setMnemonic('A');
        menuTool.add((JMenuItem)menuItemAudit);
        ActionUnAudit actionUnaudit = new ActionUnAudit();
        actionUnaudit.putValue("Name", this.resHelper.getString("actionUnaudit") + "(U)");
        KDMenuItem menuItemUnAudit = new KDMenuItem((Action)actionUnaudit);
        menuItemUnAudit.setName("unaudit");
        menuItemUnAudit.setMnemonic('U');
        menuTool.add((JMenuItem)menuItemUnAudit);
        KDMenu menuStyle = (KDMenu)this.getMenuManager().findMenuUsingPath("Style");
        ActionUseNewTemplate actionUseNewTemplate = new ActionUseNewTemplate();
        actionUseNewTemplate.putValue("Name", this.resHelper.getString("actionUseNewTemplate") + "(N)");
        KDMenuItem menuItemUseNewTemplate = new KDMenuItem((Action)actionUseNewTemplate);
        menuItemUseNewTemplate.setName("useNewTemplate");
        menuItemUseNewTemplate.setMnemonic('N');
        menuStyle.add((JMenuItem)menuItemUseNewTemplate);
        KDMenu menuFile = (KDMenu)this.getMenuManager().findMenuUsingPath("file");
        KDMenuItem menuImportData = new KDMenuItem((Action)actionAudit);
        menuImportData.setAction((Action)new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                CslReportDesigner.this.actionImportData_perform(e);
            }
        });
        menuImportData.setText(this.resHelper.getString("importData"));
        menuImportData.setMnemonic('D');
        menuFile.insert((JMenuItem)menuImportData, 2);
        this.setMenuStrategy(new ReportMenuStrategy());
        this.getSpreadManager().setItemFormulasetEnabled(false);
        this.getMenuStrategy().applyMenuState(this.getOperState());
    }

    private void initListener() throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select r.FSourceType, t.FDynaRpttype from t_eas_report r ");
        sql.append(" join t_eas_template t on r.FTemplateNumber = t.FNumber");
        sql.append(" where r.FId = ?");
        IRowSet rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{this.id});
        if (rowSet.next()) {
            int sourceType = rowSet.getInt("FSourceType");
            int dynaType = rowSet.getInt("FDynaRpttype");
            if (sourceType == 10 && dynaType == 2) {
                this.getSpread().getBook().addSheetChangeListener((SheetChangeListener)new DynaItemListener());
                SpreadAction action = (SpreadAction)this.getActionManager().getAction("Insert_Row");
                action.setBeforeAction((NotifyListener)new TableBeforeAction("Insert_Row"));
                action = (SpreadAction)this.getActionManager().getAction("Insert_Col");
                action.setBeforeAction((NotifyListener)new TableBeforeAction("Insert_Col"));
                action = (SpreadAction)this.getActionManager().getAction("Insert_Cell");
                action.setBeforeAction((NotifyListener)new TableBeforeAction("Insert_Cell"));
                action = (SpreadAction)this.getActionManager().getAction("Delete_Row");
                action.setBeforeAction((NotifyListener)new TableBeforeAction("Delete_Row"));
                action = (SpreadAction)this.getActionManager().getAction("Delete_Col");
                action.setBeforeAction((NotifyListener)new TableBeforeAction("Delete_Col"));
                action = (SpreadAction)this.getActionManager().getAction("Delete_Cell");
                action.setBeforeAction((NotifyListener)new TableBeforeAction("Delete_Cell"));
                ((SpreadAction)this.getActionManager().getAction("Insert_Row")).setAfterAction((NotifyListener)new TableAfterAction("Insert_Row"));
                ((SpreadAction)this.getActionManager().getAction("Insert_Col")).setAfterAction((NotifyListener)new TableAfterAction("Insert_Col"));
            }
        }
    }

    protected void actionImportData_perform(ActionEvent e) {
        File f;
        KDFileChooser fc = new KDFileChooser();
        fc.addChoosableFileFilter((FileFilter)new SimpleFileFilter("xls", ResourceHelper.getMenuResource("MenuManager.136")));
        fc.setMultiSelectionEnabled(false);
        int openResult = fc.showOpenDialog((Component)((Object)this));
        if (openResult == 0 && (f = fc.getSelectedFile()).exists() && f.canRead()) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("EXPORT_FORMULA", "false");
            KDSBook book = POIXlsReader.parse((String)f.getAbsolutePath(), hm);
            if (book == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"badFileError"));
                SysUtil.abort();
            }
            KDSSheet ks = null;
            Book spread = this.getSpread().getBook();
            StringBuffer failingSheet = new StringBuffer();
            int size = book.getSheetCount();
            for (int i = 0; i < size; ++i) {
                ks = book.getSheet((Object)new Integer(i));
                Sheet sheet = spread.getSheet(ks.getName());
                if (sheet == null) {
                    if (failingSheet.length() > 1) {
                        failingSheet.append(',');
                    }
                    failingSheet.append(ks.getName());
                    continue;
                }
                for (int r = 0; r < ks.getRowCount(); ++r) {
                    KDSRow row = ks.getRow(r, false);
                    if (row == null) continue;
                    for (int c = 0; c < ks.getColumnCount(); ++c) {
                        KDSCell cell = ks.getCell(r, c, false);
                        if (cell == null) continue;
                        sheet.getCell(r, c, true).setValue(new Variant(cell.getValue()));
                    }
                }
            }
            if (failingSheet.length() > 1) {
                MsgBox.showWarning((String)("\u56e0\u4e3a\u627e\u4e0d\u5230\u5339\u914d\u7684\u5de5\u4f5c\u8868\u540d\u79f0\uff0c\u5bfc\u5165\u5931\u8d25\u7684\u5de5\u4f5c\u8868\u6709 " + failingSheet.toString()));
            }
        }
    }

    private void setAction(String actionName, AbstractAction action, String keystrok) {
        KDMenuItem menuItem = (KDMenuItem)this.getMenuManager().findMenuUsingPath(actionName);
        menuItem.setAction((Action)action);
        if (!StringUtils.isEmpty((String)keystrok)) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(keystrok));
        }
    }

    public void actionFileSave_actionPerform(ActionEvent e) {
        this.save();
        super.actionFileSave_actionPerform(e);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
    }

    private void save() {
        CslReportDataProvider provider = (CslReportDataProvider)this.getDataProvider();
        try {
            provider.saveBook(this.getSpread().getBook());
            byte[] data = provider.getKDF();
            if (data != null) {
                StringBuffer sql = new StringBuffer();
                sql.append("update t_eas_report set FData = ?, ");
                sql.append("FLastUpdateUserID = '").append(UIConfig.getUserName());
                sql.append("', FLastUpdateTime = ");
                sql.append(CslRptUtil.formatDateForSql((Date)new Date()));
                sql.append(" where FId = ?");
                DbUtil.execute(sql.toString(), new Object[]{data, this.id});
            }
        }
        catch (Exception exc) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)exc);
            return;
        }
    }

    public void setUiObj(CoreUIObject uiObj) {
        this.uiObj = uiObj;
    }

    public void actionAudit_actionPerform(ActionEvent e) {
        if (!OprtState.VIEW.equals(this.getOperState())) {
            this.save();
        }
        if (!DynamicTemplateUtility.checkItem(this.getSpread().getBook())) {
            MsgBox.showInfo((Component)((Object)this), (String)this.resHelper.getString("ItemFormulaDup"));
            return;
        }
        KDSpread spread = this.getSpread();
        RptCheckExpTank expTank = BookProperties.loadFromSpread(spread.getBook()).getOperationSchema().getExpTank();
        try {
            Book book = SpreadHelper.copySpread(this.getSpread()).getBook();
            String string = ReportCheckHelper.checkReport(book, this.getDataProvider(), expTank, Locale.getDefault());
            if (string != null) {
                AdvMsgBox box = AdvMsgBox.createAdvMsgBox((Component)spread, (String)"\u68c0\u67e5\u4e0d\u901a\u8fc7", (String)"\u62a5\u8868\u68c0\u67e5\u4e0d\u901a\u8fc7", (String)string, (int)1, (int)8188);
                box.show();
                return;
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)spread, (Throwable)e1);
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update t_eas_report set FAuditedStatus = 2, ");
        sql.append("FAuditorID = '").append(UIConfig.getUserName());
        sql.append("', FAuditedTime = ");
        sql.append(CslRptUtil.formatDateForSql((Date)new Date()));
        sql.append(" where fid = ?");
        try {
            DbUtil.execute(sql.toString(), new Object[]{this.id});
        }
        catch (BOSException e1) {
            this.uiObj.handUIException((Throwable)e1);
            return;
        }
        this.isAudited = true;
        this.setOperState("VIEW");
        MsgBox.showInfo((String)this.resHelper.getString("HasAudited"));
        this.getMenuStrategy().applyMenuState(this.getOperState());
    }

    public void actionUnAudit_actionPerform(ActionEvent e) {
        try {
            StringBuffer oql = new StringBuffer();
            oql.append("update t_eas_report set FAuditedStatus = 1, ");
            oql.append("FAuditorID = null, ");
            oql.append(" FAuditedTime = null");
            oql.append(" where fid = ?");
            DbUtil.execute(oql.toString(), new Object[]{this.id});
        }
        catch (Exception exc) {
            this.uiObj.handUIException((Throwable)exc);
            return;
        }
        this.isAudited = false;
        this.setOperState("EDIT");
        MsgBox.showInfo((String)this.resHelper.getString("HasUnAudited"));
        this.getMenuStrategy().applyMenuState(this.getOperState());
    }

    public void actionUseNewTemplate_actionPerform(ActionEvent e) {
        CslReportDataProvider dataProvider = (CslReportDataProvider)this.getDataProvider();
        String templateNumber = dataProvider.getReportVO().getTemplateNumber();
        String sql = "select FId, FData from t_eas_template where FNumber = ? and FId <> ?";
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{templateNumber, this.id});
            if (rowSet.next()) {
                byte[] data = rowSet.getBytes("FData");
                Book book = IOHelper.unpackBook((byte[])data);
                KDSpread nowSpread = this.getSpread();
                for (int i = 0; i < book.getSheetCount(); ++i) {
                    Sheet sheet = book.getSheet(i);
                    Sheet nowSheet = nowSpread.getBook().getSheet(sheet.getSheetName());
                    if (nowSheet == null) continue;
                    nowSheet.copyStyleFrom(sheet);
                }
                nowSpread.repaint();
            }
        }
        catch (Exception e1) {
            MsgBox.showInfo((Component)((Object)this), (String)e1.getMessage());
        }
    }

    protected class ReportMenuStrategy
    implements IMenuStrategy {
        protected ReportMenuStrategy() {
        }

        public void applyMenuState(String state) {
            if (state.equals("ADDNEW")) {
                this.setAddNew();
            } else if (state.equals("EDIT")) {
                this.setEdit();
            } else if (state.equals("VIEW")) {
                this.setView();
            }
        }

        private void setAddNew() {
            this.setEdit();
        }

        private void setView() {
            MenuManager m = CslReportDesigner.this.getMenuManager();
            m.findMenuUsingPath("File/addnew").setVisible(false);
            KDMenuItem save = (KDMenuItem)m.findMenuUsingPath(CslReportDesigner.MenuName_Save);
            save.setVisible(false);
            save.getAction().setEnabled(false);
            m.findMenuUsingPath("File/saveAs").setVisible(false);
            m.findMenuUsingPath("Style/useNewTemplate").setVisible(false);
            if (CslReportDesigner.this.isAudited) {
                m.findMenuUsingPath(CslReportDesigner.MenuName_Audit).setVisible(false);
                m.findMenuUsingPath(CslReportDesigner.MenuName_UnAudit).setVisible(true);
            } else {
                m.findMenuUsingPath(CslReportDesigner.MenuName_Audit).setVisible(true);
                m.findMenuUsingPath(CslReportDesigner.MenuName_UnAudit).setVisible(false);
            }
        }

        private void setEdit() {
            MenuManager m = CslReportDesigner.this.getMenuManager();
            m.findMenuUsingPath("File/addnew").setVisible(false);
            m.findMenuUsingPath("File/saveAs").setVisible(false);
            KDMenuItem save = (KDMenuItem)m.findMenuUsingPath(CslReportDesigner.MenuName_Save);
            m.findMenuUsingPath("Style/useNewTemplate").setVisible(true);
            if (CslReportDesigner.this.isAudited) {
                m.findMenuUsingPath(CslReportDesigner.MenuName_Audit).setVisible(false);
                m.findMenuUsingPath(CslReportDesigner.MenuName_UnAudit).setVisible(true);
                save.setVisible(false);
                save.getAction().setEnabled(false);
            } else {
                m.findMenuUsingPath(CslReportDesigner.MenuName_Audit).setVisible(true);
                m.findMenuUsingPath(CslReportDesigner.MenuName_UnAudit).setVisible(false);
                save.setVisible(true);
                save.getAction().setEnabled(true);
            }
        }
    }

    class ActionUseNewTemplate
    extends AbstractAction {
        ActionUseNewTemplate() {
        }

        public void actionPerformed(ActionEvent e) {
            CslReportDesigner.this.actionUseNewTemplate_actionPerform(e);
        }
    }

    class ActionUnAudit
    extends AbstractAction {
        ActionUnAudit() {
        }

        public void actionPerformed(ActionEvent e) {
            CslReportDesigner.this.actionUnAudit_actionPerform(e);
        }
    }

    class ActionAudit
    extends AbstractAction {
        ActionAudit() {
        }

        public void actionPerformed(ActionEvent e) {
            CslReportDesigner.this.actionAudit_actionPerform(e);
        }
    }

    class ActionFileSave
    extends AbstractAction {
        ActionFileSave() {
        }

        public void actionPerformed(ActionEvent e) {
            CslReportDesigner.this.actionFileSave_actionPerform(e);
        }
    }
}

