/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPasswordField;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.eas.base.uiframe.ProjectFaceUtil;
import com.kingdee.eas.common.cache.CacheConfigImpl;
import com.kingdee.eas.common.client.ClientVersionUtil;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.util.DNFFile;
import com.kingdee.eas.fi.gr.cslrpt.util.PropertiesFileUtil;
import com.kingdee.eas.rptclient.base.IUIFactory;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.k3webservice.K3WebServiceFacade;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.AisInfo;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.WebServiceException;
import com.kingdee.eas.rptclient.gr.rptclient.DownFilePathSetUI;
import com.kingdee.eas.rptclient.gr.rptclient.frame.RptClientMainFrame;
import com.kingdee.eas.rptclient.gr.rptclient.util.DataBaseConstructor;
import com.kingdee.eas.rptclient.gr.rptclient.util.FTPUpDown;
import com.kingdee.eas.rptclient.gr.rptclient.util.ReceiveTemplate;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.util.CommonUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.ConnectException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LoginFrame
extends KDFrame {
    private static Logger logger = Logger.getLogger((Class)LoginFrame.class);
    public static Image TITLE_ICON;
    private static final String LFCLASSNAME = "com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel";
    private AisInfo[] aisList;
    private KDLabelContainer lbcLanguage = new KDLabelContainer();
    private KDLabelContainer lbcDataCenter = new KDLabelContainer();
    private KDLabelContainer lbcUserName = new KDLabelContainer();
    private KDLabel kdlLogo = new KDLabel();
    private KDLabel kdlProject = new KDLabel();
    private KDLabelContainer lbcPassword = new KDLabelContainer();
    private KDComboBox ddlLanguage = new KDComboBox();
    private KDComboBox ddlDataCenter = new KDComboBox();
    private KDTextField txtUserName = new KDTextField();
    private KDPasswordField txtPassword = new KDPasswordField();
    private KDButton btnLogin = new KDButton();
    private KDButton btnCancel = new KDButton();
    private KDButtonGroup buttonGroup1 = new KDButtonGroup();
    private KDRadioButton rdoK3Login = new KDRadioButton();
    private KDRadioButton rdoNoneK3Login = new KDRadioButton();
    private KDButtonGroup buttonGroup2 = new KDButtonGroup();
    private KDRadioButton rdoDomainLogin = new KDRadioButton();
    private KDRadioButton rdoUserLogin = new KDRadioButton();
    private KDLabelContainer lbcServer = new KDLabelContainer();
    private KDTextField txtServer = new KDTextField();
    private static Component loginFrameWindow;
    private boolean isInLogin = false;

    public static Component getLoginFrame() {
        return loginFrameWindow;
    }

    public LoginFrame() {
        this.jbInit();
        this.rdoK3Login.setVisible(false);
        this.rdoNoneK3Login.setVisible(false);
        loginFrameWindow = this;
    }

    private void jbInit() {
        this.initLanguage();
        this.initIcon();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setPreferredSize(new Dimension(634, 418));
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                LoginFrame.this.this_windowClosing(e);
            }
        });
        this.rdoK3Login.setBounds(new Rectangle(256, 147, 100, 19));
        this.rdoK3Login.setForeground(Color.WHITE);
        this.rdoK3Login.setSelected(true);
        this.buttonGroup1.add((AbstractButton)this.rdoK3Login);
        this.rdoNoneK3Login.setBounds(new Rectangle(360, 147, 100, 19));
        this.rdoNoneK3Login.setForeground(Color.WHITE);
        this.rdoNoneK3Login.setEnabled(false);
        this.buttonGroup1.add((AbstractButton)this.rdoNoneK3Login);
        this.lbcServer.getBoundLabel().setForeground(Color.WHITE);
        this.lbcServer.setBounds(new Rectangle(256, 147, 279, 19));
        this.lbcServer.setBoundLabelUnderline(true);
        this.lbcServer.setBoundLabelLength(89);
        ((KDLabel)this.lbcServer.getBoundLabel()).setUnderlineColor(Color.WHITE);
        this.lbcLanguage.getBoundLabel().setForeground(Color.WHITE);
        this.lbcLanguage.setBounds(new Rectangle(256, 170, 279, 19));
        this.lbcLanguage.setBoundLabelUnderline(true);
        this.lbcLanguage.setBoundLabelLength(89);
        ((KDLabel)this.lbcLanguage.getBoundLabel()).setUnderlineColor(Color.WHITE);
        this.lbcDataCenter.getBoundLabel().setForeground(Color.WHITE);
        this.lbcDataCenter.setBounds(new Rectangle(256, 193, 279, 19));
        this.lbcDataCenter.setBoundLabelUnderline(true);
        this.lbcDataCenter.setBoundLabelLength(89);
        ((KDLabel)this.lbcDataCenter.getBoundLabel()).setUnderlineColor(Color.WHITE);
        this.rdoDomainLogin.setBounds(new Rectangle(256, 216, 140, 19));
        this.rdoDomainLogin.setForeground(Color.WHITE);
        this.rdoDomainLogin.setSelected(true);
        this.buttonGroup2.add((AbstractButton)this.rdoDomainLogin);
        this.rdoUserLogin.setBounds(new Rectangle(256, 239, 140, 19));
        this.rdoUserLogin.setForeground(Color.WHITE);
        this.buttonGroup2.add((AbstractButton)this.rdoUserLogin);
        this.lbcUserName.getBoundLabel().setForeground(Color.WHITE);
        this.lbcUserName.setBounds(new Rectangle(256, 262, 279, 19));
        this.lbcUserName.setBoundLabelUnderline(true);
        this.lbcUserName.setBoundLabelLength(89);
        ((KDLabel)this.lbcUserName.getBoundLabel()).setUnderlineColor(Color.WHITE);
        this.lbcPassword.getBoundLabel().setForeground(Color.WHITE);
        this.lbcPassword.setBounds(new Rectangle(256, 285, 279, 19));
        this.lbcPassword.setBoundLabelUnderline(true);
        this.lbcPassword.setBoundLabelLength(89);
        ((KDLabel)this.lbcPassword.getBoundLabel()).setUnderlineColor(Color.WHITE);
        this.ddlLanguage.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.lbcLanguage.setBoundEditor((JComponent)this.ddlLanguage);
        this.ddlLanguage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginFrame.this.changeLang();
            }
        });
        this.txtServer.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.txtServer.setText(UIConfig.getServer());
        this.txtServer.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                LoginFrame.this.txtServer_focusLost(e);
            }
        });
        this.lbcServer.setBoundEditor((JComponent)this.txtServer);
        this.ddlDataCenter.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.lbcDataCenter.setBoundEditor((JComponent)this.ddlDataCenter);
        this.txtUserName.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.lbcUserName.setBoundEditor((JComponent)this.txtUserName);
        this.initUserName();
        this.txtPassword.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.lbcPassword.setBoundEditor((JComponent)this.txtPassword);
        class ActionLogin
        extends AbstractAction {
            ActionLogin() {
            }

            public void actionPerformed(ActionEvent e) {
                if (LoginFrame.this.isInLogin) {
                    return;
                }
                LoginFrame.this.isInLogin = true;
                Thread workThread = new Thread(this){
                    private final /* synthetic */ ActionLogin this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        LoginFrame.access$400(ActionLogin.access$300(this.this$1));
                        LoginFrame.access$202(ActionLogin.access$300(this.this$1), false);
                        LoginFrame.access$500(ActionLogin.access$300(this.this$1));
                    }
                };
                workThread.start();
            }

            static /* synthetic */ LoginFrame access$300(ActionLogin x0) {
                return x0.LoginFrame.this;
            }
        }
        ActionLogin actionLogin = new ActionLogin();
        this.txtPassword.setAction((Action)actionLogin);
        this.btnLogin.setBounds(new Rectangle(373, 314, 77, 21));
        this.btnLogin.setAction((Action)actionLogin);
        this.btnCancel.setBounds(new Rectangle(458, 314, 77, 21));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginFrame.this.btnCancel_actionPerformed(e);
            }
        });
        this.initResources();
        this.getContentPane().add((Component)this.rdoK3Login);
        this.getContentPane().add((Component)this.rdoNoneK3Login);
        this.getContentPane().add((Component)this.lbcServer);
        this.getContentPane().add((Component)this.lbcLanguage);
        this.getContentPane().add((Component)this.lbcDataCenter);
        this.getContentPane().add((Component)this.rdoDomainLogin);
        this.getContentPane().add((Component)this.rdoUserLogin);
        this.getContentPane().add((Component)this.lbcUserName);
        this.getContentPane().add((Component)this.lbcPassword);
        this.getContentPane().add((Component)this.btnLogin);
        this.getContentPane().add((Component)this.btnCancel);
        this.pack();
        this.setLocationRelativeTo(null);
        ControlUtilities.resetAppDefaultFocusTraversalKeys();
        ControlUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtPassword, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.getRootPane().setDefaultButton((JButton)this.btnLogin);
        this.txtServer.requestFocus();
    }

    private void this_windowClosing(WindowEvent e) {
        this.setDefaultCloseOperation(3);
    }

    private void preLogin() {
        this.rdoK3Login.setEnabled(false);
        this.lbcServer.setEnabled(false);
        this.lbcLanguage.setEnabled(false);
        this.lbcDataCenter.setEnabled(false);
        this.rdoDomainLogin.setEnabled(false);
        this.rdoUserLogin.setEnabled(false);
        this.lbcPassword.setEnabled(false);
        this.lbcUserName.setEnabled(false);
        this.btnLogin.setEnabled(false);
        this.btnCancel.setEnabled(false);
    }

    private void enableAll() {
        this.rdoK3Login.setEnabled(true);
        this.lbcServer.setEnabled(true);
        this.lbcLanguage.setEnabled(true);
        this.lbcDataCenter.setEnabled(true);
        this.rdoDomainLogin.setEnabled(true);
        this.rdoUserLogin.setEnabled(true);
        this.lbcPassword.setEnabled(true);
        this.lbcUserName.setEnabled(true);
        this.btnLogin.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loginMain() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.login();
        }
        catch (Exception exc) {
            MsgBox.showInfo((Component)((Object)this), (String)exc.getMessage());
            this.enableAll();
            this.txtPassword.requestFocus();
            this.txtPassword.selectAll();
            return;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        try {
            UIConfig.initSysParams();
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            return;
        }
        this.upgradeClient();
        long startMainFrame = System.currentTimeMillis();
        try {
            RptClientMainFrame frame = new RptClientMainFrame();
            this.dispose();
            frame.show();
            if (CacheConfigManager.getConfig() == null) {
                long startCache = System.currentTimeMillis();
                CacheConfigManager.registerConfig((ICacheConfig)new CacheConfigImpl());
                long costCache = System.currentTimeMillis() - startCache;
                logger.debug((Object)(" register cache : " + costCache + " ms."));
            }
        }
        catch (Exception exc) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)exc);
        }
        long costMainFrame = System.currentTimeMillis() - startMainFrame;
        logger.info((Object)(" show main frame:" + costMainFrame + " ms."));
    }

    private void upgradeClient() {
        String msg;
        String ip = UIConfig.getFTPIP();
        String username = UIConfig.getFTPUser();
        String password = UIConfig.getFTPPassword();
        String downPath = UIConfig.getFTPDownPath();
        String updatePath = UIConfig.getFTPUpdatePath();
        String companyNumber = UIConfig.getCurCompanyNumber();
        String curPath = System.getProperty("user.home");
        String filename = companyNumber + ".dnf";
        String versionFile = "clientUpdate.properties";
        if (StringUtils.isEmpty((String)ip) || StringUtils.isEmpty((String)downPath) || StringUtils.isEmpty((String)companyNumber)) {
            MsgBox.showWarning((Component)((Object)this), (String)CommonUtil.getResource("ftpConfigIncomplete"));
            return;
        }
        logger.debug((Object)"step 1:connectin ftp server and download file");
        FTPUpDown ftp = null;
        try {
            ftp = new FTPUpDown(ip, "21", username, password);
        }
        catch (Exception ex) {
            MsgBox.showInfo((Component)((Object)this), (String)(CommonUtil.getResource("ftpConnectFail") + "," + ex.getMessage()));
            return;
        }
        logger.debug((Object)"step 2:Update Application Program");
        if (StringUtils.isEmpty((String)updatePath)) {
            MsgBox.showWarning((Component)((Object)this), (String)CommonUtil.getResource("updatePathNotConfig"));
        } else {
            try {
                boolean existUpdatePath = ftp.checkFolderIsExist(updatePath);
                if (existUpdatePath) {
                    ftp.downSearchFile(updatePath, versionFile, curPath);
                    String filePath = curPath + "/" + versionFile;
                    Properties prop = PropertiesFileUtil.read((String)(curPath + "/" + versionFile));
                    String versionNumber = prop.getProperty("VersionNumber");
                    String pathNumber = prop.getProperty("PathVersionNumber");
                    boolean isForceUpdate = new Boolean(prop.getProperty("IsForceUpdate"));
                    prop.clear();
                    System.gc();
                    File downFile = new File(filePath);
                    downFile.delete();
                    prop.load(UIConfig.class.getClassLoader().getResourceAsStream("clientUpdate.properties"));
                    String currentVersion = prop.getProperty("VersionNumber");
                    String currentPathNumber = prop.getProperty("PathVersionNumber");
                    boolean hasNew = currentVersion.compareTo(versionNumber) < 0;
                    boolean bl = hasNew = hasNew || currentVersion.equals(versionNumber) && currentPathNumber.compareTo(pathNumber) < 0;
                    if (hasNew) {
                        UIContext uiContext = new UIContext((Object)this);
                        IUIFactory factory = UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory");
                        DownFilePathSetUI downPanel = (DownFilePathSetUI)factory.create((Component)((Object)this), DownFilePathSetUI.class.getName(), (Map)uiContext);
                        downPanel.setFTPUpDown(ftp, updatePath);
                        downPanel.showWindow();
                        if (downPanel.isCancel()) {
                            if (isForceUpdate) {
                                String msg2 = MessageFormat.format(CommonUtil.getResource("forceUpdateProgram1"), versionNumber);
                                MsgBox.showInfo((Component)((Object)this), (String)msg2);
                                System.exit(0);
                            } else {
                                String msg3 = MessageFormat.format(CommonUtil.getResource("manualUpdateProgram1"), versionNumber);
                                MsgBox.showInfo((Component)((Object)this), (String)msg3);
                            }
                        } else if (isForceUpdate) {
                            String msg4 = MessageFormat.format(CommonUtil.getResource("forceUpdateProgram2"), versionNumber);
                            MsgBox.showInfo((Component)((Object)this), (String)msg4);
                            System.exit(0);
                        } else {
                            String msg5 = MessageFormat.format(CommonUtil.getResource("manualUpdateProgram2"), versionNumber);
                            MsgBox.showInfo((Component)((Object)this), (String)msg5);
                        }
                    }
                } else {
                    msg = MessageFormat.format(CommonUtil.getResource("updatePathNotExists"), updatePath);
                    MsgBox.showInfo((Component)((Object)this), (String)msg);
                }
            }
            catch (Exception e) {
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            }
        }
        logger.debug((Object)"step 3:update template and basedata(currency and company)");
        try {
            ftp.resetPath();
            boolean existDataPath = ftp.checkFolderIsExist(downPath);
            if (existDataPath) {
                ftp.downFile(downPath, filename, curPath);
            } else {
                msg = MessageFormat.format(CommonUtil.getResource("downPathNotExists"), downPath);
                MsgBox.showInfo((Component)((Object)this), (String)msg);
            }
        }
        catch (Exception e) {
            logger.error((Object)("download DNFFile(" + filename + ") error"), (Throwable)e);
        }
        logger.debug((Object)"step 3.2:parse DNFFile");
        File dnnFile = new File(curPath + File.separator + filename);
        if (dnnFile.exists()) {
            int confirm;
            DNFFile file = new DNFFile(dnnFile.getPath(), "gamania");
            String easVersion = null;
            try {
                easVersion = ClientVersionUtil.getCommonLibVersion();
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (easVersion.compareTo(file.getEASVersion()) < 0 && (confirm = MsgBox.showConfirm2((Component)((Object)this), (String)"\u60a8\u4f7f\u7528\u7684\u5ba2\u6237\u7a0b\u5e8f\u7248\u672c\u592a\u4f4e\uff0c\u53ef\u80fd\u65e0\u6cd5\u4f7f\u7528\u65b0\u6a21\u677f\uff0c\u5efa\u8bae\u5347\u7ea7\u5ba2\u6237\u7aef\u7a0b\u5e8f\uff01")) == 0) {
                System.exit(0);
            }
            if (file.getUpdateTime() != null && (UIConfig.getDNFUpdateTime() == null || file.getUpdateTime().compareTo(UIConfig.getDNFUpdateTime()) > 0) && (confirm = MsgBox.showConfirm2((Component)((Object)this), (String)CommonUtil.getResource("hasNewTemplates"))) == 0) {
                try {
                    logger.debug((Object)"step 3.3~3.5: Receive basedata");
                    ReceiveTemplate.receiveTemplates(file.getTemplateCollection());
                    ReceiveTemplate.receiveCurrency(file.getCurrencyCollection());
                    ReceiveTemplate.receiveCompany(file.getOrgUnitCollection());
                    ReceiveTemplate.writeUpdateTime(file.getUpdateTime());
                }
                catch (Exception e) {
                    MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                }
            }
        }
        System.gc();
        dnnFile.delete();
    }

    private void btnCancel_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    protected void txtServer_focusLost(FocusEvent e) {
        String server = this.txtServer.getText();
        if (StringUtils.isEmpty((String)server)) {
            return;
        }
        UIConfig.setServer(server);
        this.initDataCenter();
    }

    private void login() throws Exception {
        String server = this.txtServer.getText();
        if (StringUtils.isEmpty((String)server)) {
            throw new BOSException(this.getResx("ServerIsNull"));
        }
        LanguageInfo currentLangInfo = (LanguageInfo)this.ddlLanguage.getSelectedItem();
        if (currentLangInfo == null) {
            throw new BOSException(this.getResx("selectLoginLanguage"));
        }
        Locale locale = new Locale(((LanguageInfo)this.ddlLanguage.getSelectedItem()).getLocale());
        int aisInfoIndex = this.ddlDataCenter.getSelectedIndex();
        if (aisInfoIndex < 0) {
            throw new BOSException(this.getResx("selectDatacenter"));
        }
        String password = new String(this.txtPassword.getPassword());
        AisInfo aisInfo = this.aisList[aisInfoIndex];
        LocaleUtils.setDefaultLocale((Locale)locale);
        String loginString = K3WebServiceFacade.login(this.txtUserName.getText(), password, aisInfo.getAisID());
        if (StringUtils.isEmpty((String)loginString)) {
            throw new BOSException(this.getResx("LoginString_isnull"));
        }
        System.out.println(loginString);
        this.parseLoginString(loginString);
        UIConfig.setUrl(loginString);
        UIConfig.setLangIndex(this.ddlLanguage.getSelectedIndex());
        UIConfig.setDcIndex(this.ddlDataCenter.getSelectedIndex());
        UIConfig.setUserName(this.txtUserName.getText());
        UIConfig.storeConfig();
        DataBaseConstructor.initDataBase();
    }

    private String parseLoginString(String loginString) throws BOSException {
        String dataSource;
        int end;
        if (!loginString.startsWith("ConnectString")) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        int begin = loginString.indexOf("{");
        String tmpStr = loginString.substring(begin + 1, end = loginString.indexOf("}"));
        if (StringUtils.isEmpty((String)tmpStr)) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        String[] param = tmpStr.split("\\;");
        if (param.length == 0) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        HashMap<String, String> context = new HashMap<String, String>();
        for (int i = 0; i < param.length; ++i) {
            String[] strs = param[i].split("=");
            if (strs.length == 2) {
                context.put(strs[0], strs[1]);
                continue;
            }
            if (strs.length == 1) {
                context.put(strs[0], "");
                continue;
            }
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        StringBuffer connectString = new StringBuffer();
        String provider = (String)context.get("Provider");
        if (StringUtils.isEmpty((String)provider)) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        if (provider.startsWith("SQLOLEDB")) {
            connectString.append("jdbc:ksql:com.microsoft.jdbc.sqlserver.SQLServerDriver:dbtype=mssqlserver:trace=off:file=null:Optimize=1:");
        }
        if (StringUtils.isEmpty((String)(dataSource = (String)context.get("Data Source")))) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        connectString.append("jdbc:microsoft:sqlserver://").append(dataSource).append(":1433;");
        String dbname = (String)context.get("Initial Catalog");
        if (StringUtils.isEmpty((String)dbname)) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        connectString.append("DataBaseName=").append(dbname);
        String userName = (String)context.get("User ID");
        if (StringUtils.isEmpty((String)userName)) {
            throw new BOSException(this.getResx("UserIsNull"));
        }
        String password = (String)context.get("Password");
        UIConfig.setConnectUrl(connectString.toString(), userName, password);
        return connectString.toString();
    }

    private void initResources() {
        this.initBackground();
        this.initProjectLogo();
        this.setTitle(this.getResx("this.title"));
        this.rdoK3Login.setText(this.getResx("rdoK3Login.text"));
        this.rdoNoneK3Login.setText(this.getResx("rdoNoneK3Login.text"));
        this.lbcServer.setBoundLabelText(this.getResx("lbcServer.text"));
        this.lbcLanguage.setBoundLabelText(this.getResx("lblLanguage.text"));
        this.lbcDataCenter.setBoundLabelText(this.getResx("lblDataCenter.text"));
        this.rdoDomainLogin.setText(this.getResx("rdoDomainLogin.text"));
        this.rdoUserLogin.setText(this.getResx("rdoUserLogin.text"));
        this.lbcUserName.setBoundLabelText(this.getResx("lblUserName.text"));
        this.lbcPassword.setBoundLabelText(this.getResx("lblPassword.text"));
        this.btnLogin.setText(this.getResx("btnLogin.text"));
        this.btnCancel.setText(this.getResx("btnCancel.text"));
    }

    private void initProjectLogo() {
        Preferences pref = Preferences.systemRoot().node("kingdee/eas");
        String localDirName = pref.get("easclienthome", null);
        if (localDirName == null) {
            localDirName = "C:/kingdee/eas/client/";
        }
        this.kdlLogo.setBounds(new Rectangle(0, 0, 317, 84));
        this.kdlLogo.setIcon(ProjectFaceUtil.getClientProjectInstance((String)localDirName, (boolean)true).getLoginLogo());
        this.getContentPane().add((Component)this.kdlLogo);
        this.kdlProject.setBounds(454, 338, 180, 80);
        this.kdlProject.setIcon(ProjectFaceUtil.getClientProjectInstance((String)localDirName, (boolean)true).getLoginName());
        this.getContentPane().add((Component)this.kdlProject);
    }

    private String getResx(String resxItemName) {
        LanguageInfo currentLangInfo = (LanguageInfo)this.ddlLanguage.getSelectedItem();
        Locale locale = new Locale(currentLangInfo.getLocale());
        String resxName = "com.kingdee.eas.rptclient.gr.rptclient.resource.LoginFrameResource";
        return ResourceBase.getString((String)resxName, (String)resxItemName, (Locale)locale);
    }

    private void initIcon() {
        if (TITLE_ICON == null) {
            TITLE_ICON = EASResource.getImage((String)"imgEas_16");
        }
        this.setIconImage(TITLE_ICON);
    }

    private void initBackground() {
        Icon backgroundImageIcon = EASResource.getIcon((String)"imgPic_login_bg");
        JLabel lblBackground = new JLabel();
        lblBackground.setIcon(backgroundImageIcon);
        lblBackground.setBounds(0, 0, 634, 418);
        this.getLayeredPane().add((Component)lblBackground, JLayeredPane.FRAME_CONTENT_LAYER);
        ((JPanel)this.getContentPane()).setOpaque(false);
    }

    private void initLanguage() {
        Map sortedLangMap = UIConfig.getLanguages();
        Object[] langs = new LanguageInfo[sortedLangMap.size()];
        Iterator iterator = sortedLangMap.entrySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            String[] locales = key.split("#");
            langs[index] = new LanguageInfo(locales[0], (String)entry.getValue());
            ++index;
        }
        this.ddlLanguage.addItems(langs);
        int langIndex = UIConfig.getLangIndex();
        if (this.ddlLanguage.getItemCount() > langIndex) {
            this.ddlLanguage.setSelectedIndex(langIndex);
        }
        this.initDefaultLocale();
    }

    private void initDefaultLocale() {
        LanguageInfo currentLangInfo = (LanguageInfo)this.ddlLanguage.getSelectedItem();
        String l = currentLangInfo.getLocale();
        if ("l1".equalsIgnoreCase(l)) {
            Locale.setDefault(Locale.US);
        } else if ("l2".equalsIgnoreCase(l)) {
            Locale.setDefault(Locale.CHINA);
        } else if ("l3".equalsIgnoreCase(l)) {
            Locale.setDefault(Locale.TAIWAN);
        }
    }

    private void initDataCenter() {
        long start = System.currentTimeMillis();
        try {
            this.aisList = K3WebServiceFacade.queryAisInfo();
        }
        catch (ConnectException e) {
            MsgBox.showError((Component)((Object)this), (String)this.getResx("connectTimeout"));
            this.ddlDataCenter.removeAllItems();
            return;
        }
        catch (AxisFault e) {
            MsgBox.showError((Component)((Object)this), (String)this.getResx("connectTimeout"));
            this.ddlDataCenter.removeAllItems();
            return;
        }
        catch (WebServiceException e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            this.ddlDataCenter.removeAllItems();
            return;
        }
        catch (Exception e) {
            this.ddlDataCenter.removeAllItems();
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return;
        }
        if (this.aisList == null || this.aisList.length == 0) {
            MsgBox.showError((Component)((Object)this), (String)this.getResx("this.msgdcerror"));
            return;
        }
        this.fillDataCenter();
        int langIndex = UIConfig.getDcIndex();
        if (this.ddlDataCenter.getItemCount() > langIndex) {
            this.ddlDataCenter.setSelectedIndex(langIndex);
        }
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)(" init data center spent:" + cost + " ms."));
    }

    private void fillDataCenter() {
        int index = this.ddlDataCenter.getSelectedIndex();
        LanguageInfo currentLangInfo = (LanguageInfo)this.ddlLanguage.getSelectedItem();
        if (currentLangInfo == null) {
            this.ddlLanguage.removeAllItems();
            this.initLanguage();
            currentLangInfo = (LanguageInfo)this.ddlLanguage.getSelectedItem();
        }
        this.ddlDataCenter.removeAllItems();
        for (int i = 0; i < this.aisList.length; ++i) {
            this.ddlDataCenter.addItem((Object)this.aisList[i].getAisName());
        }
        this.ddlDataCenter.setSelectedIndex(index);
    }

    private void changeLang() {
        this.fillDataCenter();
        this.initResources();
        this.initDefaultLocale();
    }

    private void initUserName() {
        if (StringUtils.isEmpty((String)UIConfig.getUserName())) {
            this.txtUserName.requestFocus();
        } else {
            this.txtPassword.requestFocus();
        }
        this.txtUserName.setText(UIConfig.getUserName());
    }

    public static void initData() throws Exception {
        long start = System.currentTimeMillis();
        LoginFrame.initLog4jConfig();
        LoginFrame.initExceptionHandler();
        UIManager.setLookAndFeel(LFCLASSNAME);
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)(" before show Login Frame,init env var : " + cost + " ms!"));
    }

    public static void main(String[] args) {
        try {
            long start = System.currentTimeMillis();
            LoginFrame.initData();
            LoginFrame loginFrame = new LoginFrame();
            loginFrame.show();
            long showCost = System.currentTimeMillis() - start;
            logger.info((Object)("finished showing Login Frame,spent:" + showCost + " ms."));
        }
        catch (Exception exc) {
            ExceptionHandler.handle((Throwable)exc);
        }
    }

    public static void initLog4jConfig() {
        URL url;
        String configItem = "log4j.configuration";
        if (System.getProperty(configItem) == null && (url = LoginFrame.class.getClassLoader().getResource("log4j.properties")) != null) {
            PropertyConfigurator.configure((URL)url);
        }
    }

    public static void initExceptionHandler() {
        String excHandlerKey = "sun.awt.exception.handler";
        String excHandlerValue = ExceptionHandler.class.getName();
        System.setProperty(excHandlerKey, excHandlerValue);
    }

    static /* synthetic */ void access$400(LoginFrame x0) {
        x0.preLogin();
    }

    static /* synthetic */ void access$500(LoginFrame x0) {
        x0.loginMain();
    }

    class LanguageInfo {
        private String locale;
        private String name;

        public LanguageInfo(String locale, String name) {
            this.locale = locale;
            this.name = name;
        }

        public String getLocale() {
            return this.locale;
        }

        public String toString() {
            return this.name;
        }
    }
}

