/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.report.util.KDTableHeaderModel;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.rptclient.gr.rptclient.ReportListUI;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslEditUI;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.util.CommonUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import com.kingdee.util.enum.EnumUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ReportEditUI
extends CslEditUI {
    IUIWindow reportUI = null;
    private boolean isLock = false;
    FilterInfo currentFilter = null;
    protected KDLabelContainer contYear;
    protected KDLabelContainer contPeriodType;
    protected KDComboBox comboPeriodType;
    protected KDLabelContainer contCurrency;
    protected KDComboBox comboYear;
    protected KDComboBox comboCurrency;
    protected KDComboBox comboPeriod;
    protected KDLabel lblYear;
    protected KDLabel lblPeriod;
    protected KDTable tblMain;
    protected KDLabelContainer contRptDate;
    protected KDDatePicker datePickerRptDate;

    public ReportEditUI() throws Exception {
        this.jbInit();
        this.initUIP();
    }

    private void jbInit() throws Exception {
        this.resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        this.setUITitle(this.resHelper.getString("ReportEditUI.title"));
        this.contYear = new KDLabelContainer();
        this.contPeriodType = new KDLabelContainer();
        this.comboPeriodType = new KDComboBox();
        this.contCurrency = new KDLabelContainer();
        this.comboYear = new KDComboBox();
        this.comboCurrency = new KDComboBox();
        this.comboPeriod = new KDComboBox();
        this.lblYear = new KDLabel();
        this.lblPeriod = new KDLabel();
        this.tblMain = new KDTable();
        this.contRptDate = new KDLabelContainer();
        this.datePickerRptDate = new KDDatePicker();
        this.contYear.setName("contYear");
        this.contPeriodType.setName("contPeriodType");
        this.comboPeriodType.setName("comboPeriodType");
        this.contCurrency.setName("contCurrency");
        this.comboYear.setName("comboYear");
        this.comboCurrency.setName("comboCurrency");
        this.comboPeriod.setName("comboPeriod");
        this.lblYear.setName("lblYear");
        this.lblPeriod.setName("lblPeriod");
        this.tblMain.setName("tblMain");
        this.contRptDate.setName("contRptDate");
        this.datePickerRptDate.setName("datePickerRptDate");
        this.contYear.setBoundLabelText(this.resHelper.getString("ReportEditUI.contYear"));
        this.contYear.setBoundLabelLength(80);
        this.contYear.setBoundLabelUnderline(true);
        this.contPeriodType.setBoundLabelText(this.resHelper.getString("ReportEditUI.contPeriodType"));
        this.contPeriodType.setBoundLabelLength(80);
        this.contPeriodType.setBoundLabelUnderline(true);
        this.comboPeriodType.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fi.rpt.RptPeriodTypeEnum").toArray());
        this.comboPeriodType.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                ReportEditUI.this.beforeActionPerformed(e);
                try {
                    ReportEditUI.this.comboPeriodType_actionPerformed(e);
                }
                catch (Exception exc) {
                    ReportEditUI.this.handUIException(exc);
                }
                finally {
                    ReportEditUI.this.afterActionPerformed(e);
                }
            }
        });
        this.contCurrency.setBoundLabelText(this.resHelper.getString("ReportEditUI.contCurrency"));
        this.contCurrency.setBoundLabelLength(60);
        this.contCurrency.setBoundLabelUnderline(true);
        this.lblYear.setText(this.resHelper.getString("ReportEditUI.lblYear"));
        this.lblPeriod.setText(this.resHelper.getString("ReportEditUI.lblPeriod"));
        KDTableHeaderModel tableHeader = this.createHeader();
        KDTableUtil.setHeader((KDTableHeaderModel)tableHeader, (KDTable)this.tblMain);
        String[] keys = new String[]{"id", "templateName", "periodType", "versionNumber"};
        for (int i = 0; i < 4; ++i) {
            this.tblMain.getColumn(i).setKey(keys[i]);
        }
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    ReportEditUI.this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    ReportEditUI.this.handUIException(exc);
                }
            }
        });
        this.tblMain.addKDTDataRequestListener(new KDTDataRequestListener(){

            public void tableDataRequest(KDTDataRequestEvent e) {
                ReportEditUI.this.tblMain_tableDataRequest(e);
            }
        });
        this.contRptDate.setBoundLabelText(this.resHelper.getString("ReportEditUI.contRptDate"));
        this.contRptDate.setBoundLabelUnderline(true);
        this.contRptDate.setBoundLabelLength(60);
        this.datePickerRptDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ReportEditUI.this.datePickerRptDate_dataChanged(e);
                }
                catch (Exception exc) {
                    ReportEditUI.this.handUIException(exc);
                }
            }
        });
    }

    private KDTableHeaderModel createHeader() {
        int size = 4;
        String[][] hd = new String[1][size];
        int[] align = new int[size];
        int[] width = new int[size];
        String[] format = new String[size];
        hd[0][0] = "id";
        align[0] = 0;
        width[0] = 0;
        format[0] = "";
        hd[0][1] = this.resHelper.getString("ReportEditUI.templateName");
        align[1] = 0;
        width[1] = 200;
        format[1] = "";
        hd[0][2] = this.resHelper.getString("ReportEditUI.periodType");
        align[2] = 0;
        width[2] = 100;
        format[2] = "";
        hd[0][3] = this.resHelper.getString("ReportEditUI.versionNumber");
        align[3] = 0;
        width[3] = 100;
        format[3] = "";
        KDTableHeaderModel mm = new KDTableHeaderModel();
        mm.setHiddenColumnIndexices(new int[]{0});
        mm.setData(hd);
        mm.setAlignColumns(align);
        mm.setColumnsFormat(format);
        mm.setColumnWidths(width);
        return mm;
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 470, 306));
        this.setLayout(null);
        this.contYear.setBounds(new Rectangle(10, 32, 140, 19));
        this.add((Component)this.contYear, null);
        this.contPeriodType.setBounds(new Rectangle(10, 10, 217, 19));
        this.add((Component)this.contPeriodType, null);
        this.contCurrency.setBounds(new Rectangle(270, 32, 189, 19));
        this.add((Component)this.contCurrency, null);
        this.comboPeriod.setBounds(new Rectangle(176, 32, 50, 19));
        this.add((Component)this.comboPeriod, null);
        this.lblYear.setBounds(new Rectangle(155, 34, 18, 19));
        this.add((Component)this.lblYear, null);
        this.lblPeriod.setBounds(new Rectangle(232, 34, 21, 19));
        this.add((Component)this.lblPeriod, null);
        this.tblMain.setBounds(new Rectangle(10, 59, 450, 237));
        this.add((Component)this.tblMain, null);
        this.contRptDate.setBounds(new Rectangle(270, 10, 187, 19));
        this.add((Component)this.contRptDate, null);
        this.contYear.setBoundEditor((JComponent)this.comboYear);
        this.contPeriodType.setBoundEditor((JComponent)this.comboPeriodType);
        this.contCurrency.setBoundEditor((JComponent)this.comboCurrency);
        this.contRptDate.setBoundEditor((JComponent)this.datePickerRptDate);
    }

    public void initUIMenuBarLayout() {
        this.menuBar.add((JMenu)this.menuFile);
        this.menuFile.add((JMenuItem)this.menuItemSubmit);
        this.menuFile.add((Component)this.kDSeparator1);
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
    }

    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnSubmit);
    }

    public void setDataObject(IObjectValue dataObject) {
        IObjectValue ov = dataObject;
        super.setDataObject(ov);
        this.editData = (CslReportInfo)ov;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tblMain_tableDataRequest(KDTDataRequestEvent e) {
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, FName, case FPeriodType ");
        sql.append(" when 1 then '").append(RptPeriodTypeEnum.DAILY.getAlias());
        sql.append("' when 2 then '").append(RptPeriodTypeEnum.WEEKLY.getAlias());
        sql.append("' when 3 then '").append(RptPeriodTypeEnum.MONTHLY.getAlias());
        sql.append("' when 4 then '").append(RptPeriodTypeEnum.QUARTERLY.getAlias());
        sql.append("' when 5 then '").append(RptPeriodTypeEnum.SEMIYEARLY.getAlias());
        sql.append("' when 6 then '").append(RptPeriodTypeEnum.YEARLY.getAlias());
        sql.append("' end as FPeriodType, FVersionNumber ");
        sql.append(" from t_eas_template");
        sql.append(" where FVersionStatus = 1 and FPeriodType = ?");
        SqlParams param = new SqlParams();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        param.addInt(periodType.getValue());
        try {
            RptRowSet rst;
            this.setCursorOfWair();
            int from = e.getFirstRow();
            int length = e.getLastRow() - e.getFirstRow() + 1;
            try {
                rst = DbUtil.executeQuery(sql.toString(), param, from, length);
            }
            catch (SQLException ex) {
                throw new SQLDataException(ex);
            }
            if (from == 0) {
                this.tblMain.setRowCount(rst.getVirtualRowCount());
            }
            KDTableUtil.insertRows((Object[][])rst.toArray(), null, (int)from, (KDTable)this.tblMain);
            if (rst.getRowCount() > 0) {
                int countRowIndex = from + rst.getRowCount() - 1;
                rst.moveTo(rst.getRowCount() - 1);
            }
        }
        catch (BOSException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        int year = (Integer)this.comboYear.getSelectedItem();
        short period = (Short)this.comboPeriod.getSelectedItem();
        if (this.comboCurrency.getItemCount() < 1 || this.tblMain.getRowCount() < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)CommonUtil.getResource("noBaseData"));
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        String currencyId = null;
        IRowSet rowSet = DbUtil.executeQuery("select FId from t_eas_currency where FNumber = ?", new Object[]{currency.getNumber()});
        if (rowSet.next()) {
            currencyId = rowSet.getString("FId");
        }
        String templateId = this.getSelectedTemplateID();
        StringBuffer sql = new StringBuffer();
        sql.append("select FId from t_eas_report");
        sql.append(" where FTemplateNumber = ( ");
        sql.append(" select FNumber from t_eas_template where FId = ?)");
        sql.append(" and FCurrencyId = ? and FYear = ? and FPeriod = ?");
        rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{templateId, currencyId, new Integer(year), new Integer(period)});
        if (rowSet.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.resHelper.getString("Report_Has_Created")));
        }
        String reportId = Uuid.create().toString();
        sql = new StringBuffer();
        sql.append("select FId, FNumber, FName, FData, FDescription, ");
        sql.append(" FTemplateType, FDynaRpttype, FVersionNumber ");
        sql.append(" from t_eas_template where fid = ?");
        rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{templateId});
        if (rowSet.next()) {
            sql = new StringBuffer();
            sql.append("insert into t_eas_report");
            sql.append("(FId, FName, FTemplateID, FPeriodType, ");
            sql.append("FYear, FPeriod, FCreatorID,  FCurrencyID, ");
            sql.append("FDescription, FTemplateNumber, FVersionNumber, ");
            sql.append(" FCreateTime, FDynaRpttype, ");
            sql.append("FSourceType, FAuditedStatus, FCheckedStatus) \n");
            sql.append(" values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            sql.append(CslRptUtil.formatDateForSql((Date)new Date())).append(", ");
            int dynaType = rowSet.getInt("FDynaRpttype");
            sql.append(dynaType).append(", ");
            int templateType = rowSet.getInt("FTemplateType");
            if (templateType <= 0) {
                sql.append("'', ");
            } else if (templateType == 10) {
                sql.append(10).append(", ");
            } else {
                sql.append(1).append(", ");
            }
            sql.append(1).append(", ");
            sql.append(1).append(")");
            Object[] param = new Object[]{reportId, rowSet.getString("FName"), templateId, new Integer(periodType.getValue()), new Integer(year), new Integer(period), UIConfig.getUserName(), currencyId, rowSet.getString("FDescription"), rowSet.getString("FNumber"), rowSet.getString("FVersionNumber")};
            DbUtil.execute(sql.toString(), param);
            sql = new StringBuffer();
            sql.append("update t_eas_report set FData = ?");
            sql.append(" where FId = ?");
            DbUtil.execute(sql.toString(), new Object[]{rowSet.getBytes("FData"), reportId});
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        Map context = this.getUIContext();
        ReportListUI ui = (ReportListUI)((Object)context.get("Owner"));
        if (ui != null) {
            ui.actionRefresh_actionPerformed(null);
            this.destroyWindow();
            ui.showEditUI(reportId, "ADDNEW");
        }
    }

    protected String getSelectedTemplateID() {
        Object keyValue;
        int rowIndex;
        IRow row;
        ICell cell;
        boolean tmpSelected = false;
        String selectedKeyValue = null;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && (cell = (row = this.tblMain.getRow(rowIndex = selectBlock.getTop())).getCell("id")) != null && (keyValue = cell.getValue()) != null) {
            selectedKeyValue = keyValue.toString();
            tmpSelected = true;
        }
        if (!tmpSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)CslRptUtil.getString((String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        return selectedKeyValue;
    }

    public String getReportUIName() {
        return GroupRptProcessUI.class.getName();
    }

    protected void comboPeriodType_actionPerformed(ActionEvent e) throws Exception {
        this.comboPeriod.removeAllItems();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (periodType == null) {
            return;
        }
        int type = periodType.getValue();
        ArrayList<Short> items = new ArrayList<Short>();
        int count = 0;
        switch (type) {
            case 1: {
                count = 366;
                break;
            }
            case 3: {
                count = 12;
                break;
            }
            case 4: {
                count = 4;
                break;
            }
            case 5: {
                count = 2;
                break;
            }
            case 6: {
                count = 1;
                break;
            }
            case 2: {
                count = 53;
            }
        }
        for (int i = 1; i <= count; ++i) {
            items.add(new Short((short)i));
        }
        this.comboPeriod.addItems(items.toArray());
        this.refreshTimeInfo(this.datePickerRptDate.getSqlDate());
        this.tblMain.removeRows();
    }

    private void calculatePeriod() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        Integer yearInt = (Integer)this.comboYear.getSelectedItem();
        if (yearInt != null && periodType != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(new Date());
            int year = yearInt;
            int month = calendar.get(2) + 1;
            int date = calendar.get(5);
            int period = RPTDateUtil.getPeriod((int)year, (int)month, (int)date, (RptPeriodTypeEnum)periodType);
            this.comboPeriod.setSelectedItem((Object)new Short((short)period));
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.initUI();
        this.setUITitle(this.getUITitle() + " " + CslRptUtil.getString((String)"AddNew"));
    }

    private void initUI() throws EASBizException, BOSException {
        this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.datePickerRptDate.setValue((Object)new Date());
        this.comboYear.setEnabled(false);
        this.comboPeriod.setEnabled(false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int year = calendar.get(1);
        Integer yearObj = null;
        Integer currentYearObj = null;
        for (int i = year - 1; i <= year + 1; ++i) {
            yearObj = new Integer(i);
            if (i == year) {
                currentYearObj = yearObj;
            }
            this.comboYear.addItem((Object)yearObj);
        }
        this.comboYear.setSelectedItem(currentYearObj);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        CurrencyCollection collection = this.getCurrency();
        if (collection == null || collection.isEmpty()) {
            this.actionSubmit.setEnabled(false);
        } else {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                this.comboCurrency.addItem(iter.next());
            }
        }
        this.tblMain.removeRows();
    }

    private CurrencyCollection getCurrency() throws BOSException {
        CurrencyCollection col = new CurrencyCollection();
        String sql = "select FId, FNumber, FName from t_eas_currency order by FNumber";
        IRowSet rowSet = DbUtil.executeQuery(sql);
        try {
            while (rowSet.next()) {
                CurrencyInfo info = new CurrencyInfo();
                info.setNumber(rowSet.getString("FNumber"));
                info.setName(rowSet.getString("FName"));
                col.add(info);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return col;
    }

    public boolean isModify() {
        return false;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.tblMain.getSelectManager().get() != null) {
            this.actionSubmit_actionPerformed(null);
        }
    }

    public boolean destroyWindow() {
        Object owner;
        if (this.getOprtState().equals("EDIT")) {
            super.releaseObjectLock(this.editData.getId().toString());
        }
        if ((owner = this.getUIContext().get("Owner")) instanceof ListUI) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException(e);
            }
        }
        return super.destroyWindow();
    }

    private void refreshTimeInfo(Date newDate) {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (p == null || newDate == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod((Date)newDate, (RptPeriodTypeEnum)p);
        this.comboYear.removeAllItems();
        this.comboYear.addItem((Object)new Integer(times.get(0).toString()));
        this.comboPeriod.removeAllItems();
        this.comboPeriod.addItem((Object)new Short(times.get(1).toString()));
        this.isLock = true;
        this.datePickerRptDate.setValue(times.get(2));
        this.isLock = false;
    }

    protected void datePickerRptDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isLock) {
            return;
        }
        if (e != null && e.getNewValue() instanceof Date) {
            this.refreshTimeInfo((Date)e.getNewValue());
        }
    }

    protected String getClassAlise() {
        return this.resHelper.getString("ReportEditUI.title");
    }
}

