/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.CheckStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.rptclient.gr.rptclient.AbstractReportSelecterUI;
import com.kingdee.eas.rptclient.gr.rptclient.CompanyCfgUI;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;

public class ReportSelecterUI
extends AbstractReportSelecterUI {
    private static final Logger logger = CoreUIObject.getLogger((Class)ReportSelecterUI.class);
    private static ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.ExportResource");
    private HashMap returnMap = null;
    private boolean isFTPMode = false;
    private KDTable mainTable = new KDTable();

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDTable1.setVisible(false);
        this.remove((Component)this.kDTable1);
        this.isFTPMode = this.getUIContext().get("FTPMode") != null;
        this.returnMap = (HashMap)this.getUIContext().get("returnMap");
        if (this.isFTPMode) {
            this.path.setVisible(false);
            this.txtpath.setVisible(false);
            this.btnChooser.setVisible(false);
        } else {
            this.path.setVisible(true);
            this.txtpath.setVisible(true);
            this.btnChooser.setVisible(true);
        }
        this.refreshDate();
    }

    private void initTable() {
        this.mainTable.setName("mainTable");
        this.mainTable.setVisible(true);
        this.mainTable.setBounds(new Rectangle(11, 123, 758, 288));
        this.add((Component)this.mainTable, null);
        this.mainTable.removeHeadRows();
        this.mainTable.removeColumns();
        this.mainTable.addColumns(4);
        this.mainTable.getColumn(0).setWidth(80);
        this.mainTable.getColumn(1).setWidth(320);
        this.mainTable.getColumn(2).setWidth(170);
        this.mainTable.getColumn(3).setWidth(160);
        IRow row = this.mainTable.addHeadRow();
        row.getCell(0).setValue((Object)resHelper.getString("select"));
        row.getCell(1).setValue((Object)resHelper.getString("reportName"));
        row.getCell(2).setValue((Object)resHelper.getString("currencyType"));
        row.getCell(3).setValue((Object)resHelper.getString("reportType"));
        for (int i = 1; i < 4; ++i) {
            this.mainTable.getColumn(i).getStyleAttributes().setLocked(true);
        }
        this.mainTable.getColumn(0).setEditor((ICellEditor)new EditorFactory.BooleanEditor());
    }

    public String getTitle() {
        return resHelper.getString("reportSelect");
    }

    public ReportSelecterUI() throws Exception {
        this.kDTable1.setVisible(false);
        this.txtpath.setEditable(false);
        this.txtNowYear.setEditable(false);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        DefaultComboBoxModel mode = new DefaultComboBoxModel();
        Iterator it = RptPeriodTypeEnum.iterator();
        while (it.hasNext()) {
            mode.addElement(it.next());
        }
        this.cbxPeriod.setModel(mode);
        this.cbxPeriod.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.cbxPeriod.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                ReportSelecterUI.this.refreshDate();
            }
        });
        this.kdpDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ReportSelecterUI.this.refreshDate();
            }
        });
        this.btnSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ReportSelecterUI.this.setTableLineSelectFlag(true);
            }
        });
        this.btnClearAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ReportSelecterUI.this.setTableLineSelectFlag(false);
            }
        });
        this.btnChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ReportSelecterUI.this.txtpath.setText(ReportSelecterUI.this.getPath((Object)ReportSelecterUI.this));
            }
        });
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (!ReportSelecterUI.this.checkCompanyNumber()) {
                    return;
                }
                if (!ReportSelecterUI.this.checkSelectReport()) {
                    return;
                }
                if (!ReportSelecterUI.this.isFTPMode && !ReportSelecterUI.this.checkChooserPath()) {
                    return;
                }
                ReportSelecterUI.this.returnMap.put("OK", "OK");
                ReportSelecterUI.this.returnMap.put("RPTS", ReportSelecterUI.this.getSelectReports());
                if (!ReportSelecterUI.this.isFTPMode) {
                    ReportSelecterUI.this.returnMap.put("PATH", ReportSelecterUI.this.txtpath.getText());
                } else {
                    ReportSelecterUI.this.returnMap.put("PATH", ReportSelecterUI.this.getFtpPath());
                }
                ReportSelecterUI.this.disposeUIWindow();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ReportSelecterUI.this.returnMap.put("OK", null);
                ReportSelecterUI.this.disposeUIWindow();
            }
        });
        this.initTable();
    }

    private boolean checkCompanyNumber() {
        String curCompanyNumber = CompanyCfgUI.getCompany()[0];
        if (StringUtils.isEmpty((String)curCompanyNumber)) {
            MsgBox.showInfo((String)resHelper.getString("setCurrencyCompany"));
            return false;
        }
        return true;
    }

    private String getFtpPath() {
        String curPath = System.getProperty("user.home");
        String curCompanyNumber = CompanyCfgUI.getCompany()[0];
        StringBuffer buf = new StringBuffer();
        buf.append(curPath);
        buf.append("\\");
        buf.append(curCompanyNumber);
        buf.append("_");
        buf.append(DateFormat.getDateInstance(2, Locale.CHINA).format(this.kdpDate.getSqlDate()));
        buf.append("_");
        buf.append(((RptPeriodTypeEnum)this.cbxPeriod.getSelectedItem()).getName());
        return buf.toString();
    }

    private boolean checkSelectReport() {
        for (int i = 0; i < this.mainTable.getRowCount(); ++i) {
            if (!((Boolean)this.mainTable.getRow(i).getCell(0).getValue()).booleanValue()) continue;
            return true;
        }
        MsgBox.showInfo((Component)((Object)this), (String)resHelper.getString("mustSelectReport"));
        return false;
    }

    private boolean checkChooserPath() {
        if (this.txtpath.getText() == null || this.txtpath.getText().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)resHelper.getString("mustChoosePath"));
            return false;
        }
        return true;
    }

    private String getPath(Object owner) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(resHelper.getString("commitReport"));
        int returnVal = chooser.showSaveDialog((Component)owner);
        if (returnVal == 0) {
            File selectFile = chooser.getSelectedFile();
            if (!selectFile.exists()) {
                MsgBox.showError((Component)((Object)this), (String)"\u5df2\u9009\u62e9\u7684\u6587\u4ef6\u5939\u4e0d\u5b58\u5728");
                return null;
            }
            String path = selectFile.getAbsolutePath();
            String curCompanyNumber = CompanyCfgUI.getCompany()[0];
            StringBuffer buf = new StringBuffer();
            buf.append(path);
            buf.append("\\");
            buf.append(curCompanyNumber);
            buf.append("_");
            buf.append(DateFormat.getDateInstance(2, Locale.CHINA).format(this.kdpDate.getSqlDate()));
            buf.append("_");
            buf.append(((RptPeriodTypeEnum)this.cbxPeriod.getSelectedItem()).getName());
            return buf.toString();
        }
        return null;
    }

    private void refreshDate() {
        Object type = this.cbxPeriod.getSelectedItem();
        List times = RPTDateUtil.getRptPeriod((Date)this.kdpDate.getSqlDate(), (RptPeriodTypeEnum)((RptPeriodTypeEnum)type));
        this.txtNowYear.setText(times.get(0).toString());
        this.txtNowPeriod.setText(times.get(1).toString());
        this.kdpDate.setValue(times.get(2));
        this.updateTable();
        String path = this.txtpath.getText();
        if (!StringUtils.isEmpty((String)path)) {
            StringBuffer filePath = new StringBuffer();
            path = path.substring(0, path.lastIndexOf("\\"));
            filePath.append(path);
            filePath.append("\\");
            filePath.append(UIConfig.getCurCompanyNumber());
            filePath.append("_");
            filePath.append(DateFormat.getDateInstance(2, Locale.CHINA).format(this.kdpDate.getSqlDate()));
            filePath.append("_");
            filePath.append(((RptPeriodTypeEnum)this.cbxPeriod.getSelectedItem()).getName());
            this.txtpath.setText(filePath.toString());
        }
    }

    private void updateTable() {
        this.mainTable.removeRows();
        if (this.txtNowYear.getText() != null && this.txtNowPeriod.getText() != null) {
            int year = Integer.parseInt(this.txtNowYear.getText());
            int period = Integer.parseInt(this.txtNowPeriod.getText());
            int PeriodType = ((RptPeriodTypeEnum)this.cbxPeriod.getSelectedItem()).getValue();
            try {
                this.loadReports(PeriodType, year, period);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setTableLineSelectFlag(boolean flag) {
        for (int i = 0; i < this.mainTable.getRowCount(); ++i) {
            this.mainTable.getRow(i).getCell(0).setValue((Object)new Boolean(flag));
        }
    }

    private CslReportCollection getSelectReports() {
        CslReportCollection reports = new CslReportCollection();
        for (int i = 0; i < this.mainTable.getRowCount(); ++i) {
            if (!((Boolean)this.mainTable.getRow(i).getCell(0).getValue()).booleanValue()) continue;
            reports.add((CslReportInfo)this.mainTable.getRow(i).getUserObject());
        }
        return reports;
    }

    private void loadReports(int PeriodType, int Year, int Period) throws Exception, SQLException {
        this.mainTable.removeRows();
        Object[] params = new Integer[]{new Integer(PeriodType), new Integer(Year), new Integer(Period)};
        CslReportCollection reports = new CslReportCollection();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append("report.FID  ,\n");
        sql.append("report.FName  ,\n");
        sql.append("report.FCheckedStatus  ,\n");
        sql.append("report.FSourceType  ,\n");
        sql.append("report.FDescription  ,\n");
        sql.append("report.FData  ,\n");
        sql.append("report.FTemplateID  ,\n");
        sql.append("report.FPeriodType  ,\n");
        sql.append("report.FYear  ,\n");
        sql.append("report.FPeriod  ,\n");
        sql.append("report.FCreatorID  ,\n");
        sql.append("report.FCreateTime  ,\n");
        sql.append(" report.FLastUpdateUserID  ,\n");
        sql.append("report.FLastUpdateTime ,\n");
        sql.append(" report.FAuditorID  ,\n");
        sql.append("report.FCurrencyID  ,\n");
        sql.append(" report.FAuditedTime , \n");
        sql.append(" currency.Fname as FcurrencyName  \n");
        sql.append(" FROM T_EAS_Report report left outer join T_EAS_Currency currency on report.FCurrencyID=currency.FID \n");
        sql.append(" WHERE  report.FAuditedStatus=2  AND report.FPeriodType=? AND report.FYear=? AND report.FPeriod=?");
        IRowSet rowSet = DbUtil.executeQuery(sql.toString(), params);
        while (rowSet.next()) {
            CslReportInfo report = new CslReportInfo();
            report.put("RPT-ID", (Object)rowSet.getObject("FID").toString());
            report.setName(rowSet.getObject("FName") != null ? rowSet.getObject("FName").toString() : "");
            report.setDescription(rowSet.getObject("FDescription") != null ? rowSet.getObject("FDescription").toString() : "");
            report.setData(rowSet.getBytes("FData"));
            report.setCheckedStatus(CheckStatusEnum.getEnum((int)rowSet.getInt("FCheckedStatus")));
            report.setSourceType(RptSrcTypeEnum.getEnum((int)rowSet.getInt("FSourceType")));
            TemplateInfo temp = new TemplateInfo();
            temp.setId(rowSet.getObject("FTemplateID") != null ? BOSUuid.read((String)rowSet.getObject("FTemplateID").toString()) : null);
            report.setTemplate(temp);
            report.setPeriodType(rowSet.getObject("FPeriodType") != null ? RptPeriodTypeEnum.getEnum((int)rowSet.getInt("FPeriodType")) : null);
            report.setYear(rowSet.getInt("FYear"));
            report.setPeriod(rowSet.getShort("FPeriod"));
            CurrencyInfo currency = new CurrencyInfo();
            currency.setName(rowSet.getObject("FcurrencyName") != null ? rowSet.getObject("FcurrencyName").toString() : "");
            currency.setId(rowSet.getObject("FCurrencyId") != null ? BOSUuid.read((String)rowSet.getObject("FCurrencyId").toString()) : null);
            report.setCurrency(currency);
            UserInfo creator = new UserInfo();
            creator.setName(UIConfig.getUserName());
            report.setCreator(creator);
            UserInfo auditor = new UserInfo();
            auditor.setName(UIConfig.getUserName());
            report.setAuditor(auditor);
            UserInfo lastUpdateUser = new UserInfo();
            lastUpdateUser.setName(UIConfig.getUserName());
            report.setLastUpdateUser(lastUpdateUser);
            report.setCreateTime(rowSet.getTimestamp("FCreateTime"));
            report.setLastUpdateTime(rowSet.getTimestamp("FLastUpdateTime"));
            report.setAuditTime(rowSet.getTimestamp("FAuditedTime"));
            reports.add(report);
        }
        for (int i = 0; i < reports.size(); ++i) {
            IRow row = this.mainTable.addRow();
            CslReportInfo info = reports.get(i);
            row.setUserObject((Object)info);
            row.getCell(1).setValue((Object)info.getName());
            row.getCell(2).setValue((Object)info.getCurrency().getName());
            row.getCell(3).setValue((Object)info.getSourceType());
        }
        this.setTableLineSelectFlag(true);
    }
}

