/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.eas.fi.rpt.Key;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import java.util.ArrayList;
import java.util.List;

public class BookProperties {
    private List calculateQueue = null;
    private RptOperationSchemaComp operationSchema = null;
    private ReportCalculateErrorProvider errorProvider = null;
    private ReportVariables variables = null;

    public static BookProperties loadFromSpread(Book book) {
        BookProperties m = new BookProperties();
        m.calculateQueue = (List)book.getUserObjectValue("multiCalculateQueue");
        m.errorProvider = (ReportCalculateErrorProvider)book.getUserObjectValue("ERRORHANDLER");
        m.variables = (ReportVariables)book.getUserObjectValue("VARIABLES");
        m.operationSchema = (RptOperationSchemaComp)book.getUserObjectValue("operationSchemas");
        m.initProperties();
        m.restoreToSpread(book);
        return m;
    }

    private void initProperties() {
        if (this.calculateQueue == null) {
            this.calculateQueue = new ArrayList();
        }
        if (this.errorProvider == null) {
            this.errorProvider = new ReportCalculateErrorProvider();
        }
        if (this.variables == null) {
            this.variables = new ReportVariables();
        }
        if (this.operationSchema == null) {
            this.operationSchema = new RptOperationSchemaComp();
        }
    }

    public void restoreToSpread(Book book) {
        if (this.calculateQueue != null) {
            book.setUserObject("multiCalculateQueue", (Object)this.calculateQueue);
        }
        if (this.operationSchema != null) {
            book.setUserObject("operationSchemas", (Object)this.operationSchema);
        }
        if (this.errorProvider != null) {
            book.setUserObject("ERRORHANDLER", (Object)this.errorProvider);
        }
        if (this.variables != null) {
            book.setUserObject("VARIABLES", (Object)this.variables);
        }
    }

    public static BookProperties loadFromKDF(KDF kdf) {
        KDFUserObjects m = new KDFUserObjects();
        m.reportKeys = (List)kdf.getUserObject("reportKeys");
        m.queue = (List)kdf.getUserObject("multiCalculateQueue");
        m.operationSchema = (RptOperationSchemaComp)kdf.getUserObject("operationSchemas");
        if (m.operationSchema != null) {
            m.operationSchema.init();
        }
        m.zeroReplacer = (String)kdf.getUserObject("ZEROREPLACER");
        m.errorProvider = RptUtil.getErrorhandlerFromKDF((KDF)kdf);
        BookProperties bp = new BookProperties();
        bp.calculateQueue = m.queue;
        bp.operationSchema = m.operationSchema;
        m.errorProvider = bp.errorProvider;
        return bp;
    }

    public static ReportVariables loadVariables(Book book) {
        return (ReportVariables)book.getUserObjectValue("VARIABLES");
    }

    public List getCalculateQueue() {
        return this.calculateQueue;
    }

    public void setCalculateQueue(List calculateQueue) {
        this.calculateQueue = calculateQueue;
    }

    public ReportCalculateErrorProvider getErrorProvider() {
        return this.errorProvider;
    }

    public void setErrorProvider(ReportCalculateErrorProvider errorProvider) {
        this.errorProvider = errorProvider;
    }

    public RptOperationSchemaComp getOperationSchema() {
        if (this.operationSchema == null) {
            this.operationSchema = new RptOperationSchemaComp();
        }
        return this.operationSchema;
    }

    public void setOperationSchema(RptOperationSchemaComp operationSchema) {
        this.operationSchema = operationSchema;
    }

    public ReportVariables getVariables() {
        if (this.variables == null) {
            this.variables = new ReportVariables();
        }
        return this.variables;
    }

    public void setVariables(ReportVariables variables) {
        this.variables = variables;
    }

    public static boolean isShowSumRange(Book book) {
        Boolean bool = (Boolean)book.getUserObjectValue("SHOW_SUMRANGE");
        return bool != null && bool != false;
    }

    public static void setShowSumRange(Book book, boolean b) {
        book.setUserObject("SHOW_SUMRANGE", (Object)b);
    }

    public void notifyRenameSheet(String oldname, String newname) {
        if (this.operationSchema != null) {
            this.operationSchema.notifyRenameSheet(oldname, newname);
        }
        if (this.variables != null) {
            this.variables.onRenameSheet(oldname, newname);
        }
    }

    public void notifyDeleteSheet(String name) {
        if (this.operationSchema != null) {
            this.operationSchema.notifyDeleteSheet(name);
        }
        if (this.variables != null) {
            this.variables.onDeleteSheet(name);
        }
    }

    private static class KDFUserObjects {
        private List reportKeys;
        private List queue;
        private RptOperationSchemaComp operationSchema;
        private String zeroReplacer;
        private ReportCalculateErrorProvider errorProvider = null;

        private KDFUserObjects() {
        }

        private void keysToVariables(ReportVariables v) {
            if (this.reportKeys != null) {
                for (int i = 0; i < this.reportKeys.size(); ++i) {
                    Key key = (Key)this.reportKeys.get(i);
                }
            }
        }
    }
}

