/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.formulawizard;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaWizardUI;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaComp;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaDataType;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaEnumEntry;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaEnumType;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaParameter;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaRelaxType;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class ParamInductor {
    private FormulaWizardUI wizard;
    private JComponent controller;
    private JComponent baseComponent;
    private int typeID = 0;
    private RptFormulaDataType dataType;
    private String committingString = null;
    private static final int TYPE_BIZPROMPT = 0x10000000;
    private static final int TYPE_CONTEXTPROMPT = 0x20000000;
    protected static final int TYPE_ANY = 4352;
    private static final int TYPE_ENUM = 0x30000000;
    private static final int TYPE_DATE = 0x40000000;
    private static final int TYPE_NUMBER = 0x50000000;
    private static final int TYPE_STRING = 0x60000000;
    private static final int TYPE_DATETIME = 0x70000000;
    private static final int TYPE_AMOUNT = Integer.MIN_VALUE;
    private static final int TYPE_COMMON = -1879048192;
    private static final int TYPE_MAX = -65536;
    private static final int SUB_STRING = 4096;
    private static final int SUB_DATE = 8192;
    private static final int SUB_BOOLEAN = 12288;
    private static final int SUB_NUMBER = 16384;
    private static final int SUB_DATETIME = 20480;
    private static final int SUB_AMOUNT = 24576;
    private static final int SUB_COMMON = 28672;
    private static final int SUB_NULL = 0;
    private static final int SUB_MAX = 65535;
    private static final int TYPE_INIT = 0;
    private static final String CALLBACKHINT = "setFormulaWizardUI";

    public static ParamInductor createInductor(RptFormulaDataType type, JComponent base, FormulaWizardUI wizard) {
        return new ParamInductor(type, base, wizard);
    }

    private ParamInductor(RptFormulaDataType type, JComponent base, FormulaWizardUI wizard) {
        this.baseComponent = base;
        this.dataType = type;
        this.wizard = wizard;
        String initValue = null;
        if (this.baseComponent instanceof KDTextField) {
            initValue = ((KDTextField)this.baseComponent).getText();
        }
        if (this.getController(type, initValue) != null) {
            this.getTrueController().addFocusListener(new ControllerListener());
            this.controller.setName(base.getName());
        }
    }

    public JComponent getController(RptFormulaDataType type, String initValue) {
        this.controller = null;
        if (type instanceof RptFormulaEnumType) {
            RptFormulaEnumType et = (RptFormulaEnumType)type;
            KDComboBox cb = new KDComboBox();
            cb.setEditable(true);
            RptFormulaEnumEntry hot = null;
            if (StringUtils.isEmpty((String)initValue)) {
                hot = (RptFormulaEnumEntry)((Vector)et.getEntrys()).get(et.getDefaultIndex());
            }
            Iterator es = et.getEntrys().iterator();
            while (es.hasNext()) {
                RptFormulaEnumEntry e = (RptFormulaEnumEntry)es.next();
                if (e == null) continue;
                if (hot == null && e.getName().equalsIgnoreCase(initValue)) {
                    hot = e;
                }
                cb.addItem((Object)e.getLocalName());
            }
            if (hot != null) {
                cb.setSelectedItem((Object)hot.getLocalName());
            }
            this.typeID = 0x30000000;
            this.controller = cb;
        } else if (type instanceof RptFormulaRelaxType) {
            RptFormulaRelaxType rt = (RptFormulaRelaxType)type;
            this.typeID = this.getMainType(rt);
            switch (this.typeID) {
                case 0x40000000: {
                    KDSpinner sp = new KDSpinner();
                    this.setSpinRange((JSpinner)sp, rt.getMaxValue(), rt.getMinValue());
                    Number v = ParamInductor.getNumber(initValue);
                    if (v != null) {
                        sp.setValue((Object)v);
                    }
                    this.controller = sp;
                    break;
                }
                case 0x70000000: {
                    KDDatePicker dp = new KDDatePicker();
                    dp.getDatePickerDownList().setNullValueEnabled(true);
                    Timestamp d = ParamInductor.getDateTime(initValue);
                    if (d != null) {
                        dp.setValue((Object)d);
                    }
                    this.controller = dp;
                    break;
                }
                case 0x10000000: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
                }
                case 0x20000000: {
                    KDPromptBox box = new KDPromptBox();
                    box.setText(initValue);
                    this.controller = box;
                    break;
                }
                case 0x50000000: {
                    KDFormattedTextField fldn = new KDFormattedTextField(7);
                    fldn.setDataVerifierType(12);
                    fldn.setText(initValue);
                    this.controller = fldn;
                    break;
                }
                case -2147483648: {
                    KDFormattedTextField flda = new KDFormattedTextField(1);
                    flda.setDataVerifierType(12);
                    flda.setText(initValue);
                    this.controller = flda;
                    break;
                }
                case 4352: {
                    KDTextField fda = new KDTextField();
                    fda.setText(initValue);
                    this.controller = fda;
                    fda.addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                        }

                        public void focusLost(FocusEvent e) {
                            KDTextField src = (KDTextField)e.getSource();
                            String txt = src.getText();
                            src.setText(ParamInductor.formatAnytype(txt));
                        }
                    });
                    break;
                }
                default: {
                    KDTextField fd = new KDTextField();
                    fd.setText(initValue);
                    this.controller = fd;
                    break;
                }
            }
        } else {
            this.typeID = 0x60000000;
            KDTextField fd = new KDTextField();
            fd.setText(initValue);
            this.controller = fd;
        }
        if (type != null) {
            this.typeID |= this.getSubType(type.getOriginType());
        }
        this.controller.setName(this.baseComponent.getName());
        return this.controller;
    }

    protected static String formatAnytype(String txt) {
        boolean isString = false;
        if (txt != null && txt.length() > 0) {
            if (txt.length() > 0 && txt.charAt(0) == '\"') {
                isString = true;
                txt = txt.substring(1);
            }
            if (txt.length() > 0 && txt.charAt(txt.length() - 1) == '\"') {
                isString = true;
                txt = txt.substring(0, txt.length() - 1);
            }
            if (isString) {
                txt = "\"" + txt + "\"";
                return txt;
            }
            if (TableToolkit.isCellRef((String)txt)) {
                return txt;
            }
            if (Pattern.compile("\\d*\\.?\\d*").matcher(txt).matches()) {
                return txt;
            }
            try {
                if (TableToolkit.isValidStmt((String)txt)) {
                    return txt;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            txt = "\"" + txt + "\"";
            return txt;
        }
        return txt;
    }

    private static Timestamp getDateTime(String text) {
        Timestamp res = null;
        try {
            if (text != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyy-MM-dd");
                long t = sdf.parse(text).getTime();
                res = new Timestamp(t);
            }
        }
        catch (Exception e) {
            res = null;
        }
        return res;
    }

    private static Number getNumber(String text) {
        Integer res = null;
        try {
            if (text != null) {
                res = Integer.valueOf(text);
            }
        }
        catch (Exception e) {
            res = null;
        }
        return res;
    }

    private void setSpinRange(JSpinner sp, String maxVal, String minVal) {
        Integer n;
        if (sp == null) {
            return;
        }
        SpinnerModel sm = sp.getModel();
        if (!(sm instanceof SpinnerNumberModel)) {
            return;
        }
        SpinnerNumberModel nm = (SpinnerNumberModel)sm;
        if (maxVal != null) {
            try {
                n = Integer.valueOf(maxVal);
                nm.setMaximum(n);
                if (n < 0) {
                    nm.setValue(n);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (minVal != null) {
            try {
                n = Integer.valueOf(minVal);
                nm.setMinimum(n);
                if (n > 0) {
                    nm.setValue(n);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private int getMainType(RptFormulaRelaxType type) {
        boolean isCustomBiz;
        if (type.getProperty("context_item") != null) {
            return 0x20000000;
        }
        boolean isCommonBiz = type.getProperty("selector") != null;
        isCommonBiz = isCommonBiz || type.getProperty("query") != null && type.getProperty("display_fm") != null;
        boolean bl = isCustomBiz = type.getProperty("prompt_hint") != null;
        if (isCommonBiz || isCustomBiz) {
            return 0x10000000;
        }
        String name = type.getOriginType();
        if (name == null) {
            return 0x60000000;
        }
        if ("string".equalsIgnoreCase(name)) {
            return 0x60000000;
        }
        if ("date".equalsIgnoreCase(name)) {
            return 0x40000000;
        }
        if ("datetime".equalsIgnoreCase(name)) {
            return 0x70000000;
        }
        if ("integer".equalsIgnoreCase(name)) {
            return 0x50000000;
        }
        if ("amount".equalsIgnoreCase(name)) {
            return Integer.MIN_VALUE;
        }
        if ("common".equalsIgnoreCase(name)) {
            return -1879048192;
        }
        if ("anytype".equalsIgnoreCase(name)) {
            return 4352;
        }
        return 0x60000000;
    }

    private int getSubType(String originType) {
        if (originType == null) {
            int sub = this.typeID & 0xFFFF;
            return sub == 0 ? 4096 : sub;
        }
        if ("string".equalsIgnoreCase(originType)) {
            return 4096;
        }
        if ("date".equalsIgnoreCase(originType)) {
            return 8192;
        }
        if ("datetime".equalsIgnoreCase(originType)) {
            return 4096;
        }
        if ("boolean".equalsIgnoreCase(originType)) {
            return 12288;
        }
        if ("integer".equalsIgnoreCase(originType)) {
            return 16384;
        }
        if ("amount".equalsIgnoreCase(originType)) {
            return 24576;
        }
        if ("common".equalsIgnoreCase(originType)) {
            return 28672;
        }
        return 4096;
    }

    public void setBounds(Rectangle bounds) {
        if (this.controller == null) {
            return;
        }
        this.controller.setBounds(bounds);
    }

    public JComponent getController() {
        return this.controller;
    }

    public void setController(JComponent componet) {
        this.controller = componet;
    }

    public JComponent getTrueController() {
        Object res = null;
        if (this.controller instanceof JSpinner) {
            JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)((JSpinner)this.controller).getEditor();
            res = editor.getTextField();
        } else {
            res = this.controller instanceof KDPromptBox ? ((KDPromptBox)this.controller).getEditor() : (this.controller instanceof KDComboBox ? (JComponent)((KDComboBox)this.controller).getEditor().getEditorComponent() : (this.controller instanceof KDDatePicker ? ((KDDatePicker)this.controller).getEditor() : this.controller));
        }
        return res;
    }

    public void show() {
        if (this.controller == null) {
            return;
        }
        this.controller.setVisible(true);
    }

    public void hide() {
    }

    public String getText() {
        String res = null;
        switch (this.typeID & 0xFFFF0000) {
            case 0x30000000: {
                KDComboBox cb = (KDComboBox)this.controller;
                res = (String)cb.getEditor().getItem();
                res = ((RptFormulaEnumType)this.dataType).getEntryRawName(res);
                break;
            }
            case 0x60000000: {
                KDTextField fd = (KDTextField)this.controller;
                res = fd.getText();
                break;
            }
            case 0x40000000: {
                KDSpinner sp = (KDSpinner)this.controller;
                JSpinner.DefaultEditor ed = (JSpinner.DefaultEditor)sp.getEditor();
                res = ed.getTextField().getText().toString();
                break;
            }
            case 0x70000000: {
                KDDatePicker dp = (KDDatePicker)this.controller;
                res = dp.getText();
                break;
            }
            case 0x10000000: 
            case 0x20000000: {
                KDPromptBox pb = (KDPromptBox)this.controller;
                res = pb.getText();
                if (!StringUtils.isEmpty((String)res) || this.committingString == null) break;
                res = this.committingString;
                pb.setData((Object)this.committingString);
                break;
            }
            case -2147483648: 
            case 0x50000000: {
                KDFormattedTextField fm = (KDFormattedTextField)this.controller;
                res = fm.getText();
                break;
            }
            default: {
                if (!(this.controller instanceof JTextField)) break;
                res = ((JTextField)this.controller).getText();
            }
        }
        return res;
    }

    public boolean isString() {
        if (this.typeID == 0) {
            // empty if block
        }
        return this.typeID == 0x60000000 || (this.typeID & 0xFFFF) == 4096;
    }

    public void setWizard(FormulaWizardUI wizardUI) {
        this.wizard = wizardUI;
    }

    public static boolean isString(RptFormulaDataType type) {
        if (type == null) {
            return true;
        }
        return "string".equalsIgnoreCase(type.getOriginType()) || "datetime".equalsIgnoreCase(type.getOriginType());
    }

    public static boolean canHaveCellRef(RptFormulaParameter param) {
        if (param == null) {
            return false;
        }
        if (param.getValueType() == 0) {
            RptFormulaDataType dt = RptFormulaComp.getInstance().getDataType(param.getType());
            if (dt != null && "common".equalsIgnoreCase(dt.getOriginType())) {
                param.setValueType(1);
            } else {
                param.setValueType(-1);
            }
        }
        return param.getValueType() > 0;
    }

    public JComponent getBaseComponent() {
        return this.baseComponent;
    }

    public static void setControllerValue(JComponent comp, Object initValue) {
        if (comp instanceof KDSpinner) {
            ((KDSpinner)comp).setValue((Object)ParamInductor.getNumber((String)initValue));
        } else if (comp instanceof KDDatePicker) {
            Timestamp d = ParamInductor.getDateTime((String)initValue);
            ((KDDatePicker)comp).setValue((Object)d);
        } else if (comp instanceof KDPromptBox) {
            ((KDPromptBox)comp).setText((String)initValue);
        } else if (comp instanceof KDSpinner) {
            ((KDFormattedTextField)comp).setText((String)initValue);
        } else if (comp instanceof KDTextField) {
            ((KDTextField)comp).setText((String)initValue);
        }
    }

    class ControllerListener
    implements FocusListener {
        ControllerListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (e.isTemporary()) {
                return;
            }
            ParamInductor.this.baseComponent.setNextFocusableComponent(null);
            ParamInductor.this.baseComponent.setVisible(true);
            if (ParamInductor.this.baseComponent instanceof KDTextField) {
                KDTextField bc = (KDTextField)ParamInductor.this.baseComponent;
                bc.setText(ParamInductor.this.getText());
                bc.setDirty(true);
            }
            ParamInductor.this.controller.setVisible(false);
        }
    }
}

