/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.nlm.FaContractCatFactory;
import com.kingdee.eas.fi.nlm.FaContractCatInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.client.AbstractFaAmortizedCostListRptConditionUI;
import com.kingdee.eas.fi.nlm.client.FaContractCatFilterUI;
import com.kingdee.eas.fi.nlm.client.dialog.FaContractCatPromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaAmortizedCostListRptConditionUI
extends AbstractFaAmortizedCostListRptConditionUI {
    private static final long serialVersionUID = 1772412611508391836L;
    private static final Logger logger = CoreUIObject.getLogger(FaAmortizedCostListRptConditionUI.class);
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.rpt.FaRptResource";
    private CompanyOrgUnitInfo currCompany;
    private CurrencyInfo defaultCurrency;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws EASBizException, BOSException {
        this.pmtCompany.setValue((Object)this.getCurrentCompany());
        this.dpBeginFrom.setValue(null);
        this.dpBeginTo.setValue(null);
        this.dpEndFrom.setValue(null);
        this.dpEndTo.setValue(null);
        this.pmtLeaseInNumFrom.setValue(null);
        this.pmtLeaseInNumTo.setValue(null);
        this.pmtContractType.setValue(null);
        this.pmtCostCenter.setValue(null);
        this.pmtUseDepartment.setValue(null);
        this.pmtCurrency.setValue((Object)this.getDefaultCurrencyInfo());
        this.rbBtnExpiredStatusAll.setSelected(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCurrentCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)2));
        view.setFilter(filter);
        this.pmtLeaseInNumFrom.setEntityViewInfo(view);
        this.pmtLeaseInNumTo.setEntityViewInfo(view);
        FaContractCatPromptBox faContractCatPromptBox = new FaContractCatPromptBox((CoreUIObject)this);
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCurrentCompany().getId().toString()));
        view.setFilter(filter);
        this.pmtContractType.setSelector((KDPromptSelector)faContractCatPromptBox);
        this.pmtContractType.setEntityViewInfo(view);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected CompanyOrgUnitInfo getCurrentCompany() throws BOSException, EASBizException {
        if (this.currCompany == null) {
            String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            this.currCompany = this.getCompanyById(companyID);
        }
        return this.currCompany;
    }

    protected CompanyOrgUnitInfo getCompanyById(String companyID) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("basecurrency.id"));
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
    }

    private CurrencyInfo getDefaultCurrencyInfo() throws BOSException, EASBizException {
        if (this.defaultCurrency == null) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            FilterInfo filter = new FilterInfo();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCurrentCompany().getBaseCurrency().getId().toString()));
            view.setFilter(filter);
            view.setSelector(sic);
            CurrencyCollection col = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
            if (col.size() > 0) {
                return col.get(0);
            }
            return null;
        }
        return this.defaultCurrency;
    }

    public FilterInfo getFilterInfo() {
        this.setCustomerParams(this.getCustParams());
        return super.getFilterInfo();
    }

    public boolean verify() {
        Date beginFrom = (Date)this.dpBeginFrom.getValue();
        Date beginTo = (Date)this.dpBeginTo.getValue();
        Date endFrom = (Date)this.dpEndFrom.getValue();
        Date endTo = (Date)this.dpEndTo.getValue();
        if (beginFrom != null && beginTo != null && beginFrom.compareTo(beginTo) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"startFromDateGreaterThanStartToDate"));
            return false;
        }
        if (beginTo != null && endFrom != null && beginTo.compareTo(endFrom) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"startToDateGreaterThanEndFromDate"));
            return false;
        }
        if (endFrom != null && endTo != null && endFrom.compareTo(endTo) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"endFromDateGreaterThanEndToDate"));
            return false;
        }
        if (beginFrom != null && endFrom != null && beginFrom.compareTo(endFrom) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"startFromDateGreaterThanEndFromDate"));
            return false;
        }
        if (beginFrom != null && endTo != null && beginFrom.compareTo(endTo) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"startFromDateGreaterThanEndToDate"));
            return false;
        }
        if (beginTo != null && endTo != null && beginTo.compareTo(endTo) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"startToDateGreaterThanEndToDate"));
            return false;
        }
        if (this.pmtCurrency.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"currencyIsNull"));
            return false;
        }
        return super.verify();
    }

    protected CustomerParams getCustParams() {
        CustomerParams customCond = new CustomerParams();
        Date dateBeginFrom = (Date)this.dpBeginFrom.getValue();
        Date dateBeginTo = (Date)this.dpBeginTo.getValue();
        Date dateEndFrom = (Date)this.dpEndFrom.getValue();
        Date dateEndTo = (Date)this.dpEndTo.getValue();
        FaLeaseInBillNewInfo billInfoFrom = (FaLeaseInBillNewInfo)this.pmtLeaseInNumFrom.getData();
        FaLeaseInBillNewInfo billInfoTo = (FaLeaseInBillNewInfo)this.pmtLeaseInNumTo.getData();
        FaContractCatInfo catInfo = (FaContractCatInfo)this.pmtContractType.getData();
        CostCenterOrgUnitInfo ccInfo = (CostCenterOrgUnitInfo)this.pmtCostCenter.getData();
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)this.pmtUseDepartment.getData();
        CurrencyInfo cInfo = (CurrencyInfo)this.pmtCurrency.getData();
        if (dateBeginFrom != null) {
            customCond.addCustomerParam("dateBeginFrom", String.valueOf(dateBeginFrom.getTime()));
        }
        if (dateBeginTo != null) {
            customCond.addCustomerParam("dateBeginTo", String.valueOf(dateBeginTo.getTime()));
        }
        if (dateEndFrom != null) {
            customCond.addCustomerParam("dateEndFrom", String.valueOf(dateEndFrom.getTime()));
        }
        if (dateEndTo != null) {
            customCond.addCustomerParam("dateEndTo", String.valueOf(dateEndTo.getTime()));
        }
        if (billInfoFrom != null) {
            customCond.addCustomerParam("leaseInNumFrom.id", billInfoFrom.getId().toString());
            customCond.addCustomerParam("leaseInNumFrom.number", billInfoFrom.getNumber());
            customCond.addCustomerParam("leaseInNumFrom.contractNumber", billInfoFrom.getContractNumber());
            customCond.addCustomerParam("leaseInNumFrom.name", billInfoFrom.getContractName());
        }
        if (billInfoTo != null) {
            customCond.addCustomerParam("leaseInNumTo.id", billInfoTo.getId().toString());
            customCond.addCustomerParam("leaseInNumTo.number", billInfoTo.getNumber());
            customCond.addCustomerParam("leaseInNumTo.contractNumber", billInfoTo.getContractNumber());
            customCond.addCustomerParam("leaseInNumTo.name", billInfoTo.getContractName());
        }
        if (catInfo != null) {
            customCond.addCustomerParam("contractCat.id", catInfo.getId().toString());
            customCond.addCustomerParam("contractCat.name", catInfo.getName().toString());
        }
        if (ccInfo != null) {
            customCond.addCustomerParam("costCenter.id", ccInfo.getId().toString());
            customCond.addCustomerParam("costCenter.name", ccInfo.getName());
        }
        if (adminInfo != null) {
            customCond.addCustomerParam("useDepartment.id", adminInfo.getId().toString());
            customCond.addCustomerParam("useDepartment.name", adminInfo.getName());
        }
        customCond.addCustomerParam("currency.id", cInfo.getId().toString());
        customCond.addCustomerParam("currency.name", cInfo.getName().toString());
        if (this.rbBtnExpired.isSelected()) {
            customCond.addCustomerParam("isExpired", "true");
        } else if (this.rbBtnNotExpired.isSelected()) {
            customCond.addCustomerParam("isExpired", "false");
        }
        return customCond;
    }

    public Map<String, Object> getCustomCond() {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("company", this.currCompany);
        cond.put("dateBeginFrom", this.dpBeginFrom.getValue());
        cond.put("dateBeginTo", this.dpBeginTo.getValue());
        cond.put("dateEndFrom", this.dpEndFrom.getValue());
        cond.put("dateEndTo", this.dpEndTo.getValue());
        cond.put("leaseInNumFrom", this.pmtLeaseInNumFrom.getData());
        cond.put("leaseInNumTo", this.pmtLeaseInNumTo.getData());
        cond.put("contractCat", this.pmtContractType.getData());
        cond.put("costCenter", this.pmtCostCenter.getData());
        cond.put("useDepartment", this.pmtUseDepartment.getData());
        cond.put("currency", this.pmtCurrency.getData());
        if (this.rbBtnExpired.isSelected()) {
            cond.put("isExpired", "true");
        } else if (this.rbBtnNotExpired.isSelected()) {
            cond.put("isExpired", "false");
        }
        return cond;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.clear();
        CustomerParams customCond = this.getCustomerParams();
        if (customCond != null) {
            SelectorItemCollection sic;
            if (customCond.getCustomerParam("leaseInNumFrom.id") != null) {
                FaLeaseInBillNewInfo billInfoFrom = null;
                ObjectUuidPK billFromPk = new ObjectUuidPK(customCond.getCustomerParam("leaseInNumFrom.id"));
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("number");
                sic.add("contractNumber");
                sic.add("name");
                try {
                    billInfoFrom = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)billFromPk, sic);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                this.pmtLeaseInNumFrom.setData((Object)billInfoFrom);
            } else {
                this.pmtLeaseInNumFrom.setData(null);
            }
            if (customCond.getCustomerParam("leaseInNumTo.id") != null) {
                FaLeaseInBillNewInfo billInfoTo = null;
                ObjectUuidPK billToPk = new ObjectUuidPK(customCond.getCustomerParam("leaseInNumTo.id"));
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("number");
                sic.add("contractNumber");
                sic.add("name");
                try {
                    billInfoTo = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)billToPk, sic);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                this.pmtLeaseInNumTo.setData((Object)billInfoTo);
            } else {
                this.pmtLeaseInNumTo.setData(null);
            }
            if (customCond.getCustomerParam("contractCat.id") != null) {
                FaContractCatInfo catInfo = null;
                ObjectUuidPK catPk = new ObjectUuidPK(customCond.getCustomerParam("contractCat.id"));
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("name");
                try {
                    catInfo = FaContractCatFactory.getRemoteInstance().getFaContractCatInfo((IObjectPK)catPk, sic);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                this.pmtContractType.setData((Object)catInfo);
            } else {
                this.pmtContractType.setData(null);
            }
            if (customCond.getCustomerParam("costCenter.id") != null) {
                CostCenterOrgUnitInfo ccInfo = null;
                ObjectUuidPK ccPk = new ObjectUuidPK(customCond.getCustomerParam("costCenter.id"));
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("name");
                try {
                    ccInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)ccPk, sic);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                this.pmtCostCenter.setData((Object)ccInfo);
            } else {
                this.pmtCostCenter.setData(null);
            }
            if (customCond.getCustomerParam("useDepartment.id") != null) {
                AdminOrgUnitInfo adminInfo = null;
                ObjectUuidPK adminPk = new ObjectUuidPK(customCond.getCustomerParam("useDepartment.id"));
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("name");
                try {
                    adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)adminPk, sic);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                this.pmtUseDepartment.setData((Object)adminInfo);
            } else {
                this.pmtUseDepartment.setData(null);
            }
            if (customCond.getCustomerParam("currency.id") != null) {
                CurrencyInfo cInfo = null;
                ObjectUuidPK cPk = new ObjectUuidPK(customCond.getCustomerParam("currency.id"));
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("name");
                try {
                    cInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)cPk, sic);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                this.pmtCurrency.setData((Object)cInfo);
            } else {
                this.pmtCurrency.setData(null);
            }
            Calendar cld = Calendar.getInstance();
            if (customCond.getCustomerParam("dateBeginFrom") != null) {
                cld.setTimeInMillis(Long.valueOf(customCond.getCustomerParam("dateBeginFrom")));
                this.dpBeginFrom.setValue((Object)cld.getTime());
            } else {
                this.dpBeginFrom.setValue(null);
            }
            if (customCond.getCustomerParam("dateBeginTo") != null) {
                cld.clear();
                cld.setTimeInMillis(Long.valueOf(customCond.getCustomerParam("dateBeginTo")));
                this.dpBeginTo.setValue((Object)cld.getTime());
            } else {
                this.dpBeginTo.setValue(null);
            }
            if (customCond.getCustomerParam("dateEndFrom") != null) {
                cld.clear();
                cld.setTimeInMillis(Long.valueOf(customCond.getCustomerParam("dateEndFrom")));
                this.dpEndFrom.setValue((Object)cld.getTime());
            } else {
                this.dpEndFrom.setValue(null);
            }
            if (customCond.getCustomerParam("dateEndTo") != null) {
                cld.clear();
                cld.setTimeInMillis(Long.valueOf(customCond.getCustomerParam("dateEndTo")));
                this.dpEndTo.setValue((Object)cld.getTime());
            } else {
                this.dpEndTo.setValue(null);
            }
            String isExpiredStr = customCond.getCustomerParam("isExpired");
            if (isExpiredStr == null) {
                this.rbBtnExpiredStatusAll.setSelected(true);
            } else {
                boolean isExpired = Boolean.valueOf(isExpiredStr);
                if (isExpired) {
                    this.rbBtnExpired.setSelected(true);
                } else {
                    this.rbBtnNotExpired.setSelected(true);
                }
            }
        }
    }

    public void clear() {
        try {
            this.initUI();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"96_FaAmortizedCostListRptConditionUI") + e.getMessage()));
        }
    }

    @Override
    public void actionContractCatFilter_actionPerformed(ActionEvent e) throws Exception {
        super.actionContractCatFilter_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FaContractCatFilterUI.class.getName(), (Map)uiContext);
        if (uiWindow instanceof KDDialog) {
            ((KDDialog)uiWindow).setResizable(true);
        }
        FaContractCatFilterUI filterUI = (FaContractCatFilterUI)uiWindow.getUIObject();
        filterUI.getUIWindow().show();
    }
}

