/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewCollection;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseTypeEnum;
import com.kingdee.eas.fi.nlm.FaPaymentPlanNewCollection;
import com.kingdee.eas.fi.nlm.NLMAssetCalculationDetailEntryCollection;
import com.kingdee.eas.fi.nlm.NLMAssetCalculationDetailFactory;
import com.kingdee.eas.fi.nlm.NLMAssetCalculationDetailInfo;
import com.kingdee.eas.fi.nlm.client.AbstractFaAssetCalculationDetailListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class FaAssetCalculationDetailListUI
extends AbstractFaAssetCalculationDetailListUI {
    private static final Logger logger = CoreUIObject.getLogger(FaAssetCalculationDetailListUI.class);
    public static final String RES_PATH_POLICY = "com.kingdee.eas.fi.nlm.FaNewLeasePolicyResource";
    private static final String YEAR_DATES = "365";
    private static final long DATE_TIME_MILLIS = 86400000L;
    private FaLeaseInBillNewInfo faLeaseInBillNewInfoOld = null;
    private NLMAssetCalculationDetailInfo detailInfo;
    private FaPaymentPlanNewCollection ppCol = new FaPaymentPlanNewCollection();
    private DataChangeListener pkDateListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent e) {
            FaAssetCalculationDetailListUI.this.calculationResult.setText(String.valueOf(FaAssetCalculationDetailListUI.this.subDate(FaAssetCalculationDetailListUI.this.calculationEndDate.getSqlDate(), FaAssetCalculationDetailListUI.this.calculationStartDate.getSqlDate())));
        }
    };

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        this.initBillInfo();
        this.initAuxiliaryInformation();
        this.initCalculationTable();
        this.initDateTable(this.faLeaseInBillNewInfoOld);
        this.calculationResult.setText("0");
        this.calculationStartDate.addDataChangeListener(this.pkDateListener);
        this.calculationEndDate.addDataChangeListener(this.pkDateListener);
        this.setPreferredSize(new Dimension(1600, 600));
    }

    private void initTable() {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"97_FaAssetCalculationDetailListUI"));
        this.calculationTable.getSelectManager().setSelectMode(2);
        this.calculationTable.getStyleAttributes().setLocked(true);
        this.calculationTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 1) {
                    FaAssetCalculationDetailListUI.this.doTableOneClick(e);
                }
            }
        });
        this.paymentTable.getSelectManager().setSelectMode(2);
        this.paymentTable.getStyleAttributes().setLocked(true);
        this.dateTable.getSelectManager().setSelectMode(2);
        this.dateTable.getStyleAttributes().setLocked(true);
    }

    private void initBillInfo() throws BOSException, EASBizException {
        String loadCardIds = (String)this.getUIContext().get("CardID");
        this.faLeaseInBillNewInfoOld = this.getLeaseInBill((IObjectPK)new ObjectUuidPK(loadCardIds));
        if (this.faLeaseInBillNewInfoOld.getLeaseType() != FaLeaseTypeEnum.OPERATING_LEASE) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"98_FaAssetCalculationDetailListUI"));
            SysUtil.abort();
        }
        this.ppCol = this.faLeaseInBillNewInfoOld.getPaymentEntry();
        if (this.ppCol.size() != 0) {
            this.ppCol.sort("payDate");
            this.ppCol.removeObject(0);
        }
        this.detailInfo = NLMAssetCalculationDetailFactory.getRemoteInstance().getNLMAssetCalcByBillId((IObjectPK)new ObjectUuidPK(loadCardIds));
        if (this.detailInfo == null) {
            NLMAssetCalculationDetailFactory.getRemoteInstance().saveNLMAssetCalcByBillIdForOldValue((IObjectPK)new ObjectUuidPK(loadCardIds));
            this.detailInfo = NLMAssetCalculationDetailFactory.getRemoteInstance().getNLMAssetCalcByBillId((IObjectPK)new ObjectUuidPK(loadCardIds));
        }
    }

    private void initAuxiliaryInformation() {
        this.paymentTable.checkParsed();
        this.txtBillNumber.setText(this.detailInfo.getLeaseBillNumber());
        this.txtExchangeRate.setValue((Object)new BigDecimal(this.detailInfo.getExchangeRateValue()));
        this.txtDiscountRate.setValue((Object)new BigDecimal(this.detailInfo.getDiscountRateForYear()));
        this.txtDiscountRate.setPrecision(4);
        this.txtRealDiscountRate.setText(new BigDecimal(this.detailInfo.getDiscountRateForDay()).multiply(new BigDecimal("100")).toString());
        this.isDeductible.setSelected(this.detailInfo.isIsDeductible());
        this.txtCostPmWith1.setValue((Object)new BigDecimal(this.detailInfo.getAdvancePaymentValue()));
        this.txtCostPmWith2.setValue((Object)new BigDecimal(this.detailInfo.getInitDirectFeeValue()));
        this.txtCostPmWith7.setValue((Object)new BigDecimal(this.detailInfo.getRentIncentiveValue()));
        this.txtCostPmWith6.setValue((Object)new BigDecimal(this.detailInfo.getRecoveryCostValue()));
        this.txtStampTaxStM.setValue((Object)new BigDecimal(this.detailInfo.getStampTaxStMValue()));
        int j = this.ppCol.size();
        for (int i = 0; i < j; ++i) {
            IRow row = this.paymentTable.getRow2(i);
            if (row == null) {
                row = this.paymentTable.addRow(i);
            }
            row.getCell("rentPeriod").setValue((Object)String.valueOf(this.ppCol.get(i).getRentPeriod()));
            row.getCell("payDate").setValue((Object)String.valueOf(this.ppCol.get(i).getPayDate()));
            row.getCell("paymentAmount").setValue((Object)(this.faLeaseInBillNewInfoOld.isIsDeductible() ? String.valueOf(this.ppCol.get(i).getPaymentWithoutTax()) : String.valueOf(this.ppCol.get(i).getPaymentWithTax())));
        }
    }

    private void initCalculationTable() throws ParseException, EASBizException, BOSException {
        this.calculationTable.checkParsed();
        NLMAssetCalculationDetailEntryCollection detailEntryCollection = this.detailInfo.getEntry();
        int j = detailEntryCollection.size();
        for (int i = 0; i < j; ++i) {
            IRow row = this.calculationTable.getRow2(i);
            if (row == null) {
                row = this.calculationTable.addRow(i);
            }
            row.getCell("name").setValue((Object)detailEntryCollection.get(i).getCalculationName());
            row.getCell("number").setValue((Object)detailEntryCollection.get(i).getCalculationValue());
            row.getCell("calculation").setValue((Object)detailEntryCollection.get(i).getCalculationProcess());
            row.getCell("expression").setValue((Object)detailEntryCollection.get(i).getCalculationFormula());
            if (i == 0) {
                row.getStyleAttributes().setBackground(this.calculationTable.getRequiredColor());
            }
            if (!EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"71_NLMAssetCalculationDetailControllerBean").equals(detailEntryCollection.get(i).getCalculationFormula())) continue;
            row.getStyleAttributes().setBackground(new Color(222, 222, 222, 255));
        }
    }

    private void initDateTable(FaLeaseInBillNewInfo faLeaseInBillNewInfo) {
        this.dateTable.checkParsed();
        String[] names = new String[]{EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"99_FaAssetCalculationDetailListUI"), EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"100_FaAssetCalculationDetailListUI"), EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"101_FaAssetCalculationDetailListUI"), EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"102_FaAssetCalculationDetailListUI")};
        block6: for (int i = 0; i < names.length; ++i) {
            IRow row = this.dateTable.getRow2(i);
            if (row == null) {
                row = this.dateTable.addRow(i);
            }
            row.getCell("name").setValue((Object)names[i]);
            switch (i) {
                case 0: {
                    row.getCell("date").setValue((Object)String.valueOf(this.detailInfo.getBeginDate() == null ? "" : this.detailInfo.getBeginDate()));
                    continue block6;
                }
                case 1: {
                    row.getCell("date").setValue((Object)String.valueOf(this.detailInfo.getDiscountDate() == null ? "" : this.detailInfo.getDiscountDate()));
                    continue block6;
                }
                case 2: {
                    row.getCell("date").setValue((Object)String.valueOf(this.detailInfo.getAdvancePaymentDate() == null ? "" : this.detailInfo.getAdvancePaymentDate()));
                    continue block6;
                }
                case 3: {
                    row.getCell("date").setValue((Object)String.valueOf(this.detailInfo.getRecoveryCostDate() == null ? "" : this.detailInfo.getRecoveryCostDate()));
                    continue block6;
                }
            }
        }
    }

    private FaLeaseInBillNewInfo getLeaseInBill(IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("contractCat.id");
        sic.add("contractCat.name");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.baseCurrency.precision");
        sic.add("paymentEntry.*");
        sic.add("exchangeRate.*");
        sic.add("exchangeRate.exchangeAux.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("paymentEntry.payDate"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        view.setSorter(sorter);
        FaLeaseInBillNewCollection col = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewCollection(view);
        if (col.size() < 0) {
            return null;
        }
        return col.get(0);
    }

    private void doTableOneClick(KDTMouseEvent e) {
        String stringTmp;
        int rowNumber = e.getRowIndex();
        if (this.calculationTable.getCell(rowNumber, "expression") == null) {
            this.calculationLabel.setText("");
        }
        String expression = (String)this.calculationTable.getCell(rowNumber, "expression").getValue();
        this.calculationLabel.setText(expression);
        ICell tmp = this.calculationTable.getCell(rowNumber, "name");
        if (tmp != null && (stringTmp = (String)tmp.getValue()).charAt(0) == '\u4ed8') {
            String[] strings = stringTmp.split(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"66_NLMAssetCalculationDetailControllerBean"));
            int selectIndex = Integer.parseInt(strings[1]) - 1;
            this.paymentTable.getSelectManager().select(selectIndex, 0, selectIndex, 2);
            this.paymentTable.getLayoutManager().scrollRowToShow(selectIndex);
        }
    }

    private int subDate(Date date1, Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        cld1.set(cld1.get(1), cld1.get(2), cld1.get(5), 0, 0, 0);
        cld2.set(cld2.get(1), cld2.get(2), cld2.get(5), 0, 0, 0);
        return (int)((cld1.getTimeInMillis() - cld2.getTimeInMillis()) / 86400000L);
    }
}

