/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.rpt.client.FaRptCompanyTreeFormatter;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.fi.nlm.client.AbstractFaAssetCalculationRptCondUI;
import com.kingdee.eas.fi.nlm.client.view.FLCompanyTreeSelectUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class FaAssetCalculationRptCondUI
extends AbstractFaAssetCalculationRptCondUI {
    private static final Logger logger = CoreUIObject.getLogger(FaAssetCalculationRptCondUI.class);
    private static final String COMPANY = "company";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String LEASE_BILL_NUMBER = "leaseBillNumber";
    private static final String CURRENCY_ID = "currencyID";

    public FaAssetCalculationRptCondUI() throws Exception {
        this.init();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.isVirCompany) {
            this.prmtCompany.setDisplayFormatter((IFormatter)new FaRptCompanyTreeFormatter());
        } else {
            this.btnCompany.setVisible(false);
            this.prmtCompany.setData((Object)this.currCompany.getName());
        }
        this.prmtCompany.setEnabled(false);
        this.prmtCurrency.setRequired(false);
    }

    @Override
    protected void setDefaultData() throws Exception {
        if (this.isVirCompany) {
            this.prmtCompany.setValue(null);
            if (this.ctsUI != null) {
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot(null);
            }
        } else {
            this.prmtCompany.setData((Object)this.currCompany.getName());
            this.beginDate.setValue(null);
            this.endDate.setValue(null);
            this.billNumber.setText("");
            this.prmtCurrency.setValue(null);
        }
    }

    @Override
    public FilterInfo getFilterInfo() {
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int i = 0;
        if (this.prmtCompany != null && this.prmtCompany.getValue() != null) {
            items.add(new FilterItemInfo(COMPANY, this.prmtCompany.getValue()));
            sbFormula.append("#" + i++);
        }
        if (this.beginDate != null && this.beginDate.getSqlDate() != null) {
            items.add(new FilterItemInfo(START_DATE, (Object)this.beginDate.getSqlDate(), CompareType.GREATER_EQUALS));
            sbFormula.append(" and #" + i++);
        }
        if (this.endDate != null && this.endDate.getSqlDate() != null) {
            items.add(new FilterItemInfo(END_DATE, (Object)this.endDate.getSqlDate(), CompareType.LESS_EQUALS));
            sbFormula.append(" and #" + i++);
        }
        if (this.billNumber.getText() != null && this.billNumber.getText().trim().length() > 0) {
            items.add(new FilterItemInfo(LEASE_BILL_NUMBER, (Object)this.billNumber.getText().trim()));
            sbFormula.append(" and #" + i++);
        }
        if (this.prmtCurrency != null && this.prmtCurrency.getValue() != null) {
            items.add(new FilterItemInfo(CURRENCY_ID, (Object)((CurrencyInfo)this.prmtCurrency.getValue()).getId().toString()));
            sbFormula.append(" and #" + i++);
        }
        this.setCustomerParams(this.getCustParams());
        return filter;
    }

    @Override
    protected Map getCustomCond() {
        Map customCond = super.getCustomCond();
        if (this.isVirCompany) {
            customCond.put(COMPANY, this.prmtCompany.getData());
        }
        customCond.put(START_DATE, this.beginDate.getSqlDate());
        customCond.put(END_DATE, this.endDate.getSqlDate());
        customCond.put(LEASE_BILL_NUMBER, this.billNumber.getStringValue());
        customCond.put(CURRENCY_ID, this.prmtCurrency.getValue());
        return customCond;
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = super.getCustParams();
        if (this.isVirCompany) {
            TreeNode treeNode = (TreeNode)this.prmtCompany.getData();
            CustomerParams companys = this.transCompanyTree(treeNode);
            params.putMe(COMPANY, companys);
        }
        return params;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterItemCollection currentCollection;
        super.loadData(entityViewInfo);
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            if (this.isVirCompany) {
                CustomerParams custAcountTable = cond.getMe("accountTable");
                AccountTableInfo accountTable = new AccountTableInfo();
                accountTable.setId(BOSUuid.read((String)custAcountTable.getCustomerParam("id")));
                accountTable.setName(custAcountTable.getCustomerParam("name"));
                accountTable.setNumber(custAcountTable.getCustomerParam("number"));
                CustomerParams custPeriodType = cond.getMe("periodType");
                PeriodTypeInfo periodType = new PeriodTypeInfo();
                periodType.setId(BOSUuid.read((String)custPeriodType.getCustomerParam("id")));
                periodType.setName(custPeriodType.getCustomerParam("name"));
                periodType.setNumber(custPeriodType.getCustomerParam("number"));
                if (this.ctsUI == null) {
                    try {
                        this.initCompanyTree();
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                }
                this.prmtCompany.setData((Object)this.resumeCompanyTree(cond.getMe(COMPANY)));
                ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
                if (this.prmtCompany.getData() != null) {
                    this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
                }
            }
            ArrayList<String> idList = new ArrayList<String>();
            Object data = this.prmtCompany.getData();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
        }
        if (entityViewInfo.getFilter() == null) {
            entityViewInfo.setFilter(new FilterInfo());
        }
        if ((currentCollection = entityViewInfo.getFilter().getFilterItems()) == null) {
            return;
        }
        this.beginDate.setValue(null);
        this.endDate.setValue(null);
        this.billNumber.setText("");
        this.prmtCurrency.setValue(null);
        for (int i = 0; i < currentCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = currentCollection.get(i);
            if (START_DATE.equals(filterItemInfo.getPropertyName())) {
                this.beginDate.setValue(filterItemInfo.getCompareValue());
            }
            if (END_DATE.equals(filterItemInfo.getPropertyName())) {
                this.endDate.setValue(filterItemInfo.getCompareValue());
            }
            if (LEASE_BILL_NUMBER.equals(filterItemInfo.getPropertyName())) {
                this.billNumber.setText(filterItemInfo.getCompareValue().toString());
            }
            if (!CURRENCY_ID.equals(filterItemInfo.getPropertyName())) continue;
            try {
                this.prmtCurrency.setValue((Object)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e);
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }
    }

    private void initCompanyTree() throws Exception {
        this.dialog = new JDialog(FaRptUIUtils.getFrameAncestor((Component)((Object)this)), true);
        this.ctsUI = new FLCompanyTreeSelectUI(this);
        this.ctsUI.setDialog(this.dialog);
        this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
        this.dialog.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.ctsUI.getUITitle());
        ((DefaultTreeModel)this.ctsUI.treeSelected.getModel()).setRoot((TreeNode)this.prmtCompany.getData());
        if (this.prmtCompany.getData() != null) {
            this.ctsUI.treeSelected.expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
        }
        this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("companyChanged") && evt.getNewValue() != null && evt.getNewValue() instanceof TreeModel) {
                    FaAssetCalculationRptCondUI.this.prmtCompany.setData(((TreeModel)evt.getNewValue()).getRoot());
                }
            }
        });
    }

    @Override
    public boolean verify() {
        Date endDateTmp;
        Date startDate;
        if (this.isVirCompany && (this.prmtCompany.getData() == null || !(this.prmtCompany.getData() instanceof DefaultMutableTreeNode))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"plsSelectCompany"));
            return false;
        }
        if (this.beginDate.getSqlDate() != null && this.endDate.getSqlDate() != null && (startDate = this.beginDate.getSqlDate()).compareTo(endDateTmp = this.endDate.getSqlDate()) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"103_FaAssetCalculationRptCondUI"));
            return false;
        }
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    @Override
    protected void addListener() throws Exception {
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
            }
        });
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.ctsUI == null) {
            this.initCompanyTree();
        }
        this.dialog.show();
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }
}

