/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.client.CompanyTreeBuilder;
import com.kingdee.eas.fi.fa.rpt.client.FaRptCompanyTreeFormatter;
import com.kingdee.eas.fi.fa.rpt.client.FaRptUIUtils;
import com.kingdee.eas.fi.nlm.FaContractCatFactory;
import com.kingdee.eas.fi.nlm.FaContractCatInfo;
import com.kingdee.eas.fi.nlm.NlmListFactory;
import com.kingdee.eas.fi.nlm.client.AbstractFaDepreAndAmortFilterUI;
import com.kingdee.eas.fi.nlm.client.dialog.FaContractCatPromptBox;
import com.kingdee.eas.fi.nlm.client.view.FLCompanyTreeSelectUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class FaDepreAndAmortFilterUI
extends AbstractFaDepreAndAmortFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FaDepreAndAmortFilterUI.class);
    private final HashMap periodCollection = new HashMap();
    private PeriodInfo currPeriod = null;
    private PeriodInfo startPeriod = null;
    private Integer minPeriodYear;
    private Integer maxPeriodYear;
    private Integer minPeriodStartNumber;
    private Integer maxPerioEndNumber;

    public FaDepreAndAmortFilterUI() throws Exception {
        this.init();
    }

    @Override
    public FilterInfo getFilterInfo() {
        FilterItemInfo templateFilterItemInfo;
        FilterItemInfo companyFilterItemInfo;
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int i = 0;
        items.add(new FilterItemInfo("deletedStatus", (Object)1, CompareType.EQUALS));
        sbFormula.append("(#" + i++);
        items.add(new FilterItemInfo("deletedStatus", null, CompareType.IS));
        sbFormula.append(" or #" + i++ + ")");
        items.add(new FilterItemInfo("monthlyDepreAmt", (Object)0, CompareType.NOTEQUALS));
        sbFormula.append("and (#" + i++);
        items.add(new FilterItemInfo("monthlyInterestExpe", (Object)0, CompareType.NOTEQUALS));
        sbFormula.append(" or #" + i++ + ")");
        items.add(new FilterItemInfo("monthlyDepreAmt", null, CompareType.NOTEQUALS));
        sbFormula.append("and (#" + i++);
        items.add(new FilterItemInfo("monthlyInterestExpe", null, CompareType.NOTEQUALS));
        sbFormula.append(" or #" + i++ + ")");
        CustomerParams periodMap = new CustomerParams();
        if (this.isVirCompany) {
            HashSet<String> idSet = new HashSet<String>();
            this.buildCompanIdSet((TreeNode)this.prmtCompany.getData(), idSet);
            companyFilterItemInfo = new FilterItemInfo("company.id", idSet, CompareType.INCLUDE);
            items.add(companyFilterItemInfo);
            sbFormula.append(" and (#" + i++);
            items.add(new FilterItemInfo("CU.id", (Object)""));
            sbFormula.append(" or #" + i++ + ")");
        } else {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
            if (this.prmtCompany != null && this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo && !aCompanyOrgUnitInfo.getId().toString().equals(((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"110_FaDepreAndAmortFilterUI"));
                SysUtil.abort();
            }
            if (this.prmtCompany != null && this.prmtCompany.getData() instanceof TreeNode) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"111_FaDepreAndAmortFilterUI"));
                SysUtil.abort();
            }
            if (aCompanyOrgUnitInfo != null && aCompanyOrgUnitInfo.getId() != null) {
                companyFilterItemInfo = new FilterItemInfo("company.id", (Object)aCompanyOrgUnitInfo.getId().toString());
                items.add(companyFilterItemInfo);
                sbFormula.append(" and #" + i++);
            }
        }
        Object data = this.bizPromptContractType.getData();
        if (data != null) {
            HashSet<String> typeIdSet = new HashSet<String>();
            if (data instanceof Object[]) {
                Object[] objs;
                for (Object obj : objs = (Object[])data) {
                    FaContractCatInfo cat = (FaContractCatInfo)obj;
                    if (cat == null) continue;
                    typeIdSet.add(cat.getNumber());
                }
            } else if (data instanceof FaContractCatInfo) {
                FaContractCatInfo cat = (FaContractCatInfo)data;
                typeIdSet.add(cat.getNumber());
            }
            FilterItemInfo templateFilterItemInfo2 = new FilterItemInfo("contractCat.number", typeIdSet, CompareType.INCLUDE);
            items.add(templateFilterItemInfo2);
            sbFormula.append(" and #" + i++);
        }
        if (this.txtNumberFrom.getText() != null && this.txtNumberFrom.getText().trim().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("leaseInBill.number", (Object)this.txtNumberFrom.getText().trim(), CompareType.GREATER_EQUALS);
            items.add(templateFilterItemInfo);
            sbFormula.append(" and #" + i++);
        }
        if (this.txtNumberTo.getText() != null && this.txtNumberTo.getText().trim().length() > 0) {
            templateFilterItemInfo = new FilterItemInfo("leaseInBill.number", (Object)this.txtNumberTo.getText().trim(), CompareType.LESS_EQUALS);
            items.add(templateFilterItemInfo);
            sbFormula.append(" and #" + i++);
        }
        if (this.sldPeriodFrom.getValue() != null) {
            int yearFrom = this.sldYearFrom.getIntegerVlaue();
            int numberFrom = this.sldPeriodFrom.getIntegerVlaue();
            periodMap.putInt("period.periodYearFrom", yearFrom);
            periodMap.putInt("period.periodNumberFrom", numberFrom);
            int startPeriodNumber = this.getPeriodNumber(yearFrom, numberFrom);
            FilterItemInfo startPeriod = new FilterItemInfo("period.number", (Object)new Integer(startPeriodNumber), CompareType.GREATER_EQUALS);
            items.add(startPeriod);
            sbFormula.append(" and #" + i++ + " ");
        }
        if (this.sldPeriodTo.getValue() != null) {
            int yearTo = this.sldYearTo.getIntegerVlaue();
            int numberTo = this.sldPeriodTo.getIntegerVlaue();
            periodMap.putInt("period.periodYearTo", yearTo);
            periodMap.putInt("period.periodNumberTo", numberTo);
            int toPeriodNumber = this.getPeriodNumber(yearTo, numberTo);
            FilterItemInfo endPeriod = new FilterItemInfo("period.number", (Object)new Integer(toPeriodNumber), CompareType.LESS_EQUALS);
            items.add(endPeriod);
            sbFormula.append(" and #" + i++ + " ");
        }
        if (this.rbnVoucherd.isSelected()) {
            FilterItemInfo vouchered = new FilterItemInfo("fiVouchered", (Object)1);
            items.add(vouchered);
            sbFormula.append(" and #" + i++);
        } else if (this.rbnUnVouchered.isSelected()) {
            FilterItemInfo unVouchered = new FilterItemInfo("fiVouchered", (Object)0);
            items.add(unVouchered);
            sbFormula.append(" and #" + i++);
        }
        if (this.rbnIsExpire.isSelected()) {
            FilterItemInfo audited = new FilterItemInfo("leaseInBill.isExpire", (Object)1);
            items.add(audited);
            sbFormula.append(" and #" + i++);
        } else if (this.rbnUnExpire.isSelected()) {
            FilterItemInfo audited = new FilterItemInfo("leaseInBill.isExpire", (Object)0);
            items.add(audited);
            sbFormula.append(" and #" + i++);
        }
        if (sbFormula.toString().length() != 0) {
            filter.setMaskString(sbFormula.toString());
        }
        this.setCustomerParams(periodMap);
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        this.sorterItemCollection.clear();
        SorterItemInfo sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setPropertyName("company.id");
        sorterItemInfo.setSortType(SortType.ASCEND);
        this.sorterItemCollection.add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setPropertyName("period.number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        this.sorterItemCollection.add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setPropertyName("leaseInBill.number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        this.sorterItemCollection.add(sorterItemInfo);
        return this.sorterItemCollection;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.currCompany.isIsBizUnit()) {
            this.sldYearFrom.setValue((Object)new Integer(this.currPeriod.getPeriodYear()));
            this.sldYearTo.setValue((Object)new Integer(this.currPeriod.getPeriodYear()));
            this.sldPeriodFrom.setValue((Object)new Integer(this.currPeriod.getPeriodNumber()));
            this.sldPeriodTo.setValue((Object)new Integer(this.currPeriod.getPeriodNumber()));
        }
        this.txtNumberFrom.setText(null);
        this.txtNumberTo.setText(null);
        this.bizPromptContractType.setData(null);
        this.rbnAll.setSelected(true);
        this.rbnExpireAll.setSelected(false);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.prmtCompany.setEnabled(false);
        if (this.isVirCompany) {
            this.sldYearFrom.setEnabled(false);
            this.sldYearTo.setEnabled(false);
            this.sldPeriodFrom.setEnabled(false);
            this.sldPeriodTo.setEnabled(false);
            this.prmtCompany.setDisplayFormatter((IFormatter)new FaRptCompanyTreeFormatter());
        } else {
            this.sldYearFrom.setEnabled(true);
            this.sldYearTo.setEnabled(true);
            this.sldPeriodFrom.setEnabled(true);
            this.sldPeriodTo.setEnabled(true);
            this.btnCompany.setVisible(false);
            this.prmtCompany.setData((Object)this.currCompany.getName());
        }
        this.prmtCompany.setEnabled(false);
    }

    @Override
    protected void setDefaultData() throws Exception {
        if (this.isVirCompany) {
            this.prmtCompany.setValue(null);
            if (this.ctsUI != null) {
                ((DefaultTreeModel)this.ctsUI.getTreeSelected().getModel()).setRoot(null);
            }
        } else {
            FaClientUtils.checkBeforeOnload4Fl((Map)this.getUIContext(), (CompanyOrgUnitInfo)this.currCompany);
            this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.currCompany);
            if (this.currPeriod == null) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseNewResource.Lease_Period_Is_Null");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                SysUtil.abort();
            }
            this.startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.currCompany);
            SpinnerNumberModel yearMinNumberModel = new SpinnerNumberModel();
            yearMinNumberModel.setMinimum(new Integer(this.startPeriod.getPeriodYear()));
            yearMinNumberModel.setMaximum(new Integer(this.currPeriod.getPeriodYear()));
            SpinnerNumberModel yearMaxNumberModel = new SpinnerNumberModel();
            yearMaxNumberModel.setMinimum(new Integer(this.startPeriod.getPeriodYear()));
            yearMaxNumberModel.setMaximum(new Integer(this.currPeriod.getPeriodYear()));
            this.minPeriodYear = this.startPeriod.getPeriodYear();
            this.maxPeriodYear = this.currPeriod.getPeriodYear();
            this.minPeriodStartNumber = this.startPeriod.getPeriodNumber();
            this.maxPerioEndNumber = this.currPeriod.getPeriodNumber();
            this.sldYearFrom.setModel((SpinnerModel)yearMinNumberModel);
            this.sldYearTo.setModel((SpinnerModel)yearMaxNumberModel);
            this.sldYearFrom.setValue((Object)new Integer(this.currPeriod.getPeriodYear()));
            this.sldYearTo.setValue((Object)new Integer(this.currPeriod.getPeriodYear()));
            this.sldPeriodFrom.setValue((Object)new Integer(this.currPeriod.getPeriodNumber()));
            this.sldPeriodTo.setValue((Object)new Integer(this.currPeriod.getPeriodNumber()));
            PeriodCollection periods = PeriodFactory.getRemoteInstance().getPeriodCollection("where periodType.id='" + this.currCompany.getAccountPeriodType().getId() + "' and periodYear>=" + this.startPeriod.getPeriodYear());
            for (int i = 0; i < periods.size(); ++i) {
                PeriodInfo period = periods.get(i);
                this.periodCollection.put(period.getPeriodYear() + "" + period.getPeriodNumber(), period);
            }
        }
        this.addListener();
        this.initControl();
    }

    @Override
    protected void addListener() throws Exception {
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
            }
        });
        this.sldYearFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDepreAndAmortFilterUI.this.fireStartYearChange();
                FaDepreAndAmortFilterUI.this.firePeriodChange(e);
            }
        });
        this.sldYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDepreAndAmortFilterUI.this.fireEndYearChange();
                FaDepreAndAmortFilterUI.this.firePeriodChange(e);
            }
        });
        this.sldPeriodFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDepreAndAmortFilterUI.this.firePeriodChange(e);
            }
        });
        this.sldPeriodTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaDepreAndAmortFilterUI.this.firePeriodChange(e);
            }
        });
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                FaDepreAndAmortFilterUI.this.companyChanged(eventObj.getNewValue());
            }
        });
    }

    @Override
    protected void btnCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.ctsUI == null) {
            this.initCompanyTree();
        }
        this.dialog.show();
    }

    @Override
    public boolean verify() {
        super.verify();
        if (this.prmtCompany == null || this.prmtCompany.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"112_FaDepreAndAmortFilterUI"));
            SysUtil.abort();
        }
        if (this.isVirCompany) {
            try {
                HashSet<String> idSet = new HashSet<String>();
                this.buildCompanIdSet((TreeNode)this.prmtCompany.getData(), idSet);
                for (String str : idSet) {
                    PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(str), "fa_depreAndAmort_view");
                }
            }
            catch (BOSException e) {
                MsgBox.showInfo((String)e.getMessage());
                SysUtil.abort();
            }
            catch (EASBizException e) {
                MsgBox.showInfo((String)e.getMessage());
                SysUtil.abort();
            }
        }
        return true;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterItemCollection currentCollection;
        super.loadData(entityViewInfo);
        this.clear();
        if (entityViewInfo.getFilter() == null) {
            entityViewInfo.setFilter(new FilterInfo());
        }
        if ((currentCollection = entityViewInfo.getFilter().getFilterItems()) == null) {
            return;
        }
        for (int i = 0; i < currentCollection.size(); ++i) {
            Integer value;
            FilterItemInfo filterItemInfo = currentCollection.get(i);
            if ("company.id".equals(filterItemInfo.getPropertyName()) && filterItemInfo.getCompareType().getName().equals(CompareType.INCLUDE.getName())) {
                if (!this.isVirCompany) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"111_FaDepreAndAmortFilterUI"));
                    SysUtil.abort();
                }
                this.prmtCompany.setValue((Object)this.changedIdToTreeNode(filterItemInfo));
            }
            if ("company.id".equals(filterItemInfo.getPropertyName()) && filterItemInfo.getCompareType().getName().equals(CompareType.EQUALS.getName())) {
                if (this.isVirCompany) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"113_FaDepreAndAmortFilterUI"));
                    SysUtil.abort();
                }
                try {
                    this.prmtCompany.setValue((Object)CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterItemInfo.getCompareValue().toString())));
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            if ("contractCat.number".equals(filterItemInfo.getPropertyName())) {
                String contractCatNumber = filterItemInfo.getCompareValue().toString();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                try {
                    this.bizPromptContractType.setData((Object)FaContractCatFactory.getRemoteInstance().getFaContractCatInfo("where number = '" + contractCatNumber.substring(1, contractCatNumber.length() - 1) + "' and company.id = '" + this.getCurrentCompany().getId().toString() + "'"));
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            if ("period.number".equals(filterItemInfo.getPropertyName()) && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                this.sldYearFrom.setValue((Object)((Integer)filterItemInfo.getCompareValue() / 100));
                this.sldPeriodFrom.setValue((Object)((Integer)filterItemInfo.getCompareValue() % 100));
            }
            if ("period.number".equals(filterItemInfo.getPropertyName()) && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                this.sldYearTo.setValue((Object)((Integer)filterItemInfo.getCompareValue() / 100));
                this.sldPeriodTo.setValue((Object)((Integer)filterItemInfo.getCompareValue() % 100));
            }
            if ("leaseInBill.number".equals(filterItemInfo.getPropertyName()) && filterItemInfo.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                this.txtNumberFrom.setText(filterItemInfo.getCompareValue().toString());
            }
            if ("leaseInBill.number".equals(filterItemInfo.getPropertyName()) && filterItemInfo.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                this.txtNumberTo.setText(filterItemInfo.getCompareValue().toString());
            }
            if ("fiVouchered".equals(filterItemInfo.getPropertyName())) {
                value = (Integer)filterItemInfo.getCompareValue();
                if (value == 0) {
                    this.rbnUnVouchered.setSelected(true);
                }
                if (value == 1) {
                    this.rbnVoucherd.setSelected(true);
                }
            }
            if (!"leaseInBill.isExpire".equals(filterItemInfo.getPropertyName())) continue;
            value = (Integer)filterItemInfo.getCompareValue();
            if (value == 0) {
                this.rbnUnExpire.setSelected(true);
            }
            if (value != 1) continue;
            this.rbnIsExpire.setSelected(true);
        }
    }

    private TreeNode changedIdToTreeNode(FilterItemInfo compareValue) {
        if (compareValue == null) {
            return null;
        }
        TreeNode root = null;
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("level"));
            sic.add(new SelectorItemInfo("parent.id"));
            sic.add(new SelectorItemInfo("parent.number"));
            sic.add(new SelectorItemInfo("parent.name"));
            sic.add(new SelectorItemInfo("parent.level"));
            entityViewInfo.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", compareValue.getCompareValue(), compareValue.getCompareType()));
            entityViewInfo.setFilter(filterInfo);
            SorterItemCollection sorterItemCollection = new SorterItemCollection();
            SorterItemInfo sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName("longNumber");
            sorterItemInfo.setSortType(SortType.ASCEND);
            sorterItemCollection.add(sorterItemInfo);
            entityViewInfo.setSorter(sorterItemCollection);
            CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(entityViewInfo);
            root = new CompanyTreeBuilder(companyOrgUnitCollection).getRoot();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return root;
    }

    private void initControl() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        viewInfo.setFilter(filterInfo);
        FaContractCatPromptBox faContractCatPromptBox = new FaContractCatPromptBox((CoreUIObject)this);
        this.bizPromptContractType.setEntityViewInfo(viewInfo);
        this.bizPromptContractType.setSelector((KDPromptSelector)faContractCatPromptBox);
        this.bizPromptContractType.setEnabledMultiSelection(true);
        this.bizPromptContractType.setQueryInfo("com.kingdee.eas.fi.fa.basedata.app.FaContractCatF7Query");
        this.bizPromptContractType.setEditable(true);
        this.bizPromptContractType.setEditFormat("$number$");
        this.bizPromptContractType.setDisplayFormat("$number$ - $name$");
        this.bizPromptContractType.setCommitFormat("$number$");
    }

    private int getPeriodNumber(int year, int number) {
        if (number > 13 || number < 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"114_FaDepreAndAmortFilterUI"));
            SysUtil.abort();
        }
        return year * 100 + number;
    }

    private void initCompanyTree() throws Exception {
        this.dialog = new JDialog(FaRptUIUtils.getFrameAncestor((Component)((Object)this)), true);
        this.ctsUI = new FLCompanyTreeSelectUI(this);
        this.ctsUI.setDialog(this.dialog);
        this.ctsUI.setPreferredSize(this.ctsUI.getBounds().getSize());
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)((Object)this.ctsUI), "Center");
        this.dialog.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.dialog);
        this.dialog.setResizable(false);
        this.dialog.setTitle(this.ctsUI.getUITitle());
        ((DefaultTreeModel)this.ctsUI.getTreeSelected().getModel()).setRoot((TreeNode)this.prmtCompany.getData());
        if (this.prmtCompany.getData() != null) {
            this.ctsUI.getTreeSelected().expandAllNodes(true, (TreeNode)this.prmtCompany.getData());
        }
        this.ctsUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("companyChanged") && evt.getNewValue() != null && evt.getNewValue() instanceof TreeModel) {
                    FaDepreAndAmortFilterUI.this.prmtCompany.setData(((TreeModel)evt.getNewValue()).getRoot());
                }
            }
        });
    }

    private void companyChanged(Object data) {
        if (data == null) {
            this.sldYearFrom.setEnabled(false);
            this.sldPeriodFrom.setEnabled(false);
            this.sldYearTo.setEnabled(false);
            this.sldPeriodTo.setEnabled(false);
            SpinnerNumberModel tmpModel = new SpinnerNumberModel();
            this.sldYearFrom.setModel((SpinnerModel)tmpModel);
            this.sldPeriodFrom.setModel((SpinnerModel)tmpModel);
            this.sldYearTo.setModel((SpinnerModel)tmpModel);
            this.sldPeriodTo.setModel((SpinnerModel)tmpModel);
        } else {
            this.sldYearFrom.setEnabled(true);
            this.sldPeriodFrom.setEnabled(true);
            this.sldYearTo.setEnabled(true);
            this.sldPeriodTo.setEnabled(true);
            ArrayList<String> idList = new ArrayList<String>();
            if (this.isVirCompany && data instanceof TreeNode) {
                this.buildCompanIdList((TreeNode)data, idList);
            } else {
                idList = new ArrayList();
                idList.add(this.currCompany.getId().toString());
            }
            try {
                String periodTypeID = this.currCompany.getAccountPeriodType().getId().toString();
                Map periodYears = NlmListFactory.getRemoteInstance().findPeriodYearsForNLM(idList);
                SpinnerNumberModel startYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endYearSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel startPeriodSpinnerNumberModel = new SpinnerNumberModel();
                SpinnerNumberModel endPeriodSpinnerNumberModel = new SpinnerNumberModel();
                this.minPeriodYear = (Integer)periodYears.get("MinPeriodYear");
                this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
                this.minPeriodStartNumber = (Integer)periodYears.get("MinPeriodNumber");
                this.maxPerioEndNumber = this.minPeriodYear == this.maxPeriodYear ? (Integer)periodYears.get("MaxPeriodNumber") : Integer.valueOf(13);
                startYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                startYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.sldYearFrom.setModel((SpinnerModel)startYearSpinnerNumberModel);
                endYearSpinnerNumberModel.setMinimum(this.minPeriodYear);
                endYearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
                this.sldYearTo.setModel((SpinnerModel)endYearSpinnerNumberModel);
                this.sldYearFrom.setValue(periodYears.get("MaxPeriodYear"));
                this.sldYearTo.setValue(periodYears.get("MaxPeriodYear"));
                Map periodNumOfYear = FaListFactory.getRemoteInstance().findMinMaxPeriodsOfYear(this.maxPeriodYear.intValue(), periodTypeID);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    startPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    startPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                startPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.sldPeriodFrom.setModel((SpinnerModel)startPeriodSpinnerNumberModel);
                if (this.minPeriodYear.compareTo(this.maxPeriodYear) == 0) {
                    endPeriodSpinnerNumberModel.setMinimum(this.minPeriodStartNumber);
                } else {
                    endPeriodSpinnerNumberModel.setMinimum((Integer)periodNumOfYear.get("MinPeriodNumber"));
                }
                endPeriodSpinnerNumberModel.setMaximum(this.maxPerioEndNumber);
                this.sldPeriodTo.setModel((SpinnerModel)endPeriodSpinnerNumberModel);
                this.sldPeriodFrom.setValue(periodYears.get("MaxPeriodNumber"));
                this.sldPeriodTo.setValue(periodYears.get("MaxPeriodNumber"));
            }
            catch (BOSException ex) {
                this.handUIException(ex);
            }
        }
    }

    private void fireStartYearChange() {
        String periodTypeID = this.currCompany.getAccountPeriodType().getId().toString();
        int periodYear = this.sldYearFrom.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = 1;
            Integer maxPeriod = periodNum;
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (this.minPeriodYear != null && periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodStartNumber;
            }
            if (this.maxPeriodYear != null && periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.sldPeriodFrom.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.sldPeriodFrom.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void fireEndYearChange() {
        String periodTypeID = this.currCompany.getAccountPeriodType().getId().toString();
        int periodYear = this.sldYearTo.getIntegerVlaue();
        try {
            int periodNum = FaListFactory.getRemoteInstance().findPeriodNum(periodYear, periodTypeID);
            Integer minPeriod = 1;
            Integer maxPeriod = periodNum;
            SpinnerNumberModel periodSpinnerNumberModel = new SpinnerNumberModel();
            if (periodYear == this.minPeriodYear) {
                minPeriod = this.minPeriodStartNumber;
            }
            if (periodYear == this.maxPeriodYear) {
                maxPeriod = this.maxPerioEndNumber;
            }
            periodSpinnerNumberModel.setMinimum(minPeriod);
            periodSpinnerNumberModel.setMaximum(maxPeriod);
            this.sldPeriodTo.setModel((SpinnerModel)periodSpinnerNumberModel);
            this.sldPeriodTo.setValue((Object)minPeriod);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void firePeriodChange(ChangeEvent e) {
        int endPeriod;
        int startPeriod = this.sldYearFrom.getIntegerVlaue() * 100 + this.sldPeriodFrom.getIntegerVlaue();
        if (startPeriod > (endPeriod = this.sldYearTo.getIntegerVlaue() * 100 + this.sldPeriodTo.getIntegerVlaue())) {
            if (e.getSource() == this.sldYearFrom || e.getSource() == this.sldPeriodFrom) {
                this.sldYearTo.setValue(this.sldYearFrom.getValue());
                this.sldPeriodTo.setValue(this.sldPeriodFrom.getValue());
            } else {
                this.sldYearFrom.setValue(this.sldYearTo.getValue());
                this.sldPeriodFrom.setValue(this.sldPeriodTo.getValue());
            }
        }
    }

    private void buildCompanIdList(TreeNode root, List idList) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idList.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdList(root.getChildAt(i), idList);
            }
        }
    }

    private void buildCompanIdSet(TreeNode root, Set<String> idSet) {
        if (root == null) {
            return;
        }
        if (root.isLeaf()) {
            idSet.add(((OrgUnitInfo)((DefaultMutableTreeNode)root).getUserObject()).getId().toString());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.buildCompanIdSet(root.getChildAt(i), idSet);
            }
        }
    }
}

