/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.framework.client.ClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.ControlTypeUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.nlm.FaDiscountRateEntryCollection;
import com.kingdee.eas.fi.nlm.FaDiscountRateEntryInfo;
import com.kingdee.eas.fi.nlm.FaDiscountRateFactory;
import com.kingdee.eas.fi.nlm.FaDiscountRateInfo;
import com.kingdee.eas.fi.nlm.client.AbstractFaDiscountRateEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaDiscountRateEditUI
extends AbstractFaDiscountRateEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FaDiscountRateEditUI.class);
    private static final String KEY_LIFECYCLESTART = "lifeCycleStart";
    private static final String KEY_LIFECYCLEEND = "lifeCycleEnd";
    private static final String KEY_RATE = "rate";
    private static final int RATE_PRECISION = 4;
    private static final int LIFECYCLE_PRECISION = 0;
    private static final BigDecimal MAX_LIFECYCLE = new BigDecimal("9999");
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.nlm.FaDiscountRateResource";
    private CompanyOrgUnitInfo curCompany;
    private ClientControlStrategy cStrategy = null;
    private String controlType = null;

    public void onLoad() throws Exception {
        this.kdtEntry.checkParsed();
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws EASBizException, BOSException {
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        FaClientUtils.changeTableNumberFormat((KDTable)this.kdtEntry, (String[])new String[]{KEY_LIFECYCLESTART, KEY_LIFECYCLEEND}, (String)FaClientUtils.getDecimalFormat((int)0));
        FaClientUtils.changeTableNumberFormat((KDTable)this.kdtEntry, (String[])new String[]{KEY_RATE}, (String)FaClientUtils.getDecimalFormat((int)4));
        KDFormattedTextField lifeCycleTxtFeild = new KDFormattedTextField();
        KDFormattedTextField rateTxtFeild = new KDFormattedTextField();
        lifeCycleTxtFeild.setDataType(1);
        lifeCycleTxtFeild.setMinimumValue((Comparable)BigDecimal.ZERO);
        lifeCycleTxtFeild.setPrecision(0);
        rateTxtFeild.setDataType(1);
        rateTxtFeild.setMinimumValue((Comparable)BigDecimal.ZERO);
        rateTxtFeild.setPrecision(4);
        this.kdtEntry.getColumn(KEY_LIFECYCLESTART).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)lifeCycleTxtFeild));
        this.kdtEntry.getColumn(KEY_RATE).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)rateTxtFeild));
        this.btnAddLine.registerKeyboardAction((ActionListener)((Object)this.actionAddLine), KeyStroke.getKeyStroke("ctrl shift A"), 2);
        this.btnDeleteLine.registerKeyboardAction((ActionListener)((Object)this.actionDeleteLine), KeyStroke.getKeyStroke("ctrl shift D"), 2);
        this.initButtonStatus4Enabled();
    }

    protected void initListener() {
        super.initListener();
        this.kdtEntry.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                String endValue;
                if (FaDiscountRateEditUI.this.kdtEntry.getColumnKey(e.getColIndex()).equals(FaDiscountRateEditUI.KEY_LIFECYCLEEND) && (endValue = (String)FaDiscountRateEditUI.this.kdtEntry.getCell(e.getRowIndex(), FaDiscountRateEditUI.KEY_LIFECYCLEEND).getValue()) != null && !FaDiscountRateEditUI.this.isMatchInteger(endValue)) {
                    FaDiscountRateEditUI.this.kdtEntry.getCell(e.getRowIndex(), FaDiscountRateEditUI.KEY_LIFECYCLEEND).setValue(e.getOldValue());
                }
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }

    protected IObjectValue createNewData() {
        FaDiscountRateInfo rateInfo = new FaDiscountRateInfo();
        rateInfo.setDate(new Date());
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        rateInfo.setCompany(aCompanyOrgUnitInfo);
        rateInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        if (aCompanyOrgUnitInfo == null || aCompanyOrgUnitInfo.getId() == null) {
            rateInfo.setIsGroup(true);
        } else {
            rateInfo.setIsGroup(false);
        }
        return rateInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaDiscountRateFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        this.verifyUIValue();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        this.sortEntries();
        super.loadFields();
        if ("VIEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState())) {
            this.formatLifeCycleEndCell();
        }
    }

    private boolean isMatchInteger(String input) {
        if (input != null) {
            return Pattern.matches("\\d+", input);
        }
        return false;
    }

    private void formatLifeCycleEndCell() {
        ICell cell = this.kdtEntry.getCell(this.kdtEntry.getRowCount() - 1, KEY_LIFECYCLEEND);
        if (cell.getValue() instanceof Integer && (Integer)cell.getValue() == 0 || cell.getValue() instanceof Integer && ((Integer)cell.getValue()).intValue() == MAX_LIFECYCLE.intValue() || cell.getValue() instanceof BigDecimal && MAX_LIFECYCLE.compareTo((BigDecimal)cell.getValue()) == 0 || cell.getValue() == null) {
            cell.setValue((Object)"-");
        }
    }

    private void verifyUIValue() {
        String errMsg;
        if (this.datePicker.getValue() == null) {
            errMsg = EASResource.getString((String)RESOURCE_PATH, (String)"dateIsNull");
            MsgBox.showInfo((String)errMsg);
            SysUtil.abort();
        }
        if (this.prmtCurrency.getValue() == null) {
            errMsg = EASResource.getString((String)RESOURCE_PATH, (String)"currencyIsNull");
            MsgBox.showInfo((String)errMsg);
            SysUtil.abort();
        }
        if (this.kdtEntry.getRowCount() <= 0) {
            errMsg = EASResource.getString((String)RESOURCE_PATH, (String)"entryCountIsZero");
            MsgBox.showInfo((String)errMsg);
            SysUtil.abort();
        }
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            BigDecimal rate;
            String errMsg2;
            String errMsg3;
            BigDecimal lifeCycleStart = (BigDecimal)this.kdtEntry.getCell(i, KEY_LIFECYCLESTART).getValue();
            if (lifeCycleStart == null) {
                errMsg3 = EASResource.getString((String)RESOURCE_PATH, (String)"lifeCycleStartIsNull", (Object[])new Integer[]{i + 1});
                MsgBox.showInfo((String)errMsg3);
                SysUtil.abort();
            }
            if (lifeCycleStart.compareTo(BigDecimal.ZERO) <= 0) {
                errMsg3 = EASResource.getString((String)RESOURCE_PATH, (String)"lifeCycleStartIsZero", (Object[])new Integer[]{i + 1});
                MsgBox.showInfo((String)errMsg3);
                SysUtil.abort();
            }
            Object endCellValue = this.kdtEntry.getCell(i, KEY_LIFECYCLEEND).getValue();
            if (this.kdtEntry.getRowCount() > 1 && i != this.kdtEntry.getRowCount() - 1 && (endCellValue == null || "-".equals(endCellValue)) || this.kdtEntry.getRowCount() <= 1 && (endCellValue == null || "-".equals(endCellValue))) {
                String errMsg4 = EASResource.getString((String)RESOURCE_PATH, (String)"lifeCycleEndIsNull", (Object[])new Integer[]{i + 1});
                MsgBox.showInfo((String)errMsg4);
                SysUtil.abort();
            }
            if (endCellValue != null && !"-".equals(endCellValue)) {
                BigDecimal lifeCycleEndBD = null;
                lifeCycleEndBD = endCellValue instanceof BigDecimal ? (BigDecimal)endCellValue : new BigDecimal((String)endCellValue);
                if (lifeCycleEndBD.compareTo(BigDecimal.ZERO) <= 0) {
                    errMsg2 = EASResource.getString((String)RESOURCE_PATH, (String)"lifeCycleEndIsLessThanZero", (Object[])new Integer[]{i + 1});
                    MsgBox.showInfo((String)errMsg2);
                    SysUtil.abort();
                }
            }
            if ((rate = (BigDecimal)this.kdtEntry.getCell(i, KEY_RATE).getValue()) == null) {
                errMsg2 = EASResource.getString((String)RESOURCE_PATH, (String)"rateIsNull", (Object[])new Integer[]{i + 1});
                MsgBox.showInfo((String)errMsg2);
                SysUtil.abort();
            }
            if (rate.compareTo(BigDecimal.ZERO) <= 0) {
                errMsg2 = EASResource.getString((String)RESOURCE_PATH, (String)"discountRateLessThanZero", (Object[])new Integer[]{i + 1});
                MsgBox.showInfo((String)errMsg2);
                SysUtil.abort();
            }
            if (!"-".equals(endCellValue) && endCellValue != null) {
                BigDecimal lifeCycleEndBD = null;
                lifeCycleEndBD = endCellValue instanceof BigDecimal ? (BigDecimal)endCellValue : new BigDecimal((String)endCellValue);
                if (lifeCycleStart.compareTo(lifeCycleEndBD) > 0) {
                    String errMsg5 = EASResource.getString((String)RESOURCE_PATH, (String)"lifeCycleStartLargeThanLifeCycleEnd", (Object[])new Integer[]{i + 1});
                    MsgBox.showInfo((String)errMsg5);
                    SysUtil.abort();
                }
            }
            if (i - 1 < 0) continue;
            Object lastEndCellValue = this.kdtEntry.getCell(i - 1, KEY_LIFECYCLEEND).getValue();
            BigDecimal lastLifeCycleEndBD = null;
            lastLifeCycleEndBD = lastEndCellValue instanceof BigDecimal ? (BigDecimal)lastEndCellValue : new BigDecimal((String)lastEndCellValue);
            if (lifeCycleStart.compareTo(lastLifeCycleEndBD) >= 1) continue;
            String errMsg6 = EASResource.getString((String)RESOURCE_PATH, (String)"lifeCycleStartLessThanLastLifeCycleEnd", (Object[])new Integer[]{i + 1});
            MsgBox.showInfo((String)errMsg6);
            SysUtil.abort();
        }
    }

    private void sortEntries() {
        if (this.editData == null) {
            return;
        }
        FaDiscountRateEntryCollection entries = this.editData.getEntry();
        FaDiscountRateEntryCollection newEntries = new FaDiscountRateEntryCollection();
        Object[] infoArr = entries.toArray();
        for (int i = 0; i < infoArr.length; ++i) {
            for (int j = 0; j < infoArr.length - i - 1; ++j) {
                FaDiscountRateEntryInfo entry1 = (FaDiscountRateEntryInfo)infoArr[j];
                FaDiscountRateEntryInfo entry2 = (FaDiscountRateEntryInfo)infoArr[j + 1];
                if (entry1.getLifeCycleStart().compareTo(entry2.getLifeCycleStart()) != 1) continue;
                infoArr[j + 1] = entry1;
                infoArr[j] = entry2;
            }
        }
        for (Object o : infoArr) {
            FaDiscountRateEntryInfo info = (FaDiscountRateEntryInfo)o;
            newEntries.add(info);
        }
        this.editData.put("entry", (Object)newEntries);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FaDiscountRateEntryInfo entry;
        String errMsg;
        if (this.editData.getDate() == null) {
            errMsg = EASResource.getString((String)RESOURCE_PATH, (String)"needManualInputDate");
            MsgBox.showInfo((String)errMsg);
            SysUtil.abort();
        }
        if (this.editData.getCurrency() == null) {
            errMsg = EASResource.getString((String)RESOURCE_PATH, (String)"needManualInputCurrency");
            MsgBox.showInfo((String)errMsg);
            SysUtil.abort();
        }
        if ((entry = this.editData.getEntry().get(this.editData.getEntry().size() - 1)).getLifeCycleEnd() == null) {
            entry.setLifeCycleEnd(MAX_LIFECYCLE);
        }
    }

    private ClientControlStrategy getStrategy() {
        if (this.cStrategy != null) {
            return this.cStrategy;
        }
        String controlType = this.getControlType();
        this.cStrategy = ClientControlStrategy.create((String)controlType, null);
        return this.cStrategy;
    }

    private String getControlType() {
        try {
            if (this.controlType == null) {
                this.controlType = ControlTypeUtil.getControlType((BOSObjectType)this.getBizType());
            }
            return this.controlType;
        }
        catch (Exception e) {
            return "";
        }
    }

    private void checkPermission(String action, String cuID) throws Exception {
        this.getStrategy().checkPermission(action, cuID);
    }

    protected CompanyOrgUnitInfo getCurCompany() throws BOSException, EASBizException {
        if (this.curCompany == null) {
            this.curCompany = FaClientUtils.getCurrentCompany();
        }
        return this.curCompany;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.kdtEntry.addRow();
        }
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.kdtEntry.getSelectManager().get();
        if (selectBlock == null) {
            if (this.kdtEntry.getRowCount() > 0) {
                this.kdtEntry.removeRow(this.kdtEntry.getRowCount() - 1);
            }
        } else {
            this.kdtEntry.removeRow(selectBlock.getTop());
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_MODIFY", this.editData.getId().toString());
        super.actionEdit_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_ADDNEW", this.editData.getId() == null ? null : this.editData.getId().toString());
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_ADDNEW", this.editData.getId() == null ? null : this.editData.getId().toString());
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.setOprtState("ADDNEW");
        this.setDataObject(this.createNewData());
        this.loadFields();
        this.unLockUI();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        return sic;
    }

    private void initButtonStatus4Enabled() {
        if (this.editData == null) {
            return;
        }
        OrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentOrgUnit();
        if (!currentCompany.getId().toString().equals(this.editData.getCompany().getId().toString())) {
            this.btnAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.btnCopy.setVisible(false);
            this.btnSubmit.setVisible(false);
        }
    }
}

