/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.nlm.DepreciationMethodEnum;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptFactory;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseNewDepCostSharingFactory;
import com.kingdee.eas.fi.nlm.FaLeaseSourceTypeEnum;
import com.kingdee.eas.fi.nlm.FaLiabilitiesCvMethodEnum;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyFactory;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyInfo;
import com.kingdee.eas.fi.nlm.IFaAmortizedCostRpt;
import com.kingdee.eas.fi.nlm.IFaLeaseInBillNew;
import com.kingdee.eas.fi.nlm.client.AbstractFaLeaseInNewRepairToolUI;
import com.kingdee.eas.fi.nlm.client.NLMPatternReplaceUI;
import com.kingdee.eas.fi.nlm.client.NLMRecalculateAccountBalanceUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaLeaseInNewRepairToolUI
extends AbstractFaLeaseInNewRepairToolUI {
    private static final Logger logger = CoreUIObject.getLogger(FaLeaseInNewRepairToolUI.class);
    private CompanyOrgUnitInfo currentCompany = null;
    private ArrayList loadCardIds;
    private String view;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setPreferredSize(new Dimension(460, 500));
        this.remainingLiabilityRepairToolButton.setEnabled(true);
        this.kdTabbedPaneOne.setSelectedIndex(0);
        this.loadCardIds = (ArrayList)this.getUIContext().get("CardIDs");
        this.view = (String)this.getUIContext().get("view");
        if ("leaseBill".equals(this.view)) {
            this.remainingLiabilityRepairToolButton.setEnabled(true);
            this.amortizedCostRepairToolButton.setEnabled(false);
            this.currentPeriodDepRepairToolButton.setEnabled(false);
        } else if ("depBill".equals(this.view)) {
            this.remainingLiabilityRepairToolButton.setEnabled(false);
            this.amortizedCostRepairToolButton.setEnabled(false);
            this.currentPeriodDepRepairToolButton.setEnabled(true);
        } else {
            this.remainingLiabilityRepairToolButton.setEnabled(false);
            this.amortizedCostRepairToolButton.setEnabled(false);
            this.currentPeriodDepRepairToolButton.setEnabled(false);
        }
        this.calcAllBalanceButton.setEnabled(true);
        this.matchToolButton.setEnabled(true);
        this.getCurrentCompany();
        this.kDLabel6.setText(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"250_FaLeaseInNewRepairToolUI"));
        this.kDLabel6.setBounds(35, 31, 160, 19);
    }

    @Override
    public void actionACRepairTool_actionPerformed(ActionEvent e) throws Exception {
        this.logTextArea.setText(null);
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"251_FaLeaseInNewRepairToolUI")))) {
            this.logTextArea.append(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"252_FaLeaseInNewRepairToolUI"));
            this.logTextArea.append(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"253_FaLeaseInNewRepairToolUI") + this.loadCardIds.size() + "\n");
            this.logTextArea.paintImmediately(this.logTextArea.getBounds());
            int j = this.loadCardIds.size();
            for (int i = 0; i < j; ++i) {
                double startTime = System.currentTimeMillis();
                String leaseBillId = this.loadCardIds.get(i).toString();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("contractCat.id");
                sic.add("contractCat.name");
                sic.add("currency.id");
                sic.add("currency.name");
                sic.add("company.id");
                sic.add("company.name");
                sic.add("company.baseCurrency.precision");
                sic.add("paymentEntry.*");
                sic.add("exchangeRate.*");
                sic.add("exchangeRate.exchangeAux.*");
                IFaLeaseInBillNew leaseInBillInstance = FaLeaseInBillNewFactory.getRemoteInstance();
                FaLeaseInBillNewInfo leaseBillInfo = leaseInBillInstance.getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(leaseBillId), sic);
                this.logTextArea.append(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"254_FaLeaseInNewRepairToolUI") + leaseBillInfo.getNumber() + "\n");
                this.logTextArea.paintImmediately(this.logTextArea.getBounds());
                int currencyPrecision = this.getCurrencyScale(leaseBillInfo.getCompany());
                int currencyPrecisionOC = leaseBillInfo.getCurrency().getPrecision();
                boolean isInitBill = leaseBillInfo.isIsHistory();
                boolean isEnableStockContract = FaManageUtils.getFaParamValue(null, (String)"NLM_HIDE_001", (String)leaseBillInfo.getCompany().getId().toString());
                boolean isDiscount2ImplDate = FaManageUtils.getIntFaParamValue(null, (String)"NLM_303", (String)leaseBillInfo.getCompany().getId().toString()) == 0;
                BigDecimal initAsset = BigDecimal.ZERO;
                BigDecimal initAccDepreciation = BigDecimal.ZERO;
                IFaAmortizedCostRpt iFaAmortizedCostRpt = FaAmortizedCostRptFactory.getRemoteInstance();
                if (isInitBill && isEnableStockContract && !isDiscount2ImplDate) {
                    FaAmortizedCostRptInfo stockACRptInfo = iFaAmortizedCostRpt.calc4StockContract(leaseBillInfo);
                    initAsset = stockACRptInfo.getEntry().get(stockACRptInfo.getEntry().size() - 1).getInitRightOfUseAsset();
                    leaseBillInfo.setInitialAsset(initAsset);
                    if (leaseBillInfo.getBeginDate().compareTo(leaseBillInfo.getDpInitCfmDate()) < 0) {
                        if (leaseBillInfo.getDepreciationMethod() == DepreciationMethodEnum.First) {
                            int depDateAmt = FaManageUtils.subDate((Date)leaseBillInfo.getEndDate(), (Date)leaseBillInfo.getBeginDate()) + 1;
                            int beforeDepDateAmt = FaManageUtils.subDate((Date)leaseBillInfo.getDpInitCfmDate(), (Date)leaseBillInfo.getBeginDate());
                            BigDecimal dayDep = leaseBillInfo.getInitialAsset().divide(new BigDecimal(depDateAmt), currencyPrecision, 4);
                            initAccDepreciation = new BigDecimal(beforeDepDateAmt).multiply(dayDep);
                        } else {
                            int beforeTimeCycle = FaManageUtils.subMonth((Date)leaseBillInfo.getDpInitCfmDate(), (Date)leaseBillInfo.getBeginDate());
                            BigDecimal monthDep = leaseBillInfo.getInitialAsset().divide(new BigDecimal(leaseBillInfo.getTimeCycle()), currencyPrecision, 4);
                            initAccDepreciation = new BigDecimal(beforeTimeCycle).multiply(monthDep);
                        }
                    }
                }
                leaseBillInfo.setInitialAsset(initAsset);
                leaseBillInfo.setInitAccDepreciation(initAccDepreciation);
                if (leaseBillInfo.getSourceType() == FaLeaseSourceTypeEnum.ASSET_CHANGE_CREAT) {
                    iFaAmortizedCostRpt.calc4Adjustment(leaseBillInfo);
                } else {
                    iFaAmortizedCostRpt.calc(leaseBillInfo);
                }
                double endTime = System.currentTimeMillis();
                double timeConsume = (endTime - startTime) / 1000.0;
                this.logTextArea.append(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"255_FaLeaseInNewRepairToolUI") + (i + 1) + "/" + this.loadCardIds.size() + EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"256_FaLeaseInNewRepairToolUI") + timeConsume + EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"257_FaLeaseInNewRepairToolUI"));
                this.logTextArea.paintImmediately(this.logTextArea.getBounds());
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"258_FaLeaseInNewRepairToolUI"));
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionReLiabilityRepairTool_actionPerformed(ActionEvent e) throws Exception {
        this.logTextArea.setText(null);
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"251_FaLeaseInNewRepairToolUI")))) {
            this.logTextArea.append(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"259_FaLeaseInNewRepairToolUI"));
            this.logTextArea.append(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"253_FaLeaseInNewRepairToolUI") + this.loadCardIds.size() + "\n");
            this.logTextArea.paintImmediately(this.logTextArea.getBounds());
            int count = 1;
            for (Object loadCardId : this.loadCardIds) {
                double startTime = System.currentTimeMillis();
                String leaseBillId = loadCardId.toString();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("contractCat.id");
                sic.add("contractCat.name");
                sic.add("currency.id");
                sic.add("currency.name");
                sic.add("company.id");
                sic.add("company.name");
                sic.add("company.baseCurrency.precision");
                sic.add("paymentEntry.*");
                sic.add("exchangeRate.*");
                sic.add("exchangeRate.exchangeAux.*");
                IFaLeaseInBillNew leaseInBillInstance = FaLeaseInBillNewFactory.getRemoteInstance();
                FaLeaseInBillNewInfo leaseBillInfo = leaseInBillInstance.getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(leaseBillId), sic);
                this.logTextArea.append(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"254_FaLeaseInNewRepairToolUI") + leaseBillInfo.getNumber() + "\n");
                this.logTextArea.paintImmediately(this.logTextArea.getBounds());
                int currencyPrecision = this.getCurrencyScale(leaseBillInfo.getCompany());
                int currencyPrecisionOC = leaseBillInfo.getCurrency().getPrecision();
                boolean isInitBill = leaseBillInfo.isIsHistory();
                boolean isEnableStockContract = FaManageUtils.getFaParamValue(null, (String)"NLM_HIDE_001", (String)leaseBillInfo.getCompany().getId().toString());
                boolean isDiscount2ImplDate = FaManageUtils.getIntFaParamValue(null, (String)"NLM_303", (String)leaseBillInfo.getCompany().getId().toString()) == 0;
                Double exchangeRateInfo = new Double(leaseBillInfo.getExchangeRateValue().toString());
                if (leaseBillInfo.getExchangeRate() != null && leaseBillInfo.getExchangeRate().getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
                    exchangeRateInfo = 1.0 / exchangeRateInfo;
                }
                BigDecimal remainingLiabilityTmpOne = leaseBillInfo.getInitialLiability().multiply(this.db2BD(exchangeRateInfo));
                BigDecimal remainingLiabilityTmpTwo = leaseBillInfo.getUnrecognizedFinanceFee().multiply(this.db2BD(exchangeRateInfo));
                FaNewLeasePolicyInfo newLeasePolicy = FaNewLeasePolicyFactory.getRemoteInstance().getEnabledNewLeasePolicy(leaseBillInfo.getCompany().getId().toString());
                double discountRate = this.calcDiscountRate(leaseBillInfo, newLeasePolicy);
                double advNPV = this.calcAdvPaymentNPV(leaseBillInfo, discountRate);
                double idfCost = exchangeRateInfo * this.BD2db(leaseBillInfo.isIsDeductible() ? leaseBillInfo.getCostPmWithoutTaxOC2() : leaseBillInfo.getCostPmWithTaxOC2());
                double riCost = exchangeRateInfo * this.BD2db(leaseBillInfo.isIsDeductible() ? leaseBillInfo.getCostPmWithoutTaxOC7() : leaseBillInfo.getCostPmWithTaxOC7());
                double stampTaxStM = new Double(leaseBillInfo.getStampTaxStM() == null ? "0" : leaseBillInfo.getStampTaxStM().toString());
                double rcvNPV = new Double("0");
                if (leaseBillInfo.getCostPmWithTaxOC6() != null) {
                    int subDates = this.subDate(leaseBillInfo.getCostDate6(), leaseBillInfo.getBeginDate()) + 1;
                    rcvNPV = exchangeRateInfo * this.BD2db(leaseBillInfo.getCostPmWithTaxOC6());
                    rcvNPV = this.calcCostNPV(rcvNPV, discountRate, subDates);
                }
                BigDecimal remainingLiabilityTmp = this.db2BD(idfCost + advNPV + stampTaxStM + rcvNPV - riCost);
                BigDecimal remainingLiability = remainingLiabilityTmpOne.add(leaseBillInfo.getInitAccDepreciation()).subtract(leaseBillInfo.getInitialAsset()).subtract(remainingLiabilityTmpTwo).add(remainingLiabilityTmp);
                remainingLiability = remainingLiability.setScale(currencyPrecision, 4);
                if (isInitBill && isEnableStockContract && isDiscount2ImplDate) {
                    remainingLiability = BigDecimal.ZERO;
                }
                BigDecimal surplusReserve = remainingLiability.multiply(new BigDecimal("0.1")).setScale(currencyPrecision, 4);
                BigDecimal undistributedProfit = remainingLiability.multiply(new BigDecimal("0.9")).setScale(currencyPrecision, 4);
                String updateSQL = " UPDATE T_FA_FaLeaseInBillNew SET FRemainingLiability = " + this.BD2db(remainingLiability) + ", FSurplusReserve = " + this.BD2db(surplusReserve) + ", FUndistributedProfit = " + this.BD2db(undistributedProfit) + " WHERE FID = '" + leaseBillId + "'";
                try {
                    SQLExecutorFactory.getRemoteInstance((String)updateSQL).executeSQL();
                }
                catch (Exception exception) {
                    logger.error((Object)("updateFRemainingLiability\uff1a" + exception.getMessage()));
                }
                double endTime = System.currentTimeMillis();
                double timeConsume = (endTime - startTime) / 1000.0;
                this.logTextArea.append(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"255_FaLeaseInNewRepairToolUI") + count++ + "/" + this.loadCardIds.size() + EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"256_FaLeaseInNewRepairToolUI") + timeConsume + EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"257_FaLeaseInNewRepairToolUI"));
                this.logTextArea.paintImmediately(this.logTextArea.getBounds());
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"260_FaLeaseInNewRepairToolUI"));
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionPeriodDepRepairTool_actionPerformed(ActionEvent e) throws Exception {
        this.logTextArea.setText(null);
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"251_FaLeaseInNewRepairToolUI")))) {
            this.logTextArea.append(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"261_FaLeaseInNewRepairToolUI"));
            this.logTextArea.paintImmediately(this.logTextArea.getBounds());
            ArrayList<String> depBills = new ArrayList<String>();
            double startTime = System.currentTimeMillis();
            for (Object loadCardId : this.loadCardIds) {
                String depBillId = loadCardId.toString();
                boolean isExists = FaLeaseNewDepCostSharingFactory.getRemoteInstance().exists("where head = '" + depBillId + "'");
                if (isExists) continue;
                depBills.add(depBillId);
            }
            FaLeaseNewDepCostSharingFactory.getRemoteInstance().autoSaveFaLeaseNewDepCostSharing(null, depBills);
            double endTime = System.currentTimeMillis();
            double timeConsume = (endTime - startTime) / 1000.0;
            this.logTextArea.append(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"262_FaLeaseInNewRepairToolUI") + timeConsume + EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"257_FaLeaseInNewRepairToolUI"));
            this.logTextArea.paintImmediately(this.logTextArea.getBounds());
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"263_FaLeaseInNewRepairToolUI"));
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionCalcAllBalance_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
        PeriodInfo initPeriod = FaClientUtils.getFLStartPeriod((CompanyOrgUnitInfo)curCompany);
        PeriodInfo curPeriod = FaClientUtils.getFLCurrentPeriod((CompanyOrgUnitInfo)curCompany);
        PeriodInfo latestPeriod = null;
        IRowSet latestPeriodResult = SQLExecutorFactory.getRemoteInstance((String)("SELECT leaseBill.FNUMBER leaseBillNumber, period.fnumber periodNumber, period.fid periodFid FROM T_FA_FaLeaseInBillNew leaseBill left join T_BD_PERIOD period on FPERIODID = period.FID where FCompanyID = '" + curCompany.getId().toString() + "' and FCheckedStatus = 2 order by period.FNUMBER desc \n")).executeSQL();
        if (latestPeriodResult.next()) {
            latestPeriod = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(latestPeriodResult.getString("periodFid")));
        }
        if (latestPeriod == null || latestPeriod.getNumber() < curPeriod.getNumber()) {
            latestPeriod = curPeriod;
        }
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"curCompany", (Object)curCompany);
        uiContext.put((Object)"initPeriod", (Object)initPeriod);
        uiContext.put((Object)"curPeriod", (Object)curPeriod);
        uiContext.put((Object)"latestPeriod", (Object)latestPeriod);
        uiContext.put((Object)"isRepairTool", (Object)true);
        IUIWindow modelWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NLMRecalculateAccountBalanceUI.class.getName(), (Map)uiContext, null, null);
        modelWindow.show();
    }

    @Override
    public void actionMatchToolButton_actionPerformed(ActionEvent e) throws Exception {
        UIContext modelContext = new UIContext();
        modelContext.put((Object)"CardIDs", (Object)"");
        IUIWindow modelWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NLMPatternReplaceUI.class.getName(), (Map)modelContext, null, OprtState.ADDNEW);
        modelWindow.show();
    }

    private CompanyOrgUnitInfo getCurrentCompany() {
        if (this.currentCompany == null) {
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("accountPeriodType.id"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("reportCurrency.id"));
            sic.add(new SelectorItemInfo("reportCurrency.number"));
            sic.add(new SelectorItemInfo("reportCurrency.name"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            sic.add(new SelectorItemInfo("reportExchangeTable.id"));
            try {
                this.currentCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)), sic);
            }
            catch (Exception e) {
                this.handleException(e);
                SysUtil.abort();
            }
        }
        return this.currentCompany;
    }

    private int getCurrencyScale(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency = company.getBaseCurrency();
        if (currency != null && currency.get("precision") != null) {
            return currency.getPrecision();
        }
        if (currency == null || currency.getId() == null) {
            CompanyOrgUnitInfo _comp = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select baseCurrency.precision where id='" + company.getId() + "'");
            return _comp.getBaseCurrency().getPrecision();
        }
        return CurrencyFactory.getRemoteInstance().getValue("select precision where id='" + company.getBaseCurrency().getId() + "'").getInt("precision");
    }

    private double calcAdvPaymentNPV(FaLeaseInBillNewInfo billInfo, double dayRate) {
        if (billInfo.getCostDate1() == null || billInfo.getCostPmWithTaxOC1() == null) {
            return new Double("0");
        }
        if (billInfo.getCostDate1().compareTo(billInfo.getBeginDate()) <= 0) {
            return this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTaxOC1() : billInfo.getCostPmWithTaxOC1());
        }
        int advDates = this.subDate(billInfo.getCostDate1(), billInfo.getBeginDate()) + 1;
        double advPaymentNPV = this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTaxOC1() : billInfo.getCostPmWithTaxOC1()) / Math.pow(new Double("1") + dayRate, advDates);
        return advPaymentNPV;
    }

    private double BD2db(BigDecimal bd) {
        return bd == null ? new Double("0").doubleValue() : bd.doubleValue();
    }

    private int subDate(Date date1, Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        cld1.set(cld1.get(1), cld1.get(2), cld1.get(5), 0, 0, 0);
        cld2.set(cld2.get(1), cld2.get(2), cld2.get(5), 0, 0, 0);
        return (int)((cld1.getTimeInMillis() - cld2.getTimeInMillis()) / 86400000L);
    }

    private double calcDiscountRate(FaLeaseInBillNewInfo billInfo, FaNewLeasePolicyInfo newLeasePolicy) {
        double discountRate;
        int interestCalcMethod = newLeasePolicy.getInterestCalculationMethod().getValue();
        if (newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY) {
            discountRate = interestCalcMethod == 1 ? Math.pow(this.BD2db(billInfo.getDiscountRate()) / new Double("100") + new Double("1"), new Double("1") / new Double("365")) - new Double("1") : this.BD2db(billInfo.getDiscountRate()) / new Double("100") / new Double("365");
        } else {
            Double N;
            switch (billInfo.getPayFrequency().getValue()) {
                case 0: {
                    N = new Double("1");
                    break;
                }
                case 1: {
                    N = new Double("1") / new Double("2");
                    break;
                }
                case 2: {
                    N = new Double("1") / new Double("4");
                    break;
                }
                case 3: {
                    N = new Double("1") / new Double("12");
                    break;
                }
                case 5: {
                    N = new Double("1");
                    break;
                }
                default: {
                    N = new Double("1");
                }
            }
            discountRate = interestCalcMethod == 3 ? Math.pow(this.BD2db(billInfo.getDiscountRate()) / new Double("100") + new Double("1"), N) - new Double("1") : this.BD2db(billInfo.getDiscountRate()) / new Double("100") * N;
        }
        return discountRate;
    }

    private BigDecimal db2BD(double d) {
        return new BigDecimal(String.valueOf(d));
    }

    private double calcCostNPV(double cost, double periodDiscountRate, int timeCycle) {
        return cost / Math.pow(new Double("1") + periodDiscountRate, timeCycle);
    }
}

