/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.rpt.FaDaoSqlObject;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.IFaList;
import com.kingdee.eas.fi.fa.rpt.client.TreeColumn;
import com.kingdee.eas.fi.nlm.FaContractCatInfo;
import com.kingdee.eas.fi.nlm.FaLeaseAmountDisplayTypeEnum;
import com.kingdee.eas.fi.nlm.FaLeaseBizStatusEnum;
import com.kingdee.eas.fi.nlm.FaLeaseRptDataTypeEnum;
import com.kingdee.eas.fi.nlm.client.AbstractFaLeaseLiabilitiesRptListUI;
import com.kingdee.eas.fi.nlm.client.FaLeaseInNewEditUI;
import com.kingdee.eas.fi.nlm.client.FaLeaseLiabilitiesRptCondUI;
import com.kingdee.eas.fi.nlm.client.FaRptQueryPanel;
import com.kingdee.eas.fi.nlm.util.FaLeaseLiabilitiesRptUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaLeaseLiabilitiesRptListUI
extends AbstractFaLeaseLiabilitiesRptListUI {
    private static final Logger logger = CoreUIObject.getLogger(FaLeaseLiabilitiesRptListUI.class);
    private static final String COMPANY = "company";
    private static final String CURRENCY = "currency";
    private static final String LESSOR_TYPE = "lessorType";
    private static final String LESSOR_NAME = "lessorName";
    private String company;
    private Date startDate;
    private Date endDate;
    private FaContractCatInfo contractType;
    private String leaseBillNumber;
    private String contractNumber;
    private FaLeaseRptDataTypeEnum rptDataType;
    private FaLeaseAmountDisplayTypeEnum amountDisplayType;
    private boolean isByCompany;
    private boolean isByCurrency;
    private boolean isByPersonType;
    private boolean isByPerson;
    private String[] dateColumnArray;
    private ArrayList<String> summaryColumnLists;
    private BigDecimal[] summaryAmountArrays;
    private ArrayList<BigDecimal[]> summarySubAmountList;
    private String[] perRowsSummaryHelpArrays;
    private int summaryRowsTotalVirtualMode = 0;
    private int tempTableTotal;
    private int curTempTableNum = 0;
    private int[] summaryRowsStartIndex;
    private int basePrecision = 2;
    public static String NLM_REPORT_EXPORT = "fa_leaseliabilitiesrpt_export";

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnViewCard.setEnabled(true);
        this.lblPeriod.setVisible(false);
    }

    @Override
    protected void applyData(Map result) throws Exception {
        this.basePrecision = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currCompany.getBaseCurrency().getId())).getPrecision();
        this.result = result;
        this.resultSql = (FaDaoSqlObject)result.get("resultSql");
        if (result.get("tempTableName") != null) {
            this.tempTableName = result.get("tempTableName").toString();
        }
        this.tempTableTotal = (Integer)result.get("tempTableTotal");
        this.initTableColumn(null);
        this.formatData();
        if (this.isVirtualMode()) {
            this.treeIdList = null;
            this.allIdList = null;
            this.firstLoadData = true;
            this.tblMain.removeRows();
        } else {
            IFaList manager = FaListFactory.getRemoteInstance();
            JdbcRowSet data = (JdbcRowSet)manager.getDataForFirst(this.resultSql, this.tempTableTotal);
            this.tblMain.removeRows();
            if (data != null) {
                this.fillDataToTable((IRowSet)data, 0);
            }
        }
    }

    @Override
    protected boolean isVirtualMode() {
        return false;
    }

    @Override
    protected void fillDataToTable(IRowSet rows, int start) throws Exception {
        if (rows == null) {
            return;
        }
        KDTColumns cols = this.tblMain.getColumns();
        int rowIndex = start + this.summaryRowsTotalVirtualMode;
        rows.beforeFirst();
        while (rows.next()) {
            int i;
            int j = this.summaryColumnLists.size();
            for (i = 0; i < j; ++i) {
                String curRowsSummaryColumn = rows.getObject(this.summaryColumnLists.get(i)) == null ? "" : (String)rows.getObject(this.summaryColumnLists.get(i));
                String curRowsSummaryPreColumn = "";
                if (i != 0) {
                    String string = curRowsSummaryPreColumn = rows.getObject(this.summaryColumnLists.get(i - 1)) == null ? "" : (String)rows.getObject(this.summaryColumnLists.get(i - 1));
                }
                if (rowIndex == 0 || curRowsSummaryColumn.equals(this.perRowsSummaryHelpArrays[i]) || i != 0 && !curRowsSummaryPreColumn.equals(this.perRowsSummaryHelpArrays[i - 1])) continue;
                for (int p = this.summaryColumnLists.size() - 1; p >= i; --p) {
                    this.insertSubTotalRow(rowIndex, p, cols);
                    ++rowIndex;
                    ++this.summaryRowsTotalVirtualMode;
                    this.summaryRowsStartIndex[p] = this.curTempTableNum + this.summaryRowsTotalVirtualMode + p;
                }
            }
            this.insertRow(rowIndex, rows, cols);
            ++rowIndex;
            ++this.curTempTableNum;
            j = 0;
            for (i = this.summaryColumnLists.size() - 1; i >= j; --i) {
                this.perRowsSummaryHelpArrays[i] = rows.getObject(this.summaryColumnLists.get(i)) == null ? "" : (String)rows.getObject(this.summaryColumnLists.get(i));
            }
            this.summaryAmountArrays[0] = (rows.getObject("initialMoney") == null ? new BigDecimal("0") : (BigDecimal)rows.getObject("initialMoney")).add(this.summaryAmountArrays[0] == null ? new BigDecimal("0") : this.summaryAmountArrays[0]);
            j = this.dateColumnArray.length;
            for (i = 0; i < j; ++i) {
                this.summaryAmountArrays[i + 1] = ((BigDecimal)rows.getObject("a" + this.dateColumnArray[i].replace('-', 'a'))).add(this.summaryAmountArrays[i + 1] == null ? new BigDecimal("0") : this.summaryAmountArrays[i + 1]);
            }
            j = this.summaryColumnLists.size();
            for (i = 0; i < j; ++i) {
                BigDecimal[] bigDecimals = this.summarySubAmountList.get(i);
                bigDecimals[0] = (rows.getObject("initialMoney") == null ? new BigDecimal("0") : (BigDecimal)rows.getObject("initialMoney")).add(bigDecimals[0] == null ? new BigDecimal("0") : bigDecimals[0]);
                int m = this.dateColumnArray.length;
                for (int n = 0; n < m; ++n) {
                    bigDecimals[n + 1] = ((BigDecimal)rows.getObject("a" + this.dateColumnArray[n].replace('-', 'a'))).add(bigDecimals[n + 1] == null ? new BigDecimal("0") : bigDecimals[n + 1]);
                }
            }
            if (this.curTempTableNum != this.tempTableTotal) continue;
            for (int p = this.summaryColumnLists.size() - 1; p >= 0; --p) {
                this.insertSubTotalRow(rowIndex, p, cols);
                this.tblMain.getMergeManager().mergeBlock(this.summaryRowsStartIndex[p], p, rowIndex - 1, p);
                ++rowIndex;
                ++this.summaryRowsTotalVirtualMode;
            }
            this.insertTotalRow(rowIndex, cols);
            ++rowIndex;
            ++this.summaryRowsTotalVirtualMode;
        }
        this.tblMain.setRowCount(this.tempTableTotal + this.summaryRowsTotalVirtualMode);
    }

    @Override
    protected void initTableColumn(List sumColumnNames) {
        this.tblMain.checkParsed(true);
        this.initConditionField(this.getCustomCond());
        this.summaryColumnLists = this.initSummaryColumn();
        this.initDateColumnArray();
        this.initDateColumn();
        this.summaryAmountArrays = new BigDecimal[this.dateColumnArray.length + 1];
        if (this.summaryColumnLists.size() != 0) {
            this.perRowsSummaryHelpArrays = new String[this.summaryColumnLists.size()];
            this.tblMain.getGroupManager().setGroup(true);
            for (String summaryColumnList : this.summaryColumnLists) {
                this.tblMain.getColumn(summaryColumnList).setMergeable(true);
                this.tblMain.getColumn(summaryColumnList).setGroup(true);
            }
        }
        this.summaryRowsStartIndex = new int[this.summaryColumnLists.size()];
        this.summarySubAmountList = new ArrayList();
        int j = this.summaryColumnLists.size();
        for (int i = 0; i < j; ++i) {
            this.summarySubAmountList.add(new BigDecimal[this.dateColumnArray.length + 1]);
        }
        this.summaryRowsTotalVirtualMode = 0;
        this.curTempTableNum = 0;
        FaUtils.freezeTable((KDTable)this.tblMain, (int)11);
        this.tblMain.getColumn("initialMoney").getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat((int)this.basePrecision));
    }

    @Override
    protected void initUserConfig() {
        super.initUserConfig();
        this.tHelper.restoreDefault(this.tblMain);
    }

    @Override
    protected TreeColumn getTreeColumn() {
        return null;
    }

    @Override
    protected void initCommonQueryDialog() throws Exception {
        super.initCommonQueryDialog();
        this.commonQueryDialog.setHeight(550);
        this.commonQueryDialog.setWidth(522);
    }

    @Override
    protected boolean isShowFilter() {
        return true;
    }

    @Override
    protected boolean isShowSorter() {
        return true;
    }

    @Override
    protected PeriodInfo getProperStrartPeriodInfo() throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.currCompany);
    }

    @Override
    protected boolean isAllowVirtualOrg() {
        return true;
    }

    @Override
    protected void displayPeriodInfo() {
    }

    @Override
    protected FaRptQueryPanel getConditionUI() throws Exception {
        return new FaLeaseLiabilitiesRptCondUI();
    }

    @Override
    protected String getQueryName() {
        return "FaLeaseLiabilitiesQuery";
    }

    @Override
    protected String getDaoClassName() {
        return "FaLeaseLiabilitiesListDao";
    }

    @Override
    public void actionViewCard_actionPerformed(ActionEvent e) throws Exception {
        int selectRow;
        if (this.tblMain.getSelectManager().get() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((selectRow = this.tblMain.getSelectManager().get().getBeginRow()) == -1) {
            return;
        }
        ICell cardIdCell = this.tblMain.getRow(selectRow).getCell("FID");
        if (cardIdCell == null || cardIdCell.getValue() == null) {
            return;
        }
        String cardId = cardIdCell.getValue().toString();
        if (cardId != null && !cardId.trim().equals("")) {
            try {
                Map uiContext = this.getUIContext();
                uiContext.put("ID", cardId);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FaLeaseInNewEditUI.class.getName(), uiContext, null, "FINDVIEW");
                uiWindow.show();
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    private void initConditionField(Map conditionMap) {
        this.company = (String)conditionMap.get("def_company_id");
        this.startDate = (Date)conditionMap.get("startDate");
        this.startDatePicker.setValue((Object)this.startDate);
        this.endDate = (Date)conditionMap.get("endDate");
        this.endDatePicker.setValue((Object)this.endDate);
        this.contractType = (FaContractCatInfo)conditionMap.get("contractType");
        this.leaseBillNumber = (String)conditionMap.get("leaseBillNumber");
        this.contractNumber = (String)conditionMap.get("contractNumber");
        this.rptDataType = (FaLeaseRptDataTypeEnum)((Object)conditionMap.get("rptDataType"));
        this.amountDisplayType = (FaLeaseAmountDisplayTypeEnum)((Object)conditionMap.get("amountDisplayType"));
        this.isByCompany = (Boolean)conditionMap.get("isByCompany");
        this.isByCurrency = (Boolean)conditionMap.get("isByCurrency");
        this.isByPersonType = (Boolean)conditionMap.get("isByPersonType");
        this.isByPerson = (Boolean)conditionMap.get("isByPerson");
    }

    private void initDateColumnArray() {
        Date currentDate = this.startDate;
        Date endDate = this.endDate;
        FaLeaseAmountDisplayTypeEnum amountDisplayType = this.amountDisplayType;
        if (amountDisplayType == FaLeaseAmountDisplayTypeEnum.BY_MONTH) {
            int subMonths = FaLeaseLiabilitiesRptUtil.subMonth(endDate, currentDate);
            this.dateColumnArray = new String[subMonths + 1];
            this.dateColumnArray[0] = FaLeaseLiabilitiesRptUtil.changeDateToString(FaLeaseLiabilitiesRptUtil.getMaxMonthDate(currentDate));
            for (int i = 1; i < subMonths + 1; ++i) {
                currentDate = FaLeaseLiabilitiesRptUtil.getNextEndMonth(currentDate);
                this.dateColumnArray[i] = FaLeaseLiabilitiesRptUtil.changeDateToString(currentDate);
            }
        } else if (amountDisplayType == FaLeaseAmountDisplayTypeEnum.BY_SPRING) {
            int subSprings = FaLeaseLiabilitiesRptUtil.subSpring(endDate, currentDate);
            this.dateColumnArray = new String[subSprings + 1];
            this.dateColumnArray[0] = FaLeaseLiabilitiesRptUtil.changeDateToString(FaLeaseLiabilitiesRptUtil.getCurEndSpring(currentDate));
            for (int i = 1; i < subSprings + 1; ++i) {
                currentDate = FaLeaseLiabilitiesRptUtil.getNextEndSpring(FaLeaseLiabilitiesRptUtil.getCurEndSpring(currentDate));
                this.dateColumnArray[i] = FaLeaseLiabilitiesRptUtil.changeDateToString(currentDate);
            }
        } else {
            int subYears = FaLeaseLiabilitiesRptUtil.subYear(endDate, currentDate);
            this.dateColumnArray = new String[subYears + 1];
            this.dateColumnArray[0] = FaLeaseLiabilitiesRptUtil.changeDateToString(currentDate);
            for (int i = 1; i < subYears + 1; ++i) {
                currentDate = FaLeaseLiabilitiesRptUtil.getNextYear(currentDate);
                this.dateColumnArray[i] = FaLeaseLiabilitiesRptUtil.changeDateToString(currentDate);
            }
        }
    }

    private void initDateColumn() {
        int columnCount = this.tblMain.getColumnCount();
        for (int i = 0; i < this.dateColumnArray.length; ++i) {
            IColumn col = this.tblMain.addColumn(columnCount + i);
            col.setKey(this.dateColumnArray[i]);
            col.setStyleAttributes(this.tblMain.getColumn("initialMoney").getStyleAttributes());
            this.tblMain.getHeadRow(0).getCell(this.dateColumnArray[i]).setValue((Object)this.dateColumnArray[i]);
            this.tblMain.getColumn(this.dateColumnArray[i]).getStyleAttributes().setNumberFormat(FaClientUtils.getDecimalFormat((int)this.basePrecision));
        }
    }

    private ArrayList<String> initSummaryColumn() {
        this.tblMain.setColumnMoveable(true);
        int to = this.tblMain.getColumnIndex(COMPANY);
        ArrayList<String> summaryColumnList = new ArrayList<String>();
        if (this.isByCompany) {
            ++to;
            summaryColumnList.add(COMPANY);
        }
        if (this.isByCurrency) {
            this.tblMain.exchangeColumn(this.tblMain.getColumnIndex(CURRENCY), to);
            ++to;
            summaryColumnList.add(CURRENCY);
        }
        if (this.isByPersonType) {
            this.tblMain.exchangeColumn(this.tblMain.getColumnIndex(LESSOR_TYPE), to);
            ++to;
            summaryColumnList.add(LESSOR_TYPE);
        }
        if (this.isByPerson) {
            this.tblMain.exchangeColumn(this.tblMain.getColumnIndex(LESSOR_NAME), to);
            summaryColumnList.add(LESSOR_NAME);
        }
        return summaryColumnList;
    }

    private void insertSubTotalRow(int rowIndex, int curColumnIndex, KDTColumns cols) {
        int n;
        IRow rowTmp = this.tblMain.getRow2(rowIndex);
        if (rowTmp == null) {
            rowTmp = this.tblMain.addRow(rowIndex);
        }
        rowTmp.getCell(this.summaryColumnLists.get(curColumnIndex)).setValue((Object)SUB_TOTAL);
        if (curColumnIndex - 1 >= 0) {
            int m = curColumnIndex - 1;
            for (int n2 = 0; n2 <= m; ++n2) {
                if ("".equals(this.perRowsSummaryHelpArrays[n2])) {
                    rowTmp.getCell(this.summaryColumnLists.get(n2)).setValue(null);
                    continue;
                }
                rowTmp.getCell(this.summaryColumnLists.get(n2)).setValue((Object)this.perRowsSummaryHelpArrays[n2]);
            }
        }
        BigDecimal[] bigDecimals = this.summarySubAmountList.get(curColumnIndex);
        rowTmp.getCell("initialMoney").setValue((Object)bigDecimals[0]);
        int m = this.dateColumnArray.length;
        for (n = 0; n < m; ++n) {
            String key = cols.getColumnKey(12 + n);
            rowTmp.getCell(key).setValue((Object)bigDecimals[n + 1]);
        }
        m = bigDecimals.length;
        for (n = 0; n < m; ++n) {
            bigDecimals[n] = new BigDecimal("0");
        }
        rowTmp.getStyleAttributes().setBackground(this.tblMain.getRequiredColor());
    }

    private void insertTotalRow(int rowIndex, KDTColumns cols) {
        if (this.summaryColumnLists.size() != 0) {
            IRow rowTmp = this.tblMain.getRow2(rowIndex);
            if (rowTmp == null) {
                rowTmp = this.tblMain.addRow(rowIndex);
            }
            rowTmp.getCell(this.summaryColumnLists.get(0)).setValue((Object)TOTAL);
            rowTmp.getCell("initialMoney").setValue((Object)this.summaryAmountArrays[0]);
            int m = this.dateColumnArray.length;
            for (int n = 0; n < m; ++n) {
                String key = cols.getColumnKey(12 + n);
                rowTmp.getCell(key).setValue((Object)this.summaryAmountArrays[n + 1]);
            }
            rowTmp.getStyleAttributes().setBackground(this.tblMain.getRequiredColor());
        }
    }

    private void insertRow(int rowIndex, IRowSet rows, KDTColumns cols) throws SQLException {
        IRow row = this.tblMain.getRow2(rowIndex);
        if (row == null) {
            row = this.tblMain.addRow(rowIndex);
        }
        int n = cols.size();
        for (int i = 0; i < n; ++i) {
            String key = cols.getColumnKey(i);
            if ("beginDate".equals(key)) {
                row.getCell(key).setValue((Object)rows.getDate(key));
                continue;
            }
            row.getCell(key).setValue(rows.getObject((i > 11 ? "a" : "") + key.replace('-', 'a')));
        }
        this.afterFillTableRow(row, rowIndex);
    }

    @Override
    protected void afterFillTableRow(IRow row, int rowIndex) {
        ICell bizStatus = row.getCell("bizStatus");
        if (bizStatus != null && bizStatus.getValue() != null) {
            int bizTypeInt = Integer.parseInt(bizStatus.getValue().toString());
            row.getCell("bizStatus").setValue((Object)FaLeaseBizStatusEnum.getEnum(bizTypeInt).getAlias());
        }
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        CompanyOrgUnitInfo company = this.currCompany;
        if (this.currCompany != null && user != null) {
            ObjectUuidPK orgPk = new ObjectUuidPK(company.getId());
            ObjectUuidPK userPk = new ObjectUuidPK(user.getId());
            String permItemName = NLM_REPORT_EXPORT;
            PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permItemName);
        }
        super.actionExport_actionPerformed(e);
    }
}

