/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.nlm.FaLeaseBizStatusEnum;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseSourceTypeEnum;
import com.kingdee.eas.fi.nlm.FaLeaseTypeEnum;
import com.kingdee.eas.fi.nlm.FaNLMChangeAssetItemFactory;
import com.kingdee.eas.fi.nlm.FaNLMChangeAssetItemInfo;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyFactory;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyInfo;
import com.kingdee.eas.fi.nlm.FaPayFrequencyEnum;
import com.kingdee.eas.fi.nlm.FaPaymentPlanNewCollection;
import com.kingdee.eas.fi.nlm.IFaLeaseInBillNew;
import com.kingdee.eas.fi.nlm.client.AbstractFaNLMChangeAssetItemAddEditUI;
import com.kingdee.eas.fi.nlm.client.FaLeaseInNewEditUI;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaNLMChangeAssetItemAddEditUI
extends AbstractFaNLMChangeAssetItemAddEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FaNLMChangeAssetItemAddEditUI.class);
    int currencyPrecision = 2;
    int currencyPrecisionOC = 2;
    private String[] userSelectItem = null;
    private FaLeaseInBillNewInfo faLeaseInBillNewInfoOld = null;
    private BOSUuid faLeaseInBillIdOld = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initButton();
        this.setPreferredSize(new Dimension(800, 620));
        this.getPrecision();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    protected IObjectValue createNewData() {
        ArrayList loadCardIds = (ArrayList)this.getUIContext().get("CardIDs");
        FaNLMChangeAssetItemInfo faNLMChangeAssetItemInfo = new FaNLMChangeAssetItemInfo();
        faNLMChangeAssetItemInfo.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        faNLMChangeAssetItemInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        faNLMChangeAssetItemInfo.setId(BOSUuid.create((BOSObjectType)faNLMChangeAssetItemInfo.getBOSType()));
        try {
            this.faLeaseInBillNewInfoOld = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK((String)loadCardIds.get(0)));
            this.faLeaseInBillIdOld = this.faLeaseInBillNewInfoOld.getId();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (this.faLeaseInBillNewInfoOld == null) {
            // empty if block
        }
        Calendar currentPeriodDate = Calendar.getInstance();
        currentPeriodDate.set(this.getCurrPeriod().getPeriodYear(), this.getCurrPeriod().getPeriodNumber() - 1, 1);
        faNLMChangeAssetItemInfo.setTaxRateOld(this.faLeaseInBillNewInfoOld.getTaxRate());
        faNLMChangeAssetItemInfo.setRentWithoutTaxOld(this.faLeaseInBillNewInfoOld.getRentWithTax());
        faNLMChangeAssetItemInfo.setIsDeductibleOld(this.faLeaseInBillNewInfoOld.isIsDeductible());
        faNLMChangeAssetItemInfo.setDiscountRateOld(this.faLeaseInBillNewInfoOld.getDiscountRate());
        faNLMChangeAssetItemInfo.setEndDateOld(this.faLeaseInBillNewInfoOld.getEndDate());
        faNLMChangeAssetItemInfo.setPayFrequencyOld(this.faLeaseInBillNewInfoOld.getPayFrequency());
        faNLMChangeAssetItemInfo.setTaxRateNew(this.faLeaseInBillNewInfoOld.getTaxRate());
        faNLMChangeAssetItemInfo.setRentWithoutTaxNew(this.faLeaseInBillNewInfoOld.getRentWithTax());
        faNLMChangeAssetItemInfo.setIsDeductibleNew(this.faLeaseInBillNewInfoOld.isIsDeductible());
        faNLMChangeAssetItemInfo.setDiscountRateNew(this.faLeaseInBillNewInfoOld.getDiscountRate());
        faNLMChangeAssetItemInfo.setEndDateNew(this.faLeaseInBillNewInfoOld.getEndDate());
        faNLMChangeAssetItemInfo.setPayFrequencyNew(this.faLeaseInBillNewInfoOld.getPayFrequency());
        return faNLMChangeAssetItemInfo;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.pkChangeDate.getSqlDate() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"187_FaNLMChangeAssetItemAddEditUI"));
            SysUtil.abort();
        }
        if (this.pkChangeDate.getSqlDate().compareTo(this.getCurrPeriod().getEndDate()) > 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"188_FaNLMChangeAssetItemAddEditUI"));
            SysUtil.abort();
        }
        if (this.pkEndDateNew.getSqlDate() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"189_FaNLMChangeAssetItemAddEditUI"));
            SysUtil.abort();
        }
        if (this.comboPayFrequencyNew.getSelectedItem() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"190_FaNLMChangeAssetItemAddEditUI"));
            SysUtil.abort();
        }
        this.editData.setChangeDate(this.pkChangeDate.getSqlDate());
        this.editData.setTaxRateNew(this.txtTaxRateNew.getBigDecimalValue());
        this.editData.setRentWithoutTaxNew(this.txtRentWithoutTaxNew.getBigDecimalValue());
        this.editData.setIsDeductibleNew(this.chkIsDeductibleNew.isSelected());
        this.editData.setDiscountRateNew(this.txtDiscountRateNew.getBigDecimalValue());
        this.editData.setEndDateNew(this.pkEndDateNew.getSqlDate());
        this.editData.setPayFrequencyNew((FaPayFrequencyEnum)((Object)this.comboPayFrequencyNew.getSelectedItem()));
        FaLeaseInBillNewInfo infoNew = this.getLeaseInBill();
        FaLeaseInBillNewInfo infoOld = FaLeaseInBillNewFactory.getRemoteInstance().getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(this.faLeaseInBillIdOld));
        IFaLeaseInBillNew iFaLeaseInBillNew = FaLeaseInBillNewFactory.getRemoteInstance();
        iFaLeaseInBillNew.saveSelf(infoNew);
        this.editData.setLeaseInBillNew(infoNew);
        this.editData.setLeaseInBillOld(infoOld);
        this.editData.setOldLeaseBillbizStatus(infoOld.getBizStatus());
        infoOld.setBizStatus(FaLeaseBizStatusEnum.ADJUSTMENT);
        iFaLeaseInBillNew.update((IObjectPK)new ObjectUuidPK(this.faLeaseInBillIdOld), (CoreBaseInfo)infoOld);
        super.actionSubmit_actionPerformed(e);
        this.getUIWindow().close();
        if (infoNew.getId() == null) {
            return;
        }
        Map uiContext = this.getUIContext();
        uiContext.put("ID", infoNew.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FaLeaseInNewEditUI.class.getName(), uiContext, null, "FINDVIEW");
        uiWindow.show();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaNLMChangeAssetItemFactory.getRemoteInstance();
    }

    private FaLeaseInBillNewInfo getLeaseInBill() throws EASBizException, BOSException {
        int i;
        FaLeaseInBillNewInfo infoNew = this.faLeaseInBillNewInfoOld;
        infoNew.setId(BOSUuid.create((BOSObjectType)infoNew.getBOSType()));
        infoNew.setNumber(null);
        infoNew.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        infoNew.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        infoNew.setBizStatus(FaLeaseBizStatusEnum.ADDING);
        infoNew.setSourceType(FaLeaseSourceTypeEnum.ASSET_CHANGE_CREAT);
        infoNew.setIsHistory(false);
        infoNew.setFiVouchered(false);
        try {
            this.setNewNumber(infoNew);
        }
        catch (Exception ignored) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"191_FaNLMChangeAssetItemAddEditUI"));
            SysUtil.abort();
        }
        infoNew.setTaxRate(this.editData.getTaxRateNew());
        infoNew.setRentWithTax(this.editData.getRentWithoutTaxNew());
        infoNew.setIsDeductible(this.editData.isIsDeductibleNew());
        infoNew.setDiscountRate(this.editData.getDiscountRateNew());
        infoNew.setEndDate(this.editData.getEndDateNew());
        infoNew.setPayFrequency(this.editData.getPayFrequencyNew());
        infoNew.setBeginDate(this.getDateWithoutHour(this.editData.getChangeDate()));
        infoNew.setBeginRentDate(this.getDateWithoutHour(this.editData.getChangeDate()));
        Calendar currentPeriodDate = Calendar.getInstance();
        currentPeriodDate.set(this.getCurrPeriod().getPeriodYear(), this.getCurrPeriod().getPeriodNumber() - 1, 1);
        infoNew.setFiAccountDate(this.getDateWithoutHour(currentPeriodDate.getTime()));
        Date beginDate = infoNew.getBeginDate();
        Date endDate = infoNew.getEndDate();
        if (beginDate != null && endDate != null) {
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            c1.setTime(beginDate);
            c2.setTime(endDate);
            int monthCount = c2.get(2) - c1.get(2);
            int yearCount = (c2.get(1) - c1.get(1)) * 12;
            int dayCount = c2.get(5) - c1.get(5);
            int timeCycle = monthCount + yearCount;
            if (dayCount >= 0) {
                ++timeCycle;
            }
            infoNew.setTimeCycle(timeCycle);
        }
        FaPaymentPlanNewCollection faPaymentPlanNewCollection = this.faLeaseInBillNewInfoOld.getPaymentEntry();
        faPaymentPlanNewCollection.sort("payDate");
        faPaymentPlanNewCollection.removeObject(0);
        int totalPayPeriodt = 0;
        Date firstPayTime = infoNew.getBeginDate();
        boolean inFirstPayTime = true;
        int j = faPaymentPlanNewCollection.size();
        for (i = 0; i < j; ++i) {
            if (this.compareDateIfMonthNextDate(faPaymentPlanNewCollection.get(i).getPayDate(), this.editData.getChangeDate())) {
                ++totalPayPeriodt;
            }
            if (!inFirstPayTime || !this.compareDateIfDayNextDate(faPaymentPlanNewCollection.get(i).getPayDate(), firstPayTime)) continue;
            firstPayTime = faPaymentPlanNewCollection.get(i).getPayDate();
            inFirstPayTime = false;
        }
        infoNew.setTotalPayPeriod(totalPayPeriodt);
        infoNew.setFirstPayTime(firstPayTime);
        infoNew.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        infoNew.setRentWithoutTax(new BigDecimal("0"));
        infoNew.setRentWithTaxNew(new BigDecimal("0"));
        infoNew.setRentWithoutTaxNew(new BigDecimal("0"));
        infoNew.setInitialAsset(BigDecimal.ZERO);
        infoNew.setInitialLiability(BigDecimal.ZERO);
        infoNew.setUnrecognizedFinanceFee(BigDecimal.ZERO);
        infoNew.setAccDepOfAsset(BigDecimal.ZERO);
        infoNew.setAccUnrFinExpenses(BigDecimal.ZERO);
        infoNew.setRecoveryCostNPV(BigDecimal.ZERO);
        infoNew.setInitAccDepreciation(BigDecimal.ZERO);
        infoNew.setAdjustmentLiability(BigDecimal.ZERO);
        infoNew.setAdjustmentUnFncFee(BigDecimal.ZERO);
        infoNew.setAdjustmentAsset(BigDecimal.ZERO);
        infoNew.setRemainingLiability(BigDecimal.ZERO);
        infoNew.setEstimatedLiability(BigDecimal.ZERO);
        infoNew.setWholeProcessAsset(BigDecimal.ZERO);
        infoNew.setWholeProcessLiability(BigDecimal.ZERO);
        infoNew.setWholeProcessUFF(BigDecimal.ZERO);
        infoNew.setAdjustAccDepAsset(BigDecimal.ZERO);
        infoNew.setAdjustDecAsset(BigDecimal.ZERO);
        infoNew.setAdjustInterestPayment(BigDecimal.ZERO);
        infoNew.setInitialAssetDecValue(BigDecimal.ZERO);
        if (infoNew.getFaLeaseDepCostSharingEntry() != null) {
            j = infoNew.getFaLeaseDepCostSharingEntry().size();
            for (i = 0; i < j; ++i) {
                BOSUuid id = BOSUuid.create((BOSObjectType)infoNew.getFaLeaseDepCostSharingEntry().get(i).getBOSType());
                infoNew.getFaLeaseDepCostSharingEntry().get(i).setId(id);
            }
        }
        infoNew.setInitialAssetDecValue(new BigDecimal("0"));
        infoNew.setCostDate1(null);
        infoNew.setCostDate2(null);
        infoNew.setCostDate7(null);
        infoNew.setCostTaxRate1(null);
        infoNew.setCostTaxRate2(null);
        infoNew.setCostTaxRate7(null);
        infoNew.setCostPmWithoutTax1(null);
        infoNew.setCostPmWithoutTax2(null);
        infoNew.setCostPmWithoutTax7(null);
        infoNew.setCostPmWithoutTaxOC1(null);
        infoNew.setCostPmWithoutTaxOC2(null);
        infoNew.setCostPmWithoutTaxOC7(null);
        infoNew.setCostPmWithTax1(null);
        infoNew.setCostPmWithTax2(null);
        infoNew.setCostPmWithTax7(null);
        infoNew.setCostPmWithTaxOC1(null);
        infoNew.setCostPmWithTaxOC2(null);
        infoNew.setCostPmWithTaxOC7(null);
        infoNew.setCostTax1(null);
        infoNew.setCostTax2(null);
        infoNew.setCostTax7(null);
        infoNew.setLeaseType(FaLeaseTypeEnum.OPERATING_LEASE);
        infoNew.setPeriod(FaClientUtils.getFLCurrentPeriod((CompanyOrgUnitInfo)infoNew.getCompany()));
        try {
            FaNewLeasePolicyInfo newLeasePolicy = FaNewLeasePolicyFactory.getRemoteInstance().getEnabledNewLeasePolicy(infoNew.getCompany().getId().toString());
            infoNew.setDepreciationMethod(newLeasePolicy.getDepreciationMethod());
        }
        catch (Exception e) {
            MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"52_FaTerminateBillControllerBean") + e.getMessage()));
        }
        if (infoNew.getPaymentEntry() != null) {
            infoNew.getPaymentEntry().clear();
        }
        return infoNew;
    }

    private void setNewNumber(FaLeaseInBillNewInfo billInfo) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            aCompanyOrgUnitInfo = this.getCurCompany();
            billInfo.setCompany(aCompanyOrgUnitInfo);
        }
        String strCompanyId = aCompanyOrgUnitInfo.getId().toString();
        String number = iCodingRuleManager.getNumber((IObjectValue)billInfo, strCompanyId);
        billInfo.setNumber(number);
        if (this.existNumber((IObjectValue)billInfo)) {
            this.setNewNumber(billInfo);
        }
    }

    private boolean existNumber(IObjectValue model) throws BOSException {
        FaLeaseInBillNewInfo billInfo = (FaLeaseInBillNewInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_FA_FALEASEINBILLNEW WHERE FNUMBER = '");
        sql.append(billInfo.getNumber()).append("'");
        sql.append(" AND FCOMPANYID = '").append(billInfo.getCompany().getId().toString()).append("'");
        if (billInfo.getId() != null) {
            sql.append(" AND FID != '").append(billInfo.getId().toString()).append("'");
        }
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            return rowSet.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private CompanyOrgUnitInfo getCurCompany() {
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    private void initButton() {
        this.userSelectItem = (String[])this.getUIContext().get("faNLMAssetChange_select_item");
        this.kDButtonComfirm.setEnabled(true);
        this.kDButtonCancel.setEnabled(true);
        this.txtTaxRateNew.setEnabled(false);
        this.txtDiscountRateNew.setEnabled(false);
        this.pkEndDateNew.setEnabled(false);
        this.comboPayFrequencyNew.setEnabled(false);
        this.chkIsDeductibleNew.setEnabled(false);
        this.txtRentWithoutTaxNew.setEnabled(false);
        if (this.userSelectItem != null) {
            block8: for (String item : this.userSelectItem) {
                switch (item.charAt(0)) {
                    case 't': {
                        this.txtTaxRateNew.setValue((Object)new BigDecimal(0.0));
                        this.txtTaxRateNew.setEnabled(true);
                        continue block8;
                    }
                    case 'd': {
                        this.txtDiscountRateNew.setValue((Object)new BigDecimal(0.0));
                        this.txtDiscountRateNew.setEnabled(true);
                        continue block8;
                    }
                    case 'e': {
                        this.pkEndDateNew.setValue(null);
                        this.pkEndDateNew.setEnabled(true);
                        continue block8;
                    }
                    case 'p': {
                        this.comboPayFrequencyNew.setSelectedItem(null);
                        this.comboPayFrequencyNew.setEnabled(true);
                        continue block8;
                    }
                    case 'i': {
                        this.chkIsDeductibleNew.setSelected(false);
                        this.chkIsDeductibleNew.setEnabled(true);
                        continue block8;
                    }
                    case 'r': {
                        this.txtRentWithoutTaxNew.setValue((Object)new BigDecimal(0.0));
                        this.txtRentWithoutTaxNew.setEnabled(true);
                        continue block8;
                    }
                }
            }
        }
    }

    private PeriodInfo getCurrPeriod() {
        PeriodInfo currenctPeriod = null;
        try {
            currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.getCurCompany());
        }
        catch (Exception ex) {
            this.handleException(ex);
            SysUtil.abort();
        }
        if (currenctPeriod == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notConfigStartPeriod");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        return currenctPeriod;
    }

    private void getPrecision() throws EASBizException, BOSException {
        this.currencyPrecision = FaClientUtils.getCurrencyScale((CompanyOrgUnitInfo)this.faLeaseInBillNewInfoOld.getCompany());
        if (this.faLeaseInBillNewInfoOld.getCurrency() != null && this.faLeaseInBillNewInfoOld.getCurrency().getPrecision() != 0) {
            this.currencyPrecisionOC = this.faLeaseInBillNewInfoOld.getCurrency().getPrecision();
        }
        this.txtTaxRateOld.setHorizontalAlignment(4);
        this.txtTaxRateOld.setPrecision(3);
        this.txtTaxRateNew.setHorizontalAlignment(4);
        this.txtTaxRateNew.setPrecision(3);
        this.txtRentWithoutTaxOld.setHorizontalAlignment(4);
        this.txtRentWithoutTaxOld.setPrecision(this.currencyPrecisionOC);
        this.txtRentWithoutTaxNew.setHorizontalAlignment(4);
        this.txtRentWithoutTaxNew.setPrecision(this.currencyPrecisionOC);
        this.txtDiscountRateOld.setHorizontalAlignment(4);
        this.txtDiscountRateOld.setPrecision(this.currencyPrecision);
        this.txtDiscountRateNew.setHorizontalAlignment(4);
        this.txtDiscountRateNew.setPrecision(this.currencyPrecision);
    }

    private Date getDateWithoutHour(Date date) {
        Calendar cld = Calendar.getInstance();
        cld.setTime(date);
        cld.set(5, 1);
        cld.set(11, 0);
        cld.set(12, 0);
        cld.set(13, 0);
        return cld.getTime();
    }

    private boolean compareDateIfMonthNextDate(Date date1, Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        int subMonth = (cld2.get(1) - cld1.get(1)) * 12 + cld2.get(2) - cld1.get(2);
        return subMonth <= 0;
    }

    private boolean compareDateIfDayNextDate(Date date1, Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        int subMonth = (cld2.get(1) - cld1.get(1)) * 12 + cld2.get(2) - cld1.get(2);
        int subDay = cld2.get(5) - cld1.get(5);
        return subMonth < 0 || subMonth == 0 && subDay <= 0;
    }
}

