/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.client.FACommonProcessor;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.nlm.FaRentDirectionEnum;
import com.kingdee.eas.fi.nlm.FaRentSettlementBillFactory;
import com.kingdee.eas.fi.nlm.client.AbstractFaRentSettlementBillListUI;
import com.kingdee.eas.fi.nlm.client.FaLeaseInNewEditUI;
import com.kingdee.eas.fi.nlm.client.FaRentSettleQueryUI;
import com.kingdee.eas.fi.nlm.client.FaRentSettlementBillEditUI;
import com.kingdee.eas.fi.nlm.client.flutils.FlUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaRentSettlementBillListUI
extends AbstractFaRentSettlementBillListUI {
    private static final long serialVersionUID = 5147423667193371895L;
    private static final Logger logger = CoreUIObject.getLogger(FaRentSettlementBillListUI.class);
    private static final String RES_PATH_RS = "com.kingdee.eas.fi.nlm.FaRentSettlementBillResource";
    private static final int DEFAULT_RATE_SCALE = 4;
    private static final int DEFAULT_CURRENCY_SCALE = 2;
    private int currencyScale = 2;
    private static final String KEY_NUMBER = "number";
    private static final String KEY_LEASEBILLNUMBER = "leaseBillNumber";
    private static final String KEY_PLANWITHTAXAMT = "entries.planWithTaxAmt";
    private static final String KEY_ID = "entries.id";
    private static final String KEY_PLANDATE = "entries.planDate";
    private static final String KEY_TAXRATE = "entries.taxRate";
    private static final String KEY_TAXAMT = "entries.taxAmt";
    private static final String KEY_PLANWITHOUTTAXAMT = "entries.planWithoutTaxAmt";
    private static final String KEY_WITHTAXAMT = "entries.withTaxAmt";
    private static final String KEY_TOTALPERIOD = "totalPeriod";
    private static final String KEY_HADPERIOD = "hadPeriod";
    private static final String KEY_SUBPERIOD = "subPeriod";
    private static final String KEY_RPBILLID = "entries.rpBillId";
    private static final String KEY_LEASEBILLID = "leaseBillId";
    private static final String KEY_RENTDIRECTION = "rentDirection";
    private static final String KEY_GENRPBILL = "entries.genRpBill";
    private static final String KEY_FIVOUCHERED = "fiVouchered";
    private CompanyOrgUnitInfo currCompany;
    private CommonQueryDialog commonQuerydialog = null;
    private String curSelectedRpBillId = null;
    private String curSelectedLeaseBillId = null;
    private boolean curSelectedGenRpBill = false;
    private boolean curSelectedColGenRpBill = false;
    private FaRentDirectionEnum curSelectedRentDirection = null;
    private boolean isEnableCrossPeriodVoucherGeneration = false;

    public FaRentSettlementBillListUI() throws Exception {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                FaRentSettlementBillListUI.this.onTableSelectChanged();
            }
        });
    }

    protected void onTableSelectChanged() {
        int rowIndex;
        IRow row;
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setVisible(true);
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && (row = this.tblMain.getRow(rowIndex = selectBlock.getTop())) != null) {
            ICell cellFiVc = row.getCell(KEY_FIVOUCHERED);
            Object isVc = cellFiVc.getValue();
            if (isVc != null && isVc instanceof Boolean && ((Boolean)isVc).booleanValue()) {
                this.actionVoucher.setEnabled(false);
                this.actionDelVoucher.setEnabled(true);
            } else {
                this.actionVoucher.setEnabled(true);
                this.actionDelVoucher.setEnabled(false);
            }
            try {
                this.isEnableCrossPeriodVoucherGeneration = FaManageUtils.getFaParamValue(null, (String)"NLM_310", (String)this.getCurrentCompany().getId().toString());
                PeriodInfo currentPeriod = FaClientUtils.getFLCurrentPeriod((CompanyOrgUnitInfo)FaClientUtils.getCurrentCompany());
                if (!(this.isEnableCrossPeriodVoucherGeneration || ((Date)row.getCell(KEY_PLANDATE).getValue()).compareTo(currentPeriod.getBeginDate()) >= 0 && ((Date)row.getCell(KEY_PLANDATE).getValue()).compareTo(currentPeriod.getEndDate()) <= 0)) {
                    this.actionVoucher.setEnabled(false);
                    this.actionDelVoucher.setEnabled(false);
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.currCompany = this.getCurrentCompany();
        this.currencyScale = this.getCurrentCompany().getBaseCurrency().getPrecision();
        this.initUI();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    private void initUI() {
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.menuBiz.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.menuItemCopyTo.setVisible(false);
        this.actionAttachment.setVisible(true);
        this.btnAttachment.setVisible(true);
        this.btnLinkViewLeaseBill.setEnabled(true);
        this.btnLinkViewRPBill.setEnabled(true);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(true);
        this.onTableSelectChanged();
        this.tblMain.getSelectManager().setSelectMode(10);
        String[] numKeys = new String[]{KEY_PLANWITHTAXAMT, KEY_TAXAMT, KEY_WITHTAXAMT, KEY_PLANWITHOUTTAXAMT, KEY_TOTALPERIOD, KEY_HADPERIOD, KEY_SUBPERIOD};
        FaClientUtils.changeTableNumberFormat((KDTable)this.tblMain, (String[])new String[]{KEY_TAXRATE}, (String)FaClientUtils.getDecimalFormat((int)3));
        FaClientUtils.changeTableNumberFormat((KDTable)this.tblMain, (String[])numKeys, (String)FaClientUtils.getDecimalFormat((int)this.currencyScale));
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn(KEY_NUMBER).setGroup(true);
        this.tblMain.getColumn(KEY_NUMBER).setMergeable(true);
        this.tblMain.getColumn(KEY_LEASEBILLNUMBER).setGroup(true);
        this.tblMain.getColumn(KEY_LEASEBILLNUMBER).setMergeable(true);
        this.tblMain.getGroupManager().group();
    }

    protected boolean isVoucherVisible() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQuerydialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQuerydialog = super.initCommonQueryDialog();
            this.commonQuerydialog.setWidth(580);
            this.commonQuerydialog.setHeight(420);
            try {
                FaClientUtils.checkBeforeOnload4Fl((Map)this.getUIContext(), (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
                FACommonProcessor processor = new FACommonProcessor();
                processor.set("parentDialog", (Object)this.commonQuerydialog);
                this.commonQuerydialog.addUserPanel((KDPanel)new FaRentSettleQueryUI());
                this.commonQuerydialog.setProcessor((IProcessor)processor);
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            EntityViewInfo defaultQuery = new EntityViewInfo();
            defaultQuery.getSorter().add(new SorterItemInfo(KEY_NUMBER));
            this.commonQuerydialog.setDefalutEntityViewInfo(defaultQuery);
        }
        return this.commonQuerydialog;
    }

    protected String getEditUIName() {
        return FaRentSettlementBillEditUI.class.getName();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaRentSettlementBillFactory.getRemoteInstance();
    }

    protected String[] getLocateNames() {
        return new String[]{KEY_NUMBER, KEY_LEASEBILLNUMBER};
    }

    protected CompanyOrgUnitInfo getCurrentCompany() throws BOSException, EASBizException {
        if (this.currCompany == null) {
            String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            this.currCompany = this.getCompanyById(companyID);
        }
        return this.currCompany;
    }

    protected CompanyOrgUnitInfo getCompanyById(String companyID) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("basecurrency.precision"));
        sic.add(new SelectorItemInfo("isbizunit"));
        sic.add(new SelectorItemInfo("accountTable"));
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        if (this.commonQuerydialog != null && this.commonQuerydialog.getUserPanels().size() > 0) {
            FaRentSettleQueryUI rsqUI = (FaRentSettleQueryUI)this.commonQuerydialog.getUserPanel(0);
            FilterInfo filter = rsqUI.getFilterInfo();
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo item = filter.getFilterItems().get(i);
                if (item.getPropertyName().equals(KEY_PLANDATE) && item.getCompareType().getName().equals(CompareType.GREATER_EQUALS.getName())) {
                    uiContext.put((Object)"planDateFrom", item.getCompareValue());
                }
                if (item.getPropertyName().equals(KEY_PLANDATE) && item.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) {
                    uiContext.put((Object)"planDateTo", item.getCompareValue());
                }
                if (!item.getPropertyName().equals(KEY_GENRPBILL) || !item.getCompareType().getName().equals(CompareType.LESS_EQUALS.getName())) continue;
                uiContext.put((Object)"genRpBill", item.getCompareValue());
            }
        }
        super.prepareUIContext(uiContext, e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        KDTSelectBlock block = e.getSelectBlock();
        if (block != null) {
            int rowBeginIdx = block.getBeginRow();
            int rowEndIdx = block.getEndRow();
            this.curSelectedLeaseBillId = (String)this.tblMain.getCell(rowBeginIdx, KEY_LEASEBILLID).getValue();
        }
        super.tblMain_tableSelectChanged(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        ArrayList boIDList = this.getSelectedFieldValues(KEY_ID);
        this.checkSelected();
        if (boIDList == null || boIDList.size() <= 0) {
            return;
        }
        AttachmentUIContextInfo info = new AttachmentUIContextInfo();
        info.setBoID((String)boIDList.get(0));
        info.setCode("");
        info.setEdit(true);
        info.setListener(this.createAttatchListener("HEAD"));
        acm.showAttachmentListUIByBoID((Object)this, info);
    }

    @Override
    public void actionLinkViewLeaseBill_actionPerformed(ActionEvent e) throws Exception {
        if (this.curSelectedLeaseBillId == null) {
            return;
        }
        Map uiContext = this.getUIContext();
        uiContext.put("ID", this.curSelectedLeaseBillId);
        if (this.curSelectedRentDirection == null || this.curSelectedRentDirection == FaRentDirectionEnum.RENT_IN) {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FaLeaseInNewEditUI.class.getName(), uiContext, null, "FINDVIEW");
            uiWindow.show();
        }
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkTerminateForCreatTo();
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        FaClientUtils.checkForGenVoucher4Fl();
        if (!this.isEnableCrossPeriodVoucherGeneration) {
            this.checkTerminate();
        }
        ICell iCell = this.tblMain.getCell(this.tblMain.getSelectManager().getActiveRowIndex(), KEY_NUMBER);
        if (!FaRentSettlementBillFactory.getRemoteInstance().exists("where number = '" + iCell.getValue() + "'")) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks;
        PeriodInfo currentPeriod = FaClientUtils.getFLCurrentPeriod((CompanyOrgUnitInfo)FaClientUtils.getCurrentCompany());
        if (!this.isEnableCrossPeriodVoucherGeneration && (blocks = this.tblMain.getSelectManager().getBlocks()).size() > 1) {
            for (KDTSelectBlock block : blocks) {
                int top = block.getTop();
                ICell cellPlanDate = this.tblMain.getRow(top).getCell(KEY_PLANDATE);
                if (((Date)cellPlanDate.getValue()).compareTo(currentPeriod.getBeginDate()) >= 0 && ((Date)cellPlanDate.getValue()).compareTo(currentPeriod.getEndDate()) <= 0) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FaRentSettlementBillResource.notDelVoucher"));
                SysUtil.abort();
            }
        }
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.deleteRowDataAfterChangeDate();
        this.refresh(e);
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    private void checkTerminate() throws EASBizException, BOSException {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        if (blocks.size() > 1) {
            for (KDTSelectBlock block : blocks) {
                int top = block.getTop();
                ICell cellLeaseInId = this.tblMain.getRow(top).getCell(KEY_LEASEBILLID);
                ICell cellPlanDate = this.tblMain.getRow(top).getCell(KEY_PLANDATE);
                if (cellLeaseInId == null || cellLeaseInId.getValue() == null || cellPlanDate == null || cellPlanDate.getValue() == null) continue;
                FaRentSettlementBillFactory.getRemoteInstance().checkTerminated(cellLeaseInId.getValue().toString(), (Date)cellPlanDate.getValue());
            }
        } else {
            ICell cellLeaseInId = this.tblMain.getCell(this.tblMain.getSelectManager().getActiveRowIndex(), KEY_LEASEBILLID);
            ICell cellPlanDate = this.tblMain.getCell(this.tblMain.getSelectManager().getActiveRowIndex(), KEY_PLANDATE);
            if (cellLeaseInId != null && cellLeaseInId.getValue() != null && cellPlanDate != null && cellPlanDate.getValue() != null) {
                FaRentSettlementBillFactory.getRemoteInstance().checkTerminated(cellLeaseInId.getValue().toString(), (Date)cellPlanDate.getValue());
            }
        }
    }

    private Date getChangeDate(String faLeaseinBillNewId) throws BOSException, SQLException, ParseException {
        Date changeDate = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FChangeDate \n");
        sql.append("FROM T_FA_FaNLMChangeAssetItem \n");
        sql.append("WHERE FLEASEINBILLOLDID = '" + faLeaseinBillNewId + "'\n");
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        if (rowSet.next()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            changeDate = sdf.parse(rowSet.getString("FChangeDate"));
        } else {
            changeDate = null;
        }
        return changeDate;
    }

    private Date getTerminatedDate(String faLeaseinBillNewId) throws BOSException, SQLException, ParseException {
        Date terminatedDate = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FTerminateDate FROM T_FA_FATERMINATEBILLENTRY tme \n");
        sql.append(" LEFT JOIN T_FA_FaTerminateBill tm ON tme.FBillID = tm.FID \n");
        sql.append(" WHERE FLEASEINBILLID = '" + faLeaseinBillNewId + "' \n");
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        if (rowSet.next()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            terminatedDate = sdf.parse(rowSet.getString("FTerminateDate"));
        } else {
            terminatedDate = null;
        }
        return terminatedDate;
    }

    private void deleteRowDataAfterChangeDate() throws ParseException, BOSException, SQLException {
        HashSet<String> headIdSet = new HashSet<String>();
        FilterInfo filter = this.mainQuery.getFilter();
        headIdSet.add("1");
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            ICell planDate = this.tblMain.getRow(i).getCell(KEY_PLANDATE);
            ICell faLeaseinBillNewId = this.tblMain.getRow(i).getCell(KEY_LEASEBILLID);
            ICell id = this.tblMain.getRow(i).getCell("id");
            Date value = (Date)planDate.getValue();
            if (!this.compareDateIfPreDay(value, this.getChangeDate((String)faLeaseinBillNewId.getValue()))) {
                headIdSet.add((String)id.getValue());
                continue;
            }
            if (this.compareDateIfPreDay(value, this.getTerminatedDate((String)faLeaseinBillNewId.getValue()))) continue;
            headIdSet.add((String)id.getValue());
        }
        String maskString = filter.getMaskString();
        maskString = maskString + "AND #" + filter.getFilterItems().size();
        filter.setMaskString(maskString);
        filter.getFilterItems().add(new FilterItemInfo("id", headIdSet, CompareType.NOTINCLUDE));
        this.mainQuery.setFilter(filter);
    }

    private boolean compareDateIfPreDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return true;
        }
        long DATE_TIME_MILLIS = 86400000L;
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        cld1.set(cld1.get(1), cld1.get(2), cld1.get(5), 0, 0, 0);
        cld2.set(cld2.get(1), cld2.get(2), cld2.get(5), 0, 0, 0);
        int subDay = (int)((cld2.getTimeInMillis() - cld1.getTimeInMillis()) / 86400000L);
        return subDay >= 0;
    }

    protected boolean isFootVisible() {
        return true;
    }

    private void checkTerminateForCreatTo() throws BOSException {
        ICell cellLeaseInId = this.tblMain.getCell(this.tblMain.getSelectManager().getActiveRowIndex(), KEY_LEASEBILLID);
        ICell cellPlanDate = this.tblMain.getCell(this.tblMain.getSelectManager().getActiveRowIndex(), KEY_PLANDATE);
        if (cellLeaseInId != null && cellLeaseInId.getValue() != null && cellPlanDate != null && cellPlanDate.getValue() != null) {
            try {
                PeriodInfo currentPeriod = FaClientUtils.getFLCurrentPeriod((CompanyOrgUnitInfo)FaClientUtils.getCurrentCompany());
                KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
                if (selectBlock != null) {
                    int rowIndex = selectBlock.getTop();
                    IRow iRow = this.tblMain.getRow(rowIndex);
                }
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT bill.FID FROM T_Fa_FaTerminateBill bill, T_Fa_FaTerminateBillEntry entry ");
            sql.append("WHERE bill.FID = entry.FBillId AND entry.FLeaseInBillId = '" + cellLeaseInId.getValue().toString() + "' AND bill.FTerminateDate <= {d '" + cellPlanDate.getValue() + "'}");
            IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
            try {
                if (rowSet.next()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FaRentSettlementBillResource.hasTerminated"));
                    SysUtil.abort();
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public void beforeActionPerformed(ActionEvent e) {
        super.beforeActionPerformed(e);
        FlUtils.checkAdjustmentPeriodForNLM(e.getActionCommand());
    }
}

