/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.nlm.client.AbstractFaRptBaseConditionUI;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class FaRptBaseConditionUI
extends AbstractFaRptBaseConditionUI {
    protected Map periodsMap;
    protected Integer minPeriodYear;
    protected Integer maxPeriodYear;
    protected Integer minPeriodNumber;
    protected Integer maxPeriodNumber;

    @Override
    protected void init() throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.currCompany.getId().toString());
        Map periodYears = FaListFactory.getRemoteInstance().findPeriodYears(idList);
        SpinnerNumberModel yearSpinnerNumberModel = new SpinnerNumberModel();
        this.minPeriodYear = (Integer)periodYears.get("MinPeriodYear");
        this.maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
        this.minPeriodNumber = (Integer)periodYears.get("MinPeriodNumber");
        this.maxPeriodNumber = (Integer)periodYears.get("MaxPeriodNumber");
        yearSpinnerNumberModel.setMinimum(this.minPeriodYear);
        yearSpinnerNumberModel.setMaximum(this.maxPeriodYear);
        this.spnYear.setModel((SpinnerModel)yearSpinnerNumberModel);
        super.init();
    }

    @Override
    protected Map getCustomCond() {
        Map customCond = super.getCustomCond();
        customCond.put("year", this.spnYear.getValue());
        customCond.put("month", this.spnMonth.getValue());
        customCond.put("initperiod", this.chkInitPeriod.isSelected());
        return customCond;
    }

    @Override
    protected CustomerParams getCustParams() {
        CustomerParams params = super.getCustParams();
        params.putInt("year", this.spnYear.getIntegerVlaue().intValue());
        params.putInt("month", this.spnMonth.getIntegerVlaue().intValue());
        params.putBoolean("initperiod", this.chkInitPeriod.isSelected());
        return params;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams cond = this.getCustomerParams();
        if (cond != null) {
            this.spnYear.setValue((Object)new Integer(cond.getInt("year")));
            this.spnMonth.setValue((Object)new Integer(cond.getInt("month")));
            this.chkInitPeriod.setSelected(cond.getBoolean("initperiod"));
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.chkInitPeriod.setSelected(false);
    }

    protected void initListener() {
        super.initListener();
        this.chkInitPeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FaRptBaseConditionUI.this.fireInitPeriodSelect();
            }
        });
    }

    protected void fireInitPeriodSelect() {
        if (this.chkInitPeriod.isSelected()) {
            this.spnYear.setEnabled(false);
            this.spnMonth.setEnabled(false);
        } else {
            this.spnYear.setEnabled(true);
            this.spnMonth.setEnabled(true);
        }
    }
}

