/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.nlm.client.CompanyTreeSelectUI;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class FaRptQueryPanel
extends CustomerQueryPanel {
    private static final long serialVersionUID = -8036711573806789586L;
    protected static final String RES_PATH = "com.kingdee.eas.fi.fa.rpt.FaRptResource";
    protected static final String PERIOD_TYPE = "periodType";
    protected static final String ACCOUNT_TABLE = "accountTable";
    protected static final String NUMBER = "number";
    protected static final String NAME = "name";
    protected static final String ID = "id";
    protected CompanyOrgUnitInfo currCompany = this.getCurrentCompany();
    protected boolean isVirCompany = !this.currCompany.isIsBizUnit();
    protected KDWorkButton wbtMoveUp;
    protected KDWorkButton wbtMoveDown;
    protected CompanyTreeSelectUI ctsUI;
    protected JDialog dialog;
    private boolean isShowFilterLoadData = false;
    HashMap initInfo = null;
    protected AcountSchemeInfo schemeInfo = null;

    public AcountSchemeInfo getSchemeInfo() {
        return this.schemeInfo;
    }

    public void setSchemeInfo(AcountSchemeInfo schemeInfo) {
        this.schemeInfo = schemeInfo;
    }

    protected void init() throws Exception {
        this.wbtMoveUp = new KDWorkButton();
        this.wbtMoveDown = new KDWorkButton();
        this.wbtMoveUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.wbtMoveUp.setText(null);
        this.wbtMoveUp.setToolTipText(EASResource.getString((String)RES_PATH, (String)"moveUp"));
        this.wbtMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.wbtMoveDown.setText(null);
        this.wbtMoveDown.setToolTipText(EASResource.getString((String)RES_PATH, (String)"moveDown"));
        this.addListener();
        this.setDefaultData();
    }

    protected void addListener() throws Exception {
    }

    protected void setDefaultData() throws Exception {
    }

    public FilterInfo getFilterInfo() {
        this.setCustomerParams(this.getCustParams());
        return super.getFilterInfo();
    }

    public boolean verify() {
        this.setCustomerParams(this.getCustParams());
        return true;
    }

    protected Map getCustomCond() {
        HashMap cond = new HashMap();
        return cond;
    }

    protected CustomerParams getCustParams() {
        CustomerParams params = new CustomerParams();
        return params;
    }

    protected CustomerParams transCompanyTree(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        CustomerParams params = new CustomerParams();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeNode;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)node.getUserObject();
        params.addCustomerParam(ID, company.getId().toString());
        params.addCustomerParam(NAME, company.getName());
        params.addCustomerParam(NUMBER, company.getNumber());
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode sonNode = treeNode.getChildAt(i);
            params.putMe("son" + i, this.transCompanyTree(sonNode));
        }
        return params;
    }

    protected TreeNode resumeCompanyTree(CustomerParams companys) {
        if (companys == null) {
            return null;
        }
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companys.getCustomerParam(ID)));
        company.setName(companys.getCustomerParam(NAME));
        company.setNumber(companys.getCustomerParam(NUMBER));
        node.setUserObject(company);
        for (Object son : companys.getValues()) {
            if (!(son instanceof CustomerParams)) continue;
            TreeNode sonNode = this.resumeCompanyTree((CustomerParams)son);
            node.add((MutableTreeNode)sonNode);
        }
        return node;
    }

    protected CompanyOrgUnitInfo getCurrentCompany() throws BOSException, EASBizException {
        if (this.currCompany == null) {
            String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            this.currCompany = this.getCompanyById(companyID);
        }
        return this.currCompany;
    }

    protected CompanyOrgUnitInfo getCompanyById(String companyID) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(ID));
        sic.add(new SelectorItemInfo(NAME));
        sic.add(new SelectorItemInfo(NUMBER));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("accountTable.*"));
        sic.add(new SelectorItemInfo("accountPeriodType.*"));
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
    }

    public void clear() {
        super.clear();
        try {
            this.setDefaultData();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public boolean isShowFilterLoadData() {
        return this.isShowFilterLoadData;
    }

    public void setShowFilterLoadData(boolean isShowFilterLoadData) {
        this.isShowFilterLoadData = isShowFilterLoadData;
    }
}

