/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.fi.nlm.FlContrastCaclFactory;
import com.kingdee.eas.fi.nlm.FlContrastSolutionInfo;
import com.kingdee.eas.fi.nlm.IFlContrastCacl;
import com.kingdee.eas.fi.nlm.client.FlContrastUI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.SwingUtilities;

public class FlContrastProcessAsyn {
    private static final int POOL_SIZE = 5;
    private static ScheduledExecutorService executor = Executors.newScheduledThreadPool(5);
    private static Map queryCondMap = new HashMap();

    public static Future runProcessAsyn(final String type, final String companyId, final HashMap accountMap, HashMap catMap, boolean isUseCardAcct, final boolean isIncludeUnposted, final int periodYear, final int periodNumber, boolean isUseCatNumber, final FlContrastUI.FlContrastProcessAsynCallBack callback) {
        Future<?> future = executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    IFlContrastCacl FlContrastCacl2 = FlContrastCaclFactory.getRemoteInstance();
                    if ("0".equals(type)) {
                        final HashMap results = FlContrastCacl2.faAcctDetail(companyId, accountMap, isIncludeUnposted, periodYear, periodNumber);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                callback.updateUIForFinal(results, companyId);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            callback.updateUIForException(e);
                        }
                    });
                }
            }
        });
        return future;
    }

    public static Future runProcessAsyn(final String type, final List queryCondList, final FlContrastUI.FlContrastProcessAsynCallBack callback) {
        Future<?> future = executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < queryCondList.size(); ++i) {
                        queryCondMap = (Map)queryCondList.get(i);
                        IFlContrastCacl flContrastCacl = FlContrastCaclFactory.getRemoteInstance();
                        if (!"0".equals(type)) continue;
                        final String companyId = FlContrastProcessAsyn.getContrastCompanyId();
                        final HashMap results = flContrastCacl.faAcctDetail(companyId, FlContrastProcessAsyn.getAccountMap(), FlContrastProcessAsyn.isIncludeUnposted(), Integer.parseInt(FlContrastProcessAsyn.getContrastPeriodYear()), Integer.parseInt(FlContrastProcessAsyn.getContrastPeriodNumber()));
                        if (!Thread.currentThread().isInterrupted()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    callback.updateUIForFinal(results, companyId);
                                }
                            });
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            callback.updateUIForException(e);
                        }
                    });
                }
            }
        });
        return future;
    }

    private static boolean isUseCardAcct() throws Exception {
        boolean isUseCardAcct = false;
        if (queryCondMap.size() > 0 && queryCondMap.get("solution") != null) {
            CustomerParams cp = XMLBean.TransStrToCustParams((String)((FlContrastSolutionInfo)queryCondMap.get("solution")).getParams());
            isUseCardAcct = cp.getBoolean("isUseCardAcct");
        }
        return isUseCardAcct;
    }

    private static String getContrastCompanyId() {
        String companyId = null;
        if (queryCondMap.size() > 0) {
            companyId = (String)queryCondMap.get("orgId");
        }
        return companyId;
    }

    private static HashMap getAccountMap() throws Exception {
        HashMap accounts = new HashMap();
        if (queryCondMap.size() > 0 && queryCondMap.get("solution") != null) {
            CustomerParams cp = XMLBean.TransStrToCustParams((String)((FlContrastSolutionInfo)queryCondMap.get("solution")).getParams());
            CustomerParams accountMap = cp.getMe("AccountMap");
            HashMap assets = new HashMap();
            assets.putAll(accountMap.getMe("ASSET").getCustomerParamsHashMap());
            accounts.put("ASSET", assets);
            HashMap depres = new HashMap();
            depres.putAll(accountMap.getMe("DEPRE").getCustomerParamsHashMap());
            accounts.put("DEPRE", depres);
            HashMap decvalues = new HashMap();
            decvalues.putAll(accountMap.getMe("DECVALUE").getCustomerParamsHashMap());
            accounts.put("DECVALUE", decvalues);
        }
        return accounts;
    }

    private static HashMap getCatMap() throws Exception {
        HashMap<String, HashMap> catMap = new HashMap<String, HashMap>();
        if (queryCondMap.size() > 0 && queryCondMap.get("solution") != null) {
            CustomerParams cp = XMLBean.TransStrToCustParams((String)((FlContrastSolutionInfo)queryCondMap.get("solution")).getParams());
            HashMap catMapKey = cp.getMe("CatMap").getCustomerParamsHashMap();
            CustomerParams midCP = cp.getMe("CatMap");
            Set catSet = catMapKey.keySet();
            for (int i = 0; i < catSet.size(); ++i) {
                HashMap cMap = midCP.getMe(String.valueOf(catSet.toArray()[i])).getCustomerParamsHashMap();
                catMap.put(String.valueOf(catSet.toArray()[i]), cMap);
            }
        }
        return catMap;
    }

    private static boolean isIncludeUnposted() throws Exception {
        boolean isIncludeUnposted = false;
        if (queryCondMap.size() > 0 && queryCondMap.get("solution") != null) {
            CustomerParams cp = XMLBean.TransStrToCustParams((String)((FlContrastSolutionInfo)queryCondMap.get("solution")).getParams());
            isIncludeUnposted = cp.getBoolean("isIncludeUnposted");
        }
        return isIncludeUnposted;
    }

    private static String getContrastPeriodYear() {
        String periodYear = null;
        if (queryCondMap.size() > 0) {
            periodYear = String.valueOf(queryCondMap.get("periodYear"));
        }
        return periodYear;
    }

    private static String getContrastPeriodNumber() {
        String periodNumber = null;
        if (queryCondMap.size() > 0) {
            periodNumber = String.valueOf(queryCondMap.get("periodNumber"));
        }
        return periodNumber;
    }

    private static boolean isUseEvaValue() throws Exception {
        boolean isUseEvaValue = false;
        if (queryCondMap.size() > 0 && queryCondMap.get("solution") != null) {
            CustomerParams cp = XMLBean.TransStrToCustParams((String)((FlContrastSolutionInfo)queryCondMap.get("solution")).getParams());
            isUseEvaValue = cp.getBoolean("isUseEvaValue");
        }
        return isUseEvaValue;
    }

    private static boolean isUseCatNumber() throws Exception {
        boolean isUseCat = false;
        if (queryCondMap.size() > 0 && queryCondMap.get("solution") != null) {
            CustomerParams cp = XMLBean.TransStrToCustParams((String)((FlContrastSolutionInfo)queryCondMap.get("solution")).getParams());
            isUseCat = cp.getBoolean("isUseCatNumber");
        }
        return isUseCat;
    }
}

