/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.nlm.FaContractCatFactory;
import com.kingdee.eas.fi.nlm.FaContractCatInfo;
import com.kingdee.eas.fi.nlm.FlContrastException;
import com.kingdee.eas.fi.nlm.FlContrastSolutionFactory;
import com.kingdee.eas.fi.nlm.FlContrastSolutionInfo;
import com.kingdee.eas.fi.nlm.IFaContractCat;
import com.kingdee.eas.fi.nlm.client.AbstractFlContrastSolutionUI;
import com.kingdee.eas.fi.nlm.client.FlSolutionSaveAsPromptUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class FlContrastSolutionUI
extends AbstractFlContrastSolutionUI {
    private static final long serialVersionUID = 2219456896359226313L;
    private static final Logger logger = CoreUIObject.getLogger(FlContrastSolutionUI.class);
    public static final String AccountMap_Key = "AccountMap";
    public static final String IsIncludeUnposted_Key = "isIncludeUnposted";
    public static final String IsDefaultSolution_Key = "IsDefaultSolution";
    public static final String OnlyShowUnEven_Key = "onlyShowUnEven";
    public static final String CatMap_Key = "CatMap";
    public static final String SelectedPeriod_Key = "SelectedPeriod";
    private CompanyOrgUnitInfo currCompany = null;
    private PeriodInfo currPeriod = null;
    private KDBizPromptBox assetKDBizPromptBoxAccount = new KDBizPromptBox();
    private KDBizPromptBox decKDBizPromptBoxAccount = new KDBizPromptBox();
    private KDBizPromptBox depreKDBizPromptBoxAccount = new KDBizPromptBox();
    private String currentSolutionName;
    private FlContrastSolutionInfo currSolutionInfo;
    protected boolean isCanceled = true;
    private boolean isConfirm = false;
    private List queryCondList = new ArrayList();
    private NewCompanyF7 aCompanyBizUnitF7 = new NewCompanyF7((IUIObject)this);

    public FlContrastSolutionUI() throws Exception {
        this.setPreferredSize(new Dimension(800, 530));
    }

    protected CompanyOrgUnitInfo getCurrCompany() {
        if (this.currCompany == null) {
            this.currCompany = (CompanyOrgUnitInfo)this.getUIContext().get("currCompany");
            this.currCompany = this.currCompany == null ? SysContext.getSysContext().getCurrentFIUnit() : this.currCompany;
        }
        return this.currCompany;
    }

    protected CompanyOrgUnitInfo getTxtCompany() {
        return (CompanyOrgUnitInfo)this.txtCompany.getValue();
    }

    protected PeriodInfo getCurrPeriod() throws EASBizException, BOSException {
        if (this.currPeriod == null) {
            this.currPeriod = FaClientUtils.getFLCurrentPeriodByCompanyID((String)this.getTxtCompany().getId().toString());
        }
        if (this.currPeriod == null) {
            throw new FlContrastException(FlContrastException.NOT_CONFIG_START_PERIOD);
        }
        return this.currPeriod;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.remove((Component)this.btnNew);
        this.remove((Component)this.btnDel);
        this.remove((Component)this.btnSave);
        this.remove((Component)this.btnSaveAs);
        KDTreeView.ControlPanel pnl = this.tree.getControlPane();
        Component[] component = pnl.getComponents();
        for (int i = component.length - 1; i >= 0; --i) {
            Component comp = pnl.getComponent(i);
            if (!(comp instanceof KDWorkButton)) continue;
            pnl.remove(comp);
        }
        pnl.add((Component)this.btnNew);
        pnl.add((Component)this.btnDel);
        pnl.add((Component)this.btnSave);
        pnl.add((Component)this.btnSaveAs);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCompanyF7();
        this.txtCompany.setValue((Object)this.getCurrCompany());
        this.btnAddLine_Asset.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddLine_Dec.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddLine_Depre.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelLine_Asset.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelLine_Dec.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelLine_Depre.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelLine_Asset.setEnabled(true);
        this.btnDelLine_Depre.setEnabled(true);
        this.btnDelLine_Dec.setEnabled(true);
        this.actionConfirm.setEnabled(true);
        this.actionExit.setEnabled(true);
        this.fillPeriodComponent();
        this.initAccountF7();
        this.setAccountF7Selector();
        this.init();
        this.txtCompany.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    FlContrastSolutionUI.this.setAccountF7Selector();
                    FlContrastSolutionUI.this.fillPeriodComponent2();
                    FlContrastSolutionUI.this.refreshSolutionList();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.onlyShowUnEven.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
            }
        });
        this.refreshSolutionList();
    }

    private void initCompanyF7() {
        this.txtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        this.txtCompany.setEditFormat("$number$");
        this.txtCompany.setDisplayFormat("$name$");
        this.txtCompany.setCommitFormat("$number$");
        this.aCompanyBizUnitF7.setIsCUFilter(true, true);
        this.aCompanyBizUnitF7.setNeedAddOrgRange(false);
        this.aCompanyBizUnitF7.setContainSealUp(true);
        this.aCompanyBizUnitF7.setPermissionItem("fa_leasecontrast_view");
        this.txtCompany.setSelector((KDPromptSelector)this.aCompanyBizUnitF7);
        this.txtCompany.setFilterInfoProducer(null);
        this.txtCompany.setHasCUDefaultFilter(false);
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return FlContrastSolutionFactory.getRemoteInstance();
    }

    private void initAccountF7() {
        this.assetTable.checkParsed();
        this.decTable.checkParsed();
        this.depreTable.checkParsed();
        this.assetKDBizPromptBoxAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.AccountViewQuery");
        this.assetKDBizPromptBoxAccount.setDisplayFormat("$number$--$name$");
        this.assetKDBizPromptBoxAccount.setEditFormat("$number$");
        this.assetKDBizPromptBoxAccount.setCommitFormat("$number$");
        this.assetKDBizPromptBoxAccount.setEditable(true);
        this.decKDBizPromptBoxAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.AccountViewQuery");
        this.decKDBizPromptBoxAccount.setDisplayFormat("$number$--$name$");
        this.decKDBizPromptBoxAccount.setEditFormat("$number$");
        this.decKDBizPromptBoxAccount.setCommitFormat("$number$");
        this.decKDBizPromptBoxAccount.setEditable(true);
        this.depreKDBizPromptBoxAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.AccountViewQuery");
        this.depreKDBizPromptBoxAccount.setDisplayFormat("$number$--$name$");
        this.depreKDBizPromptBoxAccount.setEditFormat("$number$");
        this.depreKDBizPromptBoxAccount.setCommitFormat("$number$");
        this.depreKDBizPromptBoxAccount.setEditable(true);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = this.getTxtCompany();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo companyAccountFilterItemInfo = new FilterItemInfo("companyID.id", (Object)aCompanyOrgUnitInfo.getId().toString());
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        FilterItemInfo companyAccountFilterItemInfo2 = new FilterItemInfo("accountTableID.id", (Object)aCompanyOrgUnitInfo.getAccountTable().getId().toString());
        filter.getFilterItems().add(companyAccountFilterItemInfo);
        filter.getFilterItems().add(companyAccountFilterItemInfo2);
        viewInfo.setFilter(filter);
        AccountPromptBox accountPromtBox = new AccountPromptBox((IUIObject)this, aCompanyOrgUnitInfo, filter, false, false);
        this.assetKDBizPromptBoxAccount.setSelector((KDPromptSelector)accountPromtBox);
        this.assetKDBizPromptBoxAccount.setEntityViewInfo(viewInfo);
        this.decKDBizPromptBoxAccount.setSelector((KDPromptSelector)accountPromtBox);
        this.decKDBizPromptBoxAccount.setEntityViewInfo(viewInfo);
        this.depreKDBizPromptBoxAccount.setSelector((KDPromptSelector)accountPromtBox);
        this.depreKDBizPromptBoxAccount.setEntityViewInfo(viewInfo);
        this.assetTable.getColumn("account").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.assetKDBizPromptBoxAccount));
        this.decTable.getColumn("account").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.decKDBizPromptBoxAccount));
        this.depreTable.getColumn("account").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.depreKDBizPromptBoxAccount));
        ObjectValueRender render = new ObjectValueRender();
        render.setFormat(new IDataFormat(){

            public String format(Object object) {
                StringBuffer ret = new StringBuffer();
                if (object.getClass().isArray()) {
                    Object[] os = (Object[])object;
                    for (int i = 0; i < os.length; ++i) {
                        if (i > 0) {
                            ret.append("; ");
                        }
                        ret.append(((FaContractCatInfo)os[i]).toString());
                    }
                }
                return ret.toString();
            }
        });
    }

    private void setAccountF7Selector() throws EASBizException, BOSException {
        CompanyOrgUnitInfo txtCompany = this.getTxtCompany();
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)txtCompany);
        String acctTableID = txtCompany.getAccountTable().getId().toString();
        acctTableID = AccountTools.getCurrentAcctTable((String)txtCompany.getId().toString(), (String)acctTableID, (int)this.getCurrPeriod().getPeriodYear(), (int)this.getCurrPeriod().getPeriodNumber());
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("number"));
        AccountTableInfo acctTable = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(acctTableID), selectors);
        FilterInfo assetFilterInfo = new FilterInfo();
        assetFilterInfo.getFilterItems().add(new FilterItemInfo("ACCOUNTVIEW.ID", (Object)("select distinct fusufructAssetAcctID from T_FA_FAContractCat where fusufructAssetAcctID is not null and FCOMPANYID='" + txtCompany.getId().toString() + "'"), CompareType.INNER));
        AccountPromptBox assetAccountPromtBox = new AccountPromptBox((IUIObject)this, txtCompany, acctTable, assetFilterInfo, false, false);
        this.assetKDBizPromptBoxAccount.setSelector((KDPromptSelector)assetAccountPromtBox);
        FilterInfo decFilterInfo = new FilterInfo();
        decFilterInfo.getFilterItems().add(new FilterItemInfo("ACCOUNTVIEW.ID", (Object)("select distinct fusufructAssetAcctDECID from T_FA_FAContractCat where fusufructAssetAcctDECID is not null and FCOMPANYID='" + txtCompany.getId().toString() + "'"), CompareType.INNER));
        AccountPromptBox decAccountPromtBox = new AccountPromptBox((IUIObject)this, txtCompany, acctTable, decFilterInfo, false, false);
        this.decKDBizPromptBoxAccount.setSelector((KDPromptSelector)decAccountPromtBox);
        FilterInfo depreFilterInfo = new FilterInfo();
        depreFilterInfo.getFilterItems().add(new FilterItemInfo("ACCOUNTVIEW.ID", (Object)("select distinct fusufructAssetAcctACMID from T_FA_FAContractCat where fusufructAssetAcctACMID is not null and FCOMPANYID='" + txtCompany.getId().toString() + "'"), CompareType.INNER));
        AccountPromptBox depreAccountPromtBox = new AccountPromptBox((IUIObject)this, txtCompany, acctTable, depreFilterInfo, false, false);
        this.depreKDBizPromptBoxAccount.setSelector((KDPromptSelector)depreAccountPromtBox);
    }

    protected void init() throws Exception {
        this.btnNew.setText(null);
        this.btnNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnNew.setFactType(0);
        this.btnNew.setBorder(null);
        this.btnNew.setContentAreaFilled(false);
        this.btnDel.setText(null);
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDel.setFactType(0);
        this.btnDel.setBorder(null);
        this.btnDel.setContentAreaFilled(false);
        this.btnSave.setText(null);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setFactType(0);
        this.btnSave.setBorder(null);
        this.btnSave.setContentAreaFilled(false);
        this.btnSaveAs.setText(null);
        this.btnSaveAs.setIcon(EASResource.getIcon((String)"imgTbtn_saveas"));
        this.btnSaveAs.setFactType(0);
        this.btnSaveAs.setBorder(null);
        this.btnSaveAs.setContentAreaFilled(false);
    }

    public CustomerParams getFilterInfo() {
        int i;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("checkedStatus", (Object)new Integer(2)));
        CustomerParams assetAccount = new CustomerParams();
        CustomerParams decAccount = new CustomerParams();
        CustomerParams depreAccount = new CustomerParams();
        CustomerParams catMap = new CustomerParams();
        for (i = 0; i < this.assetTable.getRowCount(); ++i) {
            if (this.assetTable.getRow(i).getCell("account").getValue() == null) continue;
            assetAccount.addCustomerParam("account" + i, ((AccountViewInfo)this.assetTable.getRow(i).getCell("account").getValue()).getId().toString());
        }
        for (i = 0; i < this.decTable.getRowCount(); ++i) {
            if (this.decTable.getRow(i).getCell("account").getValue() == null) continue;
            decAccount.addCustomerParam("account" + i, ((AccountViewInfo)this.decTable.getRow(i).getCell("account").getValue()).getId().toString());
        }
        for (i = 0; i < this.depreTable.getRowCount(); ++i) {
            if (this.depreTable.getRow(i).getCell("account").getValue() == null) continue;
            depreAccount.addCustomerParam("account" + i, ((AccountViewInfo)this.depreTable.getRow(i).getCell("account").getValue()).getId().toString());
        }
        if (assetAccount.getValues().size() == 0 && decAccount.getValues().size() == 0 && depreAccount.getValues().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"FlContrastUI_accountNotNull"));
            SysUtil.abort();
        }
        CustomerParams accountMap = new CustomerParams();
        accountMap.putMe("ASSET", assetAccount);
        accountMap.putMe("DECVALUE", decAccount);
        accountMap.putMe("DEPRE", depreAccount);
        filter.put(AccountMap_Key, (Object)accountMap);
        filter.put(CatMap_Key, (Object)catMap);
        filter.put(IsIncludeUnposted_Key, (Object)(this.chbHasNotVoucher.getSelected() == 32 ? 1 : 0));
        filter.put(IsDefaultSolution_Key, (Object)(this.chbDefault.getSelected() == 32 ? 1 : 0));
        filter.put(OnlyShowUnEven_Key, (Object)(this.onlyShowUnEven.getSelected() == 32 ? 1 : 0));
        CustomerParams serializObj = new CustomerParams();
        serializObj.putMe(AccountMap_Key, accountMap);
        serializObj.putMe(CatMap_Key, catMap);
        serializObj.putBoolean(IsIncludeUnposted_Key, this.chbHasNotVoucher.isSelected());
        serializObj.putBoolean(IsDefaultSolution_Key, this.chbDefault.isSelected());
        serializObj.putBoolean(OnlyShowUnEven_Key, this.onlyShowUnEven.isSelected());
        return serializObj;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        if (((AbstractButton)e.getSource()).getName().endsWith("_Asset")) {
            this.assetTable.addRow();
        }
        if (((AbstractButton)e.getSource()).getName().endsWith("_Dec")) {
            this.decTable.addRow();
        }
        if (((AbstractButton)e.getSource()).getName().endsWith("_Depre")) {
            this.depreTable.addRow();
        }
    }

    @Override
    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelLine_actionPerformed(e);
        if (((AbstractButton)e.getSource()).getName().endsWith("_Asset")) {
            this.removeLine(this.assetTable);
        }
        if (((AbstractButton)e.getSource()).getName().endsWith("_Dec")) {
            this.removeLine(this.decTable);
        }
        if (((AbstractButton)e.getSource()).getName().endsWith("_Depre")) {
            this.removeLine(this.depreTable);
        }
    }

    protected void removeLine(KDTable table) {
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = table.getSelectManager().get().getTop();
        if (table.getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        table.removeRow(top);
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public boolean verify() {
        int i;
        AccountViewInfo accountI = null;
        AccountViewInfo account0 = null;
        boolean hasChildren = false;
        String strAccount = EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"strAccount");
        String notFitPeriod = EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"notFitPeriod");
        CompanyOrgUnitInfo txtCompany = this.getTxtCompany();
        String cuID = txtCompany.getId().toString();
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)txtCompany);
        String acctTableID = txtCompany.getAccountTable().getId().toString();
        try {
            acctTableID = AccountTools.getCurrentAcctTable((String)cuID, (String)acctTableID, (int)((Integer)this.spPeriodYear.getValue()), (int)((Integer)this.spPeriodNumber.getValue()));
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        StringBuffer errInfo = new StringBuffer();
        for (i = 0; i < this.assetTable.getRowCount(); ++i) {
            if (this.assetTable.getRow(i).getCell("account").getValue() != null) {
                accountI = (AccountViewInfo)this.assetTable.getRow(i).getCell("account").getValue();
                account0 = (AccountViewInfo)this.assetTable.getRow(0).getCell("account").getValue();
                if (!accountI.getAccountTableID().getId().toString().equals(acctTableID)) {
                    errInfo.append("\uff1b").append(strAccount).append(accountI.getNumber());
                    errInfo.append("(").append(accountI.getName()).append(")").append(notFitPeriod);
                }
                if (accountI.getDC() == account0.getDC()) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"CommonQueryDialogWithoutToolBar_AssetAccountPropertyError"));
                return false;
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"FlContrastUI_accountNotNull"));
            return false;
        }
        for (i = 0; i < this.decTable.getRowCount(); ++i) {
            if (this.decTable.getRow(i).getCell("account").getValue() != null) {
                accountI = (AccountViewInfo)this.decTable.getRow(i).getCell("account").getValue();
                account0 = (AccountViewInfo)this.decTable.getRow(0).getCell("account").getValue();
                if (!accountI.getAccountTableID().getId().toString().equals(acctTableID)) {
                    errInfo.append("\uff1b").append(strAccount).append(accountI.getNumber());
                    errInfo.append("(").append(accountI.getName()).append(")").append(notFitPeriod);
                }
                if (accountI.getDC() == account0.getDC()) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"CommonQueryDialogWithoutToolBar_DecAccountPropertyError"));
                return false;
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"FlContrastUI_accountNotNull"));
            return false;
        }
        for (i = 0; i < this.depreTable.getRowCount(); ++i) {
            if (this.depreTable.getRow(i).getCell("account").getValue() != null) {
                accountI = (AccountViewInfo)this.depreTable.getRow(i).getCell("account").getValue();
                account0 = (AccountViewInfo)this.depreTable.getRow(0).getCell("account").getValue();
                if (!accountI.getAccountTableID().getId().toString().equals(acctTableID)) {
                    errInfo.append("\uff1b").append(strAccount).append(accountI.getNumber());
                    errInfo.append("(").append(accountI.getName()).append(")").append(notFitPeriod);
                }
                if (accountI.getDC() == account0.getDC()) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"CommonQueryDialogWithoutToolBar_DepreAccountPropertyError"));
                return false;
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"FlContrastUI_accountNotNull"));
            return false;
        }
        if (errInfo.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)errInfo.substring(1));
            return false;
        }
        return true;
    }

    private boolean hasChildren(Object[] catArray) {
        if (catArray == null) {
            return false;
        }
        for (int i = 0; i < catArray.length; ++i) {
            FaContractCatInfo catInfo1 = (FaContractCatInfo)catArray[i];
            for (int j = 0; j < catArray.length; ++j) {
                if (j == i) continue;
                FaContractCatInfo catInfo2 = (FaContractCatInfo)catArray[j];
                if (catInfo1.getLongNumber().indexOf(catInfo2.getLongNumber() + "!") <= -1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void btnNew_actionPerformed(ActionEvent e) throws Exception {
        this.newContrastSolution();
    }

    protected void newContrastSolution() {
        this.resetSolution();
        this.btnDel.setEnabled(false);
        this.setCurrSolutionInfo(null);
        if (this.tree.getTree() != null) {
            this.tree.getTree().setSelectionNode(null);
        }
    }

    protected void resetSolution() {
        this.assetTable.removeRows();
        this.depreTable.removeRows();
        this.decTable.removeRows();
        this.chbHasNotVoucher.setSelected(false);
        this.chbDefault.setSelected(false);
        this.onlyShowUnEven.setSelected(false);
    }

    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        this.saveContrastSolution(false);
    }

    @Override
    protected void btnSaveAs_actionPerformed(ActionEvent e) throws Exception {
        this.saveContrastSolution(true);
    }

    protected void saveContrastSolution(boolean isNewSolution) throws Exception {
        if (this.verify()) {
            if (!this.canSave(isNewSolution)) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"CommonQueryDialogWithoutToolBar_HasDefault"));
                return;
            }
            if (isNewSolution) {
                if (this.showSolutionDialog()) {
                    if (this.isExistsSameNameSolution()) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"SolutionNameExists"));
                        return;
                    }
                    this.addSolution();
                }
            } else if (this.getCurrSolutionInfo() == null || this.getCurrSolutionInfo().getId() == null) {
                if (this.showSolutionDialog()) {
                    if (this.isExistsSameNameSolution()) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"SolutionNameExists"));
                        return;
                    }
                    this.addSolution();
                }
            } else {
                this.saveSolution();
            }
            this.refreshSolutionList();
        }
    }

    private String getCurrSolutionName() {
        return this.currentSolutionName;
    }

    private void setCurrSolutionName(String name) {
        this.currentSolutionName = name;
    }

    private void setCurrSolutionInfo(FlContrastSolutionInfo info) {
        this.currSolutionInfo = info;
    }

    public FlContrastSolutionInfo getCurrSolutionInfo() {
        return this.currSolutionInfo;
    }

    private boolean canSave(boolean isNewSolution) throws Exception {
        boolean isDefaultSolution = this.chbDefault.isSelected();
        if (!isDefaultSolution) {
            return true;
        }
        CoreBaseCollection solutionColl = this.getSolutionCollection();
        for (int i = 0; i < solutionColl.size(); ++i) {
            FlContrastSolutionInfo solution = (FlContrastSolutionInfo)solutionColl.get(i);
            if (!isNewSolution && this.getCurrSolutionInfo() != null && this.getCurrSolutionInfo().getId() != null && this.getCurrSolutionInfo().getId().toString().equalsIgnoreCase(solution.getId().toString())) continue;
            boolean savedIsDefaultSolution = false;
            if (solution != null && solution.getParams() != null) {
                CustomerParams savedLoadInfo = XMLBean.TransStrToCustParams((String)solution.getParams());
                savedIsDefaultSolution = savedLoadInfo.getBoolean(IsDefaultSolution_Key);
            }
            if (!isDefaultSolution || !savedIsDefaultSolution) continue;
            return false;
        }
        return true;
    }

    private boolean showSolutionDialog() throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.nlm.client.FlSolutionSaveAsPromptUI", (Map)uiContext, null, null);
        FlSolutionSaveAsPromptUI promptUI = (FlSolutionSaveAsPromptUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!promptUI.isOK()) {
            return false;
        }
        this.setCurrSolutionName(promptUI.getSchemaName());
        return true;
    }

    private boolean isExistsSameNameSolution() {
        String orgID = this.getTxtCompany().getId().toString();
        String saveName = this.getCurrSolutionName();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)saveName));
        boolean result = false;
        try {
            result = this.getBizInterface().exists(filterInfo);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return result;
    }

    private void addSolution() throws EASBizException, BOSException {
        FlContrastSolutionInfo solution = new FlContrastSolutionInfo();
        solution.setName(this.getCurrSolutionName());
        solution.setOrgID(this.getTxtCompany().getId().toString());
        solution.setOwnerID(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        String customerParams = null;
        CustomerParams custParams = this.getFilterInfo();
        if (custParams != null) {
            Collection keys = custParams.getKeys();
            Collection values = custParams.getValues();
            if (keys.size() > 0) {
                try {
                    customerParams = XMLBean.CreateXMLStrRecursion((Collection)keys, (Collection)values);
                }
                catch (Exception ex) {
                    MsgBox.showInfo((String)ex.getMessage());
                }
            }
        }
        solution.setParams(customerParams);
        IObjectPK objectPK = this.getBizInterface().save((CoreBaseInfo)solution);
        solution.setId(BOSUuid.read((String)objectPK.toString()));
        this.setCurrSolutionInfo(solution);
    }

    private void saveSolution() throws EASBizException, BOSException {
        FlContrastSolutionInfo solution = this.getCurrSolutionInfo();
        String customerParams = null;
        CustomerParams custParams = this.getFilterInfo();
        if (custParams != null) {
            Collection keys = custParams.getKeys();
            Collection values = custParams.getValues();
            if (keys.size() > 0) {
                try {
                    customerParams = XMLBean.CreateXMLStrRecursion((Collection)keys, (Collection)values);
                }
                catch (Exception ex) {
                    MsgBox.showInfo((String)ex.getMessage());
                }
            }
        }
        solution.setParams(customerParams);
        this.getBizInterface().update((IObjectPK)new ObjectUuidPK(solution.getId().toString()), (CoreBaseInfo)solution);
        this.setCurrSolutionInfo(solution);
    }

    protected void refreshSolutionList() throws EASBizException, Exception {
        CoreBaseCollection solutionColls = this.getSolutionCollection();
        this.btnDel.setEnabled(solutionColls.size() > 0);
        Locale loc = SysContext.getSysContext().getLocale();
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"root");
        for (int i = 0; i < solutionColls.size(); ++i) {
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)solutionColls.get(i));
            node.setText(((FlContrastSolutionInfo)solutionColls.get(i)).getName(loc));
            node.setChecked(false);
            node.setCustomIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
            root.add((MutableTreeNode)node);
        }
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
        KDTree tt = new KDTree((TreeModel)model);
        tt.setRootVisible(false);
        this.tree.setTree(tt);
        tt.setShowCheckBox(false);
        tt.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                FlContrastSolutionUI.this.btnDel.setEnabled(path != null);
                if (path != null) {
                    FlContrastSolutionInfo solution = (FlContrastSolutionInfo)((DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject();
                    try {
                        if (FlContrastSolutionUI.this.currSolutionInfo != null && FlContrastSolutionUI.this.currSolutionInfo.getId() != null && FlContrastSolutionUI.this.currSolutionInfo.getId().equals((Object)solution.getId())) {
                            return;
                        }
                        FlContrastSolutionUI.this.setCurrSolutionInfo(solution);
                        if (solution.getParams() != null) {
                            FlContrastSolutionUI.this.setSolution(FlContrastSolutionUI.this.loadSolution(solution.getId().toString()));
                        }
                        ((DefaultKingdeeTreeNode)path.getLastPathComponent()).setChecked(true);
                        FlContrastSolutionUI.this.btnDel.setEnabled(true);
                        FlContrastSolutionUI.this.btnSave.setEnabled(true);
                    }
                    catch (Exception ex) {
                        FlContrastSolutionUI.this.handUIException(ex);
                    }
                }
            }
        });
        if (solutionColls.size() == 0) {
            return;
        }
        DefaultKingdeeTreeNode treeRoot = (DefaultKingdeeTreeNode)this.tree.getTree().getModel().getRoot();
        FlContrastSolutionInfo cc = null;
        if (this.getCurrSolutionInfo() == null) {
            this.btnDel.setEnabled(false);
            this.btnSave.setEnabled(false);
            return;
        }
        this.btnDel.setEnabled(true);
        this.btnSave.setEnabled(true);
        int n = treeRoot.getChildCount();
        for (int i = 0; i < n; ++i) {
            cc = (FlContrastSolutionInfo)((DefaultKingdeeTreeNode)treeRoot.getChildAt(i)).getUserObject();
            if (!cc.getId().equals((Object)this.getCurrSolutionInfo().getId())) continue;
            this.tree.getTree().setSelectionNode((DefaultKingdeeTreeNode)treeRoot.getChildAt(i));
            break;
        }
    }

    private CoreBaseCollection getSolutionCollection() throws BOSException {
        String orgID = this.getTxtCompany().getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.getSorter().add(new SorterItemInfo("name"));
        view.setSorter(sorter);
        return this.getBizInterface().getCollection(view);
    }

    protected FlContrastSolutionInfo loadSolution(String Id) throws EASBizException, BOSException {
        return (FlContrastSolutionInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(Id));
    }

    protected void setSolution(FlContrastSolutionInfo solution) throws Exception {
        CustomerParams loadInfo = XMLBean.TransStrToCustParams((String)solution.getParams());
        if (loadInfo != null) {
            this.fillTable(loadInfo);
            boolean isIncludeUnposted = loadInfo.getBoolean(IsIncludeUnposted_Key);
            this.chbHasNotVoucher.setSelected(isIncludeUnposted);
            boolean isDefaultSolution = loadInfo.getBoolean(IsDefaultSolution_Key);
            this.chbDefault.setSelected(isDefaultSolution);
            boolean isOnlyShowUnEven = loadInfo.getBoolean(OnlyShowUnEven_Key);
            this.onlyShowUnEven.setSelected(isOnlyShowUnEven);
            boolean bl = true;
        }
    }

    private void fillTable(CustomerParams loadInfo) {
        CustomerParams accountMap = loadInfo.getMe(AccountMap_Key);
        CustomerParams catMap = loadInfo.getMe(CatMap_Key);
        if (accountMap == null && catMap == null) {
            return;
        }
        if (accountMap.getMe("ASSET") == null || accountMap.getMe("ASSET").getCustomerParamsHashMap() == null || accountMap.getMe("DECVALUE") == null || accountMap.getMe("DECVALUE").getCustomerParamsHashMap() == null || accountMap.getMe("DEPRE") == null || accountMap.getMe("DEPRE").getCustomerParamsHashMap() == null) {
            return;
        }
        TreeSet assetKeySet = new TreeSet(accountMap.getMe("ASSET").getCustomerParamsHashMap().keySet());
        TreeSet decvalueKeySet = new TreeSet(accountMap.getMe("DECVALUE").getCustomerParamsHashMap().keySet());
        TreeSet depreKeySet = new TreeSet(accountMap.getMe("DEPRE").getCustomerParamsHashMap().keySet());
        IRow row = null;
        this.assetTable.removeRows();
        this.decTable.removeRows();
        this.depreTable.removeRows();
        try {
            Iterator tmpItem;
            int i;
            String value;
            int i2;
            IAccountView iAccount = AccountViewFactory.getRemoteInstance();
            HashMap<String, AccountViewInfo> accountInfoMap = new HashMap<String, AccountViewInfo>();
            HashSet<String> accountIdSet = new HashSet<String>();
            for (i2 = 0; i2 < assetKeySet.size(); ++i2) {
                value = (String)accountMap.getMe("ASSET").getCustomerParamsHashMap().get(assetKeySet.toArray()[i2]);
                accountIdSet.add(value);
            }
            for (i2 = 0; i2 < decvalueKeySet.size(); ++i2) {
                value = (String)accountMap.getMe("DECVALUE").getCustomerParamsHashMap().get(decvalueKeySet.toArray()[i2]);
                accountIdSet.add(value);
            }
            for (i2 = 0; i2 < depreKeySet.size(); ++i2) {
                value = (String)accountMap.getMe("DEPRE").getCustomerParamsHashMap().get(depreKeySet.toArray()[i2]);
                accountIdSet.add(value);
            }
            if (accountIdSet.size() > 0) {
                EntityViewInfo v = new EntityViewInfo();
                FilterInfo f = new FilterInfo();
                v.setFilter(f);
                f.getFilterItems().add(new FilterItemInfo("id", accountIdSet, CompareType.INCLUDE));
                AccountViewCollection accounts = iAccount.getAccountViewCollection(v);
                for (int i3 = 0; i3 < accounts.size(); ++i3) {
                    accountInfoMap.put(accounts.get(i3).getId().toString(), accounts.get(i3));
                }
            }
            IFaContractCat faContractCat = FaContractCatFactory.getRemoteInstance();
            String ids = "";
            for (i = 0; i < assetKeySet.size(); ++i) {
                row = this.assetTable.addRow();
                String value2 = (String)accountMap.getMe("ASSET").getCustomerParamsHashMap().get(assetKeySet.toArray()[i]);
                row.getCell("account").setValue(accountInfoMap.get(value2));
                if (catMap == null || catMap.getMe("ASSET_" + value2) == null) continue;
                Collection assetCat = catMap.getMe("ASSET_" + value2).getValues();
                ids = "";
                tmpItem = assetCat.iterator();
                while (tmpItem.hasNext()) {
                    ids = ids + ",'" + tmpItem.next().toString() + "'";
                }
            }
            for (i = 0; i < decvalueKeySet.size(); ++i) {
                row = this.decTable.addRow();
                String value3 = (String)accountMap.getMe("DECVALUE").getCustomerParamsHashMap().get(decvalueKeySet.toArray()[i]);
                row.getCell("account").setValue(accountInfoMap.get(value3));
                if (catMap == null || catMap.getMe("DECVALUE_" + value3) == null) continue;
                Collection decCat = catMap.getMe("DECVALUE_" + value3).getValues();
                ids = "";
                tmpItem = decCat.iterator();
                while (tmpItem.hasNext()) {
                    ids = ids + ",'" + tmpItem.next().toString() + "'";
                }
            }
            for (i = 0; i < depreKeySet.size(); ++i) {
                row = this.depreTable.addRow();
                String value4 = (String)accountMap.getMe("DEPRE").getCustomerParamsHashMap().get(depreKeySet.toArray()[i]);
                row.getCell("account").setValue(accountInfoMap.get(value4));
                if (catMap == null || catMap.getMe("DEPRE_" + value4) == null) continue;
                Collection depreCat = catMap.getMe("DEPRE_" + value4).getValues();
                ids = "";
                tmpItem = depreCat.iterator();
                while (tmpItem.hasNext()) {
                    ids = ids + ",'" + tmpItem.next().toString() + "'";
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((Component)((Object)this), (String)GLResUtil.getRes((String)"confirm_del_schema")) == 0) {
            this.delContrastSolution();
        }
    }

    protected void delContrastSolution() throws Exception {
        if (this.getCurrSolutionInfo().getId() != null) {
            this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(this.getCurrSolutionInfo().getId()));
            this.setCurrSolutionInfo(null);
            this.refreshSolutionList();
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.getCurrSolutionInfo() == null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"Solution_Is_NotNull");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        this.setCanceled(false);
        StringBuffer msg = new StringBuffer();
        this.queryCondList = new ArrayList();
        CompanyOrgUnitInfo companyInfo = this.getTxtCompany();
        ObjectUuidPK orgPK = new ObjectUuidPK(companyInfo.getId());
        try {
            PermissionFactory.getRemoteInstance().checkFunctionPermission(this.getUserPk(), (IObjectPK)orgPK, "rpt_report_calculate");
        }
        catch (Exception e1) {
            this.handleException(e1);
            this.abort();
        }
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo txtPeriod = new PeriodInfo();
        txtPeriod.setPeriodYear(((Integer)this.spPeriodYear.getValue()).intValue());
        txtPeriod.setPeriodNumber(((Integer)this.spPeriodNumber.getValue()).intValue());
        if (FlContrastSolutionUI.PeriodCompare(txtPeriod, startPeriod) < 0 || FlContrastSolutionUI.PeriodCompare(txtPeriod, currPeriod) > 0) {
            String msg1 = EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"Solution_Period_Check");
            MsgBox.showInfo((Component)((Object)this), (String)msg1);
            this.spPeriodYear.requestFocus();
            return;
        }
        HashMap<String, Object> queryCondMap = new HashMap<String, Object>();
        queryCondMap.put("orgId", companyInfo.getId().toString());
        queryCondMap.put("periodYear", this.spPeriodYear.getValue());
        queryCondMap.put("periodNumber", this.spPeriodNumber.getValue());
        String orgNumber = companyInfo.getNumber();
        String orgName = companyInfo.getName();
        FlContrastSolutionInfo currSolution = this.getCurrSolutionInfo();
        this.verify();
        queryCondMap.put("solution", currSolution);
        this.queryCondList.add(queryCondMap);
        if (msg.length() > 0) {
            String title = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDecValueResource", (String)"Fail_To_Operate");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)title.toString(), (String)msg.toString(), (int)1);
            SysUtil.abort();
        }
        if (this.queryCondList.size() == 0) {
            String message = EASResource.getString((String)"com.kingdee.eas.fi.nlm.FlContrastResource", (String)"ContrastOrg_Is_NotNull");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return;
        }
        this.getUIContext().put("queryCondList", this.queryCondList);
        this.isConfirm = true;
        this.disposeUIWindow();
    }

    public static int PeriodCompare(PeriodInfo sourceperiodInfo, PeriodInfo targetperiodInfo) {
        if (sourceperiodInfo.getPeriodYear() > targetperiodInfo.getPeriodYear()) {
            return 1;
        }
        if (sourceperiodInfo.getPeriodYear() == targetperiodInfo.getPeriodYear()) {
            if (sourceperiodInfo.getPeriodNumber() > targetperiodInfo.getPeriodNumber()) {
                return 1;
            }
            if (sourceperiodInfo.getPeriodNumber() == targetperiodInfo.getPeriodNumber()) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public List getQueryCondList() {
        return this.queryCondList;
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.setCanceled(true);
        this.disposeUIWindow();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean b) {
        this.isCanceled = b;
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    private void fillPeriodComponent() throws EASBizException, BOSException {
        CompanyOrgUnitInfo currCompanyInfo = SysContext.getSysContext().getCurrentFIUnit();
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)currCompanyInfo);
        if (currPeriod == null || !currCompanyInfo.isIsBizUnit()) {
            currPeriod = PeriodUtils.getPeriodInfo((Date)new Date(), (CompanyOrgUnitInfo)currCompanyInfo);
        }
        int currYear = currPeriod.getPeriodYear();
        int currMonth = currPeriod.getPeriodNumber();
        this.spPeriodYear.setValue((Object)new Integer(currYear));
        this.spPeriodNumber.setValue((Object)new Integer(currMonth));
    }

    private void fillPeriodComponent2() throws EASBizException, BOSException {
        CompanyOrgUnitInfo txtCompany = this.getTxtCompany();
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)txtCompany);
        if (currPeriod == null || !txtCompany.isIsBizUnit()) {
            currPeriod = PeriodUtils.getPeriodInfo((Date)new Date(), (CompanyOrgUnitInfo)txtCompany);
        }
        int currYear = currPeriod.getPeriodYear();
        int currMonth = currPeriod.getPeriodNumber();
        this.spPeriodYear.setValue((Object)new Integer(currYear));
        this.spPeriodNumber.setValue((Object)new Integer(currMonth));
    }
}

