/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client.dialog;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.client.AbstractPeriodFilterPanel;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PeriodFilterPanel
extends AbstractPeriodFilterPanel {
    private static final long serialVersionUID = -4140681194174945683L;
    PeriodInfo currPeriod;
    private HashMap zipData = null;

    public void onLoad() throws Exception {
        super.onLoad();
        ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
        list.add(SysContext.getSysContext().getCurrentFIUnit());
        this.zipData = FaDepreciationFactory.getRemoteInstance().getZipDataForRPC(list);
        PeriodInfo startPeriod = (PeriodInfo)this.zipData.get("startPeriod");
        this.currPeriod = (PeriodInfo)this.zipData.get("currPeriod");
        this.initPeriodYear(startPeriod, this.currPeriod);
        this.fillPeriodComponent(this.currPeriod);
    }

    private void initPeriodYear(final PeriodInfo startPeriod, final PeriodInfo curPeriod) {
        SpinnerNumberModel yearModel = (SpinnerNumberModel)this.spPeriodYear.getModel();
        yearModel.setMinimum(new Integer(startPeriod.getPeriodYear()));
        yearModel.setMaximum(new Integer(curPeriod.getPeriodYear()));
        this.spPeriodYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PeriodFilterPanel.this.fireYearChange(startPeriod, curPeriod);
            }
        });
    }

    private void fireYearChange(PeriodInfo startPeriodInfo, PeriodInfo curPeriodInfo) {
        if (startPeriodInfo == null || curPeriodInfo == null) {
            return;
        }
        Integer year = (Integer)this.spPeriodYear.getValue();
        SpinnerNumberModel numberModel = (SpinnerNumberModel)this.spPeriodNumber.getModel();
        try {
            int maxPeriod = (Integer)this.zipData.get("maxNumber" + year);
            int minPeriod = (Integer)this.zipData.get("minNumber" + year);
            numberModel.setMaximum(new Integer(maxPeriod));
            numberModel.setMinimum(new Integer(minPeriod));
            if (startPeriodInfo.getPeriodYear() == year.intValue()) {
                numberModel.setMinimum(new Integer(startPeriodInfo.getPeriodNumber()));
            }
            if (startPeriodInfo.getPeriodYear() > year) {
                this.spPeriodYear.setValue((Object)new Integer(startPeriodInfo.getPeriodYear()));
            }
            if (year.intValue() == curPeriodInfo.getPeriodYear()) {
                numberModel.setMaximum(new Integer(curPeriodInfo.getPeriodNumber()));
            }
            this.spPeriodNumber.setValue(numberModel.getMinimum());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void fillPeriodComponent(PeriodInfo periodInfo) {
        if (periodInfo != null) {
            this.spPeriodYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
            this.spPeriodNumber.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
        }
    }

    public Integer getPeriodYear() {
        return this.spPeriodYear.getIntegerVlaue();
    }

    public Integer getPeriodNumber() {
        return this.spPeriodNumber.getIntegerVlaue();
    }

    public boolean isCurrentPeriod() {
        int selectPeriodYear = this.spPeriodYear.getIntegerVlaue();
        int selectPeriodNumber = this.spPeriodNumber.getIntegerVlaue();
        return this.currPeriod.getPeriodYear() == selectPeriodYear && this.currPeriod.getPeriodNumber() == selectPeriodNumber;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams customCond = this.getCustomerParams();
        if (customCond != null) {
            this.spPeriodYear.setValue((Object)new Integer(customCond.getInt("periodYear")));
            this.spPeriodNumber.setValue((Object)new Integer(customCond.getInt("periodNumber")));
        }
    }

    public FilterInfo getFilterInfo() {
        this.setCustomerParams(this.getCustomCond());
        return super.getFilterInfo();
    }

    public boolean verify() {
        this.setCustomerParams(this.getCustomCond());
        return true;
    }

    public CustomerParams getCustomCond() {
        CustomerParams customCond = new CustomerParams();
        customCond.putInt("periodYear", this.spPeriodYear.getIntegerVlaue().intValue());
        customCond.putInt("periodNumber", this.spPeriodNumber.getIntegerVlaue().intValue());
        return customCond;
    }

    public FilterInfo getWorkFilterInfo() {
        FilterInfo workFilterInfo = new FilterInfo();
        FilterItemCollection filterItems = workFilterInfo.getFilterItems();
        FilterItemInfo filterItemInfo = new FilterItemInfo("period.periodYear", this.spPeriodYear.getValue());
        filterItems.add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("period.periodNumber", this.spPeriodNumber.getValue());
        filterItems.add(filterItemInfo);
        return workFilterInfo;
    }

    public void clear() {
        super.clear();
        this.fillPeriodComponent(this.currPeriod);
    }
}

