/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.client.print;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortInfo;
import com.kingdee.eas.fi.nlm.FaLeaseChangeBillEntryInfo;
import com.kingdee.eas.fi.nlm.FaLeaseChangeBillInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaRentSettlementBillInfo;
import com.kingdee.eas.fi.nlm.FaTerminateBillInfo;
import com.kingdee.eas.fi.nlm.client.print.AbstractFLPrintManager;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class FLPrintHelper {
    private static final Logger logger = Logger.getLogger(FLPrintHelper.class);

    protected static void beforeBuildData(IObjectCollection collection) {
        String companyName = SysContext.getSysContext().getCurrentFIUnit() == null ? "" : SysContext.getSysContext().getCurrentFIUnit().getName();
        String operator = SysContext.getSysContext().getCurrentUserInfo() == null ? "" : SysContext.getSysContext().getCurrentUserInfo().getName();
        Date printDate = new Date();
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue editData = collection.getObject(i);
            if (editData instanceof BillBaseInfo) {
                BillBaseInfo info = (BillBaseInfo)editData;
                if (info.getCompany() == null) continue;
                if (info.getCompany().getName() == null || info.getCompany().getName().equals("")) {
                    info.getCompany().setName(companyName);
                }
            }
            editData.put("operator", (Object)operator);
            editData.put("printdate", (Object)printDate);
        }
    }

    public static BOSQueryDelegate getPrintManagerForEditUI(IObjectCollection collection, final KDTable[] tables) {
        FLPrintHelper.beforeBuildData(collection);
        AbstractFLPrintManager data = new AbstractFLPrintManager(collection){

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaLeaseChangeBillEditUI(IObjectCollection collection, final KDTable[] tables) throws Exception {
        FLPrintHelper.beforeBuildData(collection);
        AbstractFLPrintManager data = new AbstractFLPrintManager(collection){

            @Override
            protected List beforeBuildColumn(List columns) {
                if (!columns.contains("entries.receivedOrPaidAmt")) {
                    columns.add("entries.receivedOrPaidAmt");
                }
                if (!columns.contains("entries.accDepr")) {
                    columns.add("entries.accDepr");
                }
                if (!columns.contains("entries.accInterestExpe")) {
                    columns.add("entries.accInterestExpe");
                }
                return columns;
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaLeaseChangeBillInfo billInfo = (FaLeaseChangeBillInfo)sourceInfo;
                rs.updateString("rentDirection", billInfo.getRentDirection().getValue() == 0 ? EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"221_FLPrintHelper") : EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"222_FLPrintHelper"));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaLeaseChangeBillEntryInfo entry = (FaLeaseChangeBillEntryInfo)sourceInfo;
                rs.updateString("entries.contractCatNew.name", entry.getContractCatNew() == null ? "" : entry.getContractCatNew().getName());
                rs.updateString("entries.costCenterNew.name", entry.getCostCenterNew() == null ? "" : entry.getCostCenterNew().getName());
                rs.updateString("entries.useDepartmentNew.name", entry.getUseDepartmentNew() == null ? "" : entry.getUseDepartmentNew().getName());
                rs.updateString("entries.receivedOrPaidAmt", entry.get("entries.receivedOrPaidAmt") == null ? "" : entry.get("entries.receivedOrPaidAmt").toString());
                rs.updateString("entries.accDepr", entry.get("entries.accDepr") == null ? "" : entry.get("entries.accDepr").toString());
                rs.updateString("entries.accInterestExpe", entry.get("entries.accInterestExpe") == null ? "" : entry.get("entries.accInterestExpe").toString());
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaLeaseInBillNewEditUI(IObjectCollection collection, final KDTable[] tables) throws Exception {
        FLPrintHelper.beforeBuildData(collection);
        AbstractFLPrintManager data = new AbstractFLPrintManager(collection){

            @Override
            protected List beforeBuildColumn(List columns) {
                return columns;
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaLeaseInBillNewInfo billInfo = (FaLeaseInBillNewInfo)sourceInfo;
                rs.updateString("isExempt", billInfo.isIsExempt() ? EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"148_FaLeaseInNewEditUI") : EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"223_FLPrintHelper"));
                rs.updateString("isExpire", billInfo.isIsExpire() ? EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"148_FaLeaseInNewEditUI") : EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"223_FLPrintHelper"));
                rs.updateString("isHistory", billInfo.isIsHistory() ? EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"148_FaLeaseInNewEditUI") : EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"223_FLPrintHelper"));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaRentSettlementEditUI(IObjectCollection collection, final KDTable[] tables) throws Exception {
        FLPrintHelper.beforeBuildData(collection);
        AbstractFLPrintManager data = new AbstractFLPrintManager(collection){

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaRentSettlementBillInfo billInfo = (FaRentSettlementBillInfo)sourceInfo;
                rs.updateString("isExempt", billInfo.isIsExempt() ? EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"148_FaLeaseInNewEditUI") : EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"223_FLPrintHelper"));
                rs.updateString("isExpire", billInfo.isIsExpire() ? EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"148_FaLeaseInNewEditUI") : EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"223_FLPrintHelper"));
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaTerminateBillNewEditUI(IObjectCollection collection, final KDTable[] tables) throws Exception {
        FLPrintHelper.beforeBuildData(collection);
        AbstractFLPrintManager data = new AbstractFLPrintManager(collection){

            @Override
            protected List beforeBuildColumn(List columns) {
                return columns;
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaTerminateBillInfo billInfo = (FaTerminateBillInfo)sourceInfo;
                rs.updateString("terminateMode", billInfo.getTerminateMode().getAlias());
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
            }
        };
        return data;
    }

    private static String transBigDecimalToStr(BigDecimal val) {
        String pattern = null;
        if (val == null) {
            return null;
        }
        int scale = val.scale();
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        DecimalFormat decimalFormat = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        decimalFormat.applyPattern(pattern);
        return decimalFormat.format(val);
    }

    private static String transDateToStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = (SimpleDateFormat)CtrlFormatUtilities.getDateFormat();
        return dateFormat.format(date);
    }

    public static BOSQueryDelegate getPrintManagerForFaDepreAndAmortListUI(IObjectCollection collection) {
        FLPrintHelper.beforeBuildData(collection);
        AbstractFLPrintManager data = new AbstractFLPrintManager(collection){

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, new String[]{""}, "faleasedepcostsharingentry");
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                if (!columns.contains("contractCat.name")) {
                    columns.add("contractCat.name");
                }
                if (!columns.contains("costCenter.name")) {
                    columns.add("costCenter.name");
                }
                if (!columns.contains("useDepartment.name")) {
                    columns.add("useDepartment.name");
                }
                return columns;
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaDepreAndAmortInfo billInfo = (FaDepreAndAmortInfo)sourceInfo;
                rs.updateString("fiVouchered", billInfo.isFiVouchered() ? EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"148_FaLeaseInNewEditUI") : EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"223_FLPrintHelper"));
                rs.updateString("leaseInBill.isExpire", billInfo.getLeaseInBill().isIsExpire() ? EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"148_FaLeaseInNewEditUI") : EASResource.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"223_FLPrintHelper"));
                rs.updateString("contractCat.name", billInfo.getLeaseInBill().getContractCat() == null ? "" : billInfo.getLeaseInBill().getContractCat().getName());
                rs.updateString("costCenter.name", billInfo.getLeaseInBill().getCostCenter() == null ? "" : billInfo.getLeaseInBill().getCostCenter().getName());
                rs.updateString("useDepartment.name", billInfo.getLeaseInBill().getUseDepartment() == null ? "" : billInfo.getLeaseInBill().getUseDepartment().getName());
            }
        };
        return data;
    }
}

