/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cbs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.util.SysUtil;
import java.util.Date;
import java.util.HashSet;

public class CBSBankPayingBillFilterParam
implements FilterParam {
    private static final long serialVersionUID = 3601006913263712072L;
    private static final int OTHER_STATUS = 99;
    private String currencyId;
    private String[] companyIds;
    private String[] bankAcctIds;
    private Date beginDate;
    private Date endDate;
    private int status;
    private int transactionType;

    public String[] getCompanyIds() {
        return this.companyIds;
    }

    public void setCompanyIds(String[] companyIds) {
        this.companyIds = companyIds;
    }

    public String[] getBankAcctId() {
        return this.bankAcctIds;
    }

    public void setBankAcctId(String[] bankAcctIds) {
        this.bankAcctIds = bankAcctIds;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public FilterInfo getFilter() {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        String val = ContextHelperFactory.getRemoteInstance().getStringParam("BE003", (IObjectPK)new ObjectUuidPK(currentCompany.getId()));
        FilterInfo fi = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterItemCollection filterItems = fi.getFilterItems();
        if (val.equals("2")) {
            companyFilter.getFilterItems().add(new FilterItemInfo("unitCompany.id", (Object)currentCompany.getId().toString()));
        } else if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentCompany)) {
            String[] company = this.getCompanyIds();
            if (company != null && company.length > 0) {
                filterItems.add(new FilterItemInfo("unitCompany.id", (Object)FMHelper.asSet((String[])company), CompareType.INCLUDE));
            }
        } else if (val.equals("1")) {
            FullOrgUnitCollection coll = null;
            UserInfo userinfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
            try {
                coll = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userinfo.getId().toString()), OrgType.Company, (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()), "bankPayingBill_01view");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            HashSet<String> idSet = new HashSet<String>();
            if (coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    idSet.add(coll.get(i).getId().toString());
                }
            }
            companyFilter.getFilterItems().add(new FilterItemInfo("unitCompany.id", idSet, CompareType.INCLUDE));
        }
        if (!FMHelper.isEmpty((Object[])this.bankAcctIds)) {
            HashSet<String> list = new HashSet<String>(this.bankAcctIds.length);
            for (int i = 0; i < this.bankAcctIds.length; ++i) {
                list.add(this.bankAcctIds[i]);
            }
            filterItems.add(new FilterItemInfo("payAccountBank.id", list, CompareType.INCLUDE));
        }
        if (this.currencyId != null) {
            filterItems.add(new FilterItemInfo("currency.id", (Object)this.currencyId));
        }
        if (this.beginDate != null) {
            filterItems.add(new FilterItemInfo("createTime", (Object)DateUtil.getDayBegin((Date)this.beginDate), CompareType.GREATER_EQUALS));
        }
        if (this.endDate != null) {
            filterItems.add(new FilterItemInfo("createTime", (Object)DateUtil.getNextDay((Date)DateUtil.getDayBegin((Date)this.endDate)), CompareType.LESS));
        }
        if (this.status == 5 || this.status == 6 || this.status == 1 || this.status == 3 || this.status == 2) {
            filterItems.add(new FilterItemInfo("state", (Object)new Integer(this.status)));
        } else if (this.status == 99) {
            filterItems.add(new FilterItemInfo("state", (Object)new Integer(5), CompareType.NOTEQUALS));
            filterItems.add(new FilterItemInfo("state", (Object)new Integer(6), CompareType.NOTEQUALS));
            filterItems.add(new FilterItemInfo("state", (Object)new Integer(1), CompareType.NOTEQUALS));
            filterItems.add(new FilterItemInfo("state", (Object)new Integer(3), CompareType.NOTEQUALS));
            filterItems.add(new FilterItemInfo("state", (Object)new Integer(2), CompareType.NOTEQUALS));
        }
        if (this.getTransactionType() != 999) {
            filterItems.add(new FilterItemInfo("cbPayInfo.transactionType", (Object)new Integer(this.getTransactionType())));
        }
        try {
            fi.mergeFilter(companyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return fi;
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }

    public int getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(int transactionType) {
        this.transactionType = transactionType;
    }
}

