/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cbs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.ISharedOrgSupport;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.client.BEClientHelper;
import com.kingdee.eas.fm.cbs.TransTypeEnum;
import com.kingdee.eas.fm.cbs.client.AbstractCBSBankPayingBillFilterUI;
import com.kingdee.eas.fm.cbs.client.CBSBankPayingBillFilterParam;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.INewCompanyF7UsedAble;
import com.kingdee.eas.fm.common.client.NewCompanyF7Substitute;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class CBSBankPayingBillFilterUI
extends AbstractCBSBankPayingBillFilterUI
implements ISharedOrgSupport {
    private CompanyOrgUnitInfo company = null;
    private static final int ALL_STATUS = 100;
    private static final int OTHER_STATUS = 99;
    private static final Logger logger = CoreUIObject.getLogger(CBSBankPayingBillFilterUI.class);
    private boolean isSharedOrg = true;
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";

    public Object getParam() {
        CBSBankPayingBillFilterParam para = new CBSBankPayingBillFilterParam();
        if (this.cboCurrency.getSelectedItem() == null || !this.cboCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            para.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cboCurrency));
        }
        para.setBankAcctId(AccessHelper.getF7Ids((KDBizPromptBox)this.f7BankAccount));
        para.setBeginDate(this.dtpBegin.getSqlDate());
        para.setEndDate(this.dtpEndo.getSqlDate());
        if (this.rdbFailure.isSelected()) {
            para.setStatus(5);
        } else if (this.rdbSucceed.isSelected()) {
            para.setStatus(6);
        } else if (this.rdbOther.isSelected()) {
            para.setStatus(99);
        } else if (this.rdbPrepSubmit.isSelected()) {
            para.setStatus(1);
        } else if (this.rdbSubmitFail.isSelected()) {
            para.setStatus(3);
        } else if (this.rdbSubmitSuccess.isSelected()) {
            para.setStatus(2);
        } else {
            para.setStatus(100);
        }
        if (this.comboFeeType.getSelectedItem() == null || this.comboFeeType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            para.setTransactionType(999);
        } else {
            para.setTransactionType(((TransTypeEnum)((Object)this.comboFeeType.getSelectedItem())).getValue());
        }
        String[] companyIds = this.getCompanyIds();
        para.setCompanyIds(companyIds);
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof CBSBankPayingBillFilterParam)) {
            return;
        }
        CBSBankPayingBillFilterParam para = (CBSBankPayingBillFilterParam)param;
        String currencyId = para.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currencyInfo);
            } else {
                this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.dtpBegin.setValue((Object)para.getBeginDate());
        this.dtpEndo.setValue((Object)para.getEndDate());
        if (para.getStatus() == 5) {
            this.rdbFailure.setSelected(true);
        } else if (para.getStatus() == 6) {
            this.rdbSucceed.setSelected(true);
        } else if (para.getStatus() == 99) {
            this.rdbOther.setSelected(true);
        } else if (para.getStatus() == 1) {
            this.rdbPrepSubmit.setSelected(true);
        } else if (para.getStatus() == 3) {
            this.rdbSubmitFail.setSelected(true);
        } else if (para.getStatus() == 2) {
            this.rdbSubmitSuccess.setSelected(true);
        } else {
            this.rdbAll.setSelected(true);
        }
        if (para.getTransactionType() == 999) {
            this.comboFeeType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboFeeType.setSelectedItem((Object)TransTypeEnum.getEnum(para.getTransactionType()));
        }
        String val = ContextHelperFactory.getRemoteInstance().getStringParam("BE003", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        String[] companyIds = para.getCompanyIds();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        if (val.equals("0") && !GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            try {
                if (para.getBankAcctId() != null) {
                    AccountBankCollection coll = null;
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                    ev.setFilter(filter);
                    IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                    coll = bankAcct.getAccountBankCollection(ev);
                    this.f7BankAccount.setData((Object)coll.toArray());
                }
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        } else {
            try {
                if (para.getBankAcctId() != null) {
                    Set set = FMHelper.asSet((String[])para.getBankAcctId());
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                    ev.setFilter(filter);
                    AccountBankCollection coll = null;
                    IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                    coll = bankAcct.getAccountBankCollection(ev);
                    this.f7BankAccount.setData((Object)coll.toArray());
                }
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        }
    }

    protected void init() throws Exception {
        if (this.company == null) {
            this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        super.init();
        this.initF7BankAccount();
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.initTransType(this.comboFeeType);
    }

    private void initTransType(KDComboBox combo) {
        combo.removeAllItems();
        combo.addItem((Object)TransTypeEnum.TRF);
        combo.addItem((Object)TransTypeEnum.ETF);
        combo.addItem((Object)TransTypeEnum.TTF);
        combo.addItem((Object)TransTypeEnum.BRP);
        combo.addItem((Object)TransTypeEnum.PP);
        combo.addItem((Object)TransTypeEnum.ACH);
        combo.addItem((Object)TransTypeEnum.CHECK);
        combo.addItem((Object)TransTypeEnum.SCB_TT);
        combo.addItem((Object)TransTypeEnum.SCB_ACH);
        combo.addItem((Object)TransTypeEnum.SCB_RTGS);
        combo.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        combo.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public String getPermissionItem() {
        return "cbs_cbpaymentbill_01view";
    }

    private void initF7BankAccount() {
        this.f7BankAccount.setData(null);
        String val = ContextHelperFactory.getRemoteInstance().getStringParam("BE003", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        FilterInfo filterInfo = new FilterInfo();
        Object[] companyId = this.getCompanyIds();
        if (!FMHelper.isEmpty((Object[])companyId)) {
            if (val.equals("2") || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
                HashSet<Object> list = new HashSet<Object>(companyId.length);
                for (int i = 0; i < companyId.length; ++i) {
                    list.add(companyId[i]);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
            }
            if (val.equals("1")) {
                FullOrgUnitCollection coll = null;
                UserInfo userinfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
                try {
                    coll = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userinfo.getId().toString()), OrgType.Company, (IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()), "bankPayingBill_01view");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                HashSet<String> idSet = new HashSet<String>();
                if (coll.size() > 0) {
                    for (int i = 0; i < coll.size(); ++i) {
                        idSet.add(coll.get(i).getId().toString());
                    }
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", idSet, CompareType.INCLUDE));
            }
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setDisplayFormat("$number$ $name$");
        this.f7BankAccount.setCommitFormat("$number$");
        this.f7BankAccount.setEditFormat("$number$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.f7BankAccount.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.f7BankAccount.setEntityViewInfo(evi);
    }

    public boolean verify() {
        return BEClientHelper.verifyDate((Component)((Object)this), (KDDatePicker)this.dtpBegin, (KDDatePicker)this.dtpEndo);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
        this.initF7BankAccount();
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        NewCompanyF7Substitute newCompanyF7 = new NewCompanyF7Substitute((INewCompanyF7UsedAble)this, this.getNewCompanyF7());
        newCompanyF7.showAndSaveSelected();
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"NoCompany"));
            SysUtil.abort();
        }
        this.btnCompanySelect.setEnabled(true);
        this.btnCompanySelect.setVisible(true);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.company.getBaseCurrency());
        this.f7BankAccount.setData(null);
        Date date = new Date();
        this.dtpBegin.setValue((Object)date);
        this.dtpEndo.setValue((Object)date);
        this.rdbPrepSubmit.setSelected(false);
        this.rdbSubmitSuccess.setSelected(false);
        this.rdbSubmitFail.setSelected(false);
        this.rdbSucceed.setSelected(false);
        this.rdbFailure.setSelected(false);
        this.rdbOther.setSelected(false);
        this.rdbAll.setSelected(true);
    }

    protected Class getParamClass() {
        return CBSBankPayingBillFilterParam.class;
    }

    public void setIsSharedOrg(boolean value) {
        this.isSharedOrg = value;
    }

    public boolean isSharedOrg() {
        return this.isSharedOrg;
    }
}

