/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.cbs.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.cas.BatchFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasSysParamInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.ISharedOrgSupport;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.cbs.TransTypeEnum;
import com.kingdee.eas.fm.cbs.client.AbstractCBSPaymentFilterUI;
import com.kingdee.eas.fm.cbs.client.CBSPaymentBillParam;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.INewCompanyF7UsedAble;
import com.kingdee.eas.fm.common.client.NewCompanyF7Substitute;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CBSPaymentFilterUI
extends AbstractCBSPaymentFilterUI
implements ISharedOrgSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(CBSPaymentFilterUI.class);
    private Map hm;
    private Context mainOrgContext;
    private boolean isSharedOrg = true;
    protected CasSysParamInfo cache = null;

    public CBSPaymentFilterUI() throws Exception {
    }

    public CBSPaymentFilterUI(Map paramValue) throws Exception {
        this.hm = paramValue;
        this.cache = new CasSysParamInfo();
        UserInfo user = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        this.mainOrgContext = new Context();
        this.mainOrgContext.put((Object)"UserInfo", (Object)user);
    }

    protected Class getParamClass() {
        return CBSPaymentBillParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    protected void init() throws Exception {
        super.init();
        this.btnCompanySelect.setVisible(true);
        this.btnCompanySelect.setEnabled(true);
        this.chkIA.setVisible(false);
        this.customInit();
    }

    private void customInit() throws Exception {
        int i;
        Date date = new Date();
        this.pkDateFrom.setValue((Object)date);
        this.pkDateTo.setValue((Object)date);
        CurrencyCollection currencyColl = (CurrencyCollection)this.hm.get("currencyCollection");
        if (currencyColl == null) {
            CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        } else {
            CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (CurrencyCollection)currencyColl, (boolean)false);
        }
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.initBillStatus(this.comboBillStatus);
        this.initTransType(this.comboFeeType);
        AsstActTypeCollection asstActTypeColl = null;
        asstActTypeColl = this.hm.get("asstActTypeCollection") != null ? (AsstActTypeCollection)this.hm.get("asstActTypeCollection") : CasRecPayHandler.getAsstActTypeColl(null, (boolean)false, (boolean)false);
        if (asstActTypeColl != null) {
            ActionListener[] actionListener = this.comboPayeeType.getActionListeners();
            for (i = 0; i < actionListener.length; ++i) {
                this.comboPayeeType.removeActionListener(actionListener[i]);
            }
            this.comboPayeeType.removeAllItems();
            this.comboPayeeType.addItems(asstActTypeColl.toArray());
            this.comboPayeeType.addItem((Object)FMSysDefinedEnum.OTHER);
            this.comboPayeeType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            for (i = 0; i < actionListener.length; ++i) {
                this.comboPayeeType.addActionListener(actionListener[i]);
            }
        }
        this.comboPayeeType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.comboPayeeType_actionPerformed(null);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            CompanyOrgUnitCollection orgRang = (CompanyOrgUnitCollection)this.hm.get("UserOrgRanges");
            if (orgRang == null) {
                this.f7Company.setValue((Object)this.currentCompany);
                return;
            }
            for (i = 0; i < orgRang.size(); ++i) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)orgRang.getObject(i);
                if (!company.isIsBizUnit() || company.isIsOUSealUp()) continue;
                this.f7Company.setValue((Object)company);
                break;
            }
        } else {
            this.f7Company.setValue((Object)this.currentCompany);
        }
    }

    private void initBillStatus(KDComboBox combo) {
        combo.removeAllItems();
        combo.addItem((Object)BillStatusEnum.SAVE);
        combo.addItem((Object)BillStatusEnum.SUBMIT);
        combo.addItem((Object)BillStatusEnum.APPROVED);
        combo.addItem((Object)BillStatusEnum.AUDITED);
        combo.addItem((Object)BillStatusEnum.PAYED);
        combo.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        combo.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initTransType(KDComboBox combo) {
        combo.removeAllItems();
        combo.addItem((Object)TransTypeEnum.TRF);
        combo.addItem((Object)TransTypeEnum.ETF);
        combo.addItem((Object)TransTypeEnum.TTF);
        combo.addItem((Object)TransTypeEnum.BRP);
        combo.addItem((Object)TransTypeEnum.FPS);
        combo.addItem((Object)TransTypeEnum.PP);
        combo.addItem((Object)TransTypeEnum.ACH);
        combo.addItem((Object)TransTypeEnum.CHECK);
        combo.addItem((Object)TransTypeEnum.SCB_TT);
        combo.addItem((Object)TransTypeEnum.SCB_ACH);
        combo.addItem((Object)TransTypeEnum.SCB_RTGS);
        combo.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        combo.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        NewCompanyF7Substitute newCompanyF7 = new NewCompanyF7Substitute((INewCompanyF7UsedAble)this, this.getNewCompanyF7());
        newCompanyF7.showAndSaveSelected();
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    @Override
    protected void comboPayeeType_actionPerformed(ActionEvent e) throws Exception {
        this.prmtPayee.setValue(null);
        if (this.comboPayeeType.getSelectedItem() == null || !(this.comboPayeeType.getSelectedItem() instanceof AsstActTypeInfo)) {
            this.prmtPayee.setEnabled(false);
            this.prmtPayee.setData(null);
            return;
        }
        if (this.prmtPayee.isEnabled() && this.prmtPayee.getData() != null) {
            return;
        }
        this.prmtPayee.setEnabled(true);
        this.prmtPayee.setData(null);
        this.prmtPayee.setSelector(null);
        this.prmtPayee.setFilterInfoProducer(null);
        AsstActTypeInfo info = (AsstActTypeInfo)this.comboPayeeType.getSelectedItem();
        this.prmtPayee.setSelector(null);
        this.prmtPayee.setFilterInfoProducer(null);
        CasRecPayHandler handler = new CasRecPayHandler();
        CompanyOrgUnitInfo company = this.getMainOrgColl().get(0);
        if (company == null) {
            company = this.currentCompany;
        }
        handler.setAsstActSelectorByCU((CoreUIObject)this, this.prmtPayee, info, company, false);
        if (info.getAsstHGAttribute().equalsIgnoreCase("innerAccount")) {
            info.setIsForCompany(false);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
            filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtPayee.setEntityViewInfo(evi);
        }
        this.prmtPayee.setDisplayFormat("$number$ $name$");
        this.prmtPayee.setCommitFormat("$number$;$name$");
        this.prmtPayee.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$", this.prmtPayee));
    }

    private CompanyOrgUnitCollection getMainOrgColl() {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        Object mainBizOrgValue = this.f7Company.getValue();
        if (mainBizOrgValue instanceof Object[]) {
            Object[] arrays = (Object[])mainBizOrgValue;
            for (int i = 0; i < arrays.length; ++i) {
                coll.add((CompanyOrgUnitInfo)arrays[i]);
            }
        } else if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
            coll.add((CompanyOrgUnitInfo)mainBizOrgValue);
        }
        return coll;
    }

    public String getPermissionItem() {
        return "cbs_cbpaymentbill_01view";
    }

    public Object getParam() {
        CBSPaymentBillParam param = new CBSPaymentBillParam();
        param.setBillDateFrom((Date)this.pkDateFrom.getValue());
        param.setBillDateTo((Date)this.pkDateTo.getValue());
        if (this.comboCurrency.getSelectedItem() == null || this.comboCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        }
        if (this.comboBillStatus.getSelectedItem() == null || this.comboBillStatus.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            param.setBillStatus(999);
        } else {
            param.setBillStatus(((BillStatusEnum)this.comboBillStatus.getSelectedItem()).getValue());
        }
        if (this.comboFeeType.getSelectedItem() == null || this.comboFeeType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            param.setTransactionType(999);
        } else {
            param.setTransactionType(((TransTypeEnum)((Object)this.comboFeeType.getSelectedItem())).getValue());
        }
        if (this.comboPayeeType.getSelectedItem() != null && !this.comboPayeeType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            if (this.comboPayeeType.getSelectedItem() == FMSysDefinedEnum.OTHER) {
                param.setPayeeTypeId("null");
            } else {
                param.setPayeeTypeId(((DataBaseInfo)this.comboPayeeType.getSelectedItem()).getId().toString());
            }
        }
        if (this.prmtPayee.getData() != null) {
            param.setPayeeId(((DataBaseInfo)this.prmtPayee.getData()).getId().toString());
            param.setPayeeName(((DataBaseInfo)this.prmtPayee.getData()).getName());
        }
        if (this.radioHead.isSelected()) {
            param.setDisplayEntries(false);
        } else if (this.radioEntries.isSelected()) {
            param.setDisplayEntries(true);
        }
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            param.setCompanyIdSet(this.getCompanyIdSet());
        }
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof CBSPaymentBillParam)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"326_CasPaymentFilterUI"));
            return;
        }
        CBSPaymentBillParam filterParam = (CBSPaymentBillParam)((Object)param);
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
        if (filterParam.isDisplayEntries()) {
            this.radioHead.setSelected(false);
            this.radioEntries.setSelected(true);
        } else {
            this.radioHead.setSelected(true);
            this.radioEntries.setSelected(false);
        }
        try {
            if (filterParam.getCurrencyId() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(filterParam.getCurrencyId());
                this.comboCurrency.setSelectedItem((Object)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)pk));
            } else {
                this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (filterParam.getBillStatus() == 999) {
            this.comboBillStatus.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboBillStatus.setSelectedItem((Object)BillStatusEnum.getEnum((int)filterParam.getBillStatus()));
        }
        if (filterParam.getTransactionType() == 999) {
            this.comboFeeType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboFeeType.setSelectedItem((Object)TransTypeEnum.getEnum(filterParam.getTransactionType()));
        }
        if (filterParam.getPayeeTypeId() == null) {
            this.comboPayeeType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            int selectIndex = BookNotifyClientHelper.getSelectIndex((KDComboBox)this.comboPayeeType, (String)filterParam.getPayeeTypeId());
            this.comboPayeeType.setSelectedIndex(selectIndex);
        }
        this.pkDateFrom.setValue((Object)filterParam.getBillDateFrom());
        this.pkDateTo.setValue((Object)filterParam.getBillDateTo());
        String payeeId = filterParam.getPayeeId();
        String payeeName = filterParam.getPayeeName();
        CasRecPayHandler handler = new CasRecPayHandler();
        handler.fillPayeeOrPayer(this.prmtPayee, payeeId, null, payeeName);
    }

    public boolean verify() {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.f7Company);
        if (this.pkDateFrom.getValue() == null || this.pkDateTo.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"327_CasPaymentFilterUI"));
            SysUtil.abort();
        }
        Date dateFrom = DateTimeUtils.truncateDate((Date)((Date)this.pkDateFrom.getValue()));
        Date dateTo = DateTimeUtils.truncateDate((Date)((Date)this.pkDateTo.getValue()));
        ClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)dateFrom, (Date)dateTo);
        return true;
    }

    public void clear() {
        super.clear();
        try {
            this.customInit();
        }
        catch (Exception e) {
            logger.info((Object)e);
            logger.error((Object)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.getNewOrg() == null) {
            this.comboPayeeType.removeAllItems();
            return;
        }
        CompanyOrgUnitInfo company = null;
        if (chgVo.getNewOrg() instanceof Object[]) {
            Object[] companys = (Object[])chgVo.getNewOrg();
            if (companys.length == 0) return;
            company = (CompanyOrgUnitInfo)companys[0];
        } else {
            company = (CompanyOrgUnitInfo)chgVo.getNewOrg();
        }
        AsstActTypeCollection asstActTypeColl = null;
        try {
            FrameWorkUtils.switchOrg((Context)this.mainOrgContext, (String)company.getId().toString());
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("ui_name", "CBSPaymentBillListUI");
            hashMap.put("isList", Boolean.TRUE);
            hashMap.put("isFirtTime", Boolean.FALSE);
            hashMap.put("selectCompany", chgVo.getNewOrg());
            Map map = BatchFetchParamFacadeFactory.getRemoteInstanceWithObjectContext((Context)this.mainOrgContext).fetchParam(hashMap);
            this.hm.putAll(map);
            asstActTypeColl = (AsstActTypeCollection)this.hm.get("asstActTypeCollection");
        }
        catch (Exception exception) {
            ExceptionHandler.handle((Throwable)exception);
            logger.error((Object)exception);
        }
        if (asstActTypeColl != null) {
            this.comboPayeeType.removeAllItems();
            this.comboPayeeType.addItems(asstActTypeColl.toArray());
            this.comboPayeeType.addItem((Object)FMSysDefinedEnum.OTHER);
            this.comboPayeeType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        this.comboPayeeType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public KDBizPromptBox getMainOrg() {
        return this.f7Company;
    }

    public void setIsSharedOrg(boolean value) {
        this.isSharedOrg = value;
    }

    public boolean isSharedOrg() {
        return this.isSharedOrg;
    }
}

