/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.ctl.AssureBillStateEnum;
import com.kingdee.eas.fm.ctl.AssureBillUsedFactory;
import org.apache.log4j.Logger;

public class AssureBillHelper {
    private static final Logger logger = CoreUIObject.getLogger(AssureBillHelper.class);

    public static boolean isCanEdit(AssureBillInfo info) {
        return !info.isCanceled();
    }

    public static boolean isCanRemove(AssureBillInfo info) {
        return !info.isCanceled() && !AssureBillStateEnum.APPROVE.equals((Object)info.getState());
    }

    public static boolean isCanCancel(AssureBillInfo info) {
        return AssureBillStateEnum.APPROVE.equals((Object)info.getState());
    }

    public static boolean isCanAntiCancel(AssureBillInfo info) {
        return info.isCanceled();
    }

    public static boolean isCanAudit(AssureBillInfo info) {
        return AssureBillStateEnum.SUBMIT.equals((Object)info.getState());
    }

    public static boolean isCanAntiAudit(AssureBillInfo info) {
        return !info.isCanceled() && AssureBillStateEnum.APPROVE.equals((Object)info.getState());
    }

    public static boolean hasUsedAssureBill(AssureBillInfo info) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("assureBillId", (Object)info.getId()));
        try {
            return AssureBillUsedFactory.getRemoteInstance().exists(filter);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return false;
    }

    public static void bgCtrlAudit(Context ctx, String billId, String boName, String handleName) throws BOSException, EASBizException {
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)new ObjectUuidPK(billId));
    }
}

