/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.IBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.ctl.FeeException;
import com.kingdee.eas.fm.ctl.FeeForGuaranteeFactory;
import com.kingdee.eas.fm.ctl.FeeForGuaranteeInfo;
import com.kingdee.eas.fm.ctl.IFeeForGuarantee;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class FeeForGuaranteeBookNotifyBuilder
implements IBookNotifyBuilder {
    private UserInfo userInfo;
    private PeriodInfo currPeriodInfo;
    private CompanyOrgUnitInfo currentCompany;

    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException, FeeException {
        JournalCollection journalCollection = new JournalCollection();
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        this.currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
        FeeForGuaranteeInfo feeInfo = this.getFeeForGuaranteeInfo(ctx, billId);
        if (feeInfo.getAccountBank() == null) {
            throw new FeeException(FeeException.ACCOUNTBANKISNULL);
        }
        JournalInfo journalInfo = this.createBaseJournal(ctx, feeInfo);
        journalCollection.add(journalInfo);
        return journalCollection;
    }

    public JournalCollection getJournalColl(Context ctx, Set idSet) throws BOSException, EASBizException {
        JournalCollection journalCollection = new JournalCollection();
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        this.currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            String billId = it.next().toString();
            FeeForGuaranteeInfo feeInfo = this.getFeeForGuaranteeInfo(ctx, billId);
            if (feeInfo.getAccountBank() != null) {
                JournalInfo journalInfo = this.createBaseJournal(ctx, feeInfo);
                journalCollection.add(journalInfo);
                continue;
            }
            throw new FeeException(FeeException.ACCOUNTBANKISNULL);
        }
        return journalCollection;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("company.id");
        cel.add("AccountView.*");
        cel.add("AccountBank.*");
        return cel;
    }

    private FeeForGuaranteeInfo getFeeForGuaranteeInfo(Context ctx, String billId) throws BOSException, EASBizException {
        IFeeForGuarantee feeForGuarantee = FeeForGuaranteeFactory.getLocalInstance(ctx);
        FeeForGuaranteeInfo feeForGuaranteeInfo = feeForGuarantee.getFeeForGuaranteeInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return feeForGuaranteeInfo;
    }

    private JournalInfo createBaseJournal(Context ctx, FeeForGuaranteeInfo feeInfo) throws BOSException, EASBizException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setCompany(feeInfo.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(feeInfo.getId().toString());
        Date bookDate = this.getBookDate(ctx, feeInfo, this.currentCompany);
        PeriodInfo bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)this.currentCompany);
        journalInfo.setPeriod(bookPeriodInfo);
        journalInfo.setCurrency(feeInfo.getCurrency());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setAccountBank(feeInfo.getAccountBank());
        journalInfo.setAccountView(feeInfo.getAccountBank().getAccount());
        journalInfo.setCurrency(feeInfo.getCurrency());
        journalInfo.setCreateDate(bookDate);
        journalInfo.setDebitAmount(Constants.ZERO);
        journalInfo.setBillType(BillTypeEnum.LetterOfGuarantee);
        journalInfo.setBillNumber(feeInfo.getFBusinessNumber());
        journalInfo.setCreditAmount(feeInfo.getMoneyAmount());
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setBizDate(feeInfo.getBizDate());
        journalInfo.setOppAccountView(feeInfo.getAccountview());
        String des = "";
        if (ctx != null) {
            des = ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"134_FeeForGuaranteeBookNotifyBuilder", (Locale)ctx.getLocale());
        }
        journalInfo.setDescription(des);
        journalInfo.setCashier(this.userInfo);
        return journalInfo;
    }

    private Date getBookDate(Context ctx, FeeForGuaranteeInfo feeInfo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (this.currPeriodInfo == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"current Period"});
        }
        Date bookDate = feeInfo.getBizDate();
        if (bookDate.before(this.currPeriodInfo.getBeginDate())) {
            bookDate = this.currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }

    public static AccountBankInfo getDefaultAccountBankInfo(Context ctx, String bankAccountNumber, AccountViewInfo Account) throws LoanException {
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)bankAccountNumber, CompareType.EQUALS));
        fInfo.getFilterItems().add(new FilterItemInfo("account.id", (Object)Account.getId().toString(), CompareType.EQUALS));
        vi.setFilter(fInfo);
        AccountBankCollection bftCollection = null;
        try {
            bftCollection = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(vi);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (bftCollection == null || bftCollection.size() == 0) {
            throw new LoanException(LoanException.BLOCKINGFLOWTYPENUMBER001NOTEXISTS);
        }
        AccountBankInfo bftInfo = bftCollection.get(0);
        return bftInfo;
    }
}

