/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.ctl.client.AssureBillDetailFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;

public abstract class AssureBillDetailReportBaseHandler
implements IFMDetailRptHandler {
    protected KDTable kdt;
    protected AssureBillDetailFilterParam filterParam;
    IContextHelper iContextHelper = ContextHelperFactory.getRemoteInstance();
    CompanyOrgUnitInfo companyInfo = this.iContextHelper.getCurrentCompany();
    boolean canShow = this.iContextHelper.getBooleanParam("CTL001", (IObjectPK)new ObjectUuidPK(this.companyInfo.getId()));
    protected String loc;

    protected AssureBillDetailReportBaseHandler(KDTable kdt, AssureBillDetailFilterParam filterParam) {
        this.kdt = kdt;
        this.filterParam = filterParam;
    }

    public void initHeader() {
        this.kdt.removeRows();
        this.kdt.getGroupManager().removeGroup();
        this.kdt.getGroupManager().removeTreeColumn();
        this.kdt.getGroupManager().reInitialize();
        this.kdt.checkParsed(true);
        this.kdt.getSelectManager().setSelectMode(2);
        this.kdt.setEditable(false);
        this.kdt.getGroupManager().setGroup(true);
        this.kdt.getGroupManager().setOrientation(1);
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.kdt.setRefresh(false);
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            this.beforeFillRow(rs, row);
            row.setUserObject((Object)rs.getString("FId"));
            row.getCell("companyName").setValue((Object)rs.getString("companyName"));
            row.getCell("assureBillNumber").setValue((Object)rs.getString("assureBillNumber"));
            int relation = rs.getInt("FassureUnionType");
            if (relation != 1) {
                relation = -1;
            }
            row.getCell("relationWithAssured").setValue((Object)new Integer(relation));
            row.getCell("AssuredCompanyName").setValue((Object)rs.getString("FAssuredCompany"));
            row.getCell("bankName").setValue((Object)rs.getString("bankName"));
            row.getCell("assureType").setValue((Object)rs.getString("assureTypeName"));
            row.getCell("currency").setValue((Object)rs.getString("currencyName"));
            row.getCell("contactAmount").setValue((Object)rs.getBigDecimal("contactAmount"));
            row.getCell("exRate").setValue((Object)rs.getBigDecimal("exRate"));
            row.getCell("contactLocalAmount").setValue((Object)rs.getBigDecimal("FContactLocalAmt"));
            row.getCell("assurePercent").setValue((Object)rs.getBigDecimal("AssurePercent"));
            row.getCell("assLimitAmount").setValue((Object)rs.getBigDecimal("FAssureLimitAmt"));
            row.getCell("beginDate").setValue((Object)rs.getDate("FBeginDate"));
            row.getCell("horizon").setValue((Object)rs.getBigDecimal("FHorizon"));
            row.getCell("horizon").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("horizon").getStyleAttributes().setNumberFormat("%r{#,##0.0000}f");
            row.getCell("assureBeginDate").setValue((Object)rs.getDate("assureBeginDate"));
            row.getCell("assureEndDate").setValue((Object)rs.getDate("assureEndDate"));
            row.getCell("project").setValue((Object)rs.getString("projectName"));
            row.getCell("endDate").setValue((Object)rs.getDate("FEndDate"));
            row.getCell("assureBizBalanceLocal").setValue((Object)rs.getBigDecimal("FBizLocalBalance"));
            row.getCell("assureRespAmount").setValue((Object)rs.getBigDecimal("FAssureResAmount"));
            java.util.Date now = DateUtil.getDayBegin();
            Date endDate = rs.getDate("FEndDate");
            row.getCell("isCanceled").setValue((Object)rs.getBoolean("FIsCanceled"));
            if (endDate != null) {
                row.getCell("isOverdue").setValue((Object)now.after(endDate));
            } else {
                row.getCell("isOverdue").setValue((Object)false);
            }
            row.getCell("antiAssurePerson").setValue((Object)rs.getString("FAntiAssurer"));
            row.getCell("antiAssAmount").setValue((Object)rs.getBigDecimal("FAntiAssAmount"));
            row.getCell("guarantee").setValue((Object)rs.getString("FAssureArticle"));
            row.getCell("antiAssValue").setValue((Object)rs.getBigDecimal("FAntiAssValue"));
            row.getCell("recordDate").setValue((Object)rs.getDate("FCreateTime"));
            this.afterFillRow(rs, row);
        }
    }

    protected void afterFillRow(IRowSet rs, IRow row) throws SQLException {
    }

    protected void beforeFillRow(IRowSet rs, IRow row) {
    }

    public void endDataFill() {
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
    }

    protected abstract String getOrderByClause();

    protected static String getAssureBillReportResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.AssureBillDetailReportUIResource", (String)key);
    }

    public IRowSet getRowSet() throws BOSException {
        ArrayList<Comparable<java.util.Date>> paramList = new ArrayList<Comparable<java.util.Date>>();
        this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        Set companyIdSet = this.filterParam.getCompanyIdSet();
        Date dateBegin = this.filterParam.getBeginDate();
        Date endBegin = this.filterParam.getEndDate();
        Set bankIdSet = this.filterParam.getBankIdSet();
        Set assureTypeIdSet = this.filterParam.getAssureTypeIdSet();
        AmountUnitEnum amountUnit = this.filterParam.getAmountUnit();
        BigDecimal amount = this.filterParam.getAmount();
        boolean cancelDisplay = this.filterParam.getCancelDisplay();
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append("where 1=1  ");
        if (companyIdSet != null && companyIdSet.size() > 0) {
            sbWhere.append(" and  ").append(FMHelper.buildIn((String)"company.FId", (Object[])companyIdSet.toArray()));
        }
        if (dateBegin != null) {
            if (this.canShow) {
                sbWhere.append(" and ( assurebill.fbegindate>=? ");
                paramList.add(dateBegin);
                sbWhere.append(" or assurebill.fbegindate is null )");
            } else {
                sbWhere.append(" and assurebill.fbegindate>=? ");
                paramList.add(dateBegin);
            }
        }
        if (endBegin != null) {
            if (this.canShow) {
                sbWhere.append(" and ( assurebill.fbegindate<=?  ");
                paramList.add(endBegin);
                sbWhere.append(" or assurebill.fbegindate is null )");
            } else {
                sbWhere.append(" and assurebill.fbegindate<=?  ");
                paramList.add(endBegin);
            }
        }
        if (bankIdSet != null && bankIdSet.size() > 0) {
            sbWhere.append(" and ").append(FMHelper.buildIn((String)"bank.FId", (Object[])bankIdSet.toArray()));
        }
        if (assureTypeIdSet != null && assureTypeIdSet.size() > 0) {
            sbWhere.append(" and ").append(FMHelper.buildIn((String)"assuretype.FId", (Object[])assureTypeIdSet.toArray()));
        }
        if (amount != null) {
            sbWhere.append(" and assurebill.fcontactamount>=?");
            BigDecimal unitValue = new BigDecimal(String.valueOf(amountUnit.getValue()));
            paramList.add(amount.multiply(unitValue));
        }
        if (!cancelDisplay) {
            sbWhere.append(" and assurebill.FIsCanceled=0 ");
        }
        String amtUnit = new Integer(this.filterParam.getAmountUnit().getValue()).toString() + ".00";
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT assurebill.fid AS fid,bank.FLevel as FBankLevel,");
        sb.append("        assurebill.FAssureBeginDate as assureBeginDate,");
        sb.append("        assurebill.FAssureEndDate as assureEndDate,");
        sb.append("        project.FName_").append(this.loc).append("  as projectName,");
        sb.append("        company.fname_").append(this.loc).append("  AS companyname1,");
        sb.append("        ISNULL(customer.FName_").append(this.loc).append(" ,company1.FName_").append(this.loc).append(" ) AS companyname,");
        sb.append("        assurebill.fnumber AS assurebillnumber,");
        sb.append("        assurebill.funiontype AS funiontype,");
        sb.append("        assurebill.fassureUnionType AS fassureUnionType,");
        sb.append("        assurebill.fassuredcompany AS fassuredcompany,");
        sb.append("        bank.fname_").append(this.loc).append("  AS bankname,");
        sb.append("        assuretype.fname_").append(this.loc).append("  AS assuretypename,");
        sb.append("        currency.fname_").append(this.loc).append("  AS currencyname,");
        sb.append("        assurebill.fcontactamount/" + amtUnit + " AS contactamount,");
        sb.append("        assurebill.fexrate AS exrate,");
        sb.append("        assurebill.fcontactlocalamt/" + amtUnit + " AS fcontactlocalamt,");
        sb.append("        assurebill.fassurepercent AS assurepercent,");
        sb.append("        assurebill.fassurelimitamt/" + amtUnit + " AS fassurelimitamt,");
        sb.append("        assurebill.fbegindate AS fbegindate,");
        sb.append("        assurebill.fenddate AS fenddate,");
        sb.append("        assurebill.fhorizon AS fhorizon,");
        sb.append("        assurebill.fbizlocalbalance/" + amtUnit + " AS fbizlocalbalance,");
        sb.append("        assurebill.fassureresamount/" + amtUnit + " AS fassureresamount,");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"57_AssureBillDetailReportBaseHandler"));
        sb.append("        assurebill.fantiassurer AS fantiassurer,");
        sb.append("        assurebill.fantiassamount/" + amtUnit + " AS fantiassamount,");
        sb.append("        assurebill.fassurearticle AS fassurearticle,");
        sb.append("        assurebill.fantiassvalue/" + amtUnit + " AS fantiassvalue,");
        sb.append("        assurebill.fcreatetime AS fcreatetime,");
        sb.append("        assurebill.FIsCanceled AS FIsCanceled");
        sb.append(" FROM   T_CTL_AssureBill assurebill");
        sb.append("        LEFT JOIN T_BD_Project project");
        sb.append("               ON assurebill.FProjectID = project.fid");
        sb.append("        LEFT JOIN t_org_company company");
        sb.append("               ON assurebill.fcompanyid = company.fid");
        sb.append("        LEFT JOIN t_bd_bank bank");
        sb.append("               ON assurebill.fbankid = bank.fid");
        sb.append("        LEFT JOIN T_CTL_AssureType assuretype");
        sb.append("               ON assurebill.fassuretypeid = assuretype.fid");
        sb.append("        LEFT JOIN t_bd_currency currency");
        sb.append("               ON assurebill.fcurrencyid = currency.fid");
        sb.append("        LEFT JOIN T_BD_Customer customer");
        sb.append("               ON assurebill.fAssureCustomerID = customer.fid");
        sb.append("        LEFT JOIN t_org_company company1");
        sb.append("               ON assurebill.fAssureCompanyID = company1.fid");
        sb.append("\n").append(sbWhere);
        String orderBy = this.getOrderByClause();
        if (!StringUtils.isEmpty((String)orderBy)) {
            sb.append("\n").append(orderBy);
        }
        Logger.info((String)"=====================================");
        Logger.info((String)sb.toString());
        Logger.info((String)"=====================================");
        try {
            return FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sb.toString(), paramList.toArray());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
            return null;
        }
    }

    protected static void initDecimalCol(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
    }

    protected static void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
    }
}

