/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.ctl.client.AbstractAssureBillUsedFilterUI;
import com.kingdee.eas.fm.ctl.client.AssureBillUsedFilterParam;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class AssureBillUsedFilterUI
extends AbstractAssureBillUsedFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AssureBillUsedFilterUI.class);
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean verify() {
        Date beginDate = (Date)this.pkAssureBeginDateFrom.getValue();
        Date endDate = (Date)this.pkAssureBeginDateTo.getValue();
        if (endDate == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"71_AssureBillUsedFilterUI"));
            this.pkAssureBeginDateTo.requestFocus();
            SysUtil.abort();
        }
        if (beginDate != null && beginDate.after(endDate)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"72_AssureBillUsedFilterUI"));
            this.pkAssureBeginDateFrom.requestFocus();
            SysUtil.abort();
        }
        return super.verify();
    }

    public Object getParam() {
        AssureBillUsedFilterParam filterParam = new AssureBillUsedFilterParam();
        if (this.pkAssureBeginDateFrom.getValue() != null) {
            filterParam.setBeginDate(DateTimeUtils.truncateDate((Date)this.pkAssureBeginDateFrom.getSqlDate()));
        }
        if (this.pkAssureBeginDateTo.getValue() != null) {
            filterParam.setEndDate(DateTimeUtils.truncateDate((Date)this.pkAssureBeginDateTo.getSqlDate()));
        }
        int typeIndex = this.billType.getSelectedIndex();
        String billBOSType = null;
        if (typeIndex > 0) {
            if (typeIndex == 1) {
                billBOSType = new LoanInfo().getBOSType().toString().trim();
            } else if (typeIndex == 2) {
                billBOSType = new PayableBillInfo().getBOSType().toString().trim();
            } else if (typeIndex == 3) {
                billBOSType = new LetterOfCreditInfo().getBOSType().toString().trim();
            } else if (typeIndex == 4) {
                billBOSType = new LetterOfGuaranteeInfo().getBOSType().toString().trim();
            }
            filterParam.setBillBOSType(billBOSType);
        } else {
            filterParam.setBillBOSType(null);
        }
        return filterParam;
    }

    public void setParam(Object param) {
        AssureBillUsedFilterParam filterParam = (AssureBillUsedFilterParam)((Object)param);
        this.pkAssureBeginDateFrom.setValue((Object)filterParam.getBeginDate());
        this.pkAssureBeginDateTo.setValue((Object)filterParam.getEndDate());
        if (filterParam.getBillBOSType() == null) {
            this.billType.setSelectedIndex(0);
        } else {
            String billBOSType = filterParam.getBillBOSType();
            if (billBOSType.equals(new LoanInfo().getBOSType().toString())) {
                this.billType.setSelectedIndex(1);
            } else if (billBOSType.equals(new PayableBillInfo().getBOSType().toString())) {
                this.billType.setSelectedIndex(2);
            } else if (billBOSType.equals(new LetterOfCreditInfo().getBOSType().toString())) {
                this.billType.setSelectedIndex(3);
            } else if (billBOSType.equals(new LetterOfGuaranteeInfo().getBOSType())) {
                this.billType.setSelectedIndex(4);
            }
        }
    }

    protected void init() throws Exception {
        this.btnCompanySelect.setVisible(false);
        this.billType.insertItemAt((Object)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"70_AssureBillUsedFilterUI"), 0);
        this.billType.insertItemAt((Object)EASResource.getString((String)RESOURCE, (String)"Loan"), 1);
        this.billType.insertItemAt((Object)EASResource.getString((String)RESOURCE, (String)"CommercialDraft"), 2);
        this.billType.insertItemAt((Object)EASResource.getString((String)RESOURCE, (String)"LetterOfCredit"), 3);
        this.billType.insertItemAt((Object)EASResource.getString((String)RESOURCE, (String)"LetterOfGuarantee"), 4);
        super.init();
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.billType.setSelectedIndex(0);
        Date date = new Date();
        try {
            date = SysUtil.getAppServerTime(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.pkAssureBeginDateFrom.setValue(null);
        this.pkAssureBeginDateTo.setValue((Object)date);
    }

    protected Class getParamClass() {
        return AssureBillUsedFilterParam.class;
    }
}

