/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.BankJournalHandler;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.TableBindHandler;
import com.kingdee.eas.fm.ctl.FeeForGuaranteeCollection;
import com.kingdee.eas.fm.ctl.FeeForGuaranteeFactory;
import com.kingdee.eas.fm.ctl.FeeForGuaranteeInfo;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.ctl.client.AbstractFeeForGuaranteeFMUI;
import com.kingdee.eas.fm.ctl.client.FeeForGuaranteeHandler;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.client.util.RecChequeUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JTextField;

public class FeeForGuaranteeFMUI
extends AbstractFeeForGuaranteeFMUI {
    private static final String COL_SXFTYPE = "sxfType";
    private static final String COL_ABTRACT = "abtract";
    private static final String COL_BIZDATE = "bizDate";
    private static final String COL_CURRENCY = "currency";
    private static final String COL_ISCREATORBEAR = "isCreatorBear";
    private static final String COL_BEARDEPT = "bearDept";
    private static final String COL_BEARPROJECT = "cdItem";
    private static final String COL_INNERACCOUNT = "innerAccount";
    private static final String COL_YEARFEE = "yearFee";
    private static final String COL_FEETIM = "feeTim";
    private static final String COL_MONEYAMOUNT = "moneyAmount";
    private static final String COL_EXCHANGERATE = "exchangeRate";
    private static final String COL_LOCALEXRATE = "localExRate";
    private static final String COL_SXFZBWB = "sxfzbwb";
    private static final String COL_OTHERVIEW = "accountView";
    private static final String COL_BANKACCOUNT = "accountBank";
    private static final String COL_BANKVIEW = "bankObject";
    private final CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private LetterOfGuaranteeInfo letterOfGuaranteeInfo;
    private FeeForGuaranteeHandler handler = new FeeForGuaranteeHandler();
    private FeeForGuaranteeCollection feeCollection = new FeeForGuaranteeCollection();
    private TableBindHandler tableHandler = new TableBindHandler();
    private BankJournalHandler bankJournalHandler = new BankJournalHandler();

    private void addLine() {
        IObjectValue detailData = this.createNewData();
        IRow row = this.kdtFee.addRow();
        this.loadLineFileds(detailData, row);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.tableHandler.bindTableToData(this.kdtFee, (IObjectCollection)this.feeCollection, FeeForGuaranteeInfo.class.getName());
    }

    private void loadLineFileds(IObjectValue obj, IRow row) {
        this.tableHandler.loadLineFields(this.kdtFee, row, obj);
        row.getCell(COL_BIZDATE).setValue((Object)new Date());
        row.getCell(COL_ISCREATORBEAR).setValue((Object)Boolean.TRUE);
        row.getCell(COL_MONEYAMOUNT).getStyleAttributes().setBackground(new Color(16579551));
        row.getCell(COL_SXFZBWB).getStyleAttributes().setLocked(true);
        row.getCell(COL_EXCHANGERATE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(COL_YEARFEE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(COL_LOCALEXRATE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddRow_actionPerformed(e);
        this.addLine();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtFee.getRowCount() <= 0) {
            return;
        }
        this.storeFields();
        this.verifyInput(e);
        this.handler.submitFeeCollection(this.feeCollection);
        this.showSubmitSuccess();
        this.feeCollection.clear();
        this.kdtFee.removeRows();
        this.addLine();
        this.storeFields();
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelRow_actionPerformed(e);
        this.removeLine();
    }

    protected IObjectValue createNewData() {
        FeeForGuaranteeInfo objectValue = new FeeForGuaranteeInfo();
        this.letterOfGuaranteeInfo = (LetterOfGuaranteeInfo)this.getUIContext().get("Guaranteeinfo");
        objectValue.setFBusinessNumber(this.letterOfGuaranteeInfo.getNumber());
        objectValue.setGuaranteeId(this.letterOfGuaranteeInfo.getId().toString());
        objectValue.setGuaranteeAmount(this.letterOfGuaranteeInfo.getAmount());
        if (this.editData != null && this.editData.getMoneyAmount() != null) {
            this.editData.setMoneyAmount(null);
        }
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FeeForGuaranteeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.txtFBusinessNumber.setEditable(false);
        this.txtGuaranteeAmount.setEditable(false);
        this.contGuaranteeAmount.setVisible(true);
        this.txtGuaranteeAmount.setVisible(true);
        this.txtGuaranteeAmount.setRemoveingZeroInDispaly(false);
        LetterOfGuaranteeInfo info = (LetterOfGuaranteeInfo)this.getUIContext().get("Guaranteeinfo");
        this.txtFBusinessNumber.setText(info.getNumber());
        this.txtGuaranteeAmount.setText(info.getAmount().toString());
        this.initTable();
        super.onLoad();
        this.addLine();
        this.storeFields();
        this.actionPre.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionNext.setVisible(false);
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        if (this.isisClearinghouse(this.company)) {
            this.isHideInnerAccountColl(false);
            KDBizPromptBox f7innerAccount = new KDBizPromptBox();
            f7innerAccount.setQueryInfo("com.kingdee.eas.fm.fs.F7InnerAccountQuery");
            f7innerAccount.setDisplayFormat("$name$");
            f7innerAccount.setEditFormat("$number$");
            f7innerAccount.setCommitFormat("$number$");
            f7innerAccount.setEditable(true);
            if (this.company != null) {
                this.setInnerAccountFilter(f7innerAccount, this.company);
            }
            KDTDefaultCellEditor innerAccountEditor = new KDTDefaultCellEditor((IKDEditor)f7innerAccount);
            this.kdtFee.getColumn(COL_INNERACCOUNT).setEditor((ICellEditor)innerAccountEditor);
        } else {
            this.isHideInnerAccountColl(true);
        }
    }

    private void initTable() throws EASBizException, BOSException {
        this.kdtFee.putBindContents("editData", new String[]{COL_BIZDATE, COL_SXFTYPE, COL_CURRENCY, COL_ISCREATORBEAR, COL_BEARDEPT, COL_BEARPROJECT, COL_INNERACCOUNT, COL_YEARFEE, COL_FEETIM, COL_MONEYAMOUNT, COL_EXCHANGERATE, COL_LOCALEXRATE, COL_SXFZBWB, COL_OTHERVIEW, COL_BANKACCOUNT, COL_BANKVIEW, COL_ABTRACT});
        this.kdtFee.checkParsed();
        this.kdtFee.getSelectManager().setSelectMode(1);
        this.kdtFee.setActiveCellStatus(1);
        KDTableHelper.updateEnterWithTab((KDTable)this.kdtFee, (boolean)true, (Action)new ItemAction(){

            public void actionPerformed(ActionEvent e) {
                IRow row = FeeForGuaranteeFMUI.this.kdtFee.getRow(FeeForGuaranteeFMUI.this.kdtFee.getSelectManager().getActiveRowIndex() + 1);
                FeeForGuaranteeFMUI.this.tableHandler.loadLineFields(FeeForGuaranteeFMUI.this.kdtFee, row, FeeForGuaranteeFMUI.this.createNewData());
                FeeForGuaranteeFMUI.this.initRowState(row);
            }
        });
        String formatString = CtrlFormatUtilities.getDateFormatString();
        KDDatePicker bizDatePicker = new KDDatePicker();
        KDTDefaultCellEditor bizEditor = new KDTDefaultCellEditor(bizDatePicker);
        this.kdtFee.getColumn(COL_BIZDATE).setEditor((ICellEditor)bizEditor);
        this.kdtFee.getColumn(COL_BIZDATE).getStyleAttributes().setNumberFormat(formatString);
        KDBizPromptBox f7sxfType = new KDBizPromptBox();
        f7sxfType.setQueryInfo("com.kingdee.eas.fm.fin.app.FeeTypeMaintenanceQuery");
        f7sxfType.setEditable(true);
        f7sxfType.setDisplayFormat("$name$");
        f7sxfType.setEditFormat("$number$");
        f7sxfType.setCommitFormat("$number$");
        EntityViewInfo entityViewInfo1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("AssociateType", (Object)new Integer(4)));
        filter1.getFilterItems().add(new FilterItemInfo("enabled", (Object)Constants.TRUE));
        entityViewInfo1.setFilter(filter1);
        f7sxfType.setEntityViewInfo(entityViewInfo1);
        KDTDefaultCellEditor descEditor = new KDTDefaultCellEditor((IKDEditor)f7sxfType);
        this.kdtFee.getColumn(COL_SXFTYPE).setEditor((ICellEditor)descEditor);
        KDBizPromptBox f7BearDept = new KDBizPromptBox();
        UIUtil.setAdminAllCU((IUIObject)this, (KDBizPromptBox)f7BearDept);
        KDTDefaultCellEditor bearDeptEditor = new KDTDefaultCellEditor((IKDEditor)f7BearDept);
        this.kdtFee.getColumn(COL_BEARDEPT).setEditor((ICellEditor)bearDeptEditor);
        KDBizPromptBox f7Currency = new KDBizPromptBox();
        f7Currency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        f7Currency.setDisplayFormat("$name$");
        f7Currency.setEditFormat("$number$");
        f7Currency.setCommitFormat("$number$");
        f7Currency.setEditable(true);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        f7Currency.setEntityViewInfo(evi);
        KDTDefaultCellEditor CurrencyEditor = new KDTDefaultCellEditor((IKDEditor)f7Currency);
        this.kdtFee.getColumn(COL_CURRENCY).setEditor((ICellEditor)CurrencyEditor);
        KDBizPromptBox f7cdItem = new KDBizPromptBox();
        f7cdItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.ProjectQuery");
        f7cdItem.setDisplayFormat("$name$");
        f7cdItem.setEditFormat("$number$");
        f7cdItem.setCommitFormat("$number$");
        f7cdItem.setEditable(true);
        EntityViewInfo entityViewInfoItem = new EntityViewInfo();
        FilterInfo filterItem = new FilterInfo();
        filterItem.getFilterItems().add(new FilterItemInfo("isListItem", (Object)Constants.TRUE));
        entityViewInfoItem.setFilter(filterItem);
        f7cdItem.setEntityViewInfo(entityViewInfoItem);
        KDTDefaultCellEditor cdItemEditor = new KDTDefaultCellEditor((IKDEditor)f7cdItem);
        this.kdtFee.getColumn(COL_BEARPROJECT).setEditor((ICellEditor)cdItemEditor);
        KDBizPromptBox f7ExchangeRate = new KDBizPromptBox();
        f7ExchangeRate.setQueryInfo("com.kingdee.eas.basedata.assistant.app.ExchangeRateQuery");
        f7ExchangeRate.setDisplayFormat("$convertRate$");
        f7ExchangeRate.setEditFormat("$convertRate$");
        f7ExchangeRate.setCommitFormat("$convertRate$");
        f7ExchangeRate.setEditable(true);
        KDTDefaultCellEditor exchangeRateEditor = new KDTDefaultCellEditor((IKDEditor)f7ExchangeRate);
        this.kdtFee.getColumn(COL_EXCHANGERATE).setEditor((ICellEditor)exchangeRateEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$convertRate$"));
        this.kdtFee.getColumn(COL_EXCHANGERATE).setRenderer((IBasicRender)avr);
        KDBizPromptBox f7AccountBank = new KDBizPromptBox();
        f7AccountBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        f7AccountBank.setEditable(true);
        f7AccountBank.setDisplayFormat("$name$");
        f7AccountBank.setEditFormat("$number$");
        f7AccountBank.setCommitFormat("$number$");
        EntityViewInfo accountViewInfo = new EntityViewInfo();
        FilterInfo accountfilter = new FilterInfo();
        accountfilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId()));
        accountfilter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        accountViewInfo.setFilter(accountfilter);
        f7AccountBank.setEntityViewInfo(accountViewInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("account.*");
        f7AccountBank.setSelectorCollection(selectors);
        KDTDefaultCellEditor accountBankEditor = new KDTDefaultCellEditor((IKDEditor)f7AccountBank);
        this.kdtFee.getColumn(COL_BANKACCOUNT).setEditor((ICellEditor)accountBankEditor);
        KDBizPromptBox f7AccountView = new KDBizPromptBox();
        f7AccountView.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        f7AccountView.setDisplayFormat("$name$");
        f7AccountView.setEditFormat("$number$");
        f7AccountView.setCommitFormat("$number$");
        f7AccountView.setEditable(true);
        NTHelper.setF7AccountEvi((IUIObject)this, (String)this.company.getBaseCurrency().getId().toString(), (CompanyOrgUnitInfo)this.company, (KDBizPromptBox)f7AccountView);
        KDTDefaultCellEditor accountViewEditor = new KDTDefaultCellEditor((IKDEditor)f7AccountView);
        this.kdtFee.getColumn(COL_OTHERVIEW).setEditor((ICellEditor)accountViewEditor);
        KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
        formattedTextField.setPrecision(2);
        formattedTextField.setMinimumValue((Comparable)new BigDecimal("0.00"));
        String numberFmt = FMClientHelper.getNumberFtm((int)2);
        KDTDefaultCellEditor numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        this.kdtFee.getColumn(COL_MONEYAMOUNT).setEditor((ICellEditor)numberEditor);
        this.kdtFee.getColumn(COL_SXFZBWB).setEditor((ICellEditor)numberEditor);
        this.kdtFee.getColumn(COL_LOCALEXRATE).setEditor((ICellEditor)numberEditor);
        this.kdtFee.getColumn(COL_YEARFEE).setEditor((ICellEditor)numberEditor);
        this.kdtFee.getColumn(COL_MONEYAMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtFee.getColumn(COL_SXFZBWB).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtFee.getColumn(COL_LOCALEXRATE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtFee.getColumn(COL_YEARFEE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtFee.getColumn(COL_MONEYAMOUNT).getStyleAttributes().setNumberFormat(numberFmt);
        this.kdtFee.getColumn(COL_SXFZBWB).getStyleAttributes().setNumberFormat(numberFmt);
        this.kdtFee.getColumn(COL_LOCALEXRATE).getStyleAttributes().setNumberFormat(numberFmt);
        this.kdtFee.getColumn(COL_YEARFEE).getStyleAttributes().setNumberFormat(numberFmt);
        KDTextField formattedTextFieldAB = new KDTextField();
        formattedTextFieldAB.setMaxLength(80);
        KDTDefaultCellEditor exchangeRateNumberEditorAB = new KDTDefaultCellEditor((JTextField)formattedTextFieldAB);
        this.kdtFee.getColumn(COL_ABTRACT).setEditor((ICellEditor)exchangeRateNumberEditorAB);
        this.kdtFee.getColumn(COL_FEETIM).setEditor((ICellEditor)exchangeRateNumberEditorAB);
    }

    private void initRowState(IRow row) {
        row.getCell(COL_BIZDATE).setValue((Object)new Date());
        row.getCell(COL_ISCREATORBEAR).setValue((Object)Boolean.TRUE);
        row.getCell(COL_MONEYAMOUNT).getStyleAttributes().setBackground(new Color(16579551));
    }

    @Override
    protected void kdtFee_editStopped(KDTEditEvent e) throws Exception {
        BigDecimal moneyAmount = (BigDecimal)this.kdtFee.getRow(0).getCell(COL_MONEYAMOUNT).getValue();
        if (moneyAmount != null && moneyAmount.doubleValue() == 0.0) {
            this.kdtFee.getRow(0).getCell(COL_MONEYAMOUNT).setValue((Object)this.editData.getMoneyAmount());
            return;
        }
        this.editData.setMoneyAmount(moneyAmount);
        super.kdtFee_editStopped(e);
        IRow row = this.kdtFee.getRow(e.getRowIndex());
        if (this.kdtFee.getColumnKey(e.getColIndex()).equals(COL_ISCREATORBEAR)) {
            this.chkIsCreatorBear_itemStateChanged(e, row);
        }
        if (this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_BANKACCOUNT)).getValue() != null) {
            AccountBankInfo accountInfo = (AccountBankInfo)this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_BANKACCOUNT)).getValue();
            this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_BANKVIEW)).setValue((Object)accountInfo.getAccount().getName().toString());
        }
        if (this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_MONEYAMOUNT)).getValue() != null) {
            this.calLocalAmount(e);
        }
        if (e.getColIndex() == this.kdtFee.getColumnIndex(COL_CURRENCY) && this.kdtFee.getCell(e.getRowIndex(), e.getColIndex()).getValue() != null) {
            CurrencyInfo currencyinfo = (CurrencyInfo)this.kdtFee.getCell(e.getRowIndex(), e.getColIndex()).getValue();
            KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
            formattedTextField.setPrecision(currencyinfo.getPrecision());
            KDTDefaultCellEditor numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
            this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_MONEYAMOUNT)).setEditor((ICellEditor)numberEditor);
            this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_SXFZBWB)).setEditor((ICellEditor)numberEditor);
            FMClientHelper.setNumberFormat((IRow)this.kdtFee.getRow(e.getRowIndex()), (String)COL_SXFZBWB, (String)currencyinfo.getId().toString());
            FMClientHelper.setNumberFormat((IRow)this.kdtFee.getRow(e.getRowIndex()), (String)COL_LOCALEXRATE, (String)currencyinfo.getId().toString());
            if (currencyinfo != null) {
                if (this.company.getBaseCurrency() != null) {
                    if (this.company.getBaseCurrency().getId().toString().equals(currencyinfo.getId().toString())) {
                        this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_LOCALEXRATE)).setValue((Object)Constants.ONE);
                        KDFormattedTextField LocExTextField = new KDFormattedTextField(1);
                        LocExTextField.setPrecision(2);
                        KDTDefaultCellEditor LocEditor = new KDTDefaultCellEditor((JTextField)LocExTextField);
                        this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_LOCALEXRATE)).setEditor((ICellEditor)LocEditor);
                        this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_LOCALEXRATE)).getStyleAttributes().setLocked(true);
                    } else {
                        try {
                            FeeForGuaranteeInfo info = (FeeForGuaranteeInfo)this.getDataObject();
                            if (info != null) {
                                ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.company, (CurrencyInfo)currencyinfo, (CurrencyInfo)this.company.getBaseCurrency(), (Date)info.getBizDate());
                                BigDecimal convertRate = exchangeRateInfo == null ? Constants.ONE : exchangeRateInfo.getConvertRate();
                                this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_LOCALEXRATE)).setValue((Object)convertRate);
                                KDFormattedTextField LocTextField = new KDFormattedTextField(1);
                                int precision = exchangeRateInfo == null ? 2 : exchangeRateInfo.getPrecision();
                                LocTextField.setPrecision(precision);
                                KDTDefaultCellEditor LocEditor = new KDTDefaultCellEditor((JTextField)LocTextField);
                                this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_LOCALEXRATE)).setEditor((ICellEditor)LocEditor);
                                this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_LOCALEXRATE)).getStyleAttributes().setLocked(false);
                            }
                        }
                        catch (EASBizException e1) {
                            this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_CURRENCY)).setValue(null);
                            throw e1;
                        }
                    }
                }
                this.calLocalAmount(e);
            }
        }
        if (this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_LOCALEXRATE)).getValue() != null) {
            this.calLocalAmount(e);
        }
        if (this.kdtFee.getColumnKey(e.getColIndex()).equals(COL_CURRENCY)) {
            CurrencyInfo info = (CurrencyInfo)row.getCell(e.getColIndex()).getValue();
            this.comboCurrency_itemStateChanged(row, info);
        }
    }

    private void chkIsCreatorBear_itemStateChanged(KDTEditEvent e, IRow row) {
        Color c = null;
        boolean flag = false;
        if (row.getCell(e.getColIndex()).getValue().toString().equals("false")) {
            c = Color.lightGray;
            flag = true;
            row.getCell(this.kdtFee.getColumnIndex(COL_BEARDEPT)).setValue(null);
            row.getCell(this.kdtFee.getColumnIndex(COL_OTHERVIEW)).setValue(null);
            row.getCell(this.kdtFee.getColumnIndex(COL_BANKACCOUNT)).setValue(null);
            row.getCell(this.kdtFee.getColumnIndex(COL_BANKVIEW)).setValue(null);
        } else {
            c = Color.WHITE;
            flag = false;
        }
        row.getCell(this.kdtFee.getColumnIndex(COL_BEARDEPT)).getStyleAttributes().setBackground(c);
        row.getCell(this.kdtFee.getColumnIndex(COL_OTHERVIEW)).getStyleAttributes().setBackground(c);
        row.getCell(this.kdtFee.getColumnIndex(COL_BANKACCOUNT)).getStyleAttributes().setBackground(c);
        row.getCell(this.kdtFee.getColumnIndex(COL_BANKVIEW)).getStyleAttributes().setBackground(c);
        row.getCell(this.kdtFee.getColumnIndex(COL_BEARDEPT)).getStyleAttributes().setLocked(flag);
        row.getCell(this.kdtFee.getColumnIndex(COL_OTHERVIEW)).getStyleAttributes().setLocked(flag);
        row.getCell(this.kdtFee.getColumnIndex(COL_BANKACCOUNT)).getStyleAttributes().setLocked(flag);
        row.getCell(this.kdtFee.getColumnIndex(COL_BANKVIEW)).getStyleAttributes().setLocked(flag);
        if (!flag) {
            row.getCell(COL_MONEYAMOUNT).getStyleAttributes().setBackground(new Color(16579551));
        } else {
            row.getCell(COL_MONEYAMOUNT).getStyleAttributes().setBackground(Color.WHITE);
        }
    }

    private void comboCurrency_itemStateChanged(IRow row, CurrencyInfo info) {
        if (info != null) {
            int precision = info.getPrecision();
            String currencyFormat = RecChequeUtil.getKDTCurrencyFormat((int)precision);
            String[] fields = new String[]{COL_MONEYAMOUNT};
            for (int i = 0; i < fields.length; ++i) {
                KDTDefaultCellEditor editor = (KDTDefaultCellEditor)this.kdtFee.getColumn(fields[i]).getEditor();
                KDFormattedTextField txt = (KDFormattedTextField)editor.getComponent();
                txt.setPrecision(precision);
                ICell cAmount = row.getCell(fields[i]);
                cAmount.getStyleAttributes().setNumberFormat(currencyFormat);
            }
        }
    }

    private void calLocalAmount(KDTEditEvent e) {
        BigDecimal bdAmount = (BigDecimal)this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_MONEYAMOUNT)).getValue();
        BigDecimal bdLocalExRate = (BigDecimal)this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_LOCALEXRATE)).getValue();
        if (bdAmount != null && bdLocalExRate != null) {
            this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_SXFZBWB)).setValue((Object)String.valueOf(bdAmount.multiply(bdLocalExRate)));
        } else {
            this.kdtFee.getCell(e.getRowIndex(), this.kdtFee.getColumnIndex(COL_SXFZBWB)).setValue((Object)Constants.ZERO);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        this.handler.issueDate = this.letterOfGuaranteeInfo.getIssueDate();
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        int size = this.feeCollection.size();
        for (int i = 0; i < size; ++i) {
            FeeForGuaranteeInfo info = this.feeCollection.get(i);
            BigDecimal amount = info.getBigDecimal("MoneyAmount");
            if (amount != null && amount.compareTo(Constants.ZERO) < 0) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.CtlResource", (String)"FeeAmountBigZERO"));
                SysUtil.abort();
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"146_FeeForGuaranteeFMUI"));
                SysUtil.abort();
            }
            this.handler.verifyFee((CoreUIObject)this, info);
            info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        }
    }

    private void removeLine() {
        if (this.kdtFee.getSelectManager().size() == 0 || this.isTableColumnSelected(this.kdtFee)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = this.kdtFee.getSelectManager().get().getTop();
        if (this.kdtFee.getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        this.kdtFee.removeRow(top);
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    private boolean isisClearinghouse(CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        boolean flag = BankFactory.getRemoteInstance().isClearinghouseCompany(currentCompany.getId().toString());
        return flag;
    }

    private void setInnerAccountFilter(KDBizPromptBox ptmtAccount, CompanyOrgUnitInfo Company) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
        if (Company != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)Company.getId().toString()));
        }
        evi.setFilter(filter);
        ptmtAccount.setEntityViewInfo(evi);
        ptmtAccount.setSelectorCollection(this.getCustomSelectors());
        ptmtAccount.getQueryAgent().resetRuntimeEntityView();
    }

    private SelectorItemCollection getCustomSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("applyUnit.*"));
        return sic;
    }

    private void isHideInnerAccountColl(boolean flag) {
        this.kdtFee.getColumn(COL_INNERACCOUNT).getStyleAttributes().setHided(flag);
    }
}

