/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ctl.client.AbstractGuaranteeApplyFilterUI;
import com.kingdee.eas.fm.ctl.client.GuaranteeApplyFilterParam;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.sql.Date;
import org.apache.log4j.Logger;

public class GuaranteeApplyFilterUI
extends AbstractGuaranteeApplyFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(GuaranteeApplyFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        GuaranteeApplyFilterParam filterParam = new GuaranteeApplyFilterParam();
        if (!(this.kdCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setCurrency(((CurrencyInfo)this.kdCurrency.getSelectedItem()).getId().toString());
        } else {
            filterParam.setCurrency(null);
        }
        filterParam.setCompanyIdSet(this.getCompanyIdSet());
        if (this.kdIssueDate1.getSqlDate() != null) {
            filterParam.setBeginDate(DateTimeUtils.truncateDate((java.util.Date)this.kdIssueDate1.getSqlDate()));
        }
        if (this.kdIssueDate2.getSqlDate() != null) {
            filterParam.setEndDate(DateTimeUtils.truncateDate((java.util.Date)DateTimeUtils.addDay((java.util.Date)this.kdIssueDate2.getSqlDate(), (long)1L)));
        }
        return filterParam;
    }

    public void setParam(Object param) {
        GuaranteeApplyFilterParam filterParam;
        block7: {
            if (param == null) {
                return;
            }
            filterParam = (GuaranteeApplyFilterParam)param;
            this.setCompanyIdSet(filterParam.getCompanyIdSet());
            if (filterParam.getCurrency() != null) {
                try {
                    if (filterParam.getCurrency() != null) {
                        CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(filterParam.getCurrency()));
                        FMClientHelper.setSelectObject((KDComboBox)this.kdCurrency, (Object)cur);
                        break block7;
                    }
                    FMClientHelper.setSelectObject((KDComboBox)this.kdCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else {
                this.kdCurrency.setSelectedIndex(this.kdCurrency.getItemCount() - 1);
            }
        }
        this.kdIssueDate1.setValue((Object)filterParam.getBeginDate());
        this.kdIssueDate2.setValue((Object)filterParam.getEndDate());
    }

    protected Class getParamClass() {
        return GuaranteeApplyFilterParam.class;
    }

    public boolean verify() {
        Date startDate = this.kdIssueDate1.getSqlDate();
        Date endDate = this.kdIssueDate2.getSqlDate();
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kdIssueDate1);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kdIssueDate2);
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (java.util.Date)startDate, (java.util.Date)endDate);
        return super.verify();
    }

    protected void init() throws Exception {
        super.init();
        CurrencyUtil.fillCombCurrency((KDComboBox)this.kdCurrency);
        this.kdCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.kdIssueDate1.setValue((Object)DateUtil.getFirstDayOfCurYear());
        this.kdIssueDate2.setValue((Object)DateUtil.getDayBegin());
        try {
            CurrencyInfo currency = CurrencyUtil.getLocalCurrency();
            FMClientHelper.setSelectObject((KDComboBox)this.kdCurrency, (Object)currency);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        super.clear();
        try {
            CurrencyInfo currency = CurrencyUtil.getLocalCurrency();
            FMClientHelper.setSelectObject((KDComboBox)this.kdCurrency, (Object)currency);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.kdIssueDate1.setValue((Object)DateUtil.getFirstDayOfCurYear());
        this.kdIssueDate2.setValue((Object)DateUtil.getDayBegin());
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }
}

