/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.client.BankF7Selector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ctl.ReceiveLetterFactory;
import com.kingdee.eas.fm.ctl.ReceiveLetterInfo;
import com.kingdee.eas.fm.ctl.ReceiveStateEnum;
import com.kingdee.eas.fm.ctl.client.AbstractReceiveLetterEditUI;
import com.kingdee.eas.fm.ctl.client.ReceiveLetterListUI;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class ReceiveLetterEditUI
extends AbstractReceiveLetterEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiveLetterEditUI.class);
    private static final BigDecimal BIGZERO = new BigDecimal("0.00");
    private static final String RESOURCE = "com.kingdee.eas.fm.ctl.client.CTLClientResource";

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getBankAcct() != null) {
            this.prmtBankAcct.setValue((Object)this.editData.getBankAcct());
        } else if (this.editData.getBankName() != null) {
            this.prmtBankAcct.setValue((Object)this.editData.getBankName());
        }
    }

    @Override
    public void storeFields() {
        try {
            this.pkIssueDate.commitEdit();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        super.storeFields();
        if (this.prmtBankAcct.getValue() != null && this.prmtBankAcct.getValue() instanceof BankInfo) {
            this.editData.setBankAcct((BankInfo)this.prmtBankAcct.getValue());
        }
        this.editData.setBankName(this.getStringName(this.prmtBankAcct.getValue()));
    }

    protected IObjectValue createNewData() {
        ReceiveLetterInfo info = new ReceiveLetterInfo();
        Date date = new Date();
        info.setApplyDate(date);
        info.setIssueDate(date);
        info.setExpiredDate(date);
        info.setBizDate(date);
        info.setCurrency(this.baseCurrency);
        info.setCompany(this.currentCompany);
        info.setCreator(this.userinfo);
        info.setLoculCurExRate(Constants.ONE);
        info.setAmount(BIGZERO);
        info.setHorizon(BIGZERO);
        info.setAmountLoculCur(BIGZERO);
        info.setBalance(BIGZERO);
        return info;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.initBankTree(this.prmtBankAcct, new Boolean(true), true);
        F7SelectorFactory.initAdminOrgUnitWithRoot((IUIObject)this, (KDBizPromptBox)this.prmtDepartment, (CompanyOrgUnitInfo)this.currentCompany);
        this.checkBizUnit();
        if (ReceiveStateEnum.APPROVE.equals((Object)this.editData.getState()) && this.getOprtState().equals(OprtState.VIEW)) {
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
        }
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
    }

    protected void initBankTree(KDBizPromptBox bank, Boolean isBank, boolean isOnlyIncludeUsed) throws Exception {
        FilterInfo filter = new FilterInfo();
        if (isBank != null) {
            filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)isBank));
        }
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
        if (isOnlyIncludeUsed) {
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bank.setEntityViewInfo(evi);
        bank.setDisplayFormat("$number$ $name$");
        bank.setCommitFormat("$number$");
        bank.setEditFormat("$number$");
        ExtendParser parser = new ExtendParser(bank);
        bank.setCommitParser((IParser)parser);
        bank.setEditable(true);
        bank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7BankQuery");
        BankF7Selector arg0 = new BankF7Selector((IUIObject)this, bank);
        if (isBank != null) {
            arg0.setBank(isBank);
        }
        bank.setSelector((KDPromptSelector)arg0);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!ReceiveStateEnum.APPROVE.equals((Object)this.editData.getState())) {
            this.editData.setState(ReceiveStateEnum.SUBMIT);
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
        try {
            ((ReceiveLetterListUI)((Object)this.getUIContext().get("Owner"))).refreshList();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.txtAmount.setPrecision(2);
        this.txtBalance.setPrecision(2);
        this.txtAmountLoculCur.setPrecision(2);
        this.txtHorizon.setPrecision(1);
        this.txtBargainAmount.setPrecision(2);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtBargainAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmountLoculCur);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtBalance);
        this.btnAttachment.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.txtLoculCurExRate.setHorizontalAlignment(4);
        this.txtLoculCurExRate.setPrecision(5);
        this.menuItemCopyLine.setVisible(false);
        try {
            FMClientHelper.initComboCurrency((KDComboBox)this.comCurrency, (boolean)true, (String)this.getOprtState());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReceiveLetterFactory.getRemoteInstance();
    }

    @Override
    protected void comCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 2) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.comCurrency.getSelectedItem();
        if (currency != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
            this.txtBalance.setPrecision(currency.getPrecision());
            this.txtAmountLoculCur.setPrecision(currency.getPrecision());
            this.txtBargainAmount.setPrecision(2);
            if (this.currentCompany.getBaseCurrency() != null) {
                if (this.currentCompany.getBaseCurrency().getId().toString().equals(currency.getId().toString())) {
                    this.txtLoculCurExRate.setEnabled(false);
                    this.txtLoculCurExRate.setEditable(false);
                } else {
                    this.txtLoculCurExRate.setEnabled(true);
                    this.txtLoculCurExRate.setEditable(true);
                    if (this.getOprtState().equals(OprtState.VIEW)) {
                        this.txtLoculCurExRate.setRequired(false);
                    }
                }
            }
            if (OprtState.VIEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState()) && this.isFirstOnload()) {
                return;
            }
            CompanyOrgUnitInfo currentFIUnit = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            try {
                ReceiveLetterInfo info = (ReceiveLetterInfo)this.getDataObject();
                if (info != null) {
                    FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtLoculCurExRate, (CompanyOrgUnitInfo)currentFIUnit, (CurrencyInfo)currency, (CurrencyInfo)currentFIUnit.getBaseCurrency(), (Date)info.getBizDate(), null);
                }
            }
            catch (EASBizException e1) {
                this.comCurrency.setSelectedItem(null);
                throw e1;
            }
            this.txtAmountLoculCur.setValue((Object)this.calcLocalAmount());
            this.txtBalance.setValue(this.txtAmount.getValue());
        }
    }

    private BigDecimal calcLocalAmount() {
        BigDecimal bdAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal bdLocalExRate = this.txtLoculCurExRate.getBigDecimalValue();
        if (bdAmount != null && bdLocalExRate != null) {
            return bdAmount.multiply(bdLocalExRate);
        }
        return Constants.ZERO;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtLoculCurExRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBankAcct);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtHorizon);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtLGType);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtOpenRecMan);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkIssueDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkExpiredDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkApplyDate);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        if (this.txtHorizon.getBigDecimalValue() != null) {
            FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtHorizon);
        }
        Date dateBegin = DateTimeUtils.truncateDate((Date)this.pkIssueDate.getSqlDate());
        Date dateEnd = DateTimeUtils.truncateDate((Date)this.pkExpiredDate.getSqlDate());
        if (dateEnd != null && !dateEnd.after(dateBegin)) {
            this.pkExpiredDate.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"LGBeginDateMustBeforeEndDate"));
            this.abort();
        }
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.txtAmountLoculCur.setValue((Object)this.calcLocalAmount());
        this.txtBalance.setValue(this.txtAmount.getValue());
    }

    @Override
    protected void pkExpiredDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkExpiredDate_dataChanged(e);
        this.txtHorizon.setValue((Object)FinHorizon.getHorizon((KDDatePicker)this.pkIssueDate, (KDDatePicker)this.pkExpiredDate));
    }

    @Override
    protected void pkIssueDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkIssueDate_dataChanged(e);
        this.txtHorizon.setValue((Object)FinHorizon.getHorizon((KDDatePicker)this.pkIssueDate, (KDDatePicker)this.pkExpiredDate));
    }

    @Override
    protected void txtLoculCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        this.txtAmountLoculCur.setValue((Object)this.calcLocalAmount());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!ReceiveStateEnum.APPROVE.equals((Object)this.editData.getState())) {
            this.editData.setState(ReceiveStateEnum.SAVE);
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        return sic;
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.btnAddNew.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.menuItemRemove.setVisible(false);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!ReceiveStateEnum.APPROVE.equals((Object)this.editData.getState())) {
            this.editData.setState(ReceiveStateEnum.SAVE);
        }
        super.actionSave_actionPerformed(e);
    }

    protected boolean isNeedAddToolMenus() {
        return false;
    }

    private String getStringName(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.CTL_MANAGE;
    }

    protected String getDateField() {
        return "IssueDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit"};
    }
}

